/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.ObjectNode;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYIncludeNode;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.TypeNode;

public class NodeUtils {
    public static final int DEFAULT_COLUMN_STEP = 2;

    @Nullable
    public static Node getGrandParent(Node node) {
        return NodeUtils.getAncestor(node, 2);
    }

    @Nullable
    public static Node getAncestor(Node node, int level) {
        Node parent;
        int i = 1;
        for (parent = node.getParent(); i < level && parent != null; parent = parent.getParent(), ++i) {
        }
        return parent;
    }

    @Nullable
    public static Node traverseToRoot(Node node) {
        if (node == null || node instanceof RamlDocumentNode) {
            return node;
        }
        if (node.getParent() == null) {
            return node;
        }
        return NodeUtils.traverseToRoot(node.getParent());
    }

    public static ObjectNode getTypesRoot(Node node) {
        Node typesRoot = NodeUtils.getTypes(NodeUtils.traverseToRoot(node));
        return typesRoot instanceof ObjectNode ? (ObjectNode)typesRoot : null;
    }

    public static boolean isStringNode(Node node) {
        return node != null && node instanceof StringNode;
    }

    public static Node getType(Node node) {
        return node.get("type") != null ? node.get("type") : node.get("schema");
    }

    public static Node getTypes(Node node) {
        return node.get("types") != null ? node.get("types") : node.get("schemas");
    }

    public static boolean isErrorResult(Node node) {
        return node != null && (node instanceof ErrorNode || node.findDescendantsWith(ErrorNode.class).size() > 0);
    }

    public static TypeNode getType(String typeName, Node node) {
        Node definitionContext = NodeUtils.getNodeContext(node);
        if (definitionContext == null) {
            return null;
        }
        if (typeName != null && typeName.contains(".")) {
            return NodeUtils.getTypeFromContext(typeName, definitionContext);
        }
        if (NodeUtils.getTypes(definitionContext) != null) {
            Node type = NodeUtils.getTypes(definitionContext).get(typeName);
            return type instanceof TypeNode ? (TypeNode)type : null;
        }
        return null;
    }

    private static TypeNode getTypeFromContext(String typeName, Node definitionContext) {
        Node localContext = definitionContext.get("uses");
        if (localContext == null) {
            return null;
        }
        Node resolution = localContext;
        String objectName = typeName.substring(typeName.lastIndexOf(".") + 1);
        String navigationPath = typeName.substring(0, typeName.lastIndexOf("."));
        if (!navigationPath.contains(".")) {
            return resolution != null && resolution.get(navigationPath) != null && NodeUtils.getTypes(resolution.get(navigationPath)) != null && NodeUtils.getTypes(resolution.get(navigationPath)).get(objectName) instanceof TypeNode ? (TypeNode)NodeUtils.getTypes(resolution.get(navigationPath)).get(objectName) : null;
        }
        for (String path : navigationPath.split(".")) {
            if (resolution == null) {
                return null;
            }
            resolution = resolution.get(path);
        }
        return resolution != null && NodeUtils.getTypes(resolution) != null && NodeUtils.getTypes(resolution).get(objectName) instanceof TypeNode ? (TypeNode)NodeUtils.getTypes(resolution).get(objectName) : null;
    }

    private static Node getNodeContext(Node node) {
        if (node == null || node instanceof RamlDocumentNode) {
            return node;
        }
        if (node.getSource() != null && node.getSource() instanceof SYIncludeNode) {
            return node;
        }
        if (node.getParent() == null) {
            return node;
        }
        return NodeUtils.getNodeContext(node.getParent());
    }

    @Nonnull
    public static ResourceLoader getResourceLoader(Node node) {
        while (node != null) {
            if (node instanceof RamlDocumentNode) {
                return ((RamlDocumentNode)node).getResourceLoader();
            }
            node = node.getParent();
        }
        throw new IllegalArgumentException("node does not belong to a raml document");
    }

    public static String computeColumnForChild(Node node) {
        return StringUtils.repeat((String)" ", (int)(node.getStartPosition().getColumn() + 2));
    }

    @Nullable
    public static Node searchNodeAt(Node root, int location) {
        if (root.getEndPosition().getIndex() != location || !root.getChildren().isEmpty()) {
            List<Node> children = root.getChildren();
            for (Node child : children) {
                if (child.getEndPosition().getIndex() == location) {
                    if (child.getChildren().isEmpty()) {
                        return child;
                    }
                    return NodeUtils.searchNodeAt(child, location);
                }
                if (child.getEndPosition().getIndex() <= location && !NodeUtils.isLastNode(child)) continue;
                if (child.getChildren().isEmpty()) {
                    return child;
                }
                return NodeUtils.searchNodeAt(child, location);
            }
            return null;
        }
        return root;
    }

    private static boolean isLastNode(Node node) {
        Node parent = node.getParent();
        if (parent == null) {
            return false;
        }
        List<Node> children = parent.getChildren();
        Node lastChild = children.get(children.size() - 1);
        return node.equals(lastChild);
    }
}

