/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.nodes.types.builtin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.nodes.AbstractRamlNode;
import org.raml.v2.internal.framework.nodes.IntegerNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NodeType;
import org.raml.v2.internal.framework.nodes.ObjectNode;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.impl.commons.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.nodes.types.InheritedPropertiesInjectedNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.TypeNodeVisitor;
import org.raml.v2.internal.utils.NodeUtils;

public class ObjectTypeNode
extends AbstractRamlNode
implements ObjectNode,
TypeNode {
    private List<InheritedPropertiesInjectedNode> inheritedProperties = Lists.newArrayList();
    private boolean resolvedType = false;

    public ObjectTypeNode() {
    }

    protected ObjectTypeNode(ObjectTypeNode node) {
        super(node);
    }

    public List<PropertyNode> getProperties() {
        String typeName;
        TypeNode type;
        ArrayList<PropertyNode> result = new ArrayList<PropertyNode>();
        List<Object> properties = Lists.newArrayList();
        if (this.getSource().get("properties") != null) {
            properties = this.getSource().get("properties").getChildren();
        } else if (NodeUtils.getType(this) instanceof StringNode && (type = NodeUtils.getType(typeName = ((StringNode)NodeUtils.getType(this)).getValue(), this)) != null && type instanceof ObjectTypeNode) {
            return ((ObjectTypeNode)type).getProperties();
        }
        for (Node property : properties) {
            result.add((PropertyNode)property);
        }
        return result;
    }

    @Override
    @Nonnull
    public Node copy() {
        return new ObjectTypeNode(this);
    }

    @Override
    public NodeType getType() {
        return NodeType.Object;
    }

    public void addInheritedProperties(InheritedPropertiesInjectedNode node) {
        this.inheritedProperties.add(node);
    }

    public void setInheritedProperties(List<InheritedPropertiesInjectedNode> inheritedProperties) {
        this.inheritedProperties = inheritedProperties;
    }

    public List<InheritedPropertiesInjectedNode> getInheritedProperties() {
        return this.inheritedProperties;
    }

    @Override
    public <T> T visit(TypeNodeVisitor<T> visitor) {
        return visitor.visitObject(this);
    }

    public boolean isArray() {
        return NodeUtils.getType(this) instanceof StringNode && "array".equals(((StringNode)NodeUtils.getType(this)).getValue());
    }

    public Integer getMinProperties() {
        return this.getIntFacet("minProperties");
    }

    public Integer getMaxProperties() {
        return this.getIntFacet("maxProperties");
    }

    private Integer getIntFacet(String facetName) {
        if (this.get(facetName) != null && this.get(facetName) instanceof IntegerNode) {
            return ((IntegerNode)this.get(facetName)).getValue();
        }
        return null;
    }

    public void markAsResolved() {
        this.resolvedType = true;
    }

    public boolean isResolved() {
        return this.resolvedType;
    }

    public boolean isAllowAdditionalProperties() {
        Node additionalProperties = this.get("additionalProperties");
        return additionalProperties == null;
    }
}

