/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.ExecutionContext;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.ParametrizedReferenceNode;
import org.raml.v2.internal.framework.nodes.ReferenceNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYBaseRamlNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYNullNode;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYObjectNode;
import org.raml.v2.internal.framework.phase.GrammarPhase;
import org.raml.v2.internal.framework.phase.Transformer;
import org.raml.v2.internal.impl.commons.grammar.BaseRamlGrammar;
import org.raml.v2.internal.impl.commons.nodes.BaseResourceTypeRefNode;
import org.raml.v2.internal.impl.commons.nodes.BaseTraitRefNode;
import org.raml.v2.internal.impl.commons.nodes.MethodNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceNode;
import org.raml.v2.internal.impl.commons.nodes.ResourceTypeNode;
import org.raml.v2.internal.impl.commons.nodes.StringTemplateNode;
import org.raml.v2.internal.impl.commons.nodes.TraitNode;
import org.raml.v2.internal.impl.commons.phase.ResourceTypesTraitsMerger;
import org.raml.v2.internal.utils.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypesTraitsTransformer
implements Transformer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<ResourceNode> mergedResources = new HashSet<ResourceNode>();
    private BaseRamlGrammar ramlGrammar;

    public ResourceTypesTraitsTransformer(BaseRamlGrammar ramlGrammar) {
        this.ramlGrammar = ramlGrammar;
    }

    @Override
    public boolean matches(Node node) {
        return node instanceof BaseTraitRefNode || node instanceof BaseResourceTypeRefNode;
    }

    @Override
    public Node transform(Node node) {
        ResourceNode resourceNode = node.findAncestorWith(ResourceNode.class);
        if (this.mergedResources.contains(resourceNode)) {
            return node;
        }
        this.checkTraits(resourceNode, resourceNode);
        ReferenceNode resourceTypeReference = this.findResourceTypeReference(resourceNode);
        if (resourceTypeReference != null) {
            this.applyResourceType(resourceNode, resourceTypeReference, resourceNode);
        }
        this.mergedResources.add(resourceNode);
        return node;
    }

    private void checkTraits(KeyValueNode resourceNode, ResourceNode baseResourceNode) {
        List<MethodNode> methodNodes = this.findMethodNodes(resourceNode);
        List<ReferenceNode> resourceTraitRefs = this.findTraitReferences(resourceNode);
        List<ReferenceNode> presentResourceTraitRefs = this.validateAndFilterResourceLevelTraitRefs(resourceTraitRefs);
        for (MethodNode methodNode : methodNodes) {
            List<ReferenceNode> traitRefs = this.findTraitReferences(methodNode);
            traitRefs.addAll(presentResourceTraitRefs);
            for (ReferenceNode traitRef : traitRefs) {
                String traitLevel = presentResourceTraitRefs.contains(traitRef) ? "resource" : "method";
                this.logger.debug("applying {} level trait '{}' to '{}.{}'", new Object[]{traitLevel, traitRef.getRefName(), resourceNode.getKey(), methodNode.getName()});
                this.applyTrait(methodNode, traitRef, baseResourceNode);
            }
        }
    }

    private List<ReferenceNode> validateAndFilterResourceLevelTraitRefs(List<ReferenceNode> resourceTraitRefs) {
        ArrayList<ReferenceNode> presentTraitRefs = new ArrayList<ReferenceNode>();
        for (ReferenceNode traitReference : resourceTraitRefs) {
            Node refNode = traitReference.getRefNode();
            if (refNode == null) {
                ErrorNode errorNode = ErrorNodeFactory.createNonexistentReferenceTraitError(traitReference);
                traitReference.replaceWith(errorNode);
                continue;
            }
            presentTraitRefs.add(traitReference);
        }
        return presentTraitRefs;
    }

    private void applyResourceType(KeyValueNode targetNode, ReferenceNode resourceTypeReference, ResourceNode baseResourceNode) {
        ResourceTypeNode refNode = (ResourceTypeNode)resourceTypeReference.getRefNode();
        if (refNode == null) {
            ErrorNode errorNode = ErrorNodeFactory.createNonexistentReferenceResourceTypeError(resourceTypeReference);
            resourceTypeReference.replaceWith(errorNode);
            return;
        }
        ResourceTypeNode templateNode = refNode.copy();
        templateNode.setParent(refNode.getParent());
        Map<String, String> parameters = this.getBuiltinResourceTypeParameters(baseResourceNode);
        if (resourceTypeReference instanceof ParametrizedReferenceNode) {
            parameters.putAll(((ParametrizedReferenceNode)resourceTypeReference).getParameters());
        }
        this.resolveParameters(templateNode, parameters);
        GrammarPhase validatePhase = new GrammarPhase(this.ramlGrammar.resourceTypeParamsResolved());
        validatePhase.apply(templateNode.getValue());
        this.checkTraits(templateNode, baseResourceNode);
        ReferenceNode parentTypeReference = this.findResourceTypeReference(templateNode);
        if (parentTypeReference != null) {
            this.applyResourceType(templateNode, parentTypeReference, baseResourceNode);
        }
        ResourceTypesTraitsMerger.merge(targetNode.getValue(), templateNode.getValue());
    }

    private Map<String, String> getBuiltinResourceTypeParameters(ResourceNode resourceNode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("resourcePathName", resourceNode.getResourcePathName());
        parameters.put("resourcePath", resourceNode.getResourcePath());
        return parameters;
    }

    private Map<String, String> getBuiltinTraitParameters(MethodNode methodNode, ResourceNode resourceNode) {
        Map<String, String> parameters = this.getBuiltinResourceTypeParameters(resourceNode);
        parameters.put("methodName", methodNode.getName());
        return parameters;
    }

    private void applyTrait(MethodNode methodNode, ReferenceNode traitReference, ResourceNode baseResourceNode) {
        TraitNode refNode = (TraitNode)traitReference.getRefNode();
        if (refNode == null) {
            ErrorNode errorNode = ErrorNodeFactory.createNonexistentReferenceTraitError(traitReference);
            traitReference.replaceWith(errorNode);
            return;
        }
        TraitNode copy = refNode.copy();
        Map<String, String> parameters = this.getBuiltinTraitParameters(methodNode, baseResourceNode);
        if (traitReference instanceof ParametrizedReferenceNode) {
            parameters.putAll(((ParametrizedReferenceNode)traitReference).getParameters());
        }
        this.resolveParameters(copy, parameters);
        this.replaceNullValueWithObject(methodNode);
        ResourceTypesTraitsMerger.merge(methodNode.getValue(), copy.getValue());
    }

    private void resolveParameters(Node parameterizedNode, Map<String, String> parameters) {
        ExecutionContext context = new ExecutionContext(parameters);
        List<StringTemplateNode> templateNodes = parameterizedNode.findDescendantsWith(StringTemplateNode.class);
        for (StringTemplateNode templateNode : templateNodes) {
            Node resolvedNode = templateNode.execute(context);
            templateNode.replaceWith(resolvedNode);
        }
    }

    private void replaceNullValueWithObject(KeyValueNode keyValueNode) {
        Node valueNode = keyValueNode.getValue();
        if (valueNode instanceof SYNullNode) {
            valueNode = new SYObjectNode((SYBaseRamlNode)valueNode);
            keyValueNode.setValue(valueNode);
        }
    }

    private List<ReferenceNode> findTraitReferences(KeyValueNode keyValueNode) {
        ArrayList<ReferenceNode> result = new ArrayList<ReferenceNode>();
        Node isNode = NodeSelector.selectFrom("is", keyValueNode.getValue());
        if (isNode != null) {
            if (isNode instanceof ReferenceNode) {
                result.add((ReferenceNode)isNode);
            } else {
                List<Node> children = isNode.getChildren();
                for (Node child : children) {
                    result.add((ReferenceNode)child);
                }
            }
        }
        return result;
    }

    private ReferenceNode findResourceTypeReference(KeyValueNode resourceNode) {
        return (ReferenceNode)NodeSelector.selectFrom("type", resourceNode.getValue());
    }

    private List<MethodNode> findMethodNodes(KeyValueNode resourceNode) {
        ArrayList<MethodNode> methodNodes = new ArrayList<MethodNode>();
        for (Node node : resourceNode.getValue().getChildren()) {
            if (!(node instanceof MethodNode)) continue;
            methodNodes.add((MethodNode)node);
        }
        return methodNodes;
    }
}

