/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.nodes.snakeyaml;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.snakeyaml.SYStringNode;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class SYIncludeNode
extends SYStringNode {
    public SYIncludeNode(SYIncludeNode node) {
        super(node);
    }

    public SYIncludeNode(ScalarNode scalarNode) {
        super(scalarNode);
    }

    public String getIncludePath() {
        for (Node current = this; current != null; current = current.getParent()) {
            Node possibleSource = current.getSource();
            if (!(possibleSource instanceof SYIncludeNode)) continue;
            String basePath = ((SYIncludeNode)possibleSource).getIncludePath();
            ArrayList segments = Lists.newArrayList((Object[])basePath.split("/"));
            if (segments.size() > 1) {
                segments.remove(segments.size() - 1);
                return StringUtils.join((Collection)segments, (String)"/") + "/" + this.getValue();
            }
            return this.getValue();
        }
        return this.getValue();
    }

    public String getIncludedType() {
        String[] parts = this.getValue().split("#");
        if (parts.length == 2) {
            return parts[1];
        }
        return null;
    }

    @Override
    @Nonnull
    public Node copy() {
        return new SYIncludeNode(this);
    }
}

