/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.nodes;

import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.nodes.BaseNode;
import org.raml.v2.internal.framework.nodes.KeyValueNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NodeType;
import org.raml.v2.internal.framework.nodes.Position;

public class KeyValueNodeImpl
extends BaseNode
implements KeyValueNode {
    private Position startPosition;
    private Position endPosition;

    public KeyValueNodeImpl() {
    }

    public KeyValueNodeImpl(@Nonnull Node keyNode, @Nonnull Node valueNode) {
        this.addChild(keyNode);
        this.addChild(valueNode);
    }

    public KeyValueNodeImpl(KeyValueNodeImpl node) {
        super(node);
    }

    @Override
    @Nonnull
    public Position getStartPosition() {
        return this.startPosition == null ? this.getKey().getStartPosition() : this.startPosition;
    }

    @Override
    @Nonnull
    public Position getEndPosition() {
        return this.endPosition == null ? this.getValue().getEndPosition() : this.endPosition;
    }

    public void setStartPosition(Position startPosition) {
        this.startPosition = startPosition;
    }

    public void setEndPosition(Position endPosition) {
        this.endPosition = endPosition;
    }

    @Override
    public void addChild(Node node) {
        if (this.getChildren().size() >= 2) {
            throw new IllegalStateException();
        }
        super.addChild(node);
    }

    @Override
    @Nonnull
    public Node copy() {
        return new KeyValueNodeImpl(this);
    }

    @Override
    public Node getKey() {
        if (this.getChildren().isEmpty()) {
            throw new IllegalStateException("Key value pair with no key " + this.getClass().getSimpleName());
        }
        return this.getChildren().get(0);
    }

    @Override
    public Node getValue() {
        if (this.getChildren().size() < 2) {
            throw new IllegalStateException("Key value pair with no value " + this.getClass().getSimpleName());
        }
        return this.getChildren().get(1);
    }

    @Override
    public void setValue(Node valueNode) {
        this.setChild(1, valueNode);
    }

    public String toString() {
        return String.format("%s: %s", this.getKey(), this.getValue());
    }

    @Override
    public NodeType getType() {
        return NodeType.KeyValue;
    }
}

