/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class MaxLengthRule
extends Rule {
    private int maxLength;

    public MaxLengthRule(int maxLength) {
        this.maxLength = maxLength;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof StringNode) {
            return ((StringNode)node).getValue().length() <= this.maxLength;
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((StringNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidMaxLength(this.maxLength);
    }

    @Override
    public String getDescription() {
        return "Max length";
    }
}

