/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.loader.CompositeResourceLoader;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.impl.RamlBuilder;
import org.raml.v2.internal.impl.commons.RamlHeader;
import org.raml.v2.internal.impl.commons.RamlVersion;
import org.raml.v2.internal.impl.commons.model.RamlValidationResult;
import org.raml.v2.internal.impl.commons.model.builder.ModelProxyBuilder;
import org.raml.v2.internal.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.internal.impl.v10.RamlFragment;
import org.raml.v2.internal.utils.StreamUtils;

public class RamlModelBuilder {
    private ResourceLoader resourceLoader;
    private RamlBuilder builder = new RamlBuilder();

    public RamlModelBuilder() {
        this(new DefaultResourceLoader());
    }

    public RamlModelBuilder(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    @Nonnull
    public RamlModelResult buildApi(String ramlLocation) {
        String content = this.getRamlContent(ramlLocation);
        if (content == null) {
            return this.generateRamlApiResult("Raml does not exist at: " + ramlLocation);
        }
        return this.buildApi(content, ramlLocation);
    }

    @Nonnull
    public RamlModelResult buildApi(File ramlFile) {
        String content = this.getRamlContent(ramlFile);
        if (content == null) {
            return this.generateRamlApiResult("Files does not exist or is not a regular file: " + ramlFile.getPath());
        }
        return this.buildApi(content, ramlFile.getPath());
    }

    @Nonnull
    public RamlModelResult buildApi(Reader reader, String ramlLocation) {
        String content = this.getRamlContent(reader);
        if (content == null) {
            return this.generateRamlApiResult("Invalid reader provided with location: " + ramlLocation);
        }
        return this.buildApi(content, ramlLocation);
    }

    @Nonnull
    public RamlModelResult buildApi(String content, String ramlLocation) {
        if (content == null) {
            return this.buildApi(ramlLocation);
        }
        Node ramlNode = this.builder.build(content, this.resourceLoader, ramlLocation);
        if (!(ramlNode instanceof RamlDocumentNode)) {
            try {
                RamlHeader ramlHeader = RamlHeader.parse(content);
                if (ramlHeader.getVersion() == RamlVersion.RAML_10 && ramlHeader.getFragment() != RamlFragment.Default) {
                    return this.generateRamlApiResult("Raml file is not a root document.");
                }
            }
            catch (RamlHeader.InvalidHeaderException e) {
                // empty catch block
            }
        }
        return this.generateRamlApiResult(ramlNode);
    }

    private RamlModelResult generateRamlApiResult(Node ramlNode) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (ramlNode instanceof ErrorNode) {
            validationResults.add(new RamlValidationResult((ErrorNode)ramlNode));
        } else {
            List<ErrorNode> errors = ramlNode.findDescendantsWith(ErrorNode.class);
            for (ErrorNode errorNode : errors) {
                validationResults.add(new RamlValidationResult(errorNode));
            }
            if (validationResults.isEmpty()) {
                return this.wrapTree((RamlDocumentNode)ramlNode);
            }
        }
        return new RamlModelResult(validationResults);
    }

    private RamlModelResult generateRamlApiResult(String errorMessage) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        validationResults.add(new RamlValidationResult(errorMessage));
        return new RamlModelResult(validationResults);
    }

    private RamlModelResult wrapTree(RamlDocumentNode ramlNode) {
        if (ramlNode.getVersion() == RamlVersion.RAML_10) {
            Api apiV10 = ModelProxyBuilder.createRaml(Api.class, ramlNode);
            return new RamlModelResult(apiV10);
        }
        org.raml.v2.api.model.v08.api.Api apiV08 = ModelProxyBuilder.createRaml(org.raml.v2.api.model.v08.api.Api.class, ramlNode);
        return new RamlModelResult(apiV08);
    }

    private String getRamlContent(File ramlFile) {
        if (ramlFile == null || !ramlFile.isFile()) {
            return null;
        }
        CompositeResourceLoader fileLoader = new CompositeResourceLoader(this.resourceLoader, new FileResourceLoader(ramlFile.getParent()));
        return this.getRamlContent(ramlFile.getName(), fileLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRamlContent(Reader ramlReader) {
        if (ramlReader == null) {
            return null;
        }
        try {
            String string = IOUtils.toString((Reader)ramlReader);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((Reader)ramlReader);
        }
    }

    private String getRamlContent(String ramlLocation) {
        return this.getRamlContent(ramlLocation, this.resourceLoader);
    }

    private String getRamlContent(String ramlLocation, ResourceLoader loader) {
        if (ramlLocation == null) {
            return null;
        }
        InputStream ramlStream = loader.fetchResource(ramlLocation);
        if (ramlStream != null) {
            return StreamUtils.toString(ramlStream);
        }
        return null;
    }
}

