/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.phase;

import com.google.common.collect.ImmutableSet;
import org.raml.v2.nodes.ArrayNode;
import org.raml.v2.nodes.KeyValueNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.NullNode;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.SimpleTypeNode;
import org.raml.v2.utils.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTypesTraitsMerger {
    private static final Logger logger = LoggerFactory.getLogger(ResourceTypesTraitsMerger.class);

    static void merge(Node baseNode, Node copyNode) {
        if (copyNode instanceof NullNode) {
            return;
        }
        if (baseNode instanceof ObjectNode && copyNode instanceof ObjectNode) {
            ResourceTypesTraitsMerger.merge((ObjectNode)baseNode, (ObjectNode)copyNode);
        } else if (baseNode instanceof ArrayNode && copyNode instanceof ArrayNode) {
            ResourceTypesTraitsMerger.merge((ArrayNode)baseNode, (ArrayNode)copyNode);
        } else if (baseNode instanceof NullNode) {
            baseNode.replaceWith(copyNode);
        } else {
            throw new RuntimeException(String.format("Merging not supported for nodes of type %s and %s", baseNode.getClass().getSimpleName(), copyNode.getClass().getSimpleName()));
        }
    }

    static void merge(ArrayNode baseNode, ArrayNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            baseNode.addChild(child);
        }
    }

    static void merge(ObjectNode baseNode, ObjectNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            Node node;
            if (!(child instanceof KeyValueNode)) {
                throw new RuntimeException("only expecting KeyValueNode");
            }
            String key = ((KeyValueNode)child).getKey().toString();
            if (ResourceTypesTraitsMerger.shouldIgnoreKey((KeyValueNode)child)) {
                logger.debug("Ignoring key '{}'", (Object)key);
                continue;
            }
            boolean optional = key.endsWith("?");
            if (optional) {
                key = key.substring(0, key.length() - 1);
            }
            if ((node = NodeSelector.selectFrom(NodeSelector.encodePath(key), (Node)baseNode)) == null && optional) {
                logger.debug("Ignoring optional key {}", (Object)key);
                continue;
            }
            if (node == null) {
                logger.debug("Adding key '{}'", (Object)key);
                baseNode.addChild(child);
                continue;
            }
            if (((KeyValueNode)child).getValue() instanceof SimpleTypeNode) {
                logger.debug("Scalar key already exists '{}'", (Object)key);
                continue;
            }
            logger.debug("Merging values '{}' and '{}'", (Object)node.getParent(), (Object)child);
            ResourceTypesTraitsMerger.merge(node, ((KeyValueNode)child).getValue());
        }
    }

    private static boolean shouldIgnoreKey(KeyValueNode child) {
        ImmutableSet ignoreSet = ImmutableSet.builder().add((Object)"usage").add((Object)"type").build();
        String key = child.getKey().toString();
        return ignoreSet.contains(key);
    }
}

