/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.nodes;

import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.nodes.ErrorNode;
import org.raml.v2.nodes.ExecutableNode;
import org.raml.v2.nodes.ExecutionContext;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.StringNodeImpl;

public class StringTemplateNode
extends StringNodeImpl
implements ExecutableNode {
    public StringTemplateNode(String value) {
        super(value);
    }

    public StringTemplateNode(StringTemplateNode node) {
        super(node);
    }

    @Override
    public void addChild(Node node) {
        if (!(node instanceof StringNode)) {
            throw new IllegalArgumentException("Only String nodes are valid as children");
        }
        super.addChild(node);
    }

    @Override
    public Node execute(ExecutionContext context) {
        List<Node> children = this.getChildren();
        StringBuilder content = new StringBuilder();
        for (Node child : children) {
            if (child instanceof ExecutableNode) {
                Node result = ((ExecutableNode)child).execute(context);
                if (result instanceof ErrorNode) {
                    return result;
                }
                content.append(((StringNode)result).getValue());
                continue;
            }
            content.append(((StringNode)child).getValue());
        }
        return new StringNodeImpl(content.toString());
    }

    @Override
    @Nonnull
    public Node copy() {
        return new StringTemplateNode(this);
    }
}

