/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.grammar.rule.ClassNodeFactory;
import org.raml.v2.grammar.rule.NodeFactory;
import org.raml.v2.nodes.Node;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;

public abstract class Rule {
    @Nullable
    private NodeFactory factory;

    protected Rule() {
    }

    public abstract boolean matches(@Nonnull Node var1);

    @Nonnull
    public abstract Node apply(@Nonnull Node var1);

    public abstract String getDescription();

    @Nullable
    private NodeFactory getFactory() {
        return this.factory;
    }

    @Nonnull
    public Node createNodeUsingFactory(@Nonnull Node currentNode, Object ... args) {
        Node newNode;
        if (this.getFactory() != null && !(newNode = this.getFactory().create(args)).getClass().equals(currentNode.getClass())) {
            return newNode;
        }
        return currentNode;
    }

    public Rule then(Class<? extends Node> clazz) {
        this.factory = new ClassNodeFactory(clazz);
        return this;
    }

    public Rule then(NodeFactory factory) {
        this.factory = factory;
        return this;
    }

    public List<Suggestion> getSuggestions(List<Node> pathToRoot, RamlParsingContext context) {
        if (!pathToRoot.isEmpty()) {
            return this.getSuggestions(pathToRoot.get(0), context);
        }
        return Collections.emptyList();
    }

    @Nonnull
    public abstract List<Suggestion> getSuggestions(Node var1, RamlParsingContext var2);
}

