/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.io.IOUtils;
import org.raml.v2.grammar.rule.ErrorNodeFactory;
import org.raml.v2.impl.commons.RamlHeader;
import org.raml.v2.impl.commons.RamlVersion;
import org.raml.v2.impl.v08.Raml08Builder;
import org.raml.v2.impl.v10.Raml10Builder;
import org.raml.v2.loader.CompositeResourceLoader;
import org.raml.v2.loader.DefaultResourceLoader;
import org.raml.v2.loader.FileResourceLoader;
import org.raml.v2.loader.ResourceLoader;
import org.raml.v2.nodes.Node;

public class RamlBuilder {
    public static int FIRST_PHASE = 1;
    public static int SECOND_PHASE = 2;
    public static int SUGAR_PHASE = 3;
    private int maxPhaseNumber;
    private ResourceLoader resourceLoader = null;
    private String actualPath = null;

    public RamlBuilder() {
        this.maxPhaseNumber = Integer.MAX_VALUE;
    }

    public RamlBuilder(int maxPhaseNumber) {
        this.maxPhaseNumber = maxPhaseNumber;
    }

    public Node build(File ramlFile) throws IOException {
        CompositeResourceLoader resourceLoader = new CompositeResourceLoader(new DefaultResourceLoader(), new FileResourceLoader(ramlFile.getParent()));
        this.resourceLoader = resourceLoader;
        this.actualPath = ramlFile.getPath();
        try (FileReader reader = new FileReader(ramlFile);){
            Node node = this.build(reader, (ResourceLoader)resourceLoader, ramlFile.getName());
            return node;
        }
    }

    public Node build(String content) {
        return this.build(content, "");
    }

    public Node build(String content, String resourceLocation) {
        return this.build(content, (ResourceLoader)new DefaultResourceLoader(), resourceLocation);
    }

    public Node build(String content, ResourceLoader resourceLoader, String resourceLocation) {
        return this.build(new StringReader(content), resourceLoader, resourceLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node build(Reader content, ResourceLoader resourceLoader, String resourceLocation) {
        Node node;
        try {
            String stringContent = IOUtils.toString((Reader)content);
            RamlHeader ramlHeader = RamlHeader.parse(stringContent);
            if (RamlVersion.RAML_10 == ramlHeader.getVersion()) {
                Node node2 = new Raml10Builder().build(stringContent, ramlHeader.getFragment(), resourceLoader, resourceLocation, this.maxPhaseNumber);
                return node2;
            }
            Node node3 = new Raml08Builder().build(stringContent, resourceLoader, resourceLocation, this.maxPhaseNumber);
            return node3;
        }
        catch (IOException ioe) {
            node = ErrorNodeFactory.createInvalidInput(ioe);
            return node;
        }
        catch (RamlHeader.InvalidHeaderVersionException e) {
            node = ErrorNodeFactory.createUnsupportedVersion(e.getMessage());
            return node;
        }
        catch (RamlHeader.InvalidHeaderFragmentException e) {
            node = ErrorNodeFactory.createInvalidFragmentName(e.getMessage());
            return node;
        }
        catch (RamlHeader.MissingHeaderException e) {
            node = ErrorNodeFactory.createEmptyDocument();
            return node;
        }
        catch (RamlHeader.InvalidHeaderException e) {
            node = ErrorNodeFactory.createInvalidHeader(e.getMessage());
            return node;
        }
        finally {
            IOUtils.closeQuietly((Reader)content);
        }
    }

    public ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getActualPath() {
        return this.actualPath;
    }
}

