/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify;

import java.sql.Connection;
import javax.sql.DataSource;
import org.r10r.sqlify.SqlifyException;

public class Database {
    private final DataSource dataSource;

    private Database(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public static Database use(DataSource dataSource) {
        Database database = new Database(dataSource);
        return database;
    }

    public <T> T withConnection(Executable<T> block) {
        return this.withConnection(true, block);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withConnection(boolean autocommit, Executable<T> block) {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(autocommit);
            T t = block.execute(connection);
            return t;
        }
        catch (Exception e) {
            throw new SqlifyException(e);
        }
    }

    public <T> T withTransaction(Executable<T> block) {
        return (T)this.withConnection(false, connection -> {
            try {
                Object t = block.execute(connection);
                connection.commit();
                return t;
            }
            catch (Exception e1) {
                try {
                    connection.rollback();
                }
                catch (Exception e2) {
                    throw new SqlifyException(e2);
                }
                throw new SqlifyException(e1);
            }
        });
    }

    public static interface Executable<T> {
        public T execute(Connection var1);
    }
}

