/*
 * Decompiled with CFR 0.152.
 */
package org.r10r.sqlify.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.r10r.sqlify.core.SqlifyCore;
import org.r10r.sqlify.core.SqlifyException;
import org.r10r.sqlify.resultparser.ResultParser;

public final class SqlifySingle {
    private final String sqlForJdbc;
    private final ResultParser<?> resultParser;
    private final Map<String, Object> parameterMap;
    private final List<String> parametersInSqlSorted;

    public SqlifySingle(String userProvidedSqlWithPlaceholder, ResultParser<?> resultParser, Map<String, Object> parameterMap) {
        this.resultParser = resultParser;
        this.parameterMap = parameterMap;
        this.parametersInSqlSorted = SqlifyCore.extractParameterNames(userProvidedSqlWithPlaceholder);
        this.sqlForJdbc = SqlifyCore.convertNamedParametersIntoJdbcCompliantPreparedStatement(userProvidedSqlWithPlaceholder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeSelect(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlForJdbc);){
            Object t;
            SqlifyCore.applyParameterMapToPreparedStatement(preparedStatement, this.parameterMap, this.parametersInSqlSorted);
            ResultSet resultSet = preparedStatement.executeQuery();
            Object obj = t = this.resultParser.parseResultSet(resultSet);
            return (T)obj;
        }
        catch (Exception exception) {
            throw new SqlifyException("Ops. Something strange happened: " + exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlForJdbc);){
            int numberOfChangedLines;
            SqlifyCore.applyParameterMapToPreparedStatement(preparedStatement, this.parameterMap, this.parametersInSqlSorted);
            int n = numberOfChangedLines = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException sqlException) {
            throw new SqlifyException("Ops. Something strange happened:  " + sqlException.getMessage(), sqlException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeUpdateAndReturnGeneratedKey(Connection connection) {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.sqlForJdbc, 1);){
            SqlifyCore.applyParameterMapToPreparedStatement(preparedStatement, this.parameterMap, this.parametersInSqlSorted);
            preparedStatement.executeUpdate();
            ResultSet generatedKeys = preparedStatement.getGeneratedKeys();
            Object obj = this.resultParser.parseResultSet(generatedKeys);
            return (T)obj;
        }
        catch (Exception exception) {
            throw new SqlifyException("Ops. Something strange happened: " + exception.getMessage(), exception);
        }
    }
}

