/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.ordermatch;

import java.util.ArrayList;
import java.util.HashMap;
import quickfix.examples.ordermatch.Market;
import quickfix.examples.ordermatch.Order;

public class OrderMatcher {
    private final HashMap<String, Market> markets = new HashMap();

    private Market getMarket(String symbol) {
        return this.markets.computeIfAbsent(symbol, k -> new Market());
    }

    public boolean insert(Order order) {
        return this.getMarket(order.getSymbol()).insert(order);
    }

    public void match(String symbol, ArrayList<Order> orders) {
        this.getMarket(symbol).match(symbol, orders);
    }

    public Order find(String symbol, char side, String id) {
        return this.getMarket(symbol).find(symbol, side, id);
    }

    public void erase(Order order) {
        this.getMarket(order.getSymbol()).erase(order);
    }

    public void display() {
        for (String symbol : this.markets.keySet()) {
            System.out.println("MARKET: " + symbol);
            this.display(symbol);
        }
    }

    public void display(String symbol) {
        this.getMarket(symbol).display();
    }
}

