/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.util.HashMap;
import java.util.Map;

public class OrderSide {
    private static final Map<String, OrderSide> known = new HashMap<String, OrderSide>();
    public static final OrderSide BUY = new OrderSide("Buy");
    public static final OrderSide SELL = new OrderSide("Sell");
    public static final OrderSide SHORT_SELL = new OrderSide("Short Sell");
    public static final OrderSide SHORT_SELL_EXEMPT = new OrderSide("Short Sell Exempt");
    public static final OrderSide CROSS = new OrderSide("Cross");
    public static final OrderSide CROSS_SHORT = new OrderSide("Cross Short");
    public static final OrderSide CROSS_SHORT_EXEMPT = new OrderSide("Cross Short Exempt");
    private static final OrderSide[] array = new OrderSide[]{BUY, SELL, SHORT_SELL, SHORT_SELL_EXEMPT, CROSS, CROSS_SHORT, CROSS_SHORT_EXEMPT};
    private final String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OrderSide(String name) {
        this.name = name;
        Class<OrderSide> clazz = OrderSide.class;
        synchronized (OrderSide.class) {
            known.put(name, this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Object[] toArray() {
        return array;
    }

    public static OrderSide parse(String type) throws IllegalArgumentException {
        OrderSide result = known.get(type);
        if (result == null) {
            throw new IllegalArgumentException("OrderSide: " + type + " is unknown.");
        }
        return result;
    }
}

