/*
 * Decompiled with CFR 0.152.
 */
package quickfix.examples.banzai;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.quickfixj.jmx.JmxExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Application;
import quickfix.Connector;
import quickfix.DefaultMessageFactory;
import quickfix.FileStoreFactory;
import quickfix.Initiator;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SocketInitiator;
import quickfix.examples.banzai.BanzaiApplication;
import quickfix.examples.banzai.ExecutionTableModel;
import quickfix.examples.banzai.OrderTableModel;
import quickfix.examples.banzai.ui.BanzaiFrame;

public class Banzai {
    private static final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger log = LoggerFactory.getLogger(Banzai.class);
    private static Banzai banzai;
    private boolean initiatorStarted = false;
    private Initiator initiator = null;
    private JFrame frame = null;

    public Banzai(String[] args) throws Exception {
        InputStream inputStream = null;
        if (args.length == 0) {
            inputStream = Banzai.class.getResourceAsStream("banzai.cfg");
        } else if (args.length == 1) {
            inputStream = new FileInputStream(args[0]);
        }
        if (inputStream == null) {
            System.out.println("usage: " + Banzai.class.getName() + " [configFile].");
            return;
        }
        SessionSettings settings = new SessionSettings(inputStream);
        inputStream.close();
        boolean logHeartbeats = Boolean.valueOf(System.getProperty("logHeartbeats", "true"));
        OrderTableModel orderTableModel = new OrderTableModel();
        ExecutionTableModel executionTableModel = new ExecutionTableModel();
        BanzaiApplication application = new BanzaiApplication(orderTableModel, executionTableModel);
        FileStoreFactory messageStoreFactory = new FileStoreFactory(settings);
        ScreenLogFactory logFactory = new ScreenLogFactory(true, true, true, logHeartbeats);
        DefaultMessageFactory messageFactory = new DefaultMessageFactory();
        this.initiator = new SocketInitiator((Application)application, (MessageStoreFactory)messageStoreFactory, settings, (LogFactory)logFactory, (MessageFactory)messageFactory);
        JmxExporter exporter = new JmxExporter();
        exporter.register((Connector)this.initiator);
        this.frame = new BanzaiFrame(orderTableModel, executionTableModel, application);
        this.frame.setDefaultCloseOperation(3);
    }

    public synchronized void logon() {
        if (!this.initiatorStarted) {
            try {
                this.initiator.start();
                this.initiatorStarted = true;
            }
            catch (Exception e) {
                log.error("Logon failed", (Throwable)e);
            }
        } else {
            for (SessionID sessionId : this.initiator.getSessions()) {
                Session.lookupSession((SessionID)sessionId).logon();
            }
        }
    }

    public void logout() {
        for (SessionID sessionId : this.initiator.getSessions()) {
            Session.lookupSession((SessionID)sessionId).logout("user requested");
        }
    }

    public void stop() {
        shutdownLatch.countDown();
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public static Banzai get() {
        return banzai;
    }

    public static void main(String[] args) throws Exception {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.info(e.getMessage(), (Throwable)e);
        }
        banzai = new Banzai(args);
        if (!System.getProperties().containsKey("openfix")) {
            banzai.logon();
        }
        shutdownLatch.await();
    }
}

