/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.mina.filter.ssl.BogusTrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.FileUtil;
import quickfix.mina.ssl.SSLConfig;
import quickfix.mina.ssl.X509TrustManagerWrapper;

public class SSLContextFactory {
    private static final Logger log = LoggerFactory.getLogger(SSLContextFactory.class);
    private static final String PROTOCOL = "TLS";
    private static final Map<SSLConfig, SSLContext> contextCache = new HashMap<SSLConfig, SSLContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLContext getInstance(SSLConfig sslConfig) throws GeneralSecurityException {
        Map<SSLConfig, SSLContext> map = contextCache;
        synchronized (map) {
            SSLContext context = contextCache.get(sslConfig);
            if (context == null) {
                try {
                    context = SSLContextFactory.createSSLContext(sslConfig);
                    contextCache.put(sslConfig, context);
                }
                catch (Exception ioe) {
                    throw new GeneralSecurityException("Can't create SSLContext", ioe);
                }
            }
            return context;
        }
    }

    private static SSLContext createSSLContext(SSLConfig sslConfig) throws GeneralSecurityException, IOException {
        TrustManager[] trustManagers;
        KeyManagerFactory kmf = SSLContextFactory.initializeKeyManager(sslConfig);
        TrustManagerFactory tmf = null;
        if (sslConfig.getTrustStoreName() != null && sslConfig.getTrustStoreType() != null && sslConfig.getTrustManagerFactoryAlgorithm() != null) {
            tmf = SSLContextFactory.initializeTrustManager(sslConfig);
        }
        if (tmf == null) {
            tmf = new BogusTrustManagerFactory();
        }
        if ((trustManagers = tmf.getTrustManagers()) != null) {
            trustManagers = X509TrustManagerWrapper.wrap(trustManagers);
        }
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(kmf.getKeyManagers(), trustManagers, null);
        return sslContext;
    }

    private static KeyManagerFactory initializeKeyManager(SSLConfig sslConfig) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore ks = SSLContextFactory.initializeKeyStore(sslConfig.getKeyStoreName(), sslConfig.getKeyStorePassword(), sslConfig.getKeyStoreType());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(sslConfig.getKeyManagerFactoryAlgorithm());
        kmf.init(ks, sslConfig.getKeyStorePassword());
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore initializeKeyStore(String keyStoreName, char[] keyStorePassword, String keyStoreType) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        InputStream in = null;
        try {
            in = FileUtil.open(SSLContextFactory.class, keyStoreName);
            if (in == null) {
                log.warn("{}: keystore not found, using empty keystore", (Object)keyStoreName);
            }
            keyStore.load(in, keyStorePassword);
        }
        finally {
            SSLContextFactory.closeInputStream(in);
        }
        return keyStore;
    }

    private static TrustManagerFactory initializeTrustManager(SSLConfig sslConfig) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        KeyStore ts = SSLContextFactory.initializeTrustStore(sslConfig.getTrustStoreName(), sslConfig.getTrustStorePassword(), sslConfig.getTrustStoreType());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(sslConfig.getTrustManagerFactoryAlgorithm());
        tmf.init(ts);
        return tmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore initializeTrustStore(String trustStoreName, char[] trustStorePassword, String trustStoreType) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        KeyStore keyStore = KeyStore.getInstance(trustStoreType);
        InputStream in = null;
        try {
            in = FileUtil.open(SSLContextFactory.class, trustStoreName);
            if (in == null) {
                KeyStore keyStore2 = null;
                return keyStore2;
            }
            keyStore.load(in, trustStorePassword);
        }
        finally {
            SSLContextFactory.closeInputStream(in);
        }
        return keyStore;
    }

    private static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

