/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.AbstractSessionConnectorBuilder;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionSettings;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.ThreadPerSessionEventHandlingStrategy;
import quickfix.mina.acceptor.AbstractSocketAcceptor;

public class ThreadedSocketAcceptor
extends AbstractSocketAcceptor {
    private final ThreadPerSessionEventHandlingStrategy eventHandlingStrategy;

    private ThreadedSocketAcceptor(Builder builder) throws ConfigError {
        super(builder.application, builder.messageStoreFactory, builder.settings, builder.logFactory, builder.messageFactory);
        this.eventHandlingStrategy = builder.queueCapacity >= 0 ? new ThreadPerSessionEventHandlingStrategy(this, builder.queueCapacity) : new ThreadPerSessionEventHandlingStrategy(this, builder.queueLowerWatermark, builder.queueUpperWatermark);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, logFactory, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory, int queueCapacity) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        super(application, messageStoreFactory, settings, messageFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    public ThreadedSocketAcceptor(SessionFactory sessionFactory, SessionSettings settings, int queueCapacity) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, queueCapacity);
    }

    public ThreadedSocketAcceptor(SessionFactory sessionFactory, SessionSettings settings) throws ConfigError {
        super(settings, sessionFactory);
        this.eventHandlingStrategy = new ThreadPerSessionEventHandlingStrategy(this, 10000);
    }

    @Override
    public void start() throws ConfigError, RuntimeError {
        this.eventHandlingStrategy.setExecutor(this.longLivedExecutor);
        this.startAcceptingConnections();
    }

    @Override
    public void stop(boolean forceDisconnect) {
        this.logoutAllSessions(forceDisconnect);
        this.stopAcceptingConnections();
        this.stopSessionTimer();
        this.eventHandlingStrategy.stopDispatcherThreads();
        Session.unregisterSessions(this.getSessions(), true);
        this.clearConnectorSessions();
    }

    @Override
    protected EventHandlingStrategy getEventHandlingStrategy() {
        return this.eventHandlingStrategy;
    }

    public static final class Builder
    extends AbstractSessionConnectorBuilder<Builder, ThreadedSocketAcceptor> {
        private Builder() {
            super(Builder.class);
        }

        @Override
        protected ThreadedSocketAcceptor doBuild() throws ConfigError {
            return new ThreadedSocketAcceptor(this);
        }
    }
}

