/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.HasFieldAndReason;
import quickfix.SessionRejectReasonText;

public class IncorrectTagValue
extends Exception
implements HasFieldAndReason {
    private String value;
    private final int field;
    private final int sessionRejectReason;

    public IncorrectTagValue(int field) {
        super(SessionRejectReasonText.getMessage(5) + ", field=" + field);
        this.field = field;
        this.sessionRejectReason = 5;
    }

    public IncorrectTagValue(int field, String value) {
        super(SessionRejectReasonText.getMessage(5) + ", field=" + field + (value != null ? ", value=" + value : ""));
        this.field = field;
        this.value = value;
        this.sessionRejectReason = 5;
    }

    public IncorrectTagValue(int field, String value, String message) {
        super(message);
        this.field = field;
        this.value = value;
        this.sessionRejectReason = 5;
    }

    @Override
    public String toString() {
        String str = super.toString();
        if (this.field != 0) {
            str = str + " field=" + this.field;
        }
        if (this.value != null) {
            str = str + " value=" + this.value;
        }
        return str;
    }

    @Override
    public int getField() {
        return this.field;
    }

    @Override
    public int getSessionRejectReason() {
        return this.sessionRejectReason;
    }
}

