/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.quickfixj.CharsetSupport;
import quickfix.BooleanField;
import quickfix.BytesField;
import quickfix.CharField;
import quickfix.DecimalField;
import quickfix.DoubleField;
import quickfix.Field;
import quickfix.FieldConvertError;
import quickfix.FieldException;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.IntField;
import quickfix.MessageComponent;
import quickfix.MessageUtils;
import quickfix.NumbersCache;
import quickfix.RuntimeError;
import quickfix.StringField;
import quickfix.UtcDateOnlyField;
import quickfix.UtcTimeOnlyField;
import quickfix.UtcTimeStampField;
import quickfix.UtcTimestampPrecision;
import quickfix.field.converter.BooleanConverter;
import quickfix.field.converter.CharConverter;
import quickfix.field.converter.DecimalConverter;
import quickfix.field.converter.DoubleConverter;
import quickfix.field.converter.IntConverter;
import quickfix.field.converter.UtcDateOnlyConverter;
import quickfix.field.converter.UtcTimeOnlyConverter;
import quickfix.field.converter.UtcTimestampConverter;

public abstract class FieldMap
implements Serializable {
    static final long serialVersionUID = -3193357271891865972L;
    private final int[] fieldOrder;
    private final TreeMap<Integer, Field<?>> fields;
    private final TreeMap<Integer, List<Group>> groups = new TreeMap();
    private static final boolean IS_STRING_EQUIVALENT = CharsetSupport.isStringEquivalent(CharsetSupport.getCharsetInstance());

    protected FieldMap(int[] fieldOrder) {
        this.fieldOrder = fieldOrder;
        this.fields = new TreeMap(fieldOrder != null ? new FieldOrderComparator() : null);
    }

    protected FieldMap() {
        this(null);
    }

    public int[] getFieldOrder() {
        return this.fieldOrder;
    }

    public void clear() {
        this.fields.clear();
        this.groups.clear();
    }

    public void reset() {
        this.fields.clear();
        for (List<Group> groupList : this.groups.values()) {
            for (Group group : groupList) {
                group.reset();
            }
        }
        this.groups.clear();
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    protected static int indexOf(int field, int[] fieldOrder) {
        if (fieldOrder != null) {
            for (int i = 0; i < fieldOrder.length; ++i) {
                if (field != fieldOrder[i]) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isOrderedField(int field, int[] fieldOrder) {
        return FieldMap.indexOf(field, fieldOrder) > -1;
    }

    public void setFields(FieldMap fieldMap) {
        this.fields.clear();
        this.fields.putAll(fieldMap.fields);
    }

    protected void setComponent(MessageComponent component) {
        component.copyTo(this);
    }

    protected void getComponent(MessageComponent component) {
        component.clear();
        component.copyFrom(this);
    }

    public void setGroups(FieldMap fieldMap) {
        this.groups.clear();
        this.groups.putAll(fieldMap.groups);
    }

    protected void setGroups(int key, List<Group> groupList) {
        this.groups.put(key, groupList);
    }

    public void setString(int field, String value) {
        this.setField(new StringField(field, value));
    }

    public void setBytes(int field, byte[] value) {
        this.setField(field, new BytesField(field, value));
    }

    public void setBoolean(int field, boolean value) {
        this.setField(new StringField(field, BooleanConverter.convert(value)));
    }

    public void setChar(int field, char value) {
        this.setField(new StringField(field, CharConverter.convert(value)));
    }

    public void setInt(int field, int value) {
        this.setField(new StringField(field, IntConverter.convert(value)));
    }

    public void setDouble(int field, double value) {
        this.setDouble(field, value, 0);
    }

    public void setDouble(int field, double value, int padding) {
        this.setField(new StringField(field, DoubleConverter.convert(value, padding)));
    }

    public void setDecimal(int field, BigDecimal value) {
        this.setField(new StringField(field, DecimalConverter.convert(value)));
    }

    public void setDecimal(int field, BigDecimal value, int padding) {
        this.setField(new StringField(field, DecimalConverter.convert(value, padding)));
    }

    public void setUtcTimeStamp(int field, LocalDateTime value) {
        this.setUtcTimeStamp(field, value, false);
    }

    public void setUtcTimeStamp(int field, LocalDateTime value, boolean includeMilliseconds) {
        this.setField(new StringField(field, UtcTimestampConverter.convert(value, includeMilliseconds ? UtcTimestampPrecision.MILLIS : UtcTimestampPrecision.SECONDS)));
    }

    public void setUtcTimeStamp(int field, LocalDateTime value, UtcTimestampPrecision precision) {
        this.setField(new StringField(field, UtcTimestampConverter.convert(value, precision)));
    }

    public void setUtcTimeOnly(int field, LocalTime value) {
        this.setUtcTimeOnly(field, value, false);
    }

    public void setUtcTimeOnly(int field, LocalTime value, boolean includeMilliseconds) {
        this.setField(new StringField(field, UtcTimeOnlyConverter.convert(value, includeMilliseconds ? UtcTimestampPrecision.MILLIS : UtcTimestampPrecision.SECONDS)));
    }

    public void setUtcTimeOnly(int field, LocalTime value, UtcTimestampPrecision precision) {
        this.setField(new StringField(field, UtcTimeOnlyConverter.convert(value, precision)));
    }

    public void setUtcDateOnly(int field, LocalDate value) {
        this.setField(new StringField(field, UtcDateOnlyConverter.convert(value)));
    }

    StringField getField(int field) throws FieldNotFound {
        StringField f = (StringField)this.fields.get(field);
        if (f == null) {
            throw new FieldNotFound(field);
        }
        return f;
    }

    Field<?> getField(int field, Field<?> defaultValue) {
        Field<?> f = this.fields.get(field);
        if (f == null) {
            return defaultValue;
        }
        return f;
    }

    public String getString(int field) throws FieldNotFound {
        return (String)this.getField(field).getObject();
    }

    public Optional<String> getOptionalString(int field) {
        StringField f = (StringField)this.fields.get(field);
        if (f == null) {
            return Optional.empty();
        }
        return Optional.of(f.getValue());
    }

    public boolean getBoolean(int field) throws FieldNotFound {
        try {
            return BooleanConverter.convert(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public char getChar(int field) throws FieldNotFound {
        try {
            return CharConverter.convert(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public int getInt(int field) throws FieldNotFound {
        try {
            return IntConverter.convert(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public double getDouble(int field) throws FieldNotFound {
        try {
            return DoubleConverter.convert(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public BigDecimal getDecimal(int field) throws FieldNotFound {
        return this.getDecimalFromString(field, this.getString(field));
    }

    public Optional<BigDecimal> getOptionalDecimal(int field) {
        return this.getOptionalString(field).map(s -> this.getDecimalFromString(field, (String)s));
    }

    private BigDecimal getDecimalFromString(int field, String s) {
        try {
            return DecimalConverter.convert(s);
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public LocalDateTime getUtcTimeStamp(int field) throws FieldNotFound {
        try {
            return UtcTimestampConverter.convertToLocalDateTime(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public LocalTime getUtcTimeOnly(int field) throws FieldNotFound {
        try {
            return UtcTimeOnlyConverter.convertToLocalTime(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public LocalDate getUtcDateOnly(int field) throws FieldNotFound {
        try {
            return UtcDateOnlyConverter.convertToLocalDate(this.getString(field));
        }
        catch (FieldConvertError e) {
            throw this.newIncorrectDataException(e, field);
        }
    }

    public void setField(int key, Field<?> field) {
        this.fields.put(key, field);
    }

    public void setField(StringField field) {
        if (field.getValue() == null) {
            throw new NullPointerException("Null field values are not allowed.");
        }
        this.fields.put(field.getField(), field);
    }

    public void setField(BooleanField field) {
        this.setBoolean(field.getField(), field.getValue());
    }

    public void setField(CharField field) {
        this.setChar(field.getField(), field.getValue());
    }

    public void setField(IntField field) {
        this.setInt(field.getField(), field.getValue());
    }

    public void setField(DoubleField field) {
        this.setDouble(field.getField(), field.getValue());
    }

    public void setField(DecimalField field) {
        this.setDecimal(field.getField(), field.getValue());
    }

    public void setField(UtcTimeStampField field) {
        this.setUtcTimeStamp(field.getField(), field.getValue(), field.getPrecision());
    }

    public void setField(UtcTimeOnlyField field) {
        this.setUtcTimeOnly(field.getField(), field.getValue(), field.getPrecision());
    }

    public void setField(UtcDateOnlyField field) {
        this.setUtcDateOnly(field.getField(), field.getValue());
    }

    public void setField(BytesField field) {
        this.setBytes(field.getField(), (byte[])field.getObject());
    }

    static <T, F extends Field<T>> F updateValue(F field, T value) {
        field.setObject(value);
        return field;
    }

    public BytesField getField(BytesField field) throws FieldNotFound {
        Field<?> returnField = this.fields.get(field.getField());
        if (returnField == null) {
            throw new FieldNotFound(field.getField());
        }
        if (returnField instanceof BytesField) {
            return (BytesField)returnField;
        }
        throw new FieldException(6, field.getField());
    }

    public StringField getField(StringField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getString(field.getField()));
    }

    public BooleanField getField(BooleanField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getBoolean(field.getField()));
    }

    public CharField getField(CharField field) throws FieldNotFound {
        return FieldMap.updateValue(field, Character.valueOf(this.getChar(field.getField())));
    }

    public IntField getField(IntField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getInt(field.getField()));
    }

    public DoubleField getField(DoubleField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getDouble(field.getField()));
    }

    public DecimalField getField(DecimalField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getDecimal(field.getField()));
    }

    public UtcTimeStampField getField(UtcTimeStampField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getUtcTimeStamp(field.getField()));
    }

    public UtcTimeOnlyField getField(UtcTimeOnlyField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getUtcTimeOnly(field.getField()));
    }

    public UtcDateOnlyField getField(UtcDateOnlyField field) throws FieldNotFound {
        return FieldMap.updateValue(field, this.getUtcDateOnly(field.getField()));
    }

    private FieldException newIncorrectDataException(FieldConvertError e, int tag) {
        return new FieldException(6, e.getMessage(), tag);
    }

    public boolean isSetField(int field) {
        return this.fields.containsKey(field);
    }

    public boolean isSetField(Field<?> field) {
        return this.isSetField(field.getField());
    }

    public void removeField(int field) {
        this.fields.remove(field);
    }

    public Iterator<Field<?>> iterator() {
        return this.fields.values().iterator();
    }

    protected void initializeFrom(FieldMap source) {
        this.fields.clear();
        this.fields.putAll(source.fields);
        for (Map.Entry<Integer, List<Group>> entry : source.groups.entrySet()) {
            ArrayList<Group> clones = new ArrayList<Group>();
            for (Group group : entry.getValue()) {
                Group clone = new Group(group.getFieldTag(), group.delim(), group.getFieldOrder());
                clone.initializeFrom(group);
                clones.add(clone);
            }
            this.groups.put(entry.getKey(), clones);
        }
    }

    private boolean isGroupField(int field) {
        return this.groups.containsKey(field);
    }

    private static void appendField(StringBuilder buffer, Field<?> field) {
        if (field != null) {
            field.toString(buffer);
            buffer.append('\u0001');
        }
    }

    protected void calculateString(StringBuilder buffer, int[] preFields, int[] postFields) {
        if (preFields != null) {
            int[] object = preFields;
            int n = object.length;
            for (int i = 0; i < n; ++i) {
                int preField = object[i];
                FieldMap.appendField(buffer, this.getField(preField, null));
            }
        }
        for (Field<?> field : this.fields.values()) {
            int tag = field.getField();
            if (!(FieldMap.isOrderedField(tag, preFields) || FieldMap.isOrderedField(tag, postFields) || this.isGroupField(tag))) {
                FieldMap.appendField(buffer, field);
                continue;
            }
            if (!this.isGroupField(tag) || !FieldMap.isOrderedField(tag, this.fieldOrder) || this.getGroupCount(tag) <= 0) continue;
            FieldMap.appendField(buffer, field);
            List<Group> groups = this.getGroups(tag);
            for (int i = 0; i < groups.size(); ++i) {
                groups.get(i).calculateString(buffer, preFields, postFields);
            }
        }
        for (Map.Entry<Integer, List<Group>> entry : this.groups.entrySet()) {
            List<Group> groups;
            int groupCount;
            Integer groupCountTag = entry.getKey();
            if (FieldMap.isOrderedField(groupCountTag, this.fieldOrder) || (groupCount = (groups = entry.getValue()).size()) <= 0) continue;
            buffer.append(NumbersCache.get(groupCountTag)).append('=');
            buffer.append(NumbersCache.get(groupCount)).append('\u0001');
            for (int i = 0; i < groups.size(); ++i) {
                groups.get(i).calculateString(buffer, preFields, postFields);
            }
        }
        if (postFields != null) {
            for (int postField : postFields) {
                FieldMap.appendField(buffer, this.getField(postField, null));
            }
        }
    }

    int calculateLength() {
        int result = 0;
        for (Field<?> field : this.fields.values()) {
            int tag = field.getField();
            if (tag == 8 || tag == 9 || tag == 10 || this.isGroupField(tag)) continue;
            result += field.getLength();
        }
        for (Map.Entry entry : this.groups.entrySet()) {
            List groupList = (List)entry.getValue();
            if (groupList.isEmpty()) continue;
            if (IS_STRING_EQUIVALENT) {
                result += FieldMap.getStringLength((Integer)entry.getKey()) + FieldMap.getStringLength(groupList.size()) + 2;
            } else {
                result += MessageUtils.length(CharsetSupport.getCharsetInstance(), NumbersCache.get((Integer)entry.getKey()));
                result += MessageUtils.length(CharsetSupport.getCharsetInstance(), NumbersCache.get(groupList.size()));
                result += 2;
            }
            for (int i = 0; i < groupList.size(); ++i) {
                result += ((Group)groupList.get(i)).calculateLength();
            }
        }
        return result;
    }

    private static int getStringLength(int num) {
        if (num == 0) {
            return 1;
        }
        return (int)(num > 0 ? Math.log10(num) + 1.0 : Math.log10(-num) + 2.0);
    }

    int calculateChecksum() {
        int result = 0;
        for (Field<?> field : this.fields.values()) {
            if (field.getField() == 10 || this.isGroupField(field.getField())) continue;
            result += field.getChecksum();
        }
        for (Map.Entry entry : this.groups.entrySet()) {
            List groupList = (List)entry.getValue();
            if (groupList.isEmpty()) continue;
            if (IS_STRING_EQUIVALENT) {
                String value = NumbersCache.get((Integer)entry.getKey());
                int i = value.length();
                while (i-- != 0) {
                    result += value.charAt(i);
                }
                value = NumbersCache.get(groupList.size());
                i = value.length();
                while (i-- != 0) {
                    result += value.charAt(i);
                }
                result += 62;
            } else {
                IntField groupField = new IntField((Integer)entry.getKey());
                groupField.setValue(groupList.size());
                result += groupField.getChecksum();
            }
            for (int i = 0; i < groupList.size(); ++i) {
                result += ((Group)groupList.get(i)).calculateChecksum();
            }
        }
        return result & 0xFF;
    }

    public int getGroupCount(int tag) {
        return this.getGroups(tag).size();
    }

    public Iterator<Integer> groupKeyIterator() {
        return this.groups.keySet().iterator();
    }

    Map<Integer, List<Group>> getGroups() {
        return this.groups;
    }

    public void addGroup(Group group) {
        this.addGroupRef(new Group(group));
    }

    public void addGroupRef(Group group) {
        int countTag = group.getFieldTag();
        List<Group> currentGroups = this.getGroups(countTag);
        currentGroups.add(group);
        this.setGroupCount(countTag, currentGroups.size());
    }

    protected void setGroupCount(int countTag, int groupSize) {
        try {
            StringField count;
            if (groupSize == 1) {
                count = new StringField(countTag, "1");
                this.setField(countTag, count);
            } else {
                count = this.getField(countTag);
            }
            count.setValue(Integer.toString(groupSize));
        }
        catch (FieldNotFound e) {
            throw new RuntimeError(e);
        }
    }

    public List<Group> getGroups(int field) {
        return this.groups.computeIfAbsent(field, k -> new ArrayList());
    }

    public Group getGroup(int num, Group group) throws FieldNotFound {
        List<Group> groupList = this.getGroups(group.getFieldTag());
        if (num > groupList.size()) {
            throw new FieldNotFound(group.getFieldTag() + ", index=" + num);
        }
        Group grp = groupList.get(num - 1);
        group.setFields(grp);
        group.setGroups(grp);
        return group;
    }

    public Group getGroup(int num, int groupTag) throws FieldNotFound {
        List<Group> groupList = this.getGroups(groupTag);
        if (num > groupList.size()) {
            throw new FieldNotFound(groupTag + ", index=" + num);
        }
        return groupList.get(num - 1);
    }

    public void replaceGroup(int num, Group group) {
        int offset = num - 1;
        List<Group> groupList = this.getGroups(group.getFieldTag());
        if (offset < 0 || offset >= groupList.size()) {
            return;
        }
        groupList.set(offset, new Group(group));
    }

    public void removeGroup(int field) {
        this.getGroups(field).clear();
        this.removeField(field);
    }

    public void removeGroup(int num, int field) {
        List<Group> groupList = this.getGroups(field);
        if (num <= groupList.size()) {
            groupList.remove(num - 1);
        }
        if (!groupList.isEmpty()) {
            this.setGroupCount(field, groupList.size());
        }
    }

    public void removeGroup(int num, Group group) {
        this.removeGroup(num, group.getFieldTag());
    }

    public void removeGroup(Group group) {
        this.removeGroup(group.getFieldTag());
    }

    public boolean hasGroup(int field) {
        return this.groups.containsKey(field);
    }

    public boolean hasGroup(int num, int field) {
        return this.hasGroup(field) && num <= this.getGroups(field).size();
    }

    public boolean hasGroup(int num, Group group) {
        return this.hasGroup(num, group.getFieldTag());
    }

    public boolean hasGroup(Group group) {
        return this.hasGroup(group.getFieldTag());
    }

    private class FieldOrderComparator
    implements Comparator<Integer>,
    Serializable {
        static final long serialVersionUID = 3416006398018829270L;

        private FieldOrderComparator() {
        }

        private int rank(int field, int[] fieldOrder) {
            int index = FieldMap.indexOf(field, fieldOrder);
            return index > -1 ? index : Integer.MAX_VALUE;
        }

        @Override
        public int compare(Integer tag1, Integer tag2) {
            int rank1 = this.rank(tag1, FieldMap.this.getFieldOrder());
            int rank2 = this.rank(tag2, FieldMap.this.getFieldOrder());
            return rank1 != Integer.MAX_VALUE || rank2 != Integer.MAX_VALUE ? rank1 - rank2 : tag1 - tag2;
        }
    }
}

