/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SystemTime;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.QueueTracker;
import quickfix.mina.QueueTrackers;
import quickfix.mina.SessionConnector;

public class SingleThreadedEventHandlingStrategy
implements EventHandlingStrategy {
    public static final String MESSAGE_PROCESSOR_THREAD_NAME = "QFJ Message Processor";
    private final BlockingQueue<SessionMessageEvent> eventQueue;
    private final QueueTracker<SessionMessageEvent> queueTracker;
    private final SessionConnector sessionConnector;
    private volatile ThreadAdapter messageProcessingThread;
    private volatile boolean isStopped;
    private Executor executor;
    private long stopTime = 0L;

    public SingleThreadedEventHandlingStrategy(SessionConnector connector, int queueCapacity) {
        this.sessionConnector = connector;
        this.eventQueue = new LinkedBlockingQueue<SessionMessageEvent>(queueCapacity);
        this.queueTracker = QueueTrackers.newDefaultQueueTracker(this.eventQueue);
    }

    public SingleThreadedEventHandlingStrategy(SessionConnector connector, int queueLowerWatermark, int queueUpperWatermark) {
        this.sessionConnector = connector;
        this.eventQueue = new LinkedBlockingQueue<SessionMessageEvent>();
        this.queueTracker = QueueTrackers.newMultiSessionWatermarkTracker(this.eventQueue, queueLowerWatermark, queueUpperWatermark, evt -> ((SessionMessageEvent)evt).quickfixSession);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void onMessage(Session quickfixSession, Message message) {
        if (message == END_OF_STREAM && this.isStopped) {
            return;
        }
        try {
            this.queueTracker.put(new SessionMessageEvent(quickfixSession, message));
        }
        catch (InterruptedException e) {
            this.isStopped = true;
            throw new RuntimeException(e);
        }
    }

    @Override
    public SessionConnector getSessionConnector() {
        return this.sessionConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void block() {
        while (true) {
            SingleThreadedEventHandlingStrategy singleThreadedEventHandlingStrategy = this;
            synchronized (singleThreadedEventHandlingStrategy) {
                if (this.isStopped) {
                    if (!this.eventQueue.isEmpty()) {
                        ArrayList tempList = new ArrayList(this.eventQueue.size());
                        this.queueTracker.drainTo(tempList);
                        for (SessionMessageEvent event : tempList) {
                            event.processMessage();
                        }
                    }
                    if (this.stopTime == 0L) {
                        this.stopTime = SystemTime.currentTimeMillis();
                    }
                    if (!this.sessionConnector.isLoggedOn() || SystemTime.currentTimeMillis() - this.stopTime > 5000L) {
                        this.sessionConnector.stopSessionTimer();
                        this.stopTime = 0L;
                    }
                    return;
                }
            }
            try {
                SessionMessageEvent event = this.getMessage();
                if (event == null) continue;
                event.processMessage();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    private SessionMessageEvent getMessage() throws InterruptedException {
        return this.queueTracker.poll(250L, TimeUnit.MILLISECONDS);
    }

    public void blockInThread() {
        if (this.messageProcessingThread != null && this.messageProcessingThread.isAlive()) {
            this.sessionConnector.log.warn("Trying to stop still running {}", (Object)MESSAGE_PROCESSOR_THREAD_NAME);
            this.stopHandlingMessages(true);
            if (this.messageProcessingThread.isAlive()) {
                throw new IllegalStateException("Still running QFJ Message Processor could not be stopped!");
            }
        }
        this.startHandlingMessages();
        this.messageProcessingThread = new ThreadAdapter(() -> {
            this.sessionConnector.log.info("Started {}", (Object)MESSAGE_PROCESSOR_THREAD_NAME);
            this.block();
            this.sessionConnector.log.info("Stopped {}", (Object)MESSAGE_PROCESSOR_THREAD_NAME);
        }, MESSAGE_PROCESSOR_THREAD_NAME, this.executor);
        this.messageProcessingThread.setDaemon(true);
        this.messageProcessingThread.start();
    }

    private synchronized void startHandlingMessages() {
        this.isStopped = false;
    }

    public synchronized void stopHandlingMessages() {
        for (Session session : this.sessionConnector.getSessionMap().values()) {
            this.onMessage(session, END_OF_STREAM);
        }
        this.isStopped = true;
    }

    public void stopHandlingMessages(boolean join) {
        this.stopHandlingMessages();
        if (join) {
            try {
                this.messageProcessingThread.join();
            }
            catch (InterruptedException e) {
                this.sessionConnector.log.error("{} interrupted.", (Object)MESSAGE_PROCESSOR_THREAD_NAME);
            }
        }
    }

    @Override
    public int getQueueSize() {
        return this.eventQueue.size();
    }

    @Override
    public int getQueueSize(SessionID sessionID) {
        return this.getQueueSize();
    }

    static final class ThreadAdapter {
        private final Executor executor;
        private final RunnableWrapper wrapper;

        ThreadAdapter(Runnable command, String name, Executor executor) {
            this.wrapper = new RunnableWrapper(command, name);
            this.executor = executor != null ? executor : new DedicatedThreadExecutor(name);
        }

        public void join() throws InterruptedException {
            this.wrapper.join();
        }

        public void setDaemon(boolean b) {
        }

        public boolean isAlive() {
            return this.wrapper.isAlive();
        }

        public void start() {
            this.executor.execute(this.wrapper);
        }

        static final class DedicatedThreadExecutor
        implements Executor {
            private final String name;
            private Thread thread;

            DedicatedThreadExecutor(String name) {
                this.name = name;
            }

            @Override
            public void execute(Runnable command) {
                this.thread = new Thread(command, this.name);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }

        static final class RunnableWrapper
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final Runnable command;
            private final String name;

            public RunnableWrapper(Runnable command, String name) {
                this.command = command;
                this.name = name;
            }

            @Override
            public void run() {
                Thread currentThread = Thread.currentThread();
                String threadName = currentThread.getName();
                try {
                    if (!this.name.equals(threadName)) {
                        currentThread.setName(this.name + " (" + threadName + ")");
                    }
                    this.command.run();
                }
                finally {
                    this.latch.countDown();
                    currentThread.setName(threadName);
                }
            }

            public void join() throws InterruptedException {
                this.latch.await();
            }

            public boolean isAlive() {
                return this.latch.getCount() > 0L;
            }
        }
    }

    private static class SessionMessageEvent {
        private final Session quickfixSession;
        private final Message message;

        public SessionMessageEvent(Session session, Message message) {
            this.message = message;
            this.quickfixSession = session;
        }

        public void processMessage() {
            try {
                this.quickfixSession.next(this.message);
            }
            catch (Throwable e) {
                LogUtil.logThrowable(this.quickfixSession.getSessionID(), e.getMessage(), e);
            }
        }
    }
}

