/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.proxy.ProxyConnector;
import org.apache.mina.proxy.handlers.ProxyRequest;
import org.apache.mina.proxy.handlers.http.HttpAuthenticationMethods;
import org.apache.mina.proxy.handlers.http.HttpProxyRequest;
import org.apache.mina.proxy.handlers.socks.SocksProxyRequest;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.apache.mina.transport.socket.SocketConnector;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketConnector;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import quickfix.ConfigError;
import quickfix.RuntimeError;

public class ProtocolFactory {
    public static final int SOCKET = 0;
    public static final int VM_PIPE = 1;
    public static final int PROXY = 2;

    public static String getTypeString(int type) {
        switch (type) {
            case 0: {
                return "SOCKET";
            }
            case 1: {
                return "VM_PIPE";
            }
            case 2: {
                return "PROXY";
            }
        }
        return "unknown";
    }

    public static SocketAddress createSocketAddress(int transportType, String host, int port) throws ConfigError {
        if (transportType == 0 || transportType == 2) {
            return host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(port);
        }
        if (transportType == 1) {
            return new VmPipeAddress(port);
        }
        throw new ConfigError("Unknown session transport type: " + transportType);
    }

    public static int getAddressTransportType(SocketAddress address) {
        if (address instanceof InetSocketAddress) {
            return 0;
        }
        if (address instanceof VmPipeAddress) {
            return 1;
        }
        throw new RuntimeError("Unknown address type: " + address.getClass().getName());
    }

    public static int getTransportType(String string) {
        if (string.equalsIgnoreCase("tcp") || string.equalsIgnoreCase("SOCKET")) {
            return 0;
        }
        if (string.equalsIgnoreCase("VM_PIPE")) {
            return 1;
        }
        if (string.equalsIgnoreCase("PROXY")) {
            return 2;
        }
        throw new RuntimeError("Unknown Transport Type type: " + string);
    }

    public static IoAcceptor createIoAcceptor(int transportType) {
        if (transportType == 0) {
            NioSocketAcceptor ret = new NioSocketAcceptor();
            ret.setReuseAddress(true);
            return ret;
        }
        if (transportType == 1) {
            return new VmPipeAcceptor();
        }
        throw new RuntimeError("Unsupported transport type: " + transportType);
    }

    public static ProxyConnector createIoProxyConnector(SocketConnector socketConnector, InetSocketAddress address, InetSocketAddress proxyAddress, String proxyType, String proxyVersion, String proxyUser, String proxyPassword, String proxyDomain, String proxyWorkstation) throws ConfigError {
        ProxyRequest req;
        ProxyConnector connector = new ProxyConnector(socketConnector);
        connector.setConnectTimeoutMillis(5000L);
        if (proxyType.equalsIgnoreCase("http")) {
            req = ProtocolFactory.createHttpProxyRequest(address, proxyVersion, proxyUser, proxyPassword, proxyDomain, proxyWorkstation);
        } else if (proxyType.equalsIgnoreCase("socks")) {
            req = ProtocolFactory.createSocksProxyRequest(address, proxyVersion, proxyUser, proxyPassword);
        } else {
            throw new ConfigError("Proxy type must be http or socks");
        }
        ProxyIoSession proxyIoSession = new ProxyIoSession(proxyAddress, req);
        ArrayList<HttpAuthenticationMethods> l = new ArrayList<HttpAuthenticationMethods>();
        l.add(HttpAuthenticationMethods.NO_AUTH);
        l.add(HttpAuthenticationMethods.DIGEST);
        l.add(HttpAuthenticationMethods.BASIC);
        proxyIoSession.setPreferedOrder(l);
        connector.setProxyIoSession(proxyIoSession);
        return connector;
    }

    private static ProxyRequest createHttpProxyRequest(InetSocketAddress address, String proxyVersion, String proxyUser, String proxyPassword, String proxyDomain, String proxyWorkstation) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("USER", proxyUser);
        props.put("PWD", proxyPassword);
        if (proxyDomain != null && proxyWorkstation != null) {
            props.put("DOMAIN", proxyDomain);
            props.put("WORKSTATION", proxyWorkstation);
        }
        HttpProxyRequest req = new HttpProxyRequest(address);
        req.setProperties(props);
        if (proxyVersion != null && proxyVersion.equalsIgnoreCase("1.1")) {
            req.setHttpVersion("HTTP/1.1");
        } else {
            req.setHttpVersion("HTTP/1.0");
        }
        return req;
    }

    private static ProxyRequest createSocksProxyRequest(InetSocketAddress address, String proxyVersion, String proxyUser, String proxyPassword) throws ConfigError {
        SocksProxyRequest req;
        if (proxyVersion.equalsIgnoreCase("4")) {
            req = new SocksProxyRequest(4, 1, address, proxyUser);
        } else if (proxyVersion.equalsIgnoreCase("4a")) {
            req = new SocksProxyRequest(1, address.getAddress().getHostAddress(), address.getPort(), proxyUser);
        } else if (proxyVersion.equalsIgnoreCase("5")) {
            req = new SocksProxyRequest(5, 1, address, proxyUser);
        } else {
            throw new ConfigError("SOCKS ProxyType must be 4,4a or 5");
        }
        if (proxyPassword != null) {
            req.setPassword(proxyPassword);
        }
        return req;
    }

    public static IoConnector createIoConnector(SocketAddress address) throws ConfigError {
        if (address instanceof InetSocketAddress) {
            return new NioSocketConnector();
        }
        if (address instanceof VmPipeAddress) {
            return new VmPipeConnector();
        }
        throw new ConfigError("Unknown session acceptor address type: " + address.getClass().getName());
    }
}

