/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.time.LocalTime;
import quickfix.Field;
import quickfix.UtcTimestampPrecision;

public class UtcTimeOnlyField
extends Field<LocalTime> {
    private UtcTimestampPrecision precision = UtcTimestampPrecision.MILLIS;

    public UtcTimeOnlyField(int field) {
        super(field, LocalTime.now());
    }

    protected UtcTimeOnlyField(int field, LocalTime data) {
        super(field, data);
    }

    protected UtcTimeOnlyField(int field, LocalTime data, UtcTimestampPrecision precision) {
        super(field, data);
        this.precision = precision;
    }

    public UtcTimeOnlyField(int field, boolean includeMilliseconds) {
        super(field, LocalTime.now());
        this.precision = includeMilliseconds ? UtcTimestampPrecision.MILLIS : UtcTimestampPrecision.SECONDS;
    }

    protected UtcTimeOnlyField(int field, LocalTime data, boolean includeMilliseconds) {
        super(field, data);
        this.precision = includeMilliseconds ? UtcTimestampPrecision.MILLIS : UtcTimestampPrecision.SECONDS;
    }

    public UtcTimestampPrecision getPrecision() {
        return this.precision;
    }

    public void setValue(LocalTime value) {
        this.setObject(value);
    }

    public LocalTime getValue() {
        return (LocalTime)this.getObject();
    }

    public boolean valueEquals(LocalTime value) {
        return this.getValue().equals(value);
    }
}

