/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import org.quickfixj.QFJException;
import org.quickfixj.SimpleCache;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.DefaultDataDictionaryProvider;
import quickfix.DefaultMessageFactory;
import quickfix.DefaultSessionScheduleFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSchedule;
import quickfix.SessionScheduleFactory;
import quickfix.SessionSettings;
import quickfix.UtcTimestampPrecision;
import quickfix.field.ApplVerID;
import quickfix.field.DefaultApplVerID;

public class DefaultSessionFactory
implements SessionFactory {
    private static final SimpleCache<String, DataDictionary> dictionaryCache = new SimpleCache<String, DataDictionary>(path -> {
        try {
            return new DataDictionary((String)path);
        }
        catch (ConfigError e) {
            throw new QFJException(e);
        }
    });
    private final Application application;
    private final MessageStoreFactory messageStoreFactory;
    private final LogFactory logFactory;
    private final MessageFactory messageFactory;
    private final SessionScheduleFactory sessionScheduleFactory;

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = new DefaultMessageFactory();
        this.sessionScheduleFactory = new DefaultSessionScheduleFactory();
    }

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = messageFactory;
        this.sessionScheduleFactory = new DefaultSessionScheduleFactory();
    }

    public DefaultSessionFactory(Application application, MessageStoreFactory messageStoreFactory, LogFactory logFactory, MessageFactory messageFactory, SessionScheduleFactory sessionScheduleFactory) {
        this.application = application;
        this.messageStoreFactory = messageStoreFactory;
        this.logFactory = logFactory;
        this.messageFactory = messageFactory;
        this.sessionScheduleFactory = sessionScheduleFactory;
    }

    @Override
    public Session create(SessionID sessionID, SessionSettings settings) throws ConfigError {
        try {
            String connectionType = null;
            boolean rejectGarbledMessage = this.getSetting(settings, sessionID, "RejectGarbledMessage", false);
            boolean rejectInvalidMessage = this.getSetting(settings, sessionID, "RejectInvalidMessage", true);
            boolean rejectMessageOnUnhandledException = this.getSetting(settings, sessionID, "RejectMessageOnUnhandledException", false);
            boolean requiresOrigSendingTime = this.getSetting(settings, sessionID, "RequiresOrigSendingTime", true);
            if (settings.isSetting(sessionID, "ConnectionType")) {
                connectionType = settings.getString(sessionID, "ConnectionType");
            }
            if (connectionType == null) {
                throw new ConfigError("Missing ConnectionType");
            }
            if (!connectionType.equals("acceptor") && !connectionType.equals("initiator")) {
                throw new ConfigError("Invalid ConnectionType");
            }
            if (connectionType.equals("acceptor") && settings.isSetting(sessionID, "SessionQualifier")) {
                throw new ConfigError("SessionQualifier cannot be used with acceptor.");
            }
            if (connectionType.equals("initiator") && settings.isSetting(sessionID, "AllowedRemoteAddresses")) {
                throw new ConfigError("AllowedRemoteAddresses cannot be used with initiator");
            }
            DefaultApplVerID senderDefaultApplVerID = null;
            if (sessionID.isFIXT()) {
                if (!settings.isSetting(sessionID, "DefaultApplVerID")) {
                    throw new ConfigError("DefaultApplVerID is required for FIXT transport");
                }
                senderDefaultApplVerID = new DefaultApplVerID(this.toApplVerID(settings.getString(sessionID, "DefaultApplVerID")).getValue());
            }
            boolean useDataDictionary = true;
            if (settings.isSetting(sessionID, "UseDataDictionary")) {
                useDataDictionary = settings.getBool(sessionID, "UseDataDictionary");
            }
            DefaultDataDictionaryProvider dataDictionaryProvider = null;
            if (useDataDictionary) {
                dataDictionaryProvider = new DefaultDataDictionaryProvider();
                if (sessionID.isFIXT()) {
                    this.processFixtDataDictionaries(sessionID, settings, dataDictionaryProvider);
                } else {
                    this.processPreFixtDataDictionary(sessionID, settings, dataDictionaryProvider);
                }
            }
            int heartbeatInterval = 0;
            if (connectionType.equals("initiator") && (heartbeatInterval = (int)settings.getLong(sessionID, "HeartBtInt")) <= 0) {
                throw new ConfigError("Heartbeat must be greater than zero");
            }
            boolean checkLatency = this.getSetting(settings, sessionID, "CheckLatency", true);
            int maxLatency = this.getSetting(settings, sessionID, "MaxLatency", 120);
            double testRequestDelayMultiplier = this.getSetting(settings, sessionID, "TestRequestDelayMultiplier", 0.5);
            UtcTimestampPrecision timestampPrecision = this.getTimestampPrecision(settings, sessionID, UtcTimestampPrecision.MILLIS);
            boolean resetOnLogout = this.getSetting(settings, sessionID, "ResetOnLogout", false);
            boolean resetOnDisconnect = this.getSetting(settings, sessionID, "ResetOnDisconnect", false);
            boolean resetOnLogon = this.getSetting(settings, sessionID, "ResetOnLogon", false);
            boolean refreshAtLogon = this.getSetting(settings, sessionID, "RefreshOnLogon", false);
            boolean checkCompID = this.getSetting(settings, sessionID, "CheckCompID", true);
            boolean redundantResentRequestAllowed = this.getSetting(settings, sessionID, "SendRedundantResendRequests", false);
            boolean persistMessages = this.getSetting(settings, sessionID, "PersistMessages", true);
            boolean useClosedIntervalForResend = this.getSetting(settings, sessionID, "ClosedResendInterval", false);
            int logonTimeout = this.getSetting(settings, sessionID, "LogonTimeout", 10);
            int logoutTimeout = this.getSetting(settings, sessionID, "LogoutTimeout", 2);
            boolean validateSequenceNumbers = this.getSetting(settings, sessionID, "ValidateSequenceNumbers", true);
            boolean validateIncomingMessage = this.getSetting(settings, sessionID, "ValidateIncomingMessage", true);
            boolean resetOnError = this.getSetting(settings, sessionID, "ResetOnError", false);
            boolean disconnectOnError = this.getSetting(settings, sessionID, "DisconnectOnError", false);
            boolean disableHeartBeatCheck = this.getSetting(settings, sessionID, "DisableHeartBeatCheck", false);
            boolean forceResendWhenCorruptedStore = this.getSetting(settings, sessionID, "ForceResendWhenCorruptedStore", false);
            boolean enableNextExpectedMsgSeqNum = this.getSetting(settings, sessionID, "EnableNextExpectedMsgSeqNum", false);
            boolean enableLastMsgSeqNumProcessed = this.getSetting(settings, sessionID, "EnableLastMsgSeqNumProcessed", false);
            int resendRequestChunkSize = this.getSetting(settings, sessionID, "ResendRequestChunkSize", 0);
            int[] logonIntervals = this.getLogonIntervalsInSeconds(settings, sessionID);
            Set<InetAddress> allowedRemoteAddresses = this.getInetAddresses(settings, sessionID);
            SessionSchedule sessionSchedule = this.sessionScheduleFactory.create(sessionID, settings);
            Session session = new Session(this.application, this.messageStoreFactory, sessionID, dataDictionaryProvider, sessionSchedule, this.logFactory, this.messageFactory, heartbeatInterval, checkLatency, maxLatency, timestampPrecision, resetOnLogon, resetOnLogout, resetOnDisconnect, refreshAtLogon, checkCompID, redundantResentRequestAllowed, persistMessages, useClosedIntervalForResend, testRequestDelayMultiplier, senderDefaultApplVerID, validateSequenceNumbers, logonIntervals, resetOnError, disconnectOnError, disableHeartBeatCheck, rejectGarbledMessage, rejectInvalidMessage, rejectMessageOnUnhandledException, requiresOrigSendingTime, forceResendWhenCorruptedStore, allowedRemoteAddresses, validateIncomingMessage, resendRequestChunkSize, enableNextExpectedMsgSeqNum, enableLastMsgSeqNumProcessed);
            session.setLogonTimeout(logonTimeout);
            session.setLogoutTimeout(logoutTimeout);
            int maxScheduledWriteRequests = this.getSetting(settings, sessionID, "MaxScheduledWriteRequests", 0);
            session.setMaxScheduledWriteRequests(maxScheduledWriteRequests);
            this.application.onCreate(sessionID);
            return session;
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e.getMessage());
        }
    }

    private void processPreFixtDataDictionary(SessionID sessionID, SessionSettings settings, DefaultDataDictionaryProvider dataDictionaryProvider) throws ConfigError, FieldConvertError {
        DataDictionary dataDictionary = this.createDataDictionary(sessionID, settings, "DataDictionary", sessionID.getBeginString());
        dataDictionaryProvider.addTransportDictionary(sessionID.getBeginString(), dataDictionary);
        dataDictionaryProvider.addApplicationDictionary(MessageUtils.toApplVerID(sessionID.getBeginString()), dataDictionary);
    }

    private DataDictionary createDataDictionary(SessionID sessionID, SessionSettings settings, String settingsKey, String beginString) throws ConfigError, FieldConvertError {
        String path = this.getDictionaryPath(sessionID, settings, settingsKey, beginString);
        DataDictionary dataDictionary = this.getDataDictionary(path);
        if (settings.isSetting(sessionID, "ValidateFieldsOutOfOrder")) {
            dataDictionary.setCheckFieldsOutOfOrder(settings.getBool(sessionID, "ValidateFieldsOutOfOrder"));
        }
        if (settings.isSetting(sessionID, "ValidateFieldsHaveValues")) {
            dataDictionary.setCheckFieldsHaveValues(settings.getBool(sessionID, "ValidateFieldsHaveValues"));
        }
        if (settings.isSetting(sessionID, "ValidateUnorderedGroupFields")) {
            dataDictionary.setCheckUnorderedGroupFields(settings.getBool(sessionID, "ValidateUnorderedGroupFields"));
        }
        if (settings.isSetting(sessionID, "ValidateUserDefinedFields")) {
            dataDictionary.setCheckUserDefinedFields(settings.getBool(sessionID, "ValidateUserDefinedFields"));
        }
        if (settings.isSetting(sessionID, "AllowUnknownMsgFields")) {
            dataDictionary.setAllowUnknownMessageFields(settings.getBool(sessionID, "AllowUnknownMsgFields"));
        }
        return dataDictionary;
    }

    private void processFixtDataDictionaries(SessionID sessionID, SessionSettings settings, DefaultDataDictionaryProvider dataDictionaryProvider) throws ConfigError, FieldConvertError {
        dataDictionaryProvider.addTransportDictionary(sessionID.getBeginString(), this.createDataDictionary(sessionID, settings, "TransportDataDictionary", sessionID.getBeginString()));
        Properties sessionProperties = settings.getSessionProperties(sessionID);
        Enumeration<?> keys = sessionProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("AppDataDictionary")) continue;
            if (key.equals("AppDataDictionary")) {
                ApplVerID applVerID = this.toApplVerID(settings.getString(sessionID, "DefaultApplVerID"));
                DataDictionary dd = this.createDataDictionary(sessionID, settings, "AppDataDictionary", sessionID.getBeginString());
                dataDictionaryProvider.addApplicationDictionary(applVerID, dd);
                continue;
            }
            int offset = key.indexOf(46);
            if (offset == -1) {
                throw new ConfigError("Malformed AppDataDictionary: " + key);
            }
            String beginStringQualifier = key.substring(offset + 1);
            DataDictionary dd = this.createDataDictionary(sessionID, settings, key, beginStringQualifier);
            dataDictionaryProvider.addApplicationDictionary(MessageUtils.toApplVerID(beginStringQualifier), dd);
        }
    }

    private ApplVerID toApplVerID(String value) {
        if (this.isApplVerIdEnum(value)) {
            return new ApplVerID(value);
        }
        return MessageUtils.toApplVerID(value);
    }

    private boolean isApplVerIdEnum(String value) {
        return value.matches("[0-9]+");
    }

    private String getDictionaryPath(SessionID sessionID, SessionSettings settings, String settingsKey, String beginString) throws ConfigError, FieldConvertError {
        String path = settings.isSetting(sessionID, settingsKey) ? settings.getString(sessionID, settingsKey) : this.toDictionaryPath(beginString);
        return path;
    }

    private String toDictionaryPath(String beginString) {
        return beginString.replaceAll("\\.", "") + ".xml";
    }

    private DataDictionary getDataDictionary(String path) throws ConfigError {
        try {
            return dictionaryCache.computeIfAbsent(path);
        }
        catch (QFJException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConfigError) {
                throw (ConfigError)cause;
            }
            throw e;
        }
    }

    private int[] getLogonIntervalsInSeconds(SessionSettings settings, SessionID sessionID) throws ConfigError {
        if (settings.isSetting(sessionID, "ReconnectInterval")) {
            try {
                String raw = settings.getString(sessionID, "ReconnectInterval");
                int[] ret = SessionSettings.parseSettingReconnectInterval(raw);
                if (ret != null) {
                    return ret;
                }
            }
            catch (Throwable e) {
                throw new ConfigError(e);
            }
        }
        return new int[]{5};
    }

    private Set<InetAddress> getInetAddresses(SessionSettings settings, SessionID sessionID) throws ConfigError {
        if (settings.isSetting(sessionID, "AllowedRemoteAddresses")) {
            try {
                String raw = settings.getString(sessionID, "AllowedRemoteAddresses");
                return SessionSettings.parseRemoteAddresses(raw);
            }
            catch (Throwable e) {
                throw new ConfigError(e);
            }
        }
        return null;
    }

    private boolean getSetting(SessionSettings settings, SessionID sessionID, String key, boolean defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? settings.getBool(sessionID, key) : defaultValue;
    }

    private int getSetting(SessionSettings settings, SessionID sessionID, String key, int defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? (int)settings.getLong(sessionID, key) : defaultValue;
    }

    private double getSetting(SessionSettings settings, SessionID sessionID, String key, double defaultValue) throws ConfigError, FieldConvertError {
        return settings.isSetting(sessionID, key) ? Double.parseDouble(settings.getString(sessionID, key)) : defaultValue;
    }

    private UtcTimestampPrecision getTimestampPrecision(SessionSettings settings, SessionID sessionID, UtcTimestampPrecision defaultValue) throws ConfigError, FieldConvertError {
        if (settings.isSetting(sessionID, "TimeStampPrecision")) {
            String string = settings.getString(sessionID, "TimeStampPrecision");
            try {
                return UtcTimestampPrecision.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError(e.getMessage() + ". Valid values: " + Arrays.toString((Object[])UtcTimestampPrecision.values()));
            }
        }
        return defaultValue;
    }
}

