/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.quickfixj.SimpleCache;
import quickfix.FieldConvertError;
import quickfix.SystemTime;
import quickfix.UtcTimestampPrecision;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcTimestampConverter
extends AbstractDateTimeConverter {
    static final String TYPE = "timestamp";
    static final int LENGTH_INCL_SECONDS = 17;
    static final int LENGTH_INCL_MILLIS = 21;
    static final int LENGTH_INCL_MICROS = 24;
    static final int LENGTH_INCL_NANOS = 27;
    static final int LENGTH_INCL_PICOS = 30;
    private static final ThreadLocal<UtcTimestampConverter> UTC_TIMESTAMP_CONVERTER = new ThreadLocal();
    private static final SimpleCache<String, Long> DATE_CACHE = new SimpleCache<String, Long>(dateString -> {
        GregorianCalendar c = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        ((Calendar)c).setTimeZone(SystemTime.UTC_TIMEZONE);
        int year = Integer.parseInt(dateString.substring(0, 4));
        int month = Integer.parseInt(dateString.substring(4, 6));
        int day = Integer.parseInt(dateString.substring(6, 8));
        c.set(year, month - 1, day);
        return c.getTimeInMillis();
    });
    private final DateFormat utcTimestampFormat = this.createDateFormat("yyyyMMdd-HH:mm:ss");
    private final DateFormat utcTimestampFormatMillis = this.createDateFormat("yyyyMMdd-HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER_SECONDS = UtcTimestampConverter.createDateTimeFormat("yyyyMMdd-HH:mm:ss");
    private static final DateTimeFormatter FORMATTER_MILLIS = UtcTimestampConverter.createDateTimeFormat("yyyyMMdd-HH:mm:ss.SSS");
    private static final DateTimeFormatter FORMATTER_MICROS = UtcTimestampConverter.createDateTimeFormat("yyyyMMdd-HH:mm:ss.SSSSSS");
    private static final DateTimeFormatter FORMATTER_NANOS = UtcTimestampConverter.createDateTimeFormat("yyyyMMdd-HH:mm:ss.SSSSSSSSS");

    public static String convert(Date d, boolean includeMilliseconds) {
        return UtcTimestampConverter.getFormatter(includeMilliseconds).format(d);
    }

    public static String convert(LocalDateTime d, UtcTimestampPrecision precision) {
        switch (precision) {
            case SECONDS: {
                return d.format(FORMATTER_SECONDS);
            }
            case MILLIS: {
                return d.format(FORMATTER_MILLIS);
            }
            case MICROS: {
                return d.format(FORMATTER_MICROS);
            }
            case NANOS: {
                return d.format(FORMATTER_NANOS);
            }
        }
        return d.format(FORMATTER_MILLIS);
    }

    private static DateFormat getFormatter(boolean includeMillis) {
        UtcTimestampConverter converter = UTC_TIMESTAMP_CONVERTER.get();
        if (converter == null) {
            converter = new UtcTimestampConverter();
            UTC_TIMESTAMP_CONVERTER.set(converter);
        }
        return includeMillis ? converter.utcTimestampFormatMillis : converter.utcTimestampFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        UtcTimestampConverter.verifyFormat(value);
        long timeOffset = UtcTimestampConverter.getTimeOffsetSeconds(value);
        if (value.length() >= 21) {
            timeOffset += UtcTimestampConverter.parseLong(value.substring(18, 21));
        }
        return new Date(UtcTimestampConverter.getMillisForDay(value) + timeOffset);
    }

    public static LocalDateTime convertToLocalDateTime(String value) throws FieldConvertError {
        UtcTimestampConverter.verifyFormat(value);
        int length = value.length();
        try {
            switch (length) {
                case 17: {
                    return LocalDateTime.parse(value, FORMATTER_SECONDS);
                }
                case 21: {
                    return LocalDateTime.parse(value, FORMATTER_MILLIS);
                }
                case 24: {
                    return LocalDateTime.parse(value, FORMATTER_MICROS);
                }
                case 27: 
                case 30: {
                    return LocalDateTime.parse(value.substring(0, 27), FORMATTER_NANOS);
                }
            }
            UtcTimestampConverter.throwFieldConvertError(value, TYPE);
        }
        catch (DateTimeParseException e) {
            UtcTimestampConverter.throwFieldConvertError(value, TYPE);
        }
        return null;
    }

    private static Long getMillisForDay(String value) {
        return DATE_CACHE.computeIfAbsent(value.substring(0, 8));
    }

    private static long getTimeOffsetSeconds(String value) {
        return UtcTimestampConverter.parseLong(value.substring(9, 11)) * 3600000L + UtcTimestampConverter.parseLong(value.substring(12, 14)) * 60000L + UtcTimestampConverter.parseLong(value.substring(15, 17)) * 1000L;
    }

    private static void verifyFormat(String value) throws FieldConvertError {
        UtcTimestampConverter.assertLength(value, TYPE, 17, 21, 24, 27, 30);
        UtcTimestampConverter.assertDigitSequence(value, 0, 8, TYPE);
        UtcTimestampConverter.assertSeparator(value, 8, '-', TYPE);
        UtcTimestampConverter.assertDigitSequence(value, 9, 11, TYPE);
        UtcTimestampConverter.assertSeparator(value, 11, ':', TYPE);
        UtcTimestampConverter.assertDigitSequence(value, 12, 14, TYPE);
        UtcTimestampConverter.assertSeparator(value, 14, ':', TYPE);
        UtcTimestampConverter.assertDigitSequence(value, 15, 17, TYPE);
        if (value.length() == 21) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', TYPE);
            UtcTimestampConverter.assertDigitSequence(value, 18, 21, TYPE);
        } else if (value.length() == 24) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', TYPE);
            UtcTimestampConverter.assertDigitSequence(value, 18, 24, TYPE);
        } else if (value.length() == 27) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', TYPE);
            UtcTimestampConverter.assertDigitSequence(value, 18, 27, TYPE);
        } else if (value.length() == 30) {
            UtcTimestampConverter.assertSeparator(value, 17, '.', TYPE);
            UtcTimestampConverter.assertDigitSequence(value, 18, 30, TYPE);
        } else if (value.length() != 17) {
            UtcTimestampConverter.throwFieldConvertError(value, TYPE);
        }
    }

    public static Date getDate(LocalDateTime localDateTime) {
        if (localDateTime != null) {
            return Date.from(localDateTime.toInstant(ZoneOffset.UTC));
        }
        return null;
    }
}

