/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina;

import java.io.IOException;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.InvalidMessage;
import quickfix.Log;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.mina.CriticalProtocolCodecException;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;

public abstract class AbstractIoHandler
extends IoHandlerAdapter {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final NetworkingOptions networkingOptions;
    private final EventHandlingStrategy eventHandlingStrategy;

    public AbstractIoHandler(NetworkingOptions options, EventHandlingStrategy eventHandlingStrategy) {
        this.networkingOptions = options;
        this.eventHandlingStrategy = eventHandlingStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(IoSession ioSession, Throwable cause) throws Exception {
        String reason;
        boolean disconnectNeeded = false;
        Session quickFixSession = this.findQFSession(ioSession);
        Throwable realCause = cause;
        if (cause instanceof ProtocolDecoderException && cause.getCause() != null) {
            realCause = cause.getCause();
        } else {
            Throwable chain = cause;
            while (chain != null && chain.getCause() != null) {
                if (!((chain = chain.getCause()) instanceof IOException)) continue;
                realCause = chain;
                break;
            }
        }
        if (realCause instanceof IOException) {
            reason = quickFixSession != null && quickFixSession.isEnabled() ? "Socket exception (" + ioSession.getRemoteAddress() + "): " + cause : "Socket (" + ioSession.getRemoteAddress() + "): " + cause;
            disconnectNeeded = true;
        } else if (realCause instanceof CriticalProtocolCodecException) {
            reason = "Critical protocol codec error: " + cause;
            disconnectNeeded = true;
        } else {
            reason = realCause instanceof ProtocolCodecException ? "Protocol handler exception: " + cause : cause.toString();
        }
        if (disconnectNeeded) {
            try {
                if (quickFixSession != null) {
                    quickFixSession.disconnect(reason, true);
                }
                this.log.error(reason, cause);
                ioSession.closeNow();
            }
            finally {
                ioSession.setAttribute((Object)"QFJ_RESET_IO_CONNECTOR", (Object)Boolean.TRUE);
            }
        } else if (quickFixSession != null) {
            LogUtil.logThrowable(quickFixSession.getLog(), reason, cause);
        } else {
            this.log.error(reason, cause);
        }
    }

    public void sessionCreated(IoSession ioSession) throws Exception {
        super.sessionCreated(ioSession);
        this.networkingOptions.apply(ioSession);
    }

    public void sessionClosed(IoSession ioSession) throws Exception {
        try {
            Session quickFixSession = this.findQFSession(ioSession);
            if (quickFixSession != null) {
                this.eventHandlingStrategy.onMessage(quickFixSession, EventHandlingStrategy.END_OF_STREAM);
                ioSession.removeAttribute((Object)"QF_SESSION");
            }
            ioSession.closeNow();
        }
        catch (Exception e) {
            ioSession.closeNow();
            throw e;
        }
    }

    public void messageReceived(IoSession ioSession, Object message) throws Exception {
        block5: {
            String messageString = (String)message;
            SessionID remoteSessionID = MessageUtils.getReverseSessionID(messageString);
            Session quickFixSession = this.findQFSession(ioSession, remoteSessionID);
            if (quickFixSession != null) {
                Log sessionLog = quickFixSession.getLog();
                sessionLog.onIncoming(messageString);
                try {
                    Message fixMessage = MessageUtils.parse(quickFixSession, messageString);
                    this.processMessage(ioSession, fixMessage);
                }
                catch (InvalidMessage e) {
                    if ("A".equals(MessageUtils.getMessageType(messageString))) {
                        sessionLog.onErrorEvent("Invalid LOGON message, disconnecting: " + e.getMessage());
                        ioSession.closeNow();
                        break block5;
                    }
                    sessionLog.onErrorEvent("Invalid message: " + e.getMessage());
                }
            } else {
                this.log.error("Disconnecting; received message for unknown session: " + messageString);
                ioSession.closeNow();
            }
        }
    }

    protected Session findQFSession(IoSession ioSession, SessionID sessionID) {
        Session quickfixSession = this.findQFSession(ioSession);
        if (quickfixSession == null) {
            quickfixSession = Session.lookupSession(sessionID);
        }
        return quickfixSession;
    }

    private Session findQFSession(IoSession ioSession) {
        return (Session)ioSession.getAttribute((Object)"QF_SESSION");
    }

    protected NetworkingOptions getNetworkingOptions() {
        return this.networkingOptions;
    }

    protected abstract void processMessage(IoSession var1, Message var2) throws Exception;
}

