/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import quickfix.FieldConvertError;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcTimeOnlyConverter
extends AbstractDateTimeConverter {
    static final int LENGTH_INCL_SECONDS = 8;
    static final int LENGTH_INCL_MILLIS = 12;
    static final int LENGTH_INCL_MICROS = 15;
    static final int LENGTH_INCL_NANOS = 18;
    static final int LENGTH_INCL_PICOS = 21;
    private static final ThreadLocal<UtcTimeOnlyConverter> UTC_TIME_CONVERTER = new ThreadLocal();
    private final DateFormat utcTimeFormat = this.createDateFormat("HH:mm:ss");
    private final DateFormat utcTimeFormatMillis = this.createDateFormat("HH:mm:ss.SSS");

    public static String convert(Date d, boolean includeMilliseconds) {
        return UtcTimeOnlyConverter.getFormatter(includeMilliseconds).format(d);
    }

    private static DateFormat getFormatter(boolean includeMillis) {
        UtcTimeOnlyConverter converter = UTC_TIME_CONVERTER.get();
        if (converter == null) {
            converter = new UtcTimeOnlyConverter();
            UTC_TIME_CONVERTER.set(converter);
        }
        return includeMillis ? converter.utcTimeFormatMillis : converter.utcTimeFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        Date d = null;
        if (value.length() != 8 && value.length() != 12 && value.length() != 15 && value.length() != 18 && value.length() != 21) {
            UtcTimeOnlyConverter.throwFieldConvertError(value, "time");
        }
        try {
            boolean includeMillis = value.length() >= 12;
            d = UtcTimeOnlyConverter.getFormatter(includeMillis).parse(includeMillis ? value.substring(0, 12) : value);
        }
        catch (ParseException e) {
            UtcTimeOnlyConverter.throwFieldConvertError(value, "time");
        }
        return d;
    }
}

