/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.mina.core.session.IoSession;
import quickfix.Log;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.field.ApplVerID;
import quickfix.mina.AbstractIoHandler;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.IoSessionResponder;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.acceptor.AcceptorSessionProvider;

class AcceptorIoHandler
extends AbstractIoHandler {
    private final EventHandlingStrategy eventHandlingStrategy;
    private final AcceptorSessionProvider sessionProvider;

    public AcceptorIoHandler(AcceptorSessionProvider sessionProvider, NetworkingOptions networkingOptions, EventHandlingStrategy eventHandlingStrategy) {
        super(networkingOptions, eventHandlingStrategy);
        this.sessionProvider = sessionProvider;
        this.eventHandlingStrategy = eventHandlingStrategy;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        super.sessionCreated(session);
        this.log.info("MINA session created: local=" + session.getLocalAddress() + ", " + session.getClass() + ", remote=" + session.getRemoteAddress());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void processMessage(IoSession protocolSession, Message message) throws Exception {
        Session qfSession = (Session)protocolSession.getAttribute((Object)"QF_SESSION");
        if (qfSession == null) {
            if (!message.getHeader().getString(35).equals("A")) {
                this.log.warn("Ignoring non-logon message before session establishment: " + message);
                protocolSession.closeNow();
                return;
            }
            SessionID sessionID = MessageUtils.getReverseSessionID(message);
            qfSession = this.sessionProvider.getSession(sessionID, this.eventHandlingStrategy.getSessionConnector());
            if (qfSession == null) {
                this.log.error("Unknown session ID during logon: " + sessionID + " cannot be found in session list " + this.eventHandlingStrategy.getSessionConnector().getSessions() + " (connecting from " + protocolSession.getRemoteAddress() + " to " + protocolSession.getLocalAddress() + ")");
                return;
            }
            Log sessionLog = qfSession.getLog();
            if (qfSession.hasResponder()) {
                sessionLog.onErrorEvent("Multiple logons/connections for this session are not allowed");
                protocolSession.closeNow();
                return;
            }
            sessionLog.onEvent("Accepting session " + qfSession.getSessionID() + " from " + protocolSession.getRemoteAddress());
            int heartbeatInterval = message.getInt(108);
            qfSession.setHeartBeatInterval(heartbeatInterval);
            sessionLog.onEvent("Acceptor heartbeat set to " + heartbeatInterval + " seconds");
            protocolSession.setAttribute((Object)"QF_SESSION", (Object)qfSession);
            NetworkingOptions networkingOptions = this.getNetworkingOptions();
            qfSession.setResponder(new IoSessionResponder(protocolSession, networkingOptions.getSynchronousWrites(), networkingOptions.getSynchronousWriteTimeout().intValue(), qfSession.getMaxScheduledWriteRequests()));
            if (sessionID.isFIXT() && message.isSetField(1137)) {
                ApplVerID applVerID = new ApplVerID(message.getString(1137));
                qfSession.setTargetDefaultApplicationVersionID(applVerID);
                this.log.info("Setting DefaultApplVerID (1137=" + applVerID.getValue() + ") from Logon");
            }
        }
        this.eventHandlingStrategy.onMessage(qfSession, message);
    }

    @Override
    protected Session findQFSession(IoSession protocolSession, SessionID sessionID) {
        InetAddress remoteInetAddress;
        SocketAddress remoteAddress;
        Session s = super.findQFSession(protocolSession, sessionID);
        if (s == null) {
            s = this.sessionProvider.getSession(sessionID, this.eventHandlingStrategy.getSessionConnector());
        }
        if (s != null && protocolSession.getAttribute((Object)"QF_SESSION") == null && (remoteAddress = protocolSession.getRemoteAddress()) instanceof InetSocketAddress && !s.isAllowedForSession(remoteInetAddress = ((InetSocketAddress)remoteAddress).getAddress())) {
            s.getLog().onEvent("Refused connection to session " + s.getSessionID() + " from " + remoteAddress);
            return null;
        }
        return s;
    }
}

