/*
 * Decompiled with CFR 0.152.
 */
package quickfix.field.converter;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import quickfix.FieldConvertError;
import quickfix.field.converter.AbstractDateTimeConverter;

public class UtcDateOnlyConverter
extends AbstractDateTimeConverter {
    private static final ThreadLocal<UtcDateOnlyConverter> utcDateConverter = new ThreadLocal();
    private final DateFormat dateFormat = this.createDateFormat("yyyyMMdd");

    public static String convert(Date d) {
        return UtcDateOnlyConverter.getFormatter().format(d);
    }

    private static DateFormat getFormatter() {
        UtcDateOnlyConverter converter = utcDateConverter.get();
        if (converter == null) {
            converter = new UtcDateOnlyConverter();
            utcDateConverter.set(converter);
        }
        return converter.dateFormat;
    }

    public static Date convert(String value) throws FieldConvertError {
        Date d = null;
        String type = "date";
        UtcDateOnlyConverter.assertLength(value, 8, type);
        UtcDateOnlyConverter.assertDigitSequence(value, 0, 8, type);
        try {
            d = UtcDateOnlyConverter.getFormatter().parse(value);
        }
        catch (ParseException e) {
            UtcDateOnlyConverter.throwFieldConvertError(value, type);
        }
        return d;
    }
}

