/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import quickfix.ConfigError;
import quickfix.FieldConvertError;
import quickfix.Log;
import quickfix.LogFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLog;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class ScreenLogFactory
implements LogFactory {
    private SessionSettings settings;
    private boolean incoming;
    private boolean outgoing;
    private boolean events;
    private boolean heartBeats;
    private boolean includeMillis;
    public static final String SETTING_LOG_INCOMING = "ScreenLogShowIncoming";
    public static final String SETTING_LOG_OUTGOING = "ScreenLogShowOutgoing";
    public static final String SETTING_LOG_EVENTS = "ScreenLogShowEvents";
    public static final String SETTING_LOG_HEARTBEATS = "ScreenLogShowHeartBeats";
    public static final String SETTING_INCLUDE_MILLIS_IN_TIMESTAMP = "ScreenIncludeMilliseconds";

    public ScreenLogFactory(SessionSettings settings) {
        this(true, true, true);
        this.settings = settings;
    }

    public ScreenLogFactory(boolean incoming, boolean outgoing, boolean events) {
        this(incoming, outgoing, events, true);
    }

    public ScreenLogFactory() {
        this(true, true, true, false);
    }

    public ScreenLogFactory(boolean incoming, boolean outgoing, boolean events, boolean logHeartBeats) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.events = events;
        this.heartBeats = logHeartBeats;
    }

    @Override
    public Log create(SessionID sessionID) {
        try {
            this.incoming = this.getBooleanSetting(sessionID, SETTING_LOG_INCOMING, this.incoming);
            this.outgoing = this.getBooleanSetting(sessionID, SETTING_LOG_OUTGOING, this.outgoing);
            this.events = this.getBooleanSetting(sessionID, SETTING_LOG_EVENTS, this.events);
            this.heartBeats = this.getBooleanSetting(sessionID, SETTING_LOG_HEARTBEATS, this.heartBeats);
            this.includeMillis = this.getBooleanSetting(sessionID, SETTING_INCLUDE_MILLIS_IN_TIMESTAMP, false);
            return new ScreenLog(this.incoming, this.outgoing, this.events, this.heartBeats, this.includeMillis, sessionID, System.out);
        }
        catch (ConfigError | FieldConvertError e) {
            throw new RuntimeError(e);
        }
    }

    private boolean getBooleanSetting(SessionID sessionID, String key, boolean incoming) throws ConfigError, FieldConvertError {
        if (this.settings != null && this.settings.isSetting(sessionID, key)) {
            incoming = this.settings.getBool(sessionID, key);
        }
        return incoming;
    }

    @Override
    public Log create() {
        throw new UnsupportedOperationException();
    }
}

