/*
 * Decompiled with CFR 0.152.
 */
package quasar.std;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import quasar.Data;
import quasar.Func$;
import quasar.Mapping$;
import quasar.NullaryFunc;
import quasar.SemanticError;
import quasar.Type;
import quasar.Type$;
import quasar.Type$Date$;
import quasar.Type$Int$;
import quasar.Type$Interval$;
import quasar.Type$Str$;
import quasar.Type$Time$;
import quasar.Type$Timestamp$;
import quasar.UnaryFunc;
import quasar.fp.ski.package$;
import quasar.std.Library;
import quasar.std.TemporalPart;
import quasar.std.TemporalPart$Century$;
import quasar.std.TemporalPart$Day$;
import quasar.std.TemporalPart$Decade$;
import quasar.std.TemporalPart$Hour$;
import quasar.std.TemporalPart$Microsecond$;
import quasar.std.TemporalPart$Millennium$;
import quasar.std.TemporalPart$Millisecond$;
import quasar.std.TemporalPart$Minute$;
import quasar.std.TemporalPart$Month$;
import quasar.std.TemporalPart$Quarter$;
import quasar.std.TemporalPart$Second$;
import quasar.std.TemporalPart$Week$;
import quasar.std.TemporalPart$Year$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scalaz.;
import scalaz.$bslash$div$;
import scalaz.Bind;
import scalaz.Functor;
import scalaz.Validation;
import scalaz.Validation$;
import shapeless.Sized;
import shapeless.Sized$;
import shapeless.Succ;
import shapeless._0;
import slamdata.Predef$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015haB\u0001\u0003!\u0003\r\ta\u0002\u0002\b\t\u0006$X\rT5c\u0015\t\u0019A!A\u0002ti\u0012T\u0011!B\u0001\u0007cV\f7/\u0019:\u0004\u0001M!\u0001\u0001\u0003\b\u0013!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\b\u0019&\u0014'/\u0019:z!\t\u0019RD\u0004\u0002\u001559\u0011Q\u0003G\u0007\u0002-)\u0011qCB\u0001\u0007yI|w\u000e\u001e \n\u0003e\t\u0001b\u001d7b[\u0012\fG/Y\u0005\u00037q\ta\u0001\u0015:fI\u00164'\"A\r\n\u0005yy\"\u0001D*fe&\fG.\u001b>bE2,\u0017B\u0001\u0011\u001d\u0005\u0019\u0001&/\u001a3fM\")!\u0005\u0001C\u0001G\u00051A%\u001b8ji\u0012\"\u0012\u0001\n\t\u0003\u0013\u0015J!A\n\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006Q\u0001!\t!K\u0001\u000fa\u0006\u00148/\u001a+j[\u0016\u001cH/Y7q)\tQ3\b\u0005\u0003,]A\"T\"\u0001\u0017\u000b\u00035\naa]2bY\u0006T\u0018BA\u0018-\u0005-!#m\u001d7bg\"$C-\u001b<\u0011\u0005E\u0012T\"\u0001\u0003\n\u0005M\"!!D*f[\u0006tG/[2FeJ|'\u000f\u0005\u00026q9\u0011\u0011GN\u0005\u0003o\u0011\tA\u0001R1uC&\u0011\u0011H\u000f\u0002\n)&lWm\u001d;b[BT!a\u000e\u0003\t\u000bq:\u0003\u0019A\u001f\u0002\u0007M$(\u000f\u0005\u0002\u0014}%\u0011qh\b\u0002\u0007'R\u0014\u0018N\\4\t\u000b\u0005\u0003A\u0011\u0001\"\u0002\u0013A\f'o]3ECR,GCA\"H!\u0011Yc\u0006\r#\u0011\u0005U*\u0015B\u0001$;\u0005\u0011!\u0015\r^3\t\u000bq\u0002\u0005\u0019A\u001f\t\u000b%\u0003A\u0011\u0001&\u0002\u0013A\f'o]3US6,GCA&P!\u0011Yc\u0006\r'\u0011\u0005Uj\u0015B\u0001(;\u0005\u0011!\u0016.\\3\t\u000bqB\u0005\u0019A\u001f\t\u000bE\u0003A\u0011\u0001*\u0002\u001bA\f'o]3J]R,'O^1m)\t\u0019v\u000b\u0005\u0003,]A\"\u0006CA\u001bV\u0013\t1&H\u0001\u0005J]R,'O^1m\u0011\u0015a\u0004\u000b1\u0001>\u0011\u0015I\u0006\u0001\"\u0001[\u0003E\u0019H/\u0019:u\u001f\u001a$\u0015-_%ogR\fg\u000e\u001e\u000b\u00037\u000e\u0004\"\u0001X1\u000e\u0003uS!AX0\u0002\tQLW.\u001a\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u0011WLA\u0004J]N$\u0018M\u001c;\t\u000b\u0011D\u0006\u0019A3\u0002\t\u0011\fG/\u001a\t\u00039\u001aL!aZ/\u0003\u00131{7-\u00197ECR,\u0007\"B5\u0001\t\u0003Q\u0017AC:uCJ$xJ\u001a#bsR\u0011Ag\u001b\u0005\u0006I\"\u0004\r\u0001\u0012\u0005\u0006[\u0002!\tA\\\u0001\u000fgR\f'\u000f^(g\u001d\u0016DH\u000fR1z)\t!t\u000eC\u0003eY\u0002\u0007A\tC\u0003r\u0001\u0011\u0005!/\u0001\bueVt7\rT8dC2$\u0016.\\3\u0015\u0007M<H\u0010\u0005\u0003,]A\"\bC\u0001/v\u0013\t1XLA\u0005M_\u000e\fG\u000eV5nK\")\u0001\u0010\u001da\u0001s\u0006!\u0001/\u0019:u!\ty!0\u0003\u0002|\u0005\taA+Z7q_J\fG\u000eU1si\")Q\u0010\u001da\u0001i\u0006\tA\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0013iJ,hn\u0019.p]\u0016$G)\u0019;f)&lW\r\u0006\u0004\u0002\u0004\u0005-\u0011Q\u0002\t\u0006W9\u0002\u0014Q\u0001\t\u00049\u0006\u001d\u0011bAA\u0005;\ni!l\u001c8fI\u0012\u000bG/\u001a+j[\u0016DQ\u0001\u001f@A\u0002eDq!a\u0004\u007f\u0001\u0004\t)!A\u0002{IRDq!a\u0005\u0001\t\u0003\t)\"A\u0005ueVt7\rR1uKR)1)a\u0006\u0002\u001a!1\u00010!\u0005A\u0002eDq!a\u0007\u0002\u0012\u0001\u0007A)A\u0001e\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\t\u0011\u0002\u001e:v]\u000e$\u0016.\\3\u0015\u000b-\u000b\u0019#!\n\t\ra\fi\u00021\u0001z\u0011\u0019i\u0018Q\u0004a\u0001\u0019\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012A\u0004;sk:\u001cG+[7fgR\fW\u000e\u001d\u000b\u0006U\u00055\u0012q\u0006\u0005\u0007q\u0006\u001d\u0002\u0019A=\t\u000f\u0005E\u0012q\u0005a\u0001i\u0005\u0011Ao\u001d\u0005\b\u0003k\u0001A\u0011BA\u001c\u0003\u001d)\u0007\u0010\u001e:bGR$B!!\u000f\u0002@A\u0019\u0011'a\u000f\n\u0007\u0005uBAA\u0005V]\u0006\u0014\u0018PR;oG\"9\u0011\u0011IA\u001a\u0001\u0004i\u0014\u0001\u00025fYBD\u0011\"!\u0012\u0001\u0005\u0004%\t!a\u0012\u0002\u001d\u0015CHO]1di\u000e+g\u000e^;ssV\u0011\u0011\u0011\b\u0005\n\u0003\u0017\u0002!\u0019!C\u0001\u0003\u000f\n\u0011#\u0012=ue\u0006\u001cG\u000fR1z\u001f\u001aluN\u001c;i\u0011%\ty\u0005\u0001b\u0001\n\u0003\t9%A\u0007FqR\u0014\u0018m\u0019;EK\u000e\fG-\u001a\u0005\n\u0003'\u0002!\u0019!C\u0001\u0003\u000f\n\u0001#\u0012=ue\u0006\u001cG\u000fR1z\u001f\u001a<V-Z6\t\u0013\u0005]\u0003A1A\u0005\u0002\u0005\u001d\u0013\u0001E#yiJ\f7\r\u001e#bs>3\u0017,Z1s\u0011%\tY\u0006\u0001b\u0001\n\u0003\t9%\u0001\u0007FqR\u0014\u0018m\u0019;Fa>\u001c\u0007\u000eC\u0005\u0002`\u0001\u0011\r\u0011\"\u0001\u0002H\u0005YQ\t\u001f;sC\u000e$\bj\\;s\u0011%\t\u0019\u0007\u0001b\u0001\n\u0003\t9%A\nFqR\u0014\u0018m\u0019;Jg>$\u0015-_(g/\u0016,7\u000eC\u0005\u0002h\u0001\u0011\r\u0011\"\u0001\u0002H\u0005qQ\t\u001f;sC\u000e$\u0018j]8ZK\u0006\u0014\b\"CA6\u0001\t\u0007I\u0011AA$\u0003M)\u0005\u0010\u001e:bGRl\u0015n\u0019:pg\u0016\u001cwN\u001c3t\u0011%\ty\u0007\u0001b\u0001\n\u0003\t9%A\tFqR\u0014\u0018m\u0019;NS2dWM\u001c8jk6D\u0011\"a\u001d\u0001\u0005\u0004%\t!a\u0012\u0002'\u0015CHO]1di6KG\u000e\\5tK\u000e|g\u000eZ:\t\u0013\u0005]\u0004A1A\u0005\u0002\u0005\u001d\u0013!D#yiJ\f7\r^'j]V$X\rC\u0005\u0002|\u0001\u0011\r\u0011\"\u0001\u0002H\u0005aQ\t\u001f;sC\u000e$Xj\u001c8uQ\"I\u0011q\u0010\u0001C\u0002\u0013\u0005\u0011qI\u0001\u000f\u000bb$(/Y2u#V\f'\u000f^3s\u0011%\t\u0019\t\u0001b\u0001\n\u0003\t9%A\u0007FqR\u0014\u0018m\u0019;TK\u000e|g\u000e\u001a\u0005\n\u0003\u000f\u0003!\u0019!C\u0001\u0003\u000f\nq\"\u0012=ue\u0006\u001cG\u000fV5nKj|g.\u001a\u0005\n\u0003\u0017\u0003!\u0019!C\u0001\u0003\u000f\n1#\u0012=ue\u0006\u001cG\u000fV5nKj|g.\u001a%pkJD\u0011\"a$\u0001\u0005\u0004%\t!a\u0012\u0002+\u0015CHO]1diRKW.\u001a>p]\u0016l\u0015N\\;uK\"I\u00111\u0013\u0001C\u0002\u0013\u0005\u0011qI\u0001\f\u000bb$(/Y2u/\u0016,7\u000eC\u0005\u0002\u0018\u0002\u0011\r\u0011\"\u0001\u0002H\u0005YQ\t\u001f;sC\u000e$\u0018,Z1s\u0011%\tY\n\u0001b\u0001\n\u0003\t9%\u0001\u0003ECR,\u0007\"CAP\u0001\t\u0007I\u0011AAQ\u0003\rqun^\u000b\u0003\u0003G\u00032!MAS\u0013\r\t9\u000b\u0002\u0002\f\u001dVdG.\u0019:z\rVt7\rC\u0005\u0002,\u0002\u0011\r\u0011\"\u0001\u0002H\u0005!A+[7f\u0011%\ty\u000b\u0001b\u0001\n\u0003\t9%A\u0005US6,7\u000f^1na\"I\u00111\u0017\u0001C\u0002\u0013\u0005\u0011qI\u0001\t\u0013:$XM\u001d<bY\"I\u0011q\u0017\u0001C\u0002\u0013\u0005\u0011qI\u0001\u000b'R\f'\u000f^(g\t\u0006L\b\"CA^\u0001\t\u0007I\u0011AA$\u0003%!\u0016.\\3PM\u0012\u000b\u0017\u0010C\u0005\u0002@\u0002\u0011\r\u0011\"\u0001\u0002H\u0005YAk\u001c+j[\u0016\u001cH/Y7q\u000f\u001d\t\u0019M\u0001E\u0001\u0003\u000b\fq\u0001R1uK2K'\rE\u0002\u0010\u0003\u000f4a!\u0001\u0002\t\u0002\u0005%7#BAd\u0011\u0005-\u0007CA\b\u0001\u0011!\ty-a2\u0005\u0002\u0005E\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u0002F\"Q\u0011Q[Ad\u0003\u0003%I!a6\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u0004B!a7\u0002b6\u0011\u0011Q\u001c\u0006\u0004\u0003?|\u0016\u0001\u00027b]\u001eLA!a9\u0002^\n1qJ\u00196fGR\u0004")
public interface DateLib
extends Library,
scala.Serializable {
    public void quasar$std$DateLib$_setter_$ExtractCentury_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractDayOfMonth_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractDecade_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractDayOfWeek_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractDayOfYear_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractEpoch_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractHour_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractIsoDayOfWeek_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractIsoYear_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractMicroseconds_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractMillennium_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractMilliseconds_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractMinute_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractMonth_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractQuarter_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractSecond_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractTimezone_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractTimezoneHour_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractTimezoneMinute_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractWeek_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ExtractYear_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$Date_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$Now_$eq(NullaryFunc var1);

    public void quasar$std$DateLib$_setter_$Time_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$Timestamp_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$Interval_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$StartOfDay_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$TimeOfDay_$eq(UnaryFunc var1);

    public void quasar$std$DateLib$_setter_$ToTimestamp_$eq(UnaryFunc var1);

    public static /* synthetic */ .bslash.div parseTimestamp$(DateLib $this, String str2) {
        return $this.parseTimestamp(str2);
    }

    default public .bslash.div<SemanticError, Data.Timestamp> parseTimestamp(String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> Instant.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>(this.Timestamp(), str2, (Option<String>)Predef$.MODULE$.None())), (Function1 & Serializable & scala.Serializable)value -> new Data.Timestamp((Instant)value));
    }

    public static /* synthetic */ .bslash.div parseDate$(DateLib $this, String str2) {
        return $this.parseDate(str2);
    }

    default public .bslash.div<SemanticError, Data.Date> parseDate(String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> LocalDate.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>(this.Date(), str2, (Option<String>)Predef$.MODULE$.None())), (Function1 & Serializable & scala.Serializable)value -> new Data.Date((LocalDate)value));
    }

    public static /* synthetic */ .bslash.div parseTime$(DateLib $this, String str2) {
        return $this.parseTime(str2);
    }

    default public .bslash.div<SemanticError, Data.Time> parseTime(String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> LocalTime.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>(this.Time(), str2, (Option<String>)Predef$.MODULE$.None())), (Function1 & Serializable & scala.Serializable)value -> new Data.Time((LocalTime)value));
    }

    public static /* synthetic */ .bslash.div parseInterval$(DateLib $this, String str2) {
        return $this.parseInterval(str2);
    }

    default public .bslash.div<SemanticError, Data.Interval> parseInterval(String str2) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> Duration.parse(str2)).bimap(package$.MODULE$.\u03ba(new SemanticError.DateFormatError<Succ<_0>>(this.Interval(), str2, (Option<String>)Predef$.MODULE$.Some().apply((Object)"expected, e.g. P3DT12H30M15.0S; note: year/month not currently supported"))), (Function1 & Serializable & scala.Serializable)value -> new Data.Interval((Duration)value));
    }

    public static /* synthetic */ Instant startOfDayInstant$(DateLib $this, LocalDate date) {
        return $this.startOfDayInstant(date);
    }

    default public Instant startOfDayInstant(LocalDate date) {
        return date.atStartOfDay().atZone(ZoneOffset.UTC).toInstant();
    }

    public static /* synthetic */ Data.Timestamp startOfDay$(DateLib $this, Data.Date date) {
        return $this.startOfDay(date);
    }

    default public Data.Timestamp startOfDay(Data.Date date) {
        return new Data.Timestamp(this.startOfDayInstant(date.value()));
    }

    public static /* synthetic */ Data.Timestamp startOfNextDay$(DateLib $this, Data.Date date) {
        return $this.startOfNextDay(date);
    }

    default public Data.Timestamp startOfNextDay(Data.Date date) {
        return new Data.Timestamp(this.startOfDayInstant(date.value().plus(Period.ofDays(1))));
    }

    public static /* synthetic */ .bslash.div truncLocalTime$(DateLib $this, TemporalPart part, LocalTime t) {
        return $this.truncLocalTime(part, t);
    }

    default public .bslash.div<SemanticError, LocalTime> truncLocalTime(TemporalPart part, LocalTime t) {
        return $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> {
            LocalTime localTime;
            TemporalPart temporalPart = part;
            boolean bl = TemporalPart$Century$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Day$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Decade$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Millennium$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Month$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Quarter$.MODULE$.equals(temporalPart) ? true : (TemporalPart$Week$.MODULE$.equals(temporalPart) ? true : TemporalPart$Year$.MODULE$.equals(temporalPart)))))));
            if (bl) {
                localTime = t.truncatedTo(ChronoUnit.DAYS);
            } else if (TemporalPart$Hour$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.HOURS);
            } else if (TemporalPart$Microsecond$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.MICROS);
            } else if (TemporalPart$Millisecond$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.MILLIS);
            } else if (TemporalPart$Minute$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.MINUTES);
            } else if (TemporalPart$Second$.MODULE$.equals(temporalPart)) {
                localTime = t.truncatedTo(ChronoUnit.SECONDS);
            } else {
                throw new MatchError((Object)temporalPart);
            }
            return localTime;
        }).leftMap((Function1 & Serializable & scala.Serializable)err -> new SemanticError.GenericError(Predef$.MODULE$.StringContext().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncLocalTime: ", ""})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{err}))));
    }

    public static /* synthetic */ .bslash.div truncZonedDateTime$(DateLib $this, TemporalPart part, ZonedDateTime zdt) {
        return $this.truncZonedDateTime(part, zdt);
    }

    default public .bslash.div<SemanticError, ZonedDateTime> truncZonedDateTime(TemporalPart part, ZonedDateTime zdt) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToBindOps(this.truncLocalTime(part, zdt.toLocalTime()), (Bind)$bslash$div$.MODULE$.DisjunctionInstances1()).$greater$greater$eq((Function1 & Serializable & scala.Serializable)t -> $bslash$div$.MODULE$.fromTryCatchNonFatal((Function0 & Serializable & scala.Serializable)() -> {
            ZonedDateTime zonedDateTime;
            ZonedDateTime truncTime = ZonedDateTime.of(zdt.toLocalDate(), t, zdt.getZone());
            TemporalPart temporalPart = part;
            if (TemporalPart$Century$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1).withYear(zdt.getYear() / 100 * 100);
            } else if (TemporalPart$Day$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Decade$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1).withYear(zdt.getYear() / 10 * 10);
            } else if (TemporalPart$Hour$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Microsecond$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Millennium$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1).withYear(zdt.getYear() / 1000 * 1000);
            } else if (TemporalPart$Millisecond$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Minute$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Month$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1);
            } else if (TemporalPart$Quarter$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(zdt.getMonth().firstMonthOfQuarter().getValue());
            } else if (TemporalPart$Second$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime;
            } else if (TemporalPart$Week$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.with(DayOfWeek.MONDAY);
            } else if (TemporalPart$Year$.MODULE$.equals(temporalPart)) {
                zonedDateTime = truncTime.withDayOfMonth(1).withMonth(1);
            } else {
                throw new MatchError((Object)temporalPart);
            }
            return zonedDateTime;
        }).leftMap((Function1 & Serializable & scala.Serializable)err -> new SemanticError.GenericError(Predef$.MODULE$.StringContext().apply((Seq)scala.Predef$.MODULE$.wrapRefArray((Object[])new String[]{"truncZonedDateTime: ", ""})).s((Seq)scala.Predef$.MODULE$.genericWrapArray((Object)new Object[]{err})))));
    }

    public static /* synthetic */ .bslash.div truncDate$(DateLib $this, TemporalPart part, Data.Date d) {
        return $this.truncDate(part, d);
    }

    default public .bslash.div<SemanticError, Data.Date> truncDate(TemporalPart part, Data.Date d) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToFunctorOps(this.truncZonedDateTime(part, d.value().atStartOfDay(ZoneOffset.UTC)), (Functor)$bslash$div$.MODULE$.DisjunctionInstances1()).$u2218((Function1 & Serializable & scala.Serializable)t -> new Data.Date(t.toLocalDate()));
    }

    public static /* synthetic */ .bslash.div truncTime$(DateLib $this, TemporalPart part, Data.Time t) {
        return $this.truncTime(part, t);
    }

    default public .bslash.div<SemanticError, Data.Time> truncTime(TemporalPart part, Data.Time t) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToFunctorOps(this.truncLocalTime(part, t.value()), (Functor)$bslash$div$.MODULE$.DisjunctionInstances1()).$u2218((Function1 & Serializable & scala.Serializable)x$1 -> new Data.Time((LocalTime)x$1));
    }

    public static /* synthetic */ .bslash.div truncTimestamp$(DateLib $this, TemporalPart part, Data.Timestamp ts) {
        return $this.truncTimestamp(part, ts);
    }

    default public .bslash.div<SemanticError, Data.Timestamp> truncTimestamp(TemporalPart part, Data.Timestamp ts) {
        return (.bslash.div)scalaz.syntax.package$.MODULE$.bind().ToFunctorOps(this.truncZonedDateTime(part, ts.value().atZone(ZoneOffset.UTC)), (Functor)$bslash$div$.MODULE$.DisjunctionInstances1()).$u2218((Function1 & Serializable & scala.Serializable)t -> new Data.Timestamp(t.toInstant()));
    }

    private UnaryFunc extract(String help) {
        return new UnaryFunc(Mapping$.MODULE$, help, Type$.MODULE$.Numeric(), Func$.MODULE$.Input1(Type$.MODULE$.Temporal()), this.noSimplification(), this.constTyper(Type$.MODULE$.Numeric()), this.basicUntyper());
    }

    public UnaryFunc ExtractCentury();

    public UnaryFunc ExtractDayOfMonth();

    public UnaryFunc ExtractDecade();

    public UnaryFunc ExtractDayOfWeek();

    public UnaryFunc ExtractDayOfYear();

    public UnaryFunc ExtractEpoch();

    public UnaryFunc ExtractHour();

    public UnaryFunc ExtractIsoDayOfWeek();

    public UnaryFunc ExtractIsoYear();

    public UnaryFunc ExtractMicroseconds();

    public UnaryFunc ExtractMillennium();

    public UnaryFunc ExtractMilliseconds();

    public UnaryFunc ExtractMinute();

    public UnaryFunc ExtractMonth();

    public UnaryFunc ExtractQuarter();

    public UnaryFunc ExtractSecond();

    public UnaryFunc ExtractTimezone();

    public UnaryFunc ExtractTimezoneHour();

    public UnaryFunc ExtractTimezoneMinute();

    public UnaryFunc ExtractWeek();

    public UnaryFunc ExtractYear();

    public UnaryFunc Date();

    public NullaryFunc Now();

    public UnaryFunc Time();

    public UnaryFunc Timestamp();

    public UnaryFunc Interval();

    public UnaryFunc StartOfDay();

    public UnaryFunc TimeOfDay();

    public UnaryFunc ToTimestamp();

    public static void $init$(DateLib $this) {
        $this.quasar$std$DateLib$_setter_$ExtractCentury_$eq($this.extract("Pulls out the century subfield from a date/time value (currently year/100)."));
        $this.quasar$std$DateLib$_setter_$ExtractDayOfMonth_$eq($this.extract("Pulls out the day of month (`day`) subfield from a date/time value (1-31)."));
        $this.quasar$std$DateLib$_setter_$ExtractDecade_$eq($this.extract("Pulls out the decade subfield from a date/time value (year/10)."));
        $this.quasar$std$DateLib$_setter_$ExtractDayOfWeek_$eq($this.extract("Pulls out the day of week (`dow`) subfield from a date/time value (Sunday: 0 to Saturday: 7)."));
        $this.quasar$std$DateLib$_setter_$ExtractDayOfYear_$eq($this.extract("Pulls out the day of year (`doy`) subfield from a date/time value (1-365 or -366)."));
        $this.quasar$std$DateLib$_setter_$ExtractEpoch_$eq($this.extract("Pulls out the epoch subfield from a date/time value. For dates and timestamps, this is the number of seconds since midnight, 1970-01-01. For intervals, the number of seconds in the interval."));
        $this.quasar$std$DateLib$_setter_$ExtractHour_$eq($this.extract("Pulls out the hour subfield from a date/time value (0-23)."));
        $this.quasar$std$DateLib$_setter_$ExtractIsoDayOfWeek_$eq($this.extract("Pulls out the ISO day of week (`isodow`) subfield from a date/time value (Monday: 1 to Sunday: 7)."));
        $this.quasar$std$DateLib$_setter_$ExtractIsoYear_$eq($this.extract("Pulls out the ISO year (`isoyear`) subfield from a date/time value (based on the first week containing Jan. 4)."));
        $this.quasar$std$DateLib$_setter_$ExtractMicroseconds_$eq($this.extract("Pulls out the microseconds subfield from a date/time value (including seconds)."));
        $this.quasar$std$DateLib$_setter_$ExtractMillennium_$eq($this.extract("Pulls out the millennium subfield from a date/time value (currently year/1000)."));
        $this.quasar$std$DateLib$_setter_$ExtractMilliseconds_$eq($this.extract("Pulls out the milliseconds subfield from a date/time value (including seconds)."));
        $this.quasar$std$DateLib$_setter_$ExtractMinute_$eq($this.extract("Pulls out the minute subfield from a date/time value (0-59)."));
        $this.quasar$std$DateLib$_setter_$ExtractMonth_$eq($this.extract("Pulls out the month subfield from a date/time value (1-12)."));
        $this.quasar$std$DateLib$_setter_$ExtractQuarter_$eq($this.extract("Pulls out the quarter subfield from a date/time value (1-4)."));
        $this.quasar$std$DateLib$_setter_$ExtractSecond_$eq($this.extract("Pulls out the second subfield from a date/time value (0-59, with fractional parts)."));
        $this.quasar$std$DateLib$_setter_$ExtractTimezone_$eq($this.extract("Pulls out the timezone subfield from a date/time value (in seconds east of UTC)."));
        $this.quasar$std$DateLib$_setter_$ExtractTimezoneHour_$eq($this.extract("Pulls out the hour component of the timezone subfield from a date/time value."));
        $this.quasar$std$DateLib$_setter_$ExtractTimezoneMinute_$eq($this.extract("Pulls out the minute component of the timezone subfield from a date/time value."));
        $this.quasar$std$DateLib$_setter_$ExtractWeek_$eq($this.extract("Pulls out the week subfield from a date/time value (1-53)."));
        $this.quasar$std$DateLib$_setter_$ExtractYear_$eq($this.extract("Pulls out the year subfield from a date/time value."));
        $this.quasar$std$DateLib$_setter_$Date_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (YYYY-MM-DD) to a date value. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Date$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x1;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseDate(str3).map((Function1 & Serializable & scala.Serializable)x$2 -> new Type.Const((Data)x$2)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Date$.MODULE$) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x1) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x1;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(quasar.Data$Date )}, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$Now_$eq(new NullaryFunc(Mapping$.MODULE$, "Returns the current timestamp \u2013 this must always return the same value within the same execution of a query.", Type$Timestamp$.MODULE$, $this.noSimplification()));
        $this.quasar$std$DateLib$_setter_$Time_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (HH:MM:SS[.SSS]) to a time value. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Time$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x2;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseTime(str3).map((Function1 & Serializable & scala.Serializable)x$3 -> new Type.Const((Data)x$3)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Time$.MODULE$) : function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x2) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x2;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(quasar.Data$Time )}, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$Timestamp_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (ISO 8601, UTC, e.g. 2015-05-12T12:22:00Z) to a timestamp value. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Timestamp$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x3;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseTimestamp(str3).map((Function1 & Serializable & scala.Serializable)x$4 -> new Type.Const((Data)x$4)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Timestamp$.MODULE$) : function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x3) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x3;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(quasar.Data$Timestamp )}, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$Interval_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a string in the format (ISO 8601, e.g. P3DT12H30M15.0S) to an interval value. Note: year/month not currently supported. This is a partial function \u2013 arguments that don\u2019t satisify the constraint have undefined results.", Type$Interval$.MODULE$, Func$.MODULE$.Input1(Type$Str$.MODULE$), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x4;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Str) {
                    Data.Str str2 = (Data.Str)data;
                    String str3 = str2.value();
                    object = this.$outer.parseInterval(str3).map((Function1 & Serializable & scala.Serializable)x$5 -> new Type.Const((Data)x$5)).validation().toValidationNel();
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Interval$.MODULE$) : function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x4) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x4;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Str ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Str$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$4(quasar.Data$Interval )}, serializedLambda);
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$StartOfDay_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts a Date or Timestamp to a Timestamp at the start of that day.", Type$Timestamp$.MODULE$, Func$.MODULE$.Input1(Type$Date$.MODULE$.$u2A3F(Type$Timestamp$.MODULE$)), $this.noSimplification(), $this.partialTyperV(new scala.Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DateLib $outer;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x5;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Date) {
                    Data.Date date = (Data.Date)data;
                    LocalDate v = date.value();
                    object = Validation$.MODULE$.success().apply((Object)new Type.Const(new Data.Timestamp(this.$outer.startOfDayInstant(v))));
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Date$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0))) {
                        object = Validation$.MODULE$.success().apply((Object)Type$Timestamp$.MODULE$);
                    } else {
                        Type.Const const_2;
                        Data data2;
                        Type type3;
                        Some some3 = Sized$.MODULE$.unapplySeq(A1);
                        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && (type3 = (Type)((LinearSeqOptimized)some3.get()).apply(0)) instanceof Type.Const && (data2 = (const_2 = (Type.Const)type3).value()) instanceof Data.Timestamp) {
                            Data.Timestamp timestamp = (Data.Timestamp)data2;
                            Instant v = timestamp.value();
                            object = this.$outer.truncZonedDateTime(TemporalPart$Day$.MODULE$, v.atZone(ZoneOffset.UTC)).map((Function1 & Serializable & scala.Serializable)t -> new Type.Const(new Data.Timestamp(t.toInstant()))).validation().toValidationNel();
                        } else {
                            Type type4;
                            Some some4 = Sized$.MODULE$.unapplySeq(A1);
                            object = !some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type4 = (Type)((LinearSeqOptimized)some4.get()).apply(0)) ? Validation$.MODULE$.success().apply((Object)Type$Timestamp$.MODULE$) : function1.apply(x5);
                        }
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x5) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Some some2;
                Type type3;
                Some some3;
                Type.Const const_2;
                Data data2;
                Type type4;
                Sized<List<Type>, Succ<_0>> sized = x5;
                Some some4 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some4.isEmpty() && some4.get() != null && ((LinearSeqOptimized)some4.get()).lengthCompare(1) == 0 && (type4 = (Type)((LinearSeqOptimized)some4.get()).apply(0)) instanceof Type.Const && (data2 = (const_2 = (Type.Const)type4).value()) instanceof Data.Date ? true : (!(some3 = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(1) == 0 && Type$Date$.MODULE$.equals(type3 = (Type)((LinearSeqOptimized)some3.get()).apply(0)) ? true : (!(some2 = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Timestamp ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.time.ZonedDateTime )}, serializedLambda);
            }
        }), $this.untyper((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Type type = x0$1;
            Validation validation = Type$Timestamp$.MODULE$.equals(type) ? (Validation)Validation$.MODULE$.success().apply(Func$.MODULE$.Input1(Type$Date$.MODULE$)) : (Validation)Validation$.MODULE$.success().apply(Func$.MODULE$.Input1(type));
            return validation;
        })));
        $this.quasar$std$DateLib$_setter_$TimeOfDay_$eq(new UnaryFunc(Mapping$.MODULE$, "Extracts the time of day from a (UTC) timestamp value.", Type$Time$.MODULE$, Func$.MODULE$.Input1(Type$Timestamp$.MODULE$), $this.noSimplification(), $this.partialTyper(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x6;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Timestamp) {
                    Data.Timestamp timestamp = (Data.Timestamp)data;
                    Instant value = timestamp.value();
                    object = new Type.Const(new Data.Time(value.atZone(ZoneOffset.UTC).toLocalTime()));
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Type$Time$.MODULE$ : function1.apply(x6);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x6) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x6;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Timestamp ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Timestamp$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
        }), $this.basicUntyper()));
        $this.quasar$std$DateLib$_setter_$ToTimestamp_$eq(new UnaryFunc(Mapping$.MODULE$, "Converts an integer epoch time value (i.e. milliseconds since 1 Jan. 1970, UTC) to a timestamp constant.", Type$Timestamp$.MODULE$, Func$.MODULE$.Input1(Type$Int$.MODULE$), $this.noSimplification(), $this.partialTyper(new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Sized<List<Type>, Succ<_0>>, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                Object object;
                Type.Const const_;
                Data data;
                Type type;
                A1 A1 = x7;
                Some some = Sized$.MODULE$.unapplySeq(A1);
                if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && (type = (Type)((LinearSeqOptimized)some.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type).value()) instanceof Data.Int) {
                    Data.Int intVal = (Data.Int)data;
                    BigInt millis = intVal.value();
                    object = new Type.Const(new Data.Timestamp(Instant.ofEpochMilli(millis.toLong())));
                } else {
                    Type type2;
                    Some some2 = Sized$.MODULE$.unapplySeq(A1);
                    object = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && Type$Int$.MODULE$.equals(type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) ? Type$Timestamp$.MODULE$ : function1.apply(x7);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Sized<List<Type>, Succ<_0>> x7) {
                Type type;
                Some some;
                Type.Const const_;
                Data data;
                Type type2;
                Sized<List<Type>, Succ<_0>> sized = x7;
                Some some2 = Sized$.MODULE$.unapplySeq(sized);
                boolean bl = !some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0 && (type2 = (Type)((LinearSeqOptimized)some2.get()).apply(0)) instanceof Type.Const && (data = (const_ = (Type.Const)type2).value()) instanceof Data.Int ? true : !(some = Sized$.MODULE$.unapplySeq(sized)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 && Type$Int$.MODULE$.equals(type = (Type)((LinearSeqOptimized)some.get()).apply(0));
                return bl;
            }
        }), $this.basicUntyper()));
    }
}

