/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.simpl;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import org.quartz.simpl.InitThreadContextClassLoadHelper;
import org.quartz.simpl.LoadingLoaderClassLoadHelper;
import org.quartz.simpl.SimpleClassLoadHelper;
import org.quartz.simpl.ThreadContextClassLoadHelper;
import org.quartz.spi.ClassLoadHelper;

public class CascadingClassLoadHelper
implements ClassLoadHelper {
    private LinkedList loadHelpers;
    private ClassLoadHelper bestCandidate;

    public void initialize() {
        this.loadHelpers = new LinkedList();
        this.loadHelpers.add(new LoadingLoaderClassLoadHelper());
        this.loadHelpers.add(new SimpleClassLoadHelper());
        this.loadHelpers.add(new ThreadContextClassLoadHelper());
        this.loadHelpers.add(new InitThreadContextClassLoadHelper());
        for (ClassLoadHelper loadHelper : this.loadHelpers) {
            loadHelper.initialize();
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.loadClass(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        ClassNotFoundException cnfe = null;
        Class clazz = null;
        ClassLoadHelper loadHelper2 = null;
        for (ClassLoadHelper loadHelper2 : this.loadHelpers) {
            try {
                clazz = loadHelper2.loadClass(name);
                break;
            }
            catch (ClassNotFoundException e) {
                cnfe = e;
            }
        }
        if (clazz == null) {
            throw cnfe;
        }
        this.bestCandidate = loadHelper2;
        return clazz;
    }

    public URL getResource(String name) {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.getResource(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        URL result = null;
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResource(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public InputStream getResourceAsStream(String name) {
        if (this.bestCandidate != null) {
            try {
                return this.bestCandidate.getResourceAsStream(name);
            }
            catch (Exception e) {
                this.bestCandidate = null;
            }
        }
        InputStream result = null;
        ClassLoadHelper loadHelper = null;
        Iterator iter = this.loadHelpers.iterator();
        while (iter.hasNext() && (result = (loadHelper = (ClassLoadHelper)iter.next()).getResourceAsStream(name)) == null) {
        }
        this.bestCandidate = loadHelper;
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.bestCandidate == null ? Thread.currentThread().getContextClassLoader() : this.bestCandidate.getClassLoader();
    }
}

