/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.core;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Calendar;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.quartz.UnableToInterruptJobException;
import org.quartz.core.ErrorLogger;
import org.quartz.core.ExecutingJobsManager;
import org.quartz.core.QuartzSchedulerResources;
import org.quartz.core.QuartzSchedulerThread;
import org.quartz.core.RemotableQuartzScheduler;
import org.quartz.core.SchedulerSignalerImpl;
import org.quartz.core.SchedulingContext;
import org.quartz.impl.SchedulerRepository;
import org.quartz.simpl.SimpleJobFactory;
import org.quartz.spi.JobFactory;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.spi.SchedulerSignaler;

public class QuartzScheduler
implements RemotableQuartzScheduler {
    private static String VERSION_MAJOR;
    private static String VERSION_MINOR;
    private static String VERSION_ITERATION;
    private QuartzSchedulerResources resources;
    private QuartzSchedulerThread schedThread;
    private ThreadGroup threadGroup;
    private SchedulerContext context = new SchedulerContext();
    private HashMap jobListeners = new HashMap(10);
    private HashMap globalJobListeners = new HashMap(10);
    private HashMap triggerListeners = new HashMap(10);
    private HashMap globalTriggerListeners = new HashMap(10);
    private ArrayList schedulerListeners = new ArrayList(10);
    private JobFactory jobFactory = new SimpleJobFactory();
    ExecutingJobsManager jobMgr = null;
    ErrorLogger errLogger = null;
    private SchedulerSignaler signaler;
    private Random random = new Random();
    private ArrayList holdToPreventGC = new ArrayList(5);
    private boolean signalOnSchedulingChange = true;
    private boolean closed = false;
    private boolean shuttingDown = false;
    private Date initialStart = null;
    private final Log log = LogFactory.getLog(this.getClass());

    public QuartzScheduler(QuartzSchedulerResources resources, SchedulingContext ctxt, long idleWaitTime, long dbRetryInterval) throws SchedulerException {
        this.resources = resources;
        try {
            this.bind();
        }
        catch (Exception re) {
            throw new SchedulerException("Unable to bind scheduler to RMI Registry.", re);
        }
        if (resources.getJMXExport()) {
            try {
                this.registerJMX();
            }
            catch (Exception e) {
                throw new SchedulerException("Unable to register scheduler with MBeanServer.", e);
            }
        }
        this.schedThread = new QuartzSchedulerThread(this, resources, ctxt);
        if (idleWaitTime > 0L) {
            this.schedThread.setIdleWaitTime(idleWaitTime);
        }
        if (dbRetryInterval > 0L) {
            this.schedThread.setDbFailureRetryInterval(dbRetryInterval);
        }
        this.jobMgr = new ExecutingJobsManager();
        this.addGlobalJobListener(this.jobMgr);
        this.errLogger = new ErrorLogger();
        this.addSchedulerListener(this.errLogger);
        this.signaler = new SchedulerSignalerImpl(this, this.schedThread);
        this.getLog().info((Object)("Quartz Scheduler v." + this.getVersion() + " created."));
    }

    public String getVersion() {
        return QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
    }

    public static String getVersionMajor() {
        return VERSION_MAJOR;
    }

    public static String getVersionMinor() {
        return VERSION_MINOR;
    }

    public static String getVersionIteration() {
        return VERSION_ITERATION;
    }

    public SchedulerSignaler getSchedulerSignaler() {
        return this.signaler;
    }

    public Log getLog() {
        return this.log;
    }

    private void registerJMX() throws Exception {
        org.apache.commons.modeler.Registry registry = org.apache.commons.modeler.Registry.getRegistry(null, null);
        String jmxObjectName = this.resources.getJMXObjectName();
        registry.registerComponent((Object)this, jmxObjectName, null);
        this.getLog().info((Object)("Scheduler registered with local MBeanServer under name '" + jmxObjectName + "'"));
    }

    private void unregisterJMX() throws Exception {
        org.apache.commons.modeler.Registry registry = org.apache.commons.modeler.Registry.getRegistry(null, null);
        String jmxObjectName = this.resources.getJMXObjectName();
        registry.unregisterComponent(jmxObjectName);
        this.getLog().info((Object)("Scheduler unregistered from name '" + jmxObjectName + "' in the local MBeanServer."));
    }

    private void bind() throws RemoteException {
        String host = this.resources.getRMIRegistryHost();
        if (host == null || host.length() == 0) {
            return;
        }
        RemotableQuartzScheduler exportable = null;
        exportable = this.resources.getRMIServerPort() > 0 ? (RemotableQuartzScheduler)UnicastRemoteObject.exportObject((Remote)this, this.resources.getRMIServerPort()) : (RemotableQuartzScheduler)((Object)UnicastRemoteObject.exportObject(this));
        Registry registry = null;
        if (this.resources.getRMICreateRegistryStrategy().equals("as_needed")) {
            try {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
                registry.list();
            }
            catch (Exception e) {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
        } else if (this.resources.getRMICreateRegistryStrategy().equals("always")) {
            try {
                registry = LocateRegistry.createRegistry(this.resources.getRMIRegistryPort());
            }
            catch (Exception e) {
                registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryPort());
            }
        } else {
            registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        }
        String bindName = this.resources.getRMIBindName();
        registry.rebind(bindName, exportable);
        this.getLog().info((Object)("Scheduler bound to RMI registry under name '" + bindName + "'"));
    }

    private void unBind() throws RemoteException {
        String host = this.resources.getRMIRegistryHost();
        if (host == null || host.length() == 0) {
            return;
        }
        Registry registry = LocateRegistry.getRegistry(this.resources.getRMIRegistryHost(), this.resources.getRMIRegistryPort());
        String bindName = this.resources.getRMIBindName();
        try {
            registry.unbind(bindName);
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (NotBoundException nbe) {
            // empty catch block
        }
        this.getLog().info((Object)("Scheduler un-bound from name '" + bindName + "' in RMI registry"));
    }

    public String getSchedulerName() {
        return this.resources.getName();
    }

    public String getSchedulerInstanceId() {
        return this.resources.getInstanceId();
    }

    public ThreadGroup getSchedulerThreadGroup() {
        if (this.threadGroup == null) {
            this.threadGroup = new ThreadGroup("QuartzScheduler:" + this.getSchedulerName());
            if (this.resources.getMakeSchedulerThreadDaemon()) {
                this.threadGroup.setDaemon(true);
            }
        }
        return this.threadGroup;
    }

    public void addNoGCObject(Object obj) {
        this.holdToPreventGC.add(obj);
    }

    public boolean removeNoGCObject(Object obj) {
        return this.holdToPreventGC.remove(obj);
    }

    public SchedulerContext getSchedulerContext() throws SchedulerException {
        return this.context;
    }

    public boolean isSignalOnSchedulingChange() {
        return this.signalOnSchedulingChange;
    }

    public void setSignalOnSchedulingChange(boolean signalOnSchedulingChange) {
        this.signalOnSchedulingChange = signalOnSchedulingChange;
    }

    public void start() throws SchedulerException {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        if (this.initialStart == null) {
            this.initialStart = new Date();
            this.resources.getJobStore().schedulerStarted();
            this.startPlugins();
        }
        this.schedThread.togglePause(false);
        this.getLog().info((Object)("Scheduler " + this.resources.getUniqueIdentifier() + " started."));
    }

    public void startDelayed(final int seconds) throws SchedulerException {
        if (this.shuttingDown || this.closed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep((long)seconds * 1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                try {
                    QuartzScheduler.this.start();
                }
                catch (SchedulerException se) {
                    QuartzScheduler.this.getLog().error((Object)"Unable to start secheduler after startup delay.", (Throwable)se);
                }
            }
        });
        t.start();
    }

    public void standby() {
        this.schedThread.togglePause(true);
        this.getLog().info((Object)("Scheduler " + this.resources.getUniqueIdentifier() + " paused."));
    }

    public boolean isInStandbyMode() {
        return this.schedThread.isPaused();
    }

    public Date runningSince() {
        return this.initialStart;
    }

    public int numJobsExecuted() {
        return this.jobMgr.getNumJobsFired();
    }

    public Class getJobStoreClass() {
        return this.resources.getJobStore().getClass();
    }

    public boolean supportsPersistence() {
        return this.resources.getJobStore().supportsPersistence();
    }

    public Class getThreadPoolClass() {
        return this.resources.getThreadPool().getClass();
    }

    public int getThreadPoolSize() {
        return this.resources.getThreadPool().getPoolSize();
    }

    public void shutdown() {
        this.shutdown(false);
    }

    public void shutdown(boolean waitForJobsToComplete) {
        if (this.shuttingDown || this.closed) {
            return;
        }
        this.shuttingDown = true;
        this.getLog().info((Object)("Scheduler " + this.resources.getUniqueIdentifier() + " shutting down."));
        this.standby();
        this.schedThread.halt();
        this.resources.getThreadPool().shutdown(waitForJobsToComplete);
        if (waitForJobsToComplete) {
            while (this.jobMgr.getNumJobsCurrentlyExecuting() > 0) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception ignore) {}
            }
        }
        try {
            this.schedThread.join();
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        this.closed = true;
        this.resources.getJobStore().shutdown();
        this.notifySchedulerListenersShutdown();
        this.shutdownPlugins();
        SchedulerRepository.getInstance().remove(this.resources.getName());
        this.holdToPreventGC.clear();
        try {
            this.unBind();
        }
        catch (RemoteException re) {
            // empty catch block
        }
        if (this.resources.getJMXExport()) {
            try {
                this.unregisterJMX();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getLog().info((Object)("Scheduler " + this.resources.getUniqueIdentifier() + " shutdown complete."));
    }

    public boolean isShutdown() {
        return this.closed;
    }

    public void validateState() throws SchedulerException {
        if (this.isShutdown()) {
            throw new SchedulerException("The Scheduler has been shutdown.");
        }
    }

    public List getCurrentlyExecutingJobs() {
        return this.jobMgr.getExecutingJobs();
    }

    public Date scheduleJob(SchedulingContext ctxt, JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        Date ft;
        this.validateState();
        if (jobDetail == null) {
            throw new SchedulerException("JobDetail cannot be null", 100);
        }
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null", 100);
        }
        jobDetail.validate();
        if (trigger.getJobName() == null) {
            trigger.setJobName(jobDetail.getName());
            trigger.setJobGroup(jobDetail.getGroup());
        } else {
            if (trigger.getJobName() != null && !trigger.getJobName().equals(jobDetail.getName())) {
                throw new SchedulerException("Trigger does not reference given job!", 100);
            }
            if (trigger.getJobGroup() != null && !trigger.getJobGroup().equals(jobDetail.getGroup())) {
                throw new SchedulerException("Trigger does not reference given job!", 100);
            }
        }
        trigger.validate();
        Calendar cal = null;
        if (trigger.getCalendarName() != null) {
            cal = this.resources.getJobStore().retrieveCalendar(ctxt, trigger.getCalendarName());
        }
        if ((ft = trigger.computeFirstFireTime(cal)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.", 100);
        }
        this.resources.getJobStore().storeJobAndTrigger(ctxt, jobDetail, trigger);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trigger);
        return ft;
    }

    public Date scheduleJob(SchedulingContext ctxt, Trigger trigger) throws SchedulerException {
        this.validateState();
        if (trigger == null) {
            throw new SchedulerException("Trigger cannot be null", 100);
        }
        trigger.validate();
        Calendar cal = null;
        if (trigger.getCalendarName() != null && (cal = this.resources.getJobStore().retrieveCalendar(ctxt, trigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + trigger.getCalendarName(), 420);
        }
        Date ft = trigger.computeFirstFireTime(cal);
        if (ft == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.", 100);
        }
        this.resources.getJobStore().storeTrigger(ctxt, trigger, false);
        this.notifySchedulerThread(trigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trigger);
        return ft;
    }

    public void addJob(SchedulingContext ctxt, JobDetail jobDetail, boolean replace) throws SchedulerException {
        this.validateState();
        if (!jobDetail.isDurable() && !replace) {
            throw new SchedulerException("Jobs added with no trigger must be durable.", 100);
        }
        this.resources.getJobStore().storeJob(ctxt, jobDetail, replace);
    }

    public boolean deleteJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().removeJob(ctxt, jobName, groupName);
    }

    public boolean unscheduleJob(SchedulingContext ctxt, String triggerName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        if (!this.resources.getJobStore().removeTrigger(ctxt, triggerName, groupName)) {
            return false;
        }
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersUnschduled(triggerName, groupName);
        return true;
    }

    public Date rescheduleJob(SchedulingContext ctxt, String triggerName, String groupName, Trigger newTrigger) throws SchedulerException {
        Date ft;
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        newTrigger.validate();
        Calendar cal = null;
        if (newTrigger.getCalendarName() != null) {
            cal = this.resources.getJobStore().retrieveCalendar(ctxt, newTrigger.getCalendarName());
        }
        if ((ft = newTrigger.computeFirstFireTime(cal)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.", 100);
        }
        if (!this.resources.getJobStore().replaceTrigger(ctxt, triggerName, groupName, newTrigger)) {
            return null;
        }
        this.notifySchedulerThread(newTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersUnschduled(triggerName, groupName);
        this.notifySchedulerListenersSchduled(newTrigger);
        return ft;
    }

    private String newTriggerId() {
        long r = this.random.nextLong();
        if (r < 0L) {
            r = -r;
        }
        return "MT_" + Long.toString(r, 30 + (int)(System.currentTimeMillis() % 7L));
    }

    public void triggerJob(SchedulingContext ctxt, String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        SimpleTrigger trig = new SimpleTrigger(this.newTriggerId(), "MANUAL_TRIGGER", jobName, groupName, new Date(), null, 0, 0L);
        trig.setVolatility(false);
        ((Trigger)trig).computeFirstFireTime(null);
        if (data != null) {
            trig.setJobDataMap(data);
        }
        boolean collision = true;
        while (collision) {
            try {
                this.resources.getJobStore().storeTrigger(ctxt, trig, false);
                collision = false;
            }
            catch (ObjectAlreadyExistsException oaee) {
                trig.setName(this.newTriggerId());
            }
        }
        this.notifySchedulerThread(((Trigger)trig).getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trig);
    }

    public void triggerJobWithVolatileTrigger(SchedulingContext ctxt, String jobName, String groupName, JobDataMap data) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        SimpleTrigger trig = new SimpleTrigger(this.newTriggerId(), "MANUAL_TRIGGER", jobName, groupName, new Date(), null, 0, 0L);
        trig.setVolatility(true);
        ((Trigger)trig).computeFirstFireTime(null);
        if (data != null) {
            trig.setJobDataMap(data);
        }
        boolean collision = true;
        while (collision) {
            try {
                this.resources.getJobStore().storeTrigger(ctxt, trig, false);
                collision = false;
            }
            catch (ObjectAlreadyExistsException oaee) {
                trig.setName(this.newTriggerId());
            }
        }
        this.notifySchedulerThread(((Trigger)trig).getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(trig);
    }

    public void pauseTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseTrigger(ctxt, triggerName, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTrigger(triggerName, groupName);
    }

    public void pauseTriggerGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseTriggerGroup(ctxt, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTrigger(null, groupName);
    }

    public void pauseJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseJob(ctxt, jobName, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedJob(jobName, groupName);
    }

    public void pauseJobGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().pauseJobGroup(ctxt, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedJob(null, groupName);
    }

    public void resumeTrigger(SchedulingContext ctxt, String triggerName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeTrigger(ctxt, triggerName, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(triggerName, groupName);
    }

    public void resumeTriggerGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeTriggerGroup(ctxt, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(null, groupName);
    }

    public Set getPausedTriggerGroups(SchedulingContext ctxt) throws SchedulerException {
        return this.resources.getJobStore().getPausedTriggerGroups(ctxt);
    }

    public void resumeJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeJob(ctxt, jobName, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedJob(jobName, groupName);
    }

    public void resumeJobGroup(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        this.resources.getJobStore().resumeJobGroup(ctxt, groupName);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedJob(null, groupName);
    }

    public void pauseAll(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().pauseAll(ctxt);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTrigger(null, null);
    }

    public void resumeAll(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().resumeAll(ctxt);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(null, null);
    }

    public String[] getJobGroupNames(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getJobGroupNames(ctxt);
    }

    public String[] getJobNames(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().getJobNames(ctxt, groupName);
    }

    public Trigger[] getTriggersOfJob(SchedulingContext ctxt, String jobName, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().getTriggersForJob(ctxt, jobName, groupName);
    }

    public String[] getTriggerGroupNames(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getTriggerGroupNames(ctxt);
    }

    public String[] getTriggerNames(SchedulingContext ctxt, String groupName) throws SchedulerException {
        this.validateState();
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        return this.resources.getJobStore().getTriggerNames(ctxt, groupName);
    }

    public JobDetail getJobDetail(SchedulingContext ctxt, String jobName, String jobGroup) throws SchedulerException {
        this.validateState();
        if (jobGroup == null) {
            jobGroup = "DEFAULT";
        }
        return this.resources.getJobStore().retrieveJob(ctxt, jobName, jobGroup);
    }

    public Trigger getTrigger(SchedulingContext ctxt, String triggerName, String triggerGroup) throws SchedulerException {
        this.validateState();
        if (triggerGroup == null) {
            triggerGroup = "DEFAULT";
        }
        return this.resources.getJobStore().retrieveTrigger(ctxt, triggerName, triggerGroup);
    }

    public int getTriggerState(SchedulingContext ctxt, String triggerName, String triggerGroup) throws SchedulerException {
        this.validateState();
        if (triggerGroup == null) {
            triggerGroup = "DEFAULT";
        }
        return this.resources.getJobStore().getTriggerState(ctxt, triggerName, triggerGroup);
    }

    public void addCalendar(SchedulingContext ctxt, String calName, Calendar calendar, boolean replace, boolean updateTriggers) throws SchedulerException {
        this.validateState();
        this.resources.getJobStore().storeCalendar(ctxt, calName, calendar, replace, updateTriggers);
    }

    public boolean deleteCalendar(SchedulingContext ctxt, String calName) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().removeCalendar(ctxt, calName);
    }

    public Calendar getCalendar(SchedulingContext ctxt, String calName) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().retrieveCalendar(ctxt, calName);
    }

    public String[] getCalendarNames(SchedulingContext ctxt) throws SchedulerException {
        this.validateState();
        return this.resources.getJobStore().getCalendarNames(ctxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        HashMap hashMap = this.globalJobListeners;
        synchronized (hashMap) {
            this.globalJobListeners.put(jobListener.getName(), jobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJobListener(JobListener jobListener) {
        if (jobListener.getName() == null || jobListener.getName().length() == 0) {
            throw new IllegalArgumentException("JobListener name cannot be empty.");
        }
        HashMap hashMap = this.jobListeners;
        synchronized (hashMap) {
            this.jobListeners.put(jobListener.getName(), jobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGlobalJobListener(String name) {
        HashMap hashMap = this.globalJobListeners;
        synchronized (hashMap) {
            return this.globalJobListeners.remove(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJobListener(String name) {
        HashMap hashMap = this.jobListeners;
        synchronized (hashMap) {
            return this.jobListeners.remove(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGlobalJobListeners() {
        HashMap hashMap = this.globalJobListeners;
        synchronized (hashMap) {
            return new LinkedList(this.globalJobListeners.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getJobListenerNames() {
        HashMap hashMap = this.jobListeners;
        synchronized (hashMap) {
            return new HashSet(this.jobListeners.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobListener getGlobalJobListener(String name) {
        HashMap hashMap = this.globalJobListeners;
        synchronized (hashMap) {
            return (JobListener)this.globalJobListeners.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobListener getJobListener(String name) {
        HashMap hashMap = this.jobListeners;
        synchronized (hashMap) {
            return (JobListener)this.jobListeners.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalTriggerListener(TriggerListener triggerListener) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        HashMap hashMap = this.globalTriggerListeners;
        synchronized (hashMap) {
            this.globalTriggerListeners.put(triggerListener.getName(), triggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTriggerListener(TriggerListener triggerListener) {
        if (triggerListener.getName() == null || triggerListener.getName().length() == 0) {
            throw new IllegalArgumentException("TriggerListener name cannot be empty.");
        }
        HashMap hashMap = this.triggerListeners;
        synchronized (hashMap) {
            this.triggerListeners.put(triggerListener.getName(), triggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGlobalTriggerListener(String name) {
        HashMap hashMap = this.globalTriggerListeners;
        synchronized (hashMap) {
            return this.globalTriggerListeners.remove(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTriggerListener(String name) {
        HashMap hashMap = this.triggerListeners;
        synchronized (hashMap) {
            return this.triggerListeners.remove(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getGlobalTriggerListeners() {
        HashMap hashMap = this.globalTriggerListeners;
        synchronized (hashMap) {
            return new LinkedList(this.globalTriggerListeners.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTriggerListenerNames() {
        HashMap hashMap = this.triggerListeners;
        synchronized (hashMap) {
            return new HashSet(this.triggerListeners.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerListener getGlobalTriggerListener(String name) {
        HashMap hashMap = this.globalTriggerListeners;
        synchronized (hashMap) {
            return (TriggerListener)this.globalTriggerListeners.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TriggerListener getTriggerListener(String name) {
        HashMap hashMap = this.triggerListeners;
        synchronized (hashMap) {
            return (TriggerListener)this.triggerListeners.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList arrayList = this.schedulerListeners;
        synchronized (arrayList) {
            this.schedulerListeners.add(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSchedulerListener(SchedulerListener schedulerListener) {
        ArrayList arrayList = this.schedulerListeners;
        synchronized (arrayList) {
            return this.schedulerListeners.remove(schedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSchedulerListeners() {
        ArrayList arrayList = this.schedulerListeners;
        synchronized (arrayList) {
            return (List)this.schedulerListeners.clone();
        }
    }

    protected void notifyJobStoreJobComplete(SchedulingContext ctxt, Trigger trigger, JobDetail detail, int instCode) throws JobPersistenceException {
        this.resources.getJobStore().triggeredJobComplete(ctxt, trigger, detail, instCode);
    }

    protected void notifyJobStoreJobVetoed(SchedulingContext ctxt, Trigger trigger, JobDetail detail, int instCode) throws JobPersistenceException {
        this.resources.getJobStore().triggeredJobComplete(ctxt, trigger, detail, instCode);
    }

    protected void notifySchedulerThread(long candidateNewNextFireTime) {
        if (this.isSignalOnSchedulingChange()) {
            this.signaler.signalSchedulingChange(candidateNewNextFireTime);
        }
    }

    private List buildTriggerListenerList(String[] additionalLstnrs) throws SchedulerException {
        List triggerListeners = this.getGlobalTriggerListeners();
        for (int i = 0; i < additionalLstnrs.length; ++i) {
            TriggerListener tl = this.getTriggerListener(additionalLstnrs[i]);
            if (tl == null) {
                throw new SchedulerException("TriggerListener '" + additionalLstnrs[i] + "' not found.", 710);
            }
            triggerListeners.add(tl);
        }
        return triggerListeners;
    }

    private List buildJobListenerList(String[] additionalLstnrs) throws SchedulerException {
        List jobListeners = this.getGlobalJobListeners();
        for (int i = 0; i < additionalLstnrs.length; ++i) {
            JobListener jl = this.getJobListener(additionalLstnrs[i]);
            if (jl == null) {
                throw new SchedulerException("JobListener '" + additionalLstnrs[i] + "' not found.", 610);
            }
            jobListeners.add(jl);
        }
        return jobListeners;
    }

    public boolean notifyTriggerListenersFired(JobExecutionContext jec) throws SchedulerException {
        List triggerListeners = this.buildTriggerListenerList(jec.getTrigger().getTriggerListenerNames());
        boolean vetoedExecution = false;
        for (TriggerListener tl : triggerListeners) {
            try {
                tl.triggerFired(jec.getTrigger(), jec);
                if (!tl.vetoJobExecution(jec.getTrigger(), jec)) continue;
                vetoedExecution = true;
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(700);
                throw se;
            }
        }
        return vetoedExecution;
    }

    public void notifyTriggerListenersMisfired(Trigger trigger) throws SchedulerException {
        List triggerListeners = this.buildTriggerListenerList(trigger.getTriggerListenerNames());
        for (TriggerListener tl : triggerListeners) {
            try {
                tl.triggerMisfired(trigger);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(700);
                throw se;
            }
        }
    }

    public void notifyTriggerListenersComplete(JobExecutionContext jec, int instCode) throws SchedulerException {
        List triggerListeners = this.buildTriggerListenerList(jec.getTrigger().getTriggerListenerNames());
        for (TriggerListener tl : triggerListeners) {
            try {
                tl.triggerComplete(jec.getTrigger(), jec, instCode);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("TriggerListener '" + tl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(700);
                throw se;
            }
        }
    }

    public void notifyJobListenersToBeExecuted(JobExecutionContext jec) throws SchedulerException {
        List jobListeners = this.buildJobListenerList(jec.getJobDetail().getJobListenerNames());
        for (JobListener jl : jobListeners) {
            try {
                jl.jobToBeExecuted(jec);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(600);
                throw se;
            }
        }
    }

    public void notifyJobListenersWasVetoed(JobExecutionContext jec) throws SchedulerException {
        List jobListeners = this.buildJobListenerList(jec.getJobDetail().getJobListenerNames());
        for (JobListener jl : jobListeners) {
            try {
                jl.jobExecutionVetoed(jec);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(600);
                throw se;
            }
        }
    }

    public void notifyJobListenersWasExecuted(JobExecutionContext jec, JobExecutionException je) throws SchedulerException {
        List jobListeners = this.buildJobListenerList(jec.getJobDetail().getJobListenerNames());
        for (JobListener jl : jobListeners) {
            try {
                jl.jobWasExecuted(jec, je);
            }
            catch (Exception e) {
                SchedulerException se = new SchedulerException("JobListener '" + jl.getName() + "' threw exception: " + e.getMessage(), e);
                se.setErrorCode(600);
                throw se;
            }
        }
    }

    public void notifySchedulerListenersError(String msg, SchedulerException se) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerError(msg, se);
            }
            catch (Exception e) {
                this.getLog().error((Object)"Error while notifying SchedulerListener of error: ", (Throwable)e);
                this.getLog().error((Object)("  Original error (for notification) was: " + msg), (Throwable)se);
            }
        }
    }

    public void notifySchedulerListenersSchduled(Trigger trigger) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobScheduled(trigger);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of scheduled job.  Triger=" + trigger.getFullName()), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersUnschduled(String triggerName, String triggerGroup) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobUnscheduled(triggerName, triggerGroup);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of unscheduled job.  Triger=" + triggerGroup + "." + triggerName), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersFinalized(Trigger trigger) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.triggerFinalized(trigger);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of finalized trigger.  Triger=" + trigger.getFullName()), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersPausedTrigger(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.triggersPaused(name, group);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of paused trigger/group.  Triger=" + group + "." + name), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersResumedTrigger(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.triggersResumed(name, group);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of resumed trigger/group.  Triger=" + group + "." + name), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersPausedJob(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobsPaused(name, group);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of paused job/group.  Job=" + group + "." + name), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersResumedJob(String name, String group) {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.jobsResumed(name, group);
            }
            catch (Exception e) {
                this.getLog().error((Object)("Error while notifying SchedulerListener of resumed job/group.  Job=" + group + "." + name), (Throwable)e);
            }
        }
    }

    public void notifySchedulerListenersShutdown() {
        List schedListeners = this.getSchedulerListeners();
        for (SchedulerListener sl : schedListeners) {
            try {
                sl.schedulerShutdown();
            }
            catch (Exception e) {
                this.getLog().error((Object)"Error while notifying SchedulerListener of shutdown.", (Throwable)e);
            }
        }
    }

    public void setJobFactory(JobFactory factory) throws SchedulerException {
        if (factory == null) {
            throw new IllegalArgumentException("JobFactory cannot be set to null!");
        }
        this.getLog().info((Object)("JobFactory set to: " + factory));
        this.jobFactory = factory;
    }

    public JobFactory getJobFactory() {
        return this.jobFactory;
    }

    public boolean interrupt(SchedulingContext ctxt, String jobName, String groupName) throws UnableToInterruptJobException {
        if (groupName == null) {
            groupName = "DEFAULT";
        }
        List jobs = this.getCurrentlyExecutingJobs();
        Iterator it = jobs.iterator();
        JobExecutionContext jec = null;
        JobDetail jobDetail = null;
        Job job = null;
        boolean interrupted = false;
        while (it.hasNext()) {
            jec = (JobExecutionContext)it.next();
            jobDetail = jec.getJobDetail();
            if (!jobName.equals(jobDetail.getName()) || !groupName.equals(jobDetail.getGroup())) continue;
            job = jec.getJobInstance();
            if (job instanceof InterruptableJob) {
                ((InterruptableJob)job).interrupt();
                interrupted = true;
                continue;
            }
            throw new UnableToInterruptJobException("Job '" + jobName + "' of group '" + groupName + "' can not be interrupted, since it does not implement " + InterruptableJob.class.getName());
        }
        return interrupted;
    }

    private void shutdownPlugins() {
        for (SchedulerPlugin plugin : this.resources.getSchedulerPlugins()) {
            plugin.shutdown();
        }
    }

    private void startPlugins() {
        for (SchedulerPlugin plugin : this.resources.getSchedulerPlugins()) {
            plugin.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        InputStream is;
        block8: {
            VERSION_MAJOR = "UNKNOWN";
            VERSION_MINOR = "UNKNOWN";
            VERSION_ITERATION = "UNKNOWN";
            Properties props = new Properties();
            is = null;
            is = QuartzScheduler.class.getResourceAsStream("/build.properties");
            if (is == null) break block8;
            props.load(is);
            String version = props.getProperty("version");
            if (version == null) break block8;
            String[] versionComponents = version.split("\\.");
            VERSION_MAJOR = versionComponents[0];
            VERSION_MINOR = versionComponents[1];
            VERSION_ITERATION = versionComponents[2];
        }
        Object var5_5 = null;
        if (is == null) return;
        try {
            is.close();
            return;
        }
        catch (Exception ignore) {}
        return;
        {
            catch (IOException e) {
                LogFactory.getLog(QuartzScheduler.class).error((Object)"Error loading version info from build.properties.", (Throwable)e);
                Object var5_6 = null;
                if (is == null) return;
                try {
                    is.close();
                    return;
                }
                catch (Exception ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

