/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyXRange;
import org.python.core.buffer.SimpleBuffer;
import org.python.util.PythonInterpreter;

public class BaseBytesTest
extends TestCase {
    public static final int SMALL = 7;
    public static final int MEDIUM = 25;
    public static final int LARGE = 10000;
    public static final int HUGE = 100000;
    PythonInterpreter interp;
    Random random;

    public BaseBytesTest(String name) {
        super(name);
    }

    public static char toChar(int b) {
        return Character.toChars(0xFF & b)[0];
    }

    public static int[] toInts(String s) {
        int n = s.length();
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            int c = s.codePointAt(i);
            r[i] = 0xFF & c;
        }
        return r;
    }

    public static int[] randomInts(Random random, int n) {
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = random.nextInt(256);
        }
        return r;
    }

    public static int[] randomInts(Random random, int n, int lo, int hi) {
        int[] r = new int[n];
        int m = hi + 1 - lo;
        for (int i = 0; i < n; ++i) {
            r[i] = lo + random.nextInt(m);
        }
        return r;
    }

    static void checkInts(int[] expected, int first, BaseBytes result, int start, int len) {
        if (len > 0) {
            int end = first + len;
            if (end > expected.length) {
                end = expected.length;
            }
            int i = first;
            int j = start;
            while (i < end) {
                BaseBytesTest.assertEquals((String)"element value", (int)expected[i], (int)result.intAt(j));
                ++i;
                ++j;
            }
        }
    }

    static void checkInts(int[] expected, BaseBytes result) {
        BaseBytesTest.assertEquals((String)"size", (int)expected.length, (int)result.size());
        for (int i = 0; i < expected.length; ++i) {
            BaseBytesTest.assertEquals((String)"element value", (int)expected[i], (int)result.intAt(i));
        }
    }

    static void checkInts(List<PyInteger> expected, BaseBytes result) {
        BaseBytesTest.assertEquals((String)"size", (int)expected.size(), (int)result.size());
        for (int i = 0; i < result.size; ++i) {
            PyInteger res = result.pyget(i);
            PyInteger exp = expected.get(i);
            BaseBytesTest.assertEquals((String)"element value", (Object)exp, (Object)res);
        }
    }

    static void checkInts(List<PyInteger> expected, PyObject result) {
        BaseBytesTest.checkInts(expected, (BaseBytes)result);
    }

    public static Iterable<PyObject> iterableBytes(int[] source) {
        ArrayList<PyObject> list = new ArrayList<PyObject>(source.length);
        int choose = 0;
        block4: for (int b : source) {
            switch (choose++) {
                case 0: {
                    PyInteger i = new PyInteger(b);
                    list.add(i);
                    continue block4;
                }
                case 1: {
                    PyLong l = new PyLong(b);
                    list.add(l);
                    continue block4;
                }
                default: {
                    PyString s = new PyString(BaseBytesTest.toChar(b));
                    list.add(s);
                    choose = 0;
                }
            }
        }
        return list;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.random = new Random(20120310L);
    }

    public void testSize() {
        int[] aRef = BaseBytesTest.toInts("Chaque coquillage incrust\u00e9");
        BaseBytes a = this.getInstance(aRef);
        System.out.println(this.toString(a));
        BaseBytesTest.assertEquals((int)aRef.length, (int)a.size());
        for (int n : new int[]{0, 1, 2, 7, 8, 9, 25, 10000, 100000}) {
            a = this.getInstance(n);
            BaseBytesTest.assertEquals((String)"size()", (int)n, (int)a.size());
            BaseBytesTest.assertEquals((String)"__len__()", (int)n, (int)a.__len__());
        }
    }

    public void testInit_intArray() {
        int[] aRef = BaseBytesTest.toInts("Dans la grotte o\u00f9 nous nous aim\u00e2mes");
        BaseBytes a = this.getInstance(aRef);
        BaseBytes b = this.getInstance(a);
        System.out.println(this.toString(b));
        BaseBytesTest.assertEquals((int)a.size(), (int)b.size());
        for (int i = 0; i < a.size(); ++i) {
            BaseBytesTest.assertEquals((int)a.intAt(i), (int)b.intAt(i));
        }
    }

    public void testInit_Iterable() {
        int[] aRef = BaseBytesTest.toInts("A sa particularit\u00e9.");
        Iterable<PyObject> ia = BaseBytesTest.iterableBytes(aRef);
        BaseBytes a = this.getInstance(ia);
        System.out.println(this.toString(a));
        BaseBytesTest.assertEquals((int)aRef.length, (int)a.size());
        BaseBytesTest.checkInts(aRef, a);
        BaseBytes b = this.getInstance(BaseBytesTest.iterableBytes(new int[0]));
        BaseBytesTest.assertEquals((int)0, (int)b.size());
        int[] cRef = BaseBytesTest.toInts(":-)");
        BaseBytes c = this.getInstance(BaseBytesTest.iterableBytes(cRef));
        BaseBytesTest.assertEquals((int)cRef.length, (int)c.size());
        BaseBytesTest.checkInts(cRef, c);
    }

    public void testInit_PyObject() {
        PyObject[] brantub = new PyObject[]{null, new PyInteger(5), new PyString("\u00a0\u00a1\u00a2\u00a3\u00a4"), this.getInstance(new int[]{180, 190, 200}), new PyXRange(1, 301, 50)};
        int[][] prize = new int[][]{new int[0], {0, 0, 0, 0, 0}, {160, 161, 162, 163, 164}, {180, 190, 200}, {1, 51, 101, 151, 201, 251}};
        for (int dip = 0; dip < brantub.length; ++dip) {
            int[] aRef = prize[dip];
            BaseBytes a = this.getInstance(brantub[dip]);
            BaseBytesTest.assertEquals((int)aRef.length, (int)a.size());
            BaseBytesTest.checkInts(aRef, a);
        }
    }

    public void testInit_Exceptions() {
        this.interp = new PythonInterpreter();
        PyObject[] brantub = new PyObject[]{Py.None, new PyInteger(-1), new PyLong(0x80000000L), new PyXRange(3, -2, -1), new PyXRange(250, 257)};
        PyObject[] boobyPrize = new PyObject[]{Py.TypeError, Py.ValueError, Py.OverflowError, Py.ValueError, Py.ValueError};
        for (int dip = 0; dip < brantub.length; ++dip) {
            PyObject aRef = boobyPrize[dip];
            try {
                BaseBytes a = this.getInstance(brantub[dip]);
                System.out.println(this.toString(a));
                BaseBytesTest.fail((String)("Exception not thrown for " + brantub[dip]));
                continue;
            }
            catch (PyException pye) {
                PyObject a = pye.type;
                BaseBytesTest.assertEquals((Object)aRef, (Object)a);
            }
        }
    }

    public void testPyget() {
        this.interp = new PythonInterpreter();
        int[] aRef = BaseBytesTest.randomInts(this.random, 25);
        BaseBytes a = this.getInstance(aRef);
        for (int i = 0; i < 25; ++i) {
            PyInteger r = a.pyget(i);
            BaseBytesTest.assertEquals((int)aRef[i], (int)r.asInt());
        }
        for (int i : new int[]{-1, -100, 25, 26}) {
            try {
                PyInteger r = a.pyget(i);
                BaseBytesTest.fail((String)("Exception not thrown for pyget(" + i + ") =" + r));
            }
            catch (PyException pye) {
                BaseBytesTest.assertEquals((Object)Py.IndexError, (Object)pye.type);
            }
        }
    }

    public void testGetslice() {
        BaseBytes b;
        int stop;
        int step;
        String ver = "L'un a la pourpre de nos \u00e2mes";
        int L = ver.length();
        int[] aRef = BaseBytesTest.toInts(ver);
        BaseBytes a = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L);
        int[] posStart = new int[]{0, 1, 18, L - 8, L - 1};
        int[] negStart = new int[]{0, 3, 16, L - 10, L - 1};
        for (step = 1; step < 4; ++step) {
            int[] arr$ = posStart;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int start;
                for (stop = start = arr$[i$]; stop <= L; ++stop) {
                    bList.clear();
                    for (int i = start; i < stop; i += step) {
                        bList.add(new PyInteger(aRef[i]));
                    }
                    b = a.getslice(start, stop, step);
                    BaseBytesTest.checkInts(bList, b);
                }
            }
        }
        for (step = -1; step > -4; --step) {
            for (int start : negStart) {
                for (stop = -1; stop <= start; ++stop) {
                    bList.clear();
                    for (int i = start; i > stop; i += step) {
                        bList.add(new PyInteger(aRef[i]));
                    }
                    b = a.getslice(start, stop, step);
                    BaseBytesTest.checkInts(bList, b);
                }
            }
        }
    }

    public void testRepeatInt() {
        String spam = "Spam, ";
        int maxCount = 10;
        int L = spam.length();
        int[] aRef = BaseBytesTest.toInts(spam);
        BaseBytes a = this.getInstance(aRef);
        for (int count2 = 0; count2 <= 10; ++count2) {
            int[] bRef = new int[count2 * L];
            for (int i = 0; i < count2; ++i) {
                for (int j = 0; j < L; ++j) {
                    bRef[i * L + j] = aRef[j];
                }
            }
            BaseBytes b = a.repeat(count2);
            BaseBytesTest.checkInts(bRef, b);
        }
    }

    public void testPyset() {
        PyObject bRef = Py.TypeError;
        int[] aRef = BaseBytesTest.toInts("This immutable type seems to allow modifications.");
        BaseBytes a = this.getInstance(aRef);
        int start = a.size() / 2;
        PyInteger x = new PyInteger(120);
        try {
            a.pyset(start, x);
            System.out.println(this.toString(a));
            BaseBytesTest.fail((String)String.format("Exception not thrown for pyset(%d,%s)", start, x));
        }
        catch (PyException pye) {
            PyObject b = pye.type;
            BaseBytesTest.assertEquals((Object)bRef, (Object)b);
        }
    }

    public void testSetslice3() {
        PyObject bRef = Py.TypeError;
        int[] aRef = BaseBytesTest.toInts("This immutable type seems to allow modifications.");
        BaseBytes a = this.getInstance(aRef);
        int start = a.size() / 4;
        int stop = (3 * a.size() + 3) / 4;
        int step = 3;
        MyBytes x = new MyBytes(BaseBytesTest.randomInts(this.random, 7));
        try {
            a.setslice(start, stop, step, x);
            System.out.println(this.toString(a));
            BaseBytesTest.fail((String)String.format("Exception not thrown for setslice(%d,%d,%d,%s)", start, stop, step, x));
        }
        catch (PyException pye) {
            PyObject b = pye.type;
            BaseBytesTest.assertEquals((Object)bRef, (Object)b);
        }
    }

    public BaseBytes getInstance(PyType type) {
        return new MyBytes(type);
    }

    public BaseBytes getInstance() {
        return new MyBytes();
    }

    public BaseBytes getInstance(int size) {
        return new MyBytes(size);
    }

    public BaseBytes getInstance(int[] value) {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(BaseBytes value) throws PyException {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(BufferProtocol value) throws PyException {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(Iterable<? extends PyObject> value) throws PyException {
        return new MyBytes(value);
    }

    public BaseBytes getInstance(PyString arg, PyObject encoding, PyObject errors) throws PyException {
        return new MyBytes(arg, encoding, errors);
    }

    public BaseBytes getInstance(PyString arg, String encoding, String errors) throws PyException {
        return new MyBytes(arg, encoding, errors);
    }

    public BaseBytes getInstance(PyObject arg) throws PyException {
        return new MyBytes(arg);
    }

    protected String toString(BaseBytes b) {
        Image i = new Image();
        i.showSummary(b);
        if (b.storage.length >= 0 && b.storage.length <= 70) {
            i.padTo(15);
            i.showContent(b);
        }
        return i.toString();
    }

    private static Object getItem(int n, Object buf, int[] strides, int[] suboffsets, int[] indices) {
        for (int i = 0; i < n; ++i) {
            Object[] p = (Object[])buf;
            buf = p[indices[i] * strides[i] + suboffsets[i]];
        }
        return buf;
    }

    private static byte getByte(int ndim, Object buf, int[] strides, int[] suboffsets, int[] indices) {
        int n = ndim - 1;
        byte[] b = (byte[])BaseBytesTest.getItem(n, buf, strides, suboffsets, indices);
        return b[indices[n] + suboffsets[n]];
    }

    protected static class Image {
        private StringBuilder image = new StringBuilder(100);

        protected Image() {
        }

        private void repeat(char c, int n) {
            for (int i = 0; i < n; ++i) {
                this.image.append(i == 0 ? (char)'|' : ' ').append(c);
            }
        }

        private void append(byte[] s, int pos, int n) {
            if (pos < 0 || pos + n > s.length) {
                return;
            }
            for (int i = 0; i < n; ++i) {
                int c = 0xFF & s[pos + i];
                if (c == 0) {
                    c = 46;
                } else if (Character.isISOControl(c)) {
                    c = 35;
                }
                this.image.append(i == 0 ? (char)'|' : ' ').append(BaseBytesTest.toChar(c));
            }
        }

        public void padTo(int n) {
            while (n > this.image.length()) {
                this.image.append(' ');
            }
        }

        public String showSummary(BaseBytes b) {
            this.image.append(b.offset);
            this.image.append(" [ ").append(b.size).append(" ] ");
            this.image.append(b.storage.length - (b.offset + b.size));
            return this.image.toString();
        }

        public String showExtent(BaseBytes b) {
            this.repeat('-', b.offset);
            this.repeat('x', b.size);
            int tail = b.storage.length - (b.offset + b.size);
            this.repeat('-', tail);
            this.image.append('|');
            return this.image.toString();
        }

        public String showContent(BaseBytes b) {
            this.append(b.storage, 0, b.offset);
            this.append(b.storage, b.offset, b.size);
            int tail = b.storage.length - (b.offset + b.size);
            this.append(b.storage, b.offset + b.size, tail);
            this.image.append('|');
            return this.image.toString();
        }

        public String toString() {
            return this.image.toString();
        }
    }

    public static class BufferedObject
    extends PyObject
    implements BufferProtocol {
        public static final PyType TYPE = PyType.fromClass(BufferedObject.class);
        private byte[] store;

        BufferedObject(int[] value) {
            super(TYPE);
            int n = value.length;
            this.store = new byte[n];
            for (int i = 0; i < n; ++i) {
                this.store[i] = (byte)value[i];
            }
        }

        @Override
        public PyBuffer getBuffer(int flags) {
            return new SimpleBuffer(flags, this.store);
        }
    }

    public static class MyBytes
    extends BaseBytes {
        public static final PyType TYPE = PyType.fromClass(MyBytes.class);

        public MyBytes(PyType type) {
            super(type);
        }

        public MyBytes() {
            super(TYPE);
        }

        public MyBytes(int size) {
            super(TYPE, size);
        }

        MyBytes(int[] value) {
            super(TYPE, value);
        }

        public MyBytes(BaseBytes value) {
            super(TYPE);
            this.init(value);
        }

        public MyBytes(BufferProtocol value) {
            super(TYPE);
            this.init(value.getBuffer(0));
        }

        public MyBytes(Iterable<? extends PyObject> value) {
            super(TYPE);
            this.init(value);
        }

        public MyBytes(PyString arg, PyObject encoding, PyObject errors) {
            super(TYPE);
            this.init(arg, encoding, errors);
        }

        public MyBytes(PyString arg, String encoding, String errors) {
            super(TYPE);
            this.init(arg, encoding, errors);
        }

        public MyBytes(PyObject arg) throws PyException {
            super(TYPE);
            this.init(arg);
        }

        protected MyBytes(int start, int stop, BaseBytes source) {
            super(TYPE);
            this.setStorage(source.storage, stop - start, start);
        }

        @Override
        protected MyBytes repeat(int count2) {
            MyBytes ret = new MyBytes();
            ret.setStorage(this.repeatImpl(count2));
            return ret;
        }

        @Override
        protected MyBytes getslice(int start, int stop, int step) {
            MyBytes r;
            if (step == 1) {
                r = new MyBytes();
                if (stop > start) {
                    r.setStorage(this.storage, stop - start, start + this.offset);
                }
            } else {
                r = new MyBytes(MyBytes.sliceLength(start, stop, step));
                int iomax = r.size + r.offset;
                int jo = start;
                for (int io = r.offset; io < iomax; ++io) {
                    r.storage[io] = this.storage[jo];
                    jo += step;
                }
            }
            return r;
        }

        @Override
        public int __len__() {
            return this.size;
        }

        protected MyBytes(BaseBytes.Builder builder) {
            super(TYPE);
            this.setStorage(builder.getStorage(), builder.getSize());
        }

        @Override
        protected BaseBytes.Builder getBuilder(int capacity) {
            return new BaseBytes.Builder(capacity){

                @Override
                MyBytes getResult() {
                    return new MyBytes(this);
                }
            };
        }
    }
}

