/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal;

import java.util.concurrent.atomic.AtomicInteger;
import org.python.netty.util.internal.FastThreadLocalThread;

public class FastThreadLocal<V>
extends ThreadLocal<V> {
    static final Object EMPTY = new Object();
    private static final AtomicInteger NEXT_INDEX = new AtomicInteger(0);
    private final ThreadLocal<V> fallback = new ThreadLocal<V>(){

        @Override
        protected V initialValue() {
            return FastThreadLocal.this.initialValue();
        }
    };
    private final int index = NEXT_INDEX.getAndIncrement();

    public FastThreadLocal() {
        if (this.index < 0) {
            NEXT_INDEX.decrementAndGet();
            throw new IllegalStateException("Maximal number (2147483647) of FastThreadLocal exceeded");
        }
    }

    @Override
    public void set(V value) {
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof FastThreadLocalThread)) {
            this.fallback.set(value);
            return;
        }
        FastThreadLocalThread fastThread = (FastThreadLocalThread)thread2;
        Object[] lookup = fastThread.lookup;
        if (this.index >= lookup.length) {
            lookup = fastThread.expandArray(this.index);
        }
        lookup[this.index] = value;
    }

    @Override
    public void remove() {
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof FastThreadLocalThread)) {
            this.fallback.remove();
            return;
        }
        Object[] lookup = ((FastThreadLocalThread)thread2).lookup;
        if (this.index >= lookup.length) {
            return;
        }
        lookup[this.index] = EMPTY;
    }

    @Override
    public V get() {
        Object v;
        Thread thread2 = Thread.currentThread();
        if (!(thread2 instanceof FastThreadLocalThread)) {
            return this.fallback.get();
        }
        FastThreadLocalThread fastThread = (FastThreadLocalThread)thread2;
        Object[] lookup = fastThread.lookup;
        if (this.index >= lookup.length) {
            v = this.initialValue();
            lookup = fastThread.expandArray(this.index);
            lookup[this.index] = v;
        } else {
            v = lookup[this.index];
            if (v == EMPTY) {
                v = this.initialValue();
                lookup[this.index] = v;
            }
        }
        return (V)v;
    }
}

