/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider.jffi;

import com.kenai.jffi.Platform;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.Buffer;
import jnr.ffi.Address;
import jnr.ffi.NativeLong;
import jnr.ffi.NativeType;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Delegate;
import jnr.ffi.provider.ParameterFlags;
import jnr.ffi.provider.jffi.AsmRuntime;
import jnr.ffi.provider.jffi.CodegenUtils;
import jnr.ffi.provider.jffi.LocalVariable;
import jnr.ffi.provider.jffi.NativeRuntime;
import jnr.ffi.provider.jffi.NumberUtil;
import jnr.ffi.provider.jffi.ParameterType;
import jnr.ffi.provider.jffi.SigType;
import jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import org.python.objectweb.asm.ClassVisitor;
import org.python.objectweb.asm.Label;
import org.python.objectweb.asm.MethodVisitor;

final class AsmUtil {
    private AsmUtil() {
    }

    public static final MethodVisitor newTraceMethodVisitor(MethodVisitor mv) {
        try {
            Class<MethodVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceMethodVisitor").asSubclass(MethodVisitor.class);
            Constructor<MethodVisitor> c = tmvClass.getDeclaredConstructor(MethodVisitor.class);
            return c.newInstance(mv);
        }
        catch (Throwable t) {
            return mv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, OutputStream out) {
        return AsmUtil.newTraceClassVisitor(cv, new PrintWriter(out, true));
    }

    public static final ClassVisitor newTraceClassVisitor(ClassVisitor cv, PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class, PrintWriter.class);
            return c.newInstance(cv, out);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final ClassVisitor newTraceClassVisitor(PrintWriter out) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.TraceClassVisitor").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(PrintWriter.class);
            return c.newInstance(out);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static final ClassVisitor newCheckClassAdapter(ClassVisitor cv) {
        try {
            Class<ClassVisitor> tmvClass = Class.forName("org.python.objectweb.asm.util.CheckClassAdapter").asSubclass(ClassVisitor.class);
            Constructor<ClassVisitor> c = tmvClass.getDeclaredConstructor(ClassVisitor.class);
            return c.newInstance(cv);
        }
        catch (Throwable t) {
            return cv;
        }
    }

    public static final Class unboxedReturnType(Class type) {
        if (Pointer.class.isAssignableFrom(type) || Struct.class.isAssignableFrom(type) || String.class.isAssignableFrom(type)) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedParameterType(Class type) {
        if (Buffer.class.isAssignableFrom(type)) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return AsmUtil.unboxedType(type);
    }

    public static final Class unboxedType(Class boxedType) {
        if (boxedType == Byte.class) {
            return Byte.TYPE;
        }
        if (boxedType == Short.class) {
            return Short.TYPE;
        }
        if (boxedType == Integer.class) {
            return Integer.TYPE;
        }
        if (boxedType == Long.class) {
            return Long.TYPE;
        }
        if (boxedType == Float.class) {
            return Float.TYPE;
        }
        if (boxedType == Double.class) {
            return Double.TYPE;
        }
        if (boxedType == Boolean.class) {
            return Boolean.TYPE;
        }
        if (boxedType == NativeLong.class) {
            return Platform.getPlatform().longSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (Pointer.class.isAssignableFrom(boxedType) || Struct.class.isAssignableFrom(boxedType)) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (Address.class == boxedType) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        if (String.class == boxedType) {
            return Platform.getPlatform().addressSize() == 32 ? Integer.TYPE : Long.TYPE;
        }
        return boxedType;
    }

    public static final Class boxedType(Class type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        return type;
    }

    static final void emitReturnOp(SkinnyMethodAdapter mv, Class returnType) {
        if (!returnType.isPrimitive()) {
            mv.areturn();
        } else if (Long.TYPE == returnType) {
            mv.lreturn();
        } else if (Float.TYPE == returnType) {
            mv.freturn();
        } else if (Double.TYPE == returnType) {
            mv.dreturn();
        } else if (Void.TYPE == returnType) {
            mv.voidreturn();
        } else {
            mv.ireturn();
        }
    }

    static final int calculateLocalVariableSpace(Class type) {
        return Long.TYPE == type || Double.TYPE == type ? 2 : 1;
    }

    static int calculateLocalVariableSpace(SigType type) {
        return AsmUtil.calculateLocalVariableSpace(type.getDeclaredType());
    }

    static final int calculateLocalVariableSpace(Class ... types) {
        int size = 0;
        for (int i = 0; i < types.length; ++i) {
            size += AsmUtil.calculateLocalVariableSpace(types[i]);
        }
        return size;
    }

    static int calculateLocalVariableSpace(SigType ... types) {
        int size = 0;
        for (SigType type : types) {
            size += AsmUtil.calculateLocalVariableSpace(type);
        }
        return size;
    }

    private static final void unboxPointerOrStruct(SkinnyMethodAdapter mv, Class type, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == nativeType ? "longValue" : "intValue", CodegenUtils.sig(nativeType, type));
    }

    static final void unboxPointer(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxPointerOrStruct(mv, Pointer.class, nativeType);
    }

    static final void unboxEnum(SkinnyMethodAdapter mv, Class nativeType) {
        mv.invokestatic(CodegenUtils.p(AsmRuntime.class), Long.TYPE == nativeType ? "longValue" : "intValue", CodegenUtils.sig(nativeType, Enum.class));
    }

    static final void unboxBoolean(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        mv.invokevirtual(CodegenUtils.p(boxedType), "booleanValue", "()Z");
        NumberUtil.widen(mv, Boolean.TYPE, nativeType);
    }

    static final void unboxBoolean(SkinnyMethodAdapter mv, Class nativeType) {
        AsmUtil.unboxBoolean(mv, Boolean.class, nativeType);
    }

    static void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class unboxedType, NativeType nativeType) {
        if (Number.class.isAssignableFrom(boxedType)) {
            switch (nativeType) {
                case SCHAR: 
                case UCHAR: {
                    mv.invokevirtual(CodegenUtils.p(boxedType), "byteValue", "()B");
                    NumberUtil.convertPrimitive(mv, Byte.TYPE, unboxedType, nativeType);
                    break;
                }
                case SSHORT: 
                case USHORT: {
                    mv.invokevirtual(CodegenUtils.p(boxedType), "shortValue", "()S");
                    NumberUtil.convertPrimitive(mv, Short.TYPE, unboxedType, nativeType);
                    break;
                }
                case SINT: 
                case UINT: 
                case SLONG: 
                case ULONG: 
                case ADDRESS: {
                    if (NumberUtil.sizeof(nativeType) == 4) {
                        mv.invokevirtual(CodegenUtils.p(boxedType), "intValue", "()I");
                        NumberUtil.convertPrimitive(mv, Integer.TYPE, unboxedType, nativeType);
                        break;
                    }
                    mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                    NumberUtil.convertPrimitive(mv, Long.TYPE, unboxedType, nativeType);
                    break;
                }
                case SLONGLONG: 
                case ULONGLONG: {
                    mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                    NumberUtil.narrow(mv, Long.TYPE, unboxedType);
                    break;
                }
                case FLOAT: {
                    mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
                    break;
                }
                case DOUBLE: {
                    mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
                }
            }
        } else if (Boolean.class.isAssignableFrom(boxedType)) {
            AsmUtil.unboxBoolean(mv, unboxedType);
        } else {
            throw new IllegalArgumentException("unsupported boxed type: " + boxedType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static final void unboxNumber(SkinnyMethodAdapter mv, Class boxedType, Class nativeType) {
        if (Number.class.isAssignableFrom(boxedType)) {
            if (Byte.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "byteValue", "()B");
                return;
            } else if (Short.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "shortValue", "()S");
                return;
            } else if (Integer.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "intValue", "()I");
                return;
            } else if (Long.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "longValue", "()J");
                return;
            } else if (Float.TYPE == nativeType) {
                mv.invokevirtual(CodegenUtils.p(boxedType), "floatValue", "()F");
                return;
            } else {
                if (Double.TYPE != nativeType) throw new IllegalArgumentException("unsupported Number subclass: " + boxedType);
                mv.invokevirtual(CodegenUtils.p(boxedType), "doubleValue", "()D");
            }
            return;
        } else {
            if (!Boolean.class.isAssignableFrom(boxedType)) throw new IllegalArgumentException("unsupported boxed type: " + boxedType);
            AsmUtil.unboxBoolean(mv, nativeType);
        }
    }

    static final void boxValue(SkinnyMethodAdapter mv, Class boxedType, Class unboxedType) {
        if (boxedType == unboxedType || boxedType.isPrimitive()) {
            return;
        }
        if (Boolean.class.isAssignableFrom(boxedType)) {
            NumberUtil.narrow(mv, unboxedType, Boolean.TYPE);
            mv.invokestatic(Boolean.class, "valueOf", Boolean.class, Boolean.TYPE);
        } else if (Pointer.class.isAssignableFrom(boxedType)) {
            mv.invokestatic(AsmRuntime.class, "pointerValue", Pointer.class, unboxedType);
        } else if (Address.class == boxedType || NativeLong.class.isAssignableFrom(boxedType)) {
            mv.invokestatic(boxedType, "valueOf", boxedType, unboxedType);
        } else if (Struct.class.isAssignableFrom(boxedType)) {
            AsmUtil.boxStruct(mv, boxedType, unboxedType);
        } else if (Number.class.isAssignableFrom(boxedType) && AsmUtil.boxedType(unboxedType) == boxedType) {
            mv.invokestatic(boxedType, "valueOf", boxedType, unboxedType);
        } else if (String.class == boxedType) {
            mv.invokestatic(AsmRuntime.class, "stringValue", String.class, unboxedType);
        } else {
            throw new IllegalArgumentException("cannot box value of type " + unboxedType + " to " + boxedType);
        }
    }

    static final void boxStruct(SkinnyMethodAdapter mv, Class structClass, Class nativeType) {
        Label nonnull = new Label();
        Label end = new Label();
        if (Long.TYPE == nativeType) {
            mv.dup2();
            mv.lconst_0();
            mv.lcmp();
            mv.ifne(nonnull);
            mv.pop2();
        } else {
            mv.dup();
            mv.ifne(nonnull);
            mv.pop();
        }
        mv.aconst_null();
        mv.go_to(end);
        mv.label(nonnull);
        mv.newobj(CodegenUtils.p(structClass));
        mv.dup();
        try {
            Constructor<Struct> constructor = structClass.asSubclass(Struct.class).getConstructor(Runtime.class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("struct subclass " + structClass.getName() + " has no constructor that takes a " + Runtime.class.getName(), ex);
        }
        mv.invokestatic(CodegenUtils.p(NativeRuntime.class), "getInstance", CodegenUtils.sig(NativeRuntime.class, new Class[0]));
        mv.invokespecial(structClass, "<init>", Void.TYPE, Runtime.class);
        if (Long.TYPE == nativeType) {
            mv.dup_x2();
        } else {
            mv.dup_x1();
        }
        mv.invokestatic(AsmRuntime.class, "useMemory", Void.TYPE, nativeType, Struct.class);
        mv.label(end);
    }

    static boolean isDelegate(Class klass) {
        for (Method m : klass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class)) continue;
            return true;
        }
        return false;
    }

    static boolean isDelegate(SigType type) {
        return AsmUtil.isDelegate(type.getDeclaredType());
    }

    static final int getParameterFlags(Annotation[] annotations) {
        return ParameterFlags.parse(annotations);
    }

    static final int getNativeArrayFlags(int flags) {
        int nflags = 0;
        nflags |= ParameterFlags.isIn(flags) ? 1 : 0;
        nflags |= ParameterFlags.isOut(flags) ? 2 : 0;
        return nflags |= ParameterFlags.isNulTerminate(flags) || ParameterFlags.isIn(flags) ? 4 : 0;
    }

    static final int getNativeArrayFlags(Annotation[] annotations) {
        return AsmUtil.getNativeArrayFlags(AsmUtil.getParameterFlags(annotations));
    }

    static Class getNativeClass(NativeType nativeType) {
        switch (nativeType) {
            case SCHAR: 
            case UCHAR: {
                return Byte.TYPE;
            }
            case SSHORT: 
            case USHORT: {
                return Short.TYPE;
            }
            case SINT: 
            case UINT: {
                return Integer.TYPE;
            }
            case SLONG: 
            case ULONG: {
                return NumberUtil.sizeof(nativeType) == 4 ? Integer.TYPE : Long.TYPE;
            }
            case SLONGLONG: 
            case ULONGLONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case ADDRESS: {
                return NumberUtil.sizeof(nativeType) == 4 ? Integer.TYPE : Long.TYPE;
            }
            case VOID: {
                return Void.TYPE;
            }
        }
        throw new IllegalArgumentException("unsupported native type: " + (Object)((Object)nativeType));
    }

    static LocalVariable[] getParameterVariables(ParameterType[] parameterTypes) {
        LocalVariable[] lvars = new LocalVariable[parameterTypes.length];
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            lvars[i] = new LocalVariable(parameterTypes[i].getDeclaredType(), lvar);
            lvar += AsmUtil.calculateLocalVariableSpace((SigType)parameterTypes[i]);
        }
        return lvars;
    }

    static LocalVariable[] getParameterVariables(Class[] parameterTypes) {
        LocalVariable[] lvars = new LocalVariable[parameterTypes.length];
        int idx = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            lvars[i] = new LocalVariable(parameterTypes[i], idx);
            idx += AsmUtil.calculateLocalVariableSpace(parameterTypes[i]);
        }
        return lvars;
    }

    static void load(SkinnyMethodAdapter mv, Class parameterType, LocalVariable parameter) {
        if (!parameterType.isPrimitive()) {
            mv.aload(parameter);
        } else if (Long.TYPE == parameterType) {
            mv.lload(parameter);
        } else if (Float.TYPE == parameterType) {
            mv.fload(parameter);
        } else if (Double.TYPE == parameterType) {
            mv.dload(parameter);
        } else {
            mv.iload(parameter);
        }
    }

    static void store(SkinnyMethodAdapter mv, Class type, LocalVariable var) {
        if (!type.isPrimitive()) {
            mv.astore(var);
        } else if (Long.TYPE == type) {
            mv.lstore(var);
        } else if (Double.TYPE == type) {
            mv.dstore(var);
        } else if (Float.TYPE == type) {
            mv.fstore(var);
        } else {
            mv.istore(var);
        }
    }

    static final Label emitDirectCheck(SkinnyMethodAdapter mv, Class[] parameterTypes) {
        Label bufferInvocationLabel = new Label();
        boolean needBufferInvocation = false;
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (Pointer.class.isAssignableFrom(parameterTypes[i])) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Pointer.class);
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            if (Struct.class.isAssignableFrom(parameterTypes[i])) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Struct.class);
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            if (Buffer.class.isAssignableFrom(parameterTypes[i])) {
                mv.aload(lvar++);
                if (Platform.getPlatform().getJavaMajorVersion() < 6 && Buffer.class == parameterTypes[i]) {
                    mv.invokestatic(AsmRuntime.class, "isDirect5", Boolean.TYPE, Buffer.class);
                } else {
                    mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, parameterTypes[i]);
                }
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            lvar += AsmUtil.calculateLocalVariableSpace(parameterTypes[i]);
        }
        return needBufferInvocation ? bufferInvocationLabel : null;
    }

    static final Label emitDirectCheck(SkinnyMethodAdapter mv, ParameterType[] parameterTypes) {
        Label bufferInvocationLabel = new Label();
        boolean needBufferInvocation = false;
        int lvar = 1;
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class javaType = parameterTypes[i].getDeclaredType();
            if (Pointer.class.isAssignableFrom(javaType)) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Pointer.class);
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            if (Struct.class.isAssignableFrom(javaType)) {
                mv.aload(lvar++);
                mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, Struct.class);
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            if (Buffer.class.isAssignableFrom(javaType)) {
                mv.aload(lvar++);
                if (Platform.getPlatform().getJavaMajorVersion() < 6 && Buffer.class == javaType) {
                    mv.invokestatic(AsmRuntime.class, "isDirect5", Boolean.TYPE, Buffer.class);
                } else {
                    mv.invokestatic(AsmRuntime.class, "isDirect", Boolean.TYPE, javaType);
                }
                mv.iffalse(bufferInvocationLabel);
                needBufferInvocation = true;
                continue;
            }
            lvar += AsmUtil.calculateLocalVariableSpace((SigType)parameterTypes[i]);
        }
        return needBufferInvocation ? bufferInvocationLabel : null;
    }

    static void emitReturn(SkinnyMethodAdapter mv, Class returnType, Class nativeIntType) {
        if (returnType.isPrimitive()) {
            if (Long.TYPE == returnType) {
                mv.lreturn();
            } else if (Float.TYPE == returnType) {
                mv.freturn();
            } else if (Double.TYPE == returnType) {
                mv.dreturn();
            } else if (Void.TYPE == returnType) {
                mv.voidreturn();
            } else {
                mv.ireturn();
            }
        } else {
            AsmUtil.boxValue(mv, returnType, nativeIntType);
            mv.areturn();
        }
    }
}

