package org.python.util;

import java.io.File;
import java.util.Set;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.python.core.Py;
import org.python.core.PySystemState;

public class CompileProxiesTask extends JycompileAntTask {

    @Override
    protected FileNameMapper createMapper() {
        FileNameMapper mapper = new RegexpPatternMapper();
        mapper.setFrom("(.*)\\.py");
        mapper.setTo("\1(\\.\\w+\\.class|\\$$py\\.class");
        return mapper;
    }

    @Override
    public void process(Set<File> toCompile) throws BuildException {
        super.process(toCompile);
        if (compiledModules.size() == 0) {
            return;
        } else {
            log("Importing " + compiledModules.size());
        }
        PySystemState sys = Py.getSystemState();
        // Import with our compiled files so we don't spew compilation in the source directory
        sys.path.insert(0, Py.newString(destDir.getAbsolutePath()));
        sys.javaproxy_dir = destDir.getAbsolutePath();
        PythonInterpreter interp = new PythonInterpreter();

        interp.exec("import os");
    }

    @Override
    protected void compile(File src, File compiled, String moduleName) {
        super.compile(src, compiled, moduleName);
        compiledModules.add(moduleName);
    }

    private Set<String> compiledModules = Generic.set();
}
