/*
 * Decompiled with CFR 0.152.
 */
package jxxload_help;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import jxxload_help.PathVFS;
import org.python.core.FileUtil;
import org.python.core.Options;

public class PathVFSJavaLoader
extends ClassLoader {
    private ClassLoader parent;
    private PathVFS vfs;
    public Vector interfaces = new Vector();

    public PathVFSJavaLoader(PathVFS pathVFS, ClassLoader classLoader) {
        this.vfs = pathVFS;
        this.parent = classLoader;
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            if (this.parent != null) {
                return this.parent.loadClass(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        InputStream inputStream = this.vfs.open(string.replace('.', '/') + ".class");
        if (inputStream == null) {
            throw new ClassNotFoundException(string);
        }
        try {
            byte[] byArray = FileUtil.readBytes(inputStream);
            inputStream.close();
            return this.loadClassFromBytes(string, byArray);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(string);
        }
    }

    private Class loadClassFromBytes(String string, byte[] byArray) {
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length);
        this.resolveClass(clazz);
        if (clazz.isInterface()) {
            this.interfaces.addElement(clazz);
        }
        if (!Options.skipCompile) {
            Compiler.compileClass(clazz);
        }
        return clazz;
    }
}

