/*
 * Decompiled with CFR 0.152.
 */
package org.python.parser;

import org.python.core.PyObject;
import org.python.parser.CtxVisitor;
import org.python.parser.DefaultArg;
import org.python.parser.ExtraArg;
import org.python.parser.ExtraArgValue;
import org.python.parser.IdentityNode;
import org.python.parser.JJTPythonGrammarState;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assert;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.AugAssign;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.BoolOp;
import org.python.parser.ast.Break;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Continue;
import org.python.parser.ast.Delete;
import org.python.parser.ast.Dict;
import org.python.parser.ast.Ellipsis;
import org.python.parser.ast.Exec;
import org.python.parser.ast.Expr;
import org.python.parser.ast.Expression;
import org.python.parser.ast.ExtSlice;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.Global;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Index;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Lambda;
import org.python.parser.ast.List;
import org.python.parser.ast.ListComp;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Pass;
import org.python.parser.ast.Print;
import org.python.parser.ast.Raise;
import org.python.parser.ast.Repr;
import org.python.parser.ast.Return;
import org.python.parser.ast.Slice;
import org.python.parser.ast.Str;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.Suite;
import org.python.parser.ast.TryExcept;
import org.python.parser.ast.TryFinally;
import org.python.parser.ast.Tuple;
import org.python.parser.ast.UnaryOp;
import org.python.parser.ast.Unicode;
import org.python.parser.ast.While;
import org.python.parser.ast.Yield;
import org.python.parser.ast.aliasType;
import org.python.parser.ast.argumentsType;
import org.python.parser.ast.excepthandlerType;
import org.python.parser.ast.exprType;
import org.python.parser.ast.keywordType;
import org.python.parser.ast.listcompType;
import org.python.parser.ast.sliceType;
import org.python.parser.ast.stmtType;

public class TreeBuilder
implements PythonGrammarTreeConstants {
    private JJTPythonGrammarState stack;
    CtxVisitor ctx;
    private static SimpleNode[] nodes = new SimpleNode[PythonGrammarTreeConstants.jjtNodeName.length];

    public TreeBuilder(JJTPythonGrammarState jJTPythonGrammarState) {
        this.stack = jJTPythonGrammarState;
        this.ctx = new CtxVisitor();
    }

    private stmtType[] makeStmts(int n) {
        stmtType[] stmtTypeArray = new stmtType[n];
        for (int i = n - 1; i >= 0; --i) {
            stmtTypeArray[i] = (stmtType)this.stack.popNode();
        }
        return stmtTypeArray;
    }

    private stmtType[] popSuite() {
        return ((Suite)this.popNode()).body;
    }

    private exprType[] makeExprs() {
        if (this.stack.nodeArity() > 0 && this.peekNode().getId() == 87) {
            this.popNode();
        }
        return this.makeExprs(this.stack.nodeArity());
    }

    private exprType[] makeExprs(int n) {
        exprType[] exprTypeArray = new exprType[n];
        for (int i = n - 1; i >= 0; --i) {
            exprTypeArray[i] = this.makeExpr();
        }
        return exprTypeArray;
    }

    private exprType makeExpr(SimpleNode simpleNode) {
        return (exprType)simpleNode;
    }

    private exprType makeExpr() {
        return this.makeExpr((SimpleNode)this.stack.popNode());
    }

    private String makeIdentifier() {
        return ((Name)this.stack.popNode()).id;
    }

    private String[] makeIdentifiers() {
        int n = this.stack.nodeArity();
        String[] stringArray = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            stringArray[i] = this.makeIdentifier();
        }
        return stringArray;
    }

    private aliasType[] makeAliases() {
        return this.makeAliases(this.stack.nodeArity());
    }

    private aliasType[] makeAliases(int n) {
        aliasType[] aliasTypeArray = new aliasType[n];
        for (int i = n - 1; i >= 0; --i) {
            aliasTypeArray[i] = (aliasType)this.stack.popNode();
        }
        return aliasTypeArray;
    }

    public SimpleNode openNode(int n) {
        if (nodes[n] == null) {
            if (n == 95 || n == 96 || n == 93) {
                return new IdentityNode(n);
            }
            TreeBuilder.nodes[n] = new IdentityNode(n);
        }
        return nodes[n];
    }

    public SimpleNode closeNode(SimpleNode simpleNode, int n) throws Exception {
        switch (simpleNode.getId()) {
            case -1: {
                System.out.println("Illegal node");
            }
            case 0: {
                return new Interactive(this.makeStmts(n));
            }
            case 1: {
                return new Module(this.makeStmts(n));
            }
            case 2: {
                return new Expression(this.makeExpr());
            }
            case 95: {
                return new Name(simpleNode.getImage().toString(), 1);
            }
            case 93: {
                return new Num((PyObject)simpleNode.getImage());
            }
            case 96: {
                return new Str(simpleNode.getImage().toString());
            }
            case 97: {
                return new Unicode(simpleNode.getImage().toString());
            }
            case 45: {
                stmtType[] stmtTypeArray = new stmtType[n];
                for (int i = n - 1; i >= 0; --i) {
                    stmtTypeArray[i] = (stmtType)this.popNode();
                }
                return new Suite(stmtTypeArray);
            }
            case 21: {
                exprType exprType2 = this.makeExpr();
                if (n > 1) {
                    SimpleNode[] simpleNodeArray = this.makeExprs(n - 1);
                    this.ctx.setStore(simpleNodeArray);
                    return new Assign((exprType[])simpleNodeArray, exprType2);
                }
                return new Expr(exprType2);
            }
            case 76: {
                sliceType sliceType2 = (sliceType)this.stack.popNode();
                exprType exprType3 = this.makeExpr();
                return new Subscript(exprType3, sliceType2, 1);
            }
            case 77: {
                String string = this.makeIdentifier();
                exprType exprType4 = this.makeExpr();
                return new Attribute(exprType4, string, 1);
            }
            case 24: {
                SimpleNode[] simpleNodeArray = this.makeExprs(n);
                this.ctx.setDelete(simpleNodeArray);
                return new Delete((exprType[])simpleNodeArray);
            }
            case 23: {
                boolean bl = true;
                if (this.stack.nodeArity() == 0) {
                    return new Print(null, null, true);
                }
                if (this.peekNode().getId() == 87) {
                    this.popNode();
                    bl = false;
                }
                return new Print(null, this.makeExprs(), bl);
            }
            case 22: {
                boolean bl = true;
                if (this.peekNode().getId() == 87) {
                    this.popNode();
                    bl = false;
                }
                exprType[] exprTypeArray = this.makeExprs(this.stack.nodeArity() - 1);
                return new Print(this.makeExpr(), exprTypeArray, bl);
            }
            case 41: {
                stmtType[] stmtTypeArray = null;
                if (this.stack.nodeArity() == 4) {
                    stmtTypeArray = this.popSuite();
                }
                stmtType[] stmtTypeArray2 = this.popSuite();
                exprType exprType5 = this.makeExpr();
                exprType exprType6 = this.makeExpr();
                this.ctx.setStore(exprType6);
                return new For(exprType6, exprType5, stmtTypeArray2, stmtTypeArray);
            }
            case 40: {
                stmtType[] stmtTypeArray = null;
                if (this.stack.nodeArity() == 3) {
                    stmtTypeArray = this.popSuite();
                }
                stmtType[] stmtTypeArray3 = this.popSuite();
                exprType exprType7 = this.makeExpr();
                return new While(exprType7, stmtTypeArray3, stmtTypeArray);
            }
            case 39: {
                stmtType[] stmtTypeArray = null;
                if (n % 2 == 1) {
                    stmtTypeArray = this.popSuite();
                }
                stmtType[] stmtTypeArray4 = this.popSuite();
                exprType exprType8 = this.makeExpr();
                If if_ = new If(exprType8, stmtTypeArray4, stmtTypeArray);
                for (int i = 0; i < n / 2 - 1; ++i) {
                    stmtTypeArray4 = this.popSuite();
                    exprType8 = this.makeExpr();
                    if_ = new If(exprType8, stmtTypeArray4, new stmtType[]{if_});
                }
                return if_;
            }
            case 25: {
                return new Pass();
            }
            case 26: {
                return new Break();
            }
            case 27: {
                return new Continue();
            }
            case 3: {
                stmtType[] stmtTypeArray = this.popSuite();
                argumentsType argumentsType2 = this.makeArguments(n - 2);
                String string = this.makeIdentifier();
                return new FunctionDef(string, argumentsType2, stmtTypeArray);
            }
            case 7: {
                exprType exprType9 = n == 1 ? null : this.makeExpr();
                return new DefaultArg(this.makeExpr(), exprType9);
            }
            case 5: {
                return new ExtraArg(this.makeIdentifier(), 5);
            }
            case 6: {
                return new ExtraArg(this.makeIdentifier(), 6);
            }
            case 89: {
                stmtType[] stmtTypeArray = this.popSuite();
                exprType[] exprTypeArray = this.makeExprs(this.stack.nodeArity() - 1);
                String string = this.makeIdentifier();
                return new ClassDef(string, exprTypeArray, stmtTypeArray);
            }
            case 28: {
                exprType exprType10 = n == 1 ? this.makeExpr() : null;
                return new Return(exprType10);
            }
            case 29: {
                return new Yield(this.makeExpr());
            }
            case 30: {
                exprType exprType11 = n >= 3 ? this.makeExpr() : null;
                exprType exprType12 = n >= 2 ? this.makeExpr() : null;
                exprType exprType13 = n >= 1 ? this.makeExpr() : null;
                return new Raise(exprType13, exprType12, exprType11);
            }
            case 36: {
                return new Global(this.makeIdentifiers());
            }
            case 37: {
                exprType exprType14 = n >= 3 ? this.makeExpr() : null;
                exprType exprType15 = n >= 2 ? this.makeExpr() : null;
                exprType exprType16 = this.makeExpr();
                return new Exec(exprType16, exprType15, exprType14);
            }
            case 38: {
                exprType exprType17 = n == 2 ? this.makeExpr() : null;
                exprType exprType18 = this.makeExpr();
                return new Assert(exprType18, exprType17);
            }
            case 43: {
                stmtType[] stmtTypeArray = this.popSuite();
                return new TryFinally(this.popSuite(), stmtTypeArray);
            }
            case 42: {
                stmtType[] stmtTypeArray = null;
                if (this.peekNode() instanceof Suite) {
                    --n;
                    stmtTypeArray = this.popSuite();
                }
                int n2 = n - 1;
                excepthandlerType[] excepthandlerTypeArray = new excepthandlerType[n2];
                for (int i = n2 - 1; i >= 0; --i) {
                    excepthandlerTypeArray[i] = (excepthandlerType)this.popNode();
                }
                return new TryExcept(this.popSuite(), excepthandlerTypeArray, stmtTypeArray);
            }
            case 44: {
                exprType exprType19;
                stmtType[] stmtTypeArray = this.popSuite();
                exprType exprType20 = exprType19 = n == 3 ? this.makeExpr() : null;
                if (exprType19 != null) {
                    this.ctx.setStore(exprType19);
                }
                exprType exprType21 = n >= 2 ? this.makeExpr() : null;
                return new excepthandlerType(exprType21, exprType19, stmtTypeArray);
            }
            case 46: {
                return new BoolOp(2, this.makeExprs());
            }
            case 47: {
                return new BoolOp(1, this.makeExprs());
            }
            case 49: {
                int n3 = n / 2;
                exprType[] exprTypeArray = new exprType[n3];
                int[] nArray = new int[n3];
                block104: for (int i = n3 - 1; i >= 0; --i) {
                    exprTypeArray[i] = this.makeExpr();
                    SimpleNode simpleNode2 = (SimpleNode)this.stack.popNode();
                    switch (simpleNode2.getId()) {
                        case 50: {
                            nArray[i] = 3;
                            continue block104;
                        }
                        case 51: {
                            nArray[i] = 5;
                            continue block104;
                        }
                        case 52: {
                            nArray[i] = 1;
                            continue block104;
                        }
                        case 53: {
                            nArray[i] = 6;
                            continue block104;
                        }
                        case 54: {
                            nArray[i] = 4;
                            continue block104;
                        }
                        case 55: {
                            nArray[i] = 2;
                            continue block104;
                        }
                        case 56: {
                            nArray[i] = 9;
                            continue block104;
                        }
                        case 57: {
                            nArray[i] = 10;
                            continue block104;
                        }
                        case 58: {
                            nArray[i] = 8;
                            continue block104;
                        }
                        case 59: {
                            nArray[i] = 7;
                            continue block104;
                        }
                        default: {
                            throw new RuntimeException("Unknown cmp op:" + simpleNode2.getId());
                        }
                    }
                }
                return new Compare(this.makeExpr(), nArray, exprTypeArray);
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                return simpleNode;
            }
            case 60: {
                return this.makeBinOp(9);
            }
            case 61: {
                return this.makeBinOp(10);
            }
            case 62: {
                return this.makeBinOp(11);
            }
            case 63: {
                return this.makeBinOp(7);
            }
            case 64: {
                return this.makeBinOp(8);
            }
            case 65: {
                return this.makeBinOp(1);
            }
            case 66: {
                return this.makeBinOp(2);
            }
            case 67: {
                return this.makeBinOp(3);
            }
            case 68: {
                return this.makeBinOp(4);
            }
            case 70: {
                return this.makeBinOp(5);
            }
            case 74: {
                return this.makeBinOp(6);
            }
            case 69: {
                return this.makeBinOp(12);
            }
            case 71: {
                return new UnaryOp(3, this.makeExpr());
            }
            case 72: {
                return new UnaryOp(4, this.makeExpr());
            }
            case 73: {
                return new UnaryOp(1, this.makeExpr());
            }
            case 48: {
                return new UnaryOp(2, this.makeExpr());
            }
            case 75: {
                exprType exprType22 = null;
                exprType exprType23 = null;
                int n4 = n - 1;
                if (n4 > 0 && this.peekNode().getId() == 91) {
                    exprType23 = ((ExtraArgValue)this.popNode()).value;
                    --n4;
                }
                if (n4 > 0 && this.peekNode().getId() == 90) {
                    exprType22 = ((ExtraArgValue)this.popNode()).value;
                    --n4;
                }
                int n5 = n4;
                SimpleNode[] simpleNodeArray = new SimpleNode[n4];
                for (int i = n4 - 1; i >= 0; --i) {
                    simpleNodeArray[i] = this.popNode();
                    if (!(simpleNodeArray[i] instanceof keywordType)) continue;
                    n5 = i;
                }
                exprType[] exprTypeArray = new exprType[n5];
                for (int i = 0; i < n5; ++i) {
                    exprTypeArray[i] = this.makeExpr(simpleNodeArray[i]);
                }
                keywordType[] keywordTypeArray = new keywordType[n4 - n5];
                for (int i = n5; i < n4; ++i) {
                    if (!(simpleNodeArray[i] instanceof keywordType)) {
                        throw new ParseException("non-keyword argument following keyword", simpleNodeArray[i]);
                    }
                    keywordTypeArray[i - n5] = (keywordType)simpleNodeArray[i];
                }
                exprType exprType24 = this.makeExpr();
                return new Call(exprType24, exprTypeArray, keywordTypeArray, exprType22, exprType23);
            }
            case 91: {
                return new ExtraArgValue(this.makeExpr(), 91);
            }
            case 90: {
                return new ExtraArgValue(this.makeExpr(), 90);
            }
            case 92: {
                exprType exprType25 = this.makeExpr();
                String string = this.makeIdentifier();
                return new keywordType(string, exprType25);
            }
            case 8: {
                return new Tuple(this.makeExprs(), 1);
            }
            case 78: {
                if (this.stack.nodeArity() > 0 && this.peekNode() instanceof listcompType) {
                    listcompType[] listcompTypeArray = new listcompType[n - 1];
                    for (int i = n - 2; i >= 0; --i) {
                        listcompTypeArray[i] = (listcompType)this.popNode();
                    }
                    return new ListComp(this.makeExpr(), listcompTypeArray);
                }
                return new List(this.makeExprs(), 1);
            }
            case 79: {
                int n6 = n / 2;
                exprType[] exprTypeArray = new exprType[n6];
                exprType[] exprTypeArray2 = new exprType[n6];
                for (int i = n6 - 1; i >= 0; --i) {
                    exprTypeArray2[i] = this.makeExpr();
                    exprTypeArray[i] = this.makeExpr();
                }
                return new Dict(exprTypeArray, exprTypeArray2);
            }
            case 80: {
                return new Repr(this.makeExpr());
            }
            case 81: {
                String string = ((Str)this.popNode()).s;
                String string2 = ((Str)this.popNode()).s;
                return new Str(string2 + string);
            }
            case 82: {
                exprType exprType26 = this.makeExpr();
                argumentsType argumentsType3 = this.makeArguments(n - 1);
                return new Lambda(argumentsType3, exprType26);
            }
            case 84: {
                return new Ellipsis();
            }
            case 85: {
                SimpleNode[] simpleNodeArray = new SimpleNode[n];
                for (int i = n - 1; i >= 0; --i) {
                    simpleNodeArray[i] = this.popNode();
                }
                exprType[] exprTypeArray = new exprType[3];
                int n7 = 0;
                for (int i = 0; i < n; ++i) {
                    if (simpleNodeArray[i].getId() == 86) {
                        ++n7;
                        continue;
                    }
                    exprTypeArray[n7] = this.makeExpr(simpleNodeArray[i]);
                }
                if (n7 == 0) {
                    return new Index(exprTypeArray[0]);
                }
                return new Slice(exprTypeArray[0], exprTypeArray[1], exprTypeArray[2]);
            }
            case 83: {
                if (n > 0 && this.peekNode().getId() == 87) {
                    --n;
                    this.popNode();
                }
                sliceType[] sliceTypeArray = new sliceType[n];
                for (int i = n - 1; i >= 0; --i) {
                    sliceTypeArray[i] = (sliceType)this.popNode();
                }
                return new ExtSlice(sliceTypeArray);
            }
            case 9: {
                return this.makeAugAssign(1);
            }
            case 10: {
                return this.makeAugAssign(2);
            }
            case 11: {
                return this.makeAugAssign(3);
            }
            case 12: {
                return this.makeAugAssign(4);
            }
            case 14: {
                return this.makeAugAssign(5);
            }
            case 15: {
                return this.makeAugAssign(11);
            }
            case 16: {
                return this.makeAugAssign(9);
            }
            case 17: {
                return this.makeAugAssign(10);
            }
            case 18: {
                return this.makeAugAssign(7);
            }
            case 19: {
                return this.makeAugAssign(8);
            }
            case 20: {
                return this.makeAugAssign(6);
            }
            case 13: {
                return this.makeAugAssign(12);
            }
            case 88: {
                exprType[] exprTypeArray = new exprType[n - 2];
                for (int i = n - 3; i >= 0; --i) {
                    exprTypeArray[i] = this.makeExpr();
                }
                exprType exprType27 = this.makeExpr();
                exprType exprType28 = this.makeExpr();
                this.ctx.setStore(exprType28);
                return new listcompType(exprType28, exprType27, exprTypeArray);
            }
            case 32: {
                aliasType[] aliasTypeArray = this.makeAliases(n - 1);
                String string = this.makeIdentifier();
                return new ImportFrom(string, aliasTypeArray);
            }
            case 31: {
                return new Import(this.makeAliases());
            }
            case 34: {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.insert(0, '.');
                    }
                    stringBuffer.insert(0, this.makeIdentifier());
                }
                return new Name(stringBuffer.toString(), 1);
            }
            case 33: {
                String string = null;
                if (n > 1) {
                    string = this.makeIdentifier();
                }
                return new aliasType(this.makeIdentifier(), string);
            }
            case 35: {
                String string = null;
                if (n > 1) {
                    string = this.makeIdentifier();
                }
                return new aliasType(this.makeIdentifier(), string);
            }
            case 86: 
            case 87: {
                return simpleNode;
            }
        }
        return null;
    }

    private stmtType makeAugAssign(int n) throws Exception {
        exprType exprType2 = this.makeExpr();
        exprType exprType3 = this.makeExpr();
        this.ctx.setAugStore(exprType3);
        return new AugAssign(exprType3, n, exprType2);
    }

    private void dumpStack() {
        int n = this.stack.nodeArity();
        System.out.println("nodeArity:" + n);
        if (n > 0) {
            System.out.println("peek:" + this.stack.peekNode());
        }
    }

    SimpleNode peekNode() {
        return (SimpleNode)this.stack.peekNode();
    }

    SimpleNode popNode() {
        return (SimpleNode)this.stack.popNode();
    }

    BinOp makeBinOp(int n) {
        exprType exprType2 = this.makeExpr();
        exprType exprType3 = this.makeExpr();
        return new BinOp(exprType3, n, exprType2);
    }

    argumentsType makeArguments(int n) throws Exception {
        String string = null;
        String string2 = null;
        if (n > 0 && this.peekNode().getId() == 6) {
            string = ((ExtraArg)this.popNode()).name;
            --n;
        }
        if (n > 0 && this.peekNode().getId() == 5) {
            string2 = ((ExtraArg)this.popNode()).name;
            --n;
        }
        int n2 = n;
        exprType[] exprTypeArray = new exprType[n];
        exprType[] exprTypeArray2 = new exprType[n];
        for (int i = n - 1; i >= 0; --i) {
            DefaultArg defaultArg = (DefaultArg)this.popNode();
            exprTypeArray[i] = defaultArg.parameter;
            this.ctx.setStore(exprTypeArray[i]);
            exprTypeArray2[i] = defaultArg.value;
            if (defaultArg.value == null) continue;
            n2 = i;
        }
        exprType[] exprTypeArray3 = new exprType[n - n2];
        System.arraycopy(exprTypeArray2, n2, exprTypeArray3, 0, exprTypeArray3.length);
        return new argumentsType(exprTypeArray, string2, string, exprTypeArray3);
    }
}

