// $ANTLR 3.5.3 Python.g 2024-08-18 16:49:56

package org.python.antlr;

import org.antlr.runtime.CommonToken;

import org.python.antlr.ParseException;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.ast.Assert;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.AugAssign;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.BoolOp;
import org.python.antlr.ast.boolopType;
import org.python.antlr.ast.Break;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.cmpopType;
import org.python.antlr.ast.Compare;
import org.python.antlr.ast.comprehension;
import org.python.antlr.ast.Context;
import org.python.antlr.ast.Continue;
import org.python.antlr.ast.Delete;
import org.python.antlr.ast.Dict;
import org.python.antlr.ast.DictComp;
import org.python.antlr.ast.Ellipsis;
import org.python.antlr.ast.ErrorMod;
import org.python.antlr.ast.ExceptHandler;
import org.python.antlr.ast.Exec;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.Expression;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.ExtSlice;
import org.python.antlr.ast.For;
import org.python.antlr.ast.GeneratorExp;
import org.python.antlr.ast.Global;
import org.python.antlr.ast.If;
import org.python.antlr.ast.IfExp;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Index;
import org.python.antlr.ast.Interactive;
import org.python.antlr.ast.keyword;
import org.python.antlr.ast.ListComp;
import org.python.antlr.ast.Lambda;
import org.python.antlr.ast.Module;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.operatorType;
import org.python.antlr.ast.Pass;
import org.python.antlr.ast.Print;
import org.python.antlr.ast.Raise;
import org.python.antlr.ast.Repr;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.Set;
import org.python.antlr.ast.SetComp;
import org.python.antlr.ast.Slice;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.Subscript;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.unaryopType;
import org.python.antlr.ast.UnaryOp;
import org.python.antlr.ast.While;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.base.excepthandler;
import org.python.antlr.base.expr;
import org.python.antlr.base.mod;
import org.python.antlr.base.slice;
import org.python.antlr.base.stmt;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;

import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.ListIterator;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

import org.antlr.runtime.tree.*;


/** Python 2.3.3 Grammar
 *
 *  Terence Parr and Loring Craymer
 *  February 2004
 *
 *  Converted to ANTLR v3 November 2005 by Terence Parr.
 *
 *  This grammar was derived automatically from the Python 2.3.3
 *  parser grammar to get a syntactically correct ANTLR grammar
 *  for Python.  Then Terence hand tweaked it to be semantically
 *  correct; i.e., removed lookahead issues etc...  It is LL(1)
 *  except for the (sometimes optional) trailing commas and semi-colons.
 *  It needs two symbols of lookahead in this case.
 *
 *  Starting with Loring's preliminary lexer for Python, I modified it
 *  to do my version of the whole nasty INDENT/DEDENT issue just so I
 *  could understand the problem better.  This grammar requires
 *  PythonTokenStream.java to work.  Also I used some rules from the
 *  semi-formal grammar on the web for Python (automatically
 *  translated to ANTLR format by an ANTLR grammar, naturally <grin>).
 *  The lexical rules for python are particularly nasty and it took me
 *  a long time to get it 'right'; i.e., think about it in the proper
 *  way.  Resist changing the lexer unless you've used ANTLR a lot. ;)
 *
 *  I (Terence) tested this by running it on the jython-2.1/Lib
 *  directory of 40k lines of Python.
 *
 *  REQUIRES ANTLR v3
 *
 *
 *  Updated the original parser for Python 2.5 features. The parser has been
 *  altered to produce an AST - the AST work started from tne newcompiler
 *  grammar from Jim Baker.  The current parsing and compiling strategy looks
 *  like this:
 *
 *  Python source->Python.g->AST (org/python/parser/ast/*)->CodeCompiler(ASM)->.class
 */
@SuppressWarnings("all")
public class PythonParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "ALT_NOTEQUAL", "AMPER", "AMPEREQUAL", 
		"AND", "AS", "ASSERT", "ASSIGN", "AT", "BACKQUOTE", "BREAK", "CIRCUMFLEX", 
		"CIRCUMFLEXEQUAL", "CLASS", "COLON", "COMMA", "COMMENT", "COMPLEX", "CONTINUE", 
		"CONTINUED_LINE", "DEDENT", "DEF", "DELETE", "DIGITS", "DOT", "DOUBLESLASH", 
		"DOUBLESLASHEQUAL", "DOUBLESTAR", "DOUBLESTAREQUAL", "ELIF", "EQUAL", 
		"ESC", "EXCEPT", "EXEC", "Exponent", "FINALLY", "FLOAT", "FOR", "FROM", 
		"GLOBAL", "GREATER", "GREATEREQUAL", "IF", "IMPORT", "IN", "INDENT", "INT", 
		"IS", "LAMBDA", "LBRACK", "LCURLY", "LEADING_WS", "LEFTSHIFT", "LEFTSHIFTEQUAL", 
		"LESS", "LESSEQUAL", "LONGINT", "LPAREN", "MINUS", "MINUSEQUAL", "NAME", 
		"NEWLINE", "NOT", "NOTEQUAL", "OR", "ORELSE", "PASS", "PERCENT", "PERCENTEQUAL", 
		"PLUS", "PLUSEQUAL", "PRINT", "RAISE", "RBRACK", "RCURLY", "RETURN", "RIGHTSHIFT", 
		"RIGHTSHIFTEQUAL", "RPAREN", "SEMI", "SLASH", "SLASHEQUAL", "STAR", "STAREQUAL", 
		"STRING", "TILDE", "TRAILBACKSLASH", "TRIAPOS", "TRIQUOTE", "TRY", "VBAR", 
		"VBAREQUAL", "WHILE", "WITH", "WS", "YIELD"
	};
	public static final int EOF=-1;
	public static final int ALT_NOTEQUAL=4;
	public static final int AMPER=5;
	public static final int AMPEREQUAL=6;
	public static final int AND=7;
	public static final int AS=8;
	public static final int ASSERT=9;
	public static final int ASSIGN=10;
	public static final int AT=11;
	public static final int BACKQUOTE=12;
	public static final int BREAK=13;
	public static final int CIRCUMFLEX=14;
	public static final int CIRCUMFLEXEQUAL=15;
	public static final int CLASS=16;
	public static final int COLON=17;
	public static final int COMMA=18;
	public static final int COMMENT=19;
	public static final int COMPLEX=20;
	public static final int CONTINUE=21;
	public static final int CONTINUED_LINE=22;
	public static final int DEDENT=23;
	public static final int DEF=24;
	public static final int DELETE=25;
	public static final int DIGITS=26;
	public static final int DOT=27;
	public static final int DOUBLESLASH=28;
	public static final int DOUBLESLASHEQUAL=29;
	public static final int DOUBLESTAR=30;
	public static final int DOUBLESTAREQUAL=31;
	public static final int ELIF=32;
	public static final int EQUAL=33;
	public static final int ESC=34;
	public static final int EXCEPT=35;
	public static final int EXEC=36;
	public static final int Exponent=37;
	public static final int FINALLY=38;
	public static final int FLOAT=39;
	public static final int FOR=40;
	public static final int FROM=41;
	public static final int GLOBAL=42;
	public static final int GREATER=43;
	public static final int GREATEREQUAL=44;
	public static final int IF=45;
	public static final int IMPORT=46;
	public static final int IN=47;
	public static final int INDENT=48;
	public static final int INT=49;
	public static final int IS=50;
	public static final int LAMBDA=51;
	public static final int LBRACK=52;
	public static final int LCURLY=53;
	public static final int LEADING_WS=54;
	public static final int LEFTSHIFT=55;
	public static final int LEFTSHIFTEQUAL=56;
	public static final int LESS=57;
	public static final int LESSEQUAL=58;
	public static final int LONGINT=59;
	public static final int LPAREN=60;
	public static final int MINUS=61;
	public static final int MINUSEQUAL=62;
	public static final int NAME=63;
	public static final int NEWLINE=64;
	public static final int NOT=65;
	public static final int NOTEQUAL=66;
	public static final int OR=67;
	public static final int ORELSE=68;
	public static final int PASS=69;
	public static final int PERCENT=70;
	public static final int PERCENTEQUAL=71;
	public static final int PLUS=72;
	public static final int PLUSEQUAL=73;
	public static final int PRINT=74;
	public static final int RAISE=75;
	public static final int RBRACK=76;
	public static final int RCURLY=77;
	public static final int RETURN=78;
	public static final int RIGHTSHIFT=79;
	public static final int RIGHTSHIFTEQUAL=80;
	public static final int RPAREN=81;
	public static final int SEMI=82;
	public static final int SLASH=83;
	public static final int SLASHEQUAL=84;
	public static final int STAR=85;
	public static final int STAREQUAL=86;
	public static final int STRING=87;
	public static final int TILDE=88;
	public static final int TRAILBACKSLASH=89;
	public static final int TRIAPOS=90;
	public static final int TRIQUOTE=91;
	public static final int TRY=92;
	public static final int VBAR=93;
	public static final int VBAREQUAL=94;
	public static final int WHILE=95;
	public static final int WITH=96;
	public static final int WS=97;
	public static final int YIELD=98;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public PythonParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public PythonParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	protected TreeAdaptor adaptor = new CommonTreeAdaptor();

	public void setTreeAdaptor(TreeAdaptor adaptor) {
		this.adaptor = adaptor;
	}
	public TreeAdaptor getTreeAdaptor() {
		return adaptor;
	}
	@Override public String[] getTokenNames() { return PythonParser.tokenNames; }
	@Override public String getGrammarFileName() { return "Python.g"; }


	    private ErrorHandler errorHandler;

	    private GrammarActions actions = new GrammarActions();

	    private String encoding;

	    private boolean printFunction = false;
	    private boolean unicodeLiterals = false;

	    public void setErrorHandler(ErrorHandler eh) {
	        this.errorHandler = eh;
	        actions.setErrorHandler(eh);
	    }

	    protected Object recoverFromMismatchedToken(IntStream input, int ttype, BitSet follow)
	        throws RecognitionException {

	        Object o = errorHandler.recoverFromMismatchedToken(this, input, ttype, follow);
	        if (o != null) {
	            return o;
	        }
	        return super.recoverFromMismatchedToken(input, ttype, follow);
	    }

	    public PythonParser(TokenStream input, String encoding) {
	        this(input);
	        this.encoding = encoding;
	    }

	    public PythonParser(TokenStream input, String encoding, boolean printFunction, boolean unicodeLiterals) {
	        this(input, encoding);
	        this.printFunction = printFunction;
	        this.unicodeLiterals = unicodeLiterals;
	    }

	    @Override
	    public void reportError(RecognitionException e) {
	      // Update syntax error count and output error.
	      super.reportError(e);
	      errorHandler.reportError(this, e);
	    }

	    @Override
	    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
	        //Do nothing. We will handle error display elsewhere.
	    }


	public static class single_input_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "single_input"
	// Python.g:315:1: single_input : ( ( NEWLINE )* EOF | simple_stmt ( NEWLINE )* EOF | compound_stmt ( NEWLINE )+ EOF );
	public final PythonParser.single_input_return single_input() throws RecognitionException {
		PythonParser.single_input_return retval = new PythonParser.single_input_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NEWLINE1=null;
		Token EOF2=null;
		Token NEWLINE4=null;
		Token EOF5=null;
		Token NEWLINE7=null;
		Token EOF8=null;
		ParserRuleReturnScope simple_stmt3 =null;
		ParserRuleReturnScope compound_stmt6 =null;

		PythonTree NEWLINE1_tree=null;
		PythonTree EOF2_tree=null;
		PythonTree NEWLINE4_tree=null;
		PythonTree EOF5_tree=null;
		PythonTree NEWLINE7_tree=null;
		PythonTree EOF8_tree=null;


		    mod mtype = null;

		try {
			// Python.g:322:5: ( ( NEWLINE )* EOF | simple_stmt ( NEWLINE )* EOF | compound_stmt ( NEWLINE )+ EOF )
			int alt4=3;
			int LA4_0 = input.LA(1);
			if ( (LA4_0==EOF||LA4_0==NEWLINE) ) {
				alt4=1;
			}
			else if ( (LA4_0==BACKQUOTE||(LA4_0 >= LBRACK && LA4_0 <= LCURLY)||(LA4_0 >= LPAREN && LA4_0 <= MINUS)||LA4_0==NAME||LA4_0==NOT||LA4_0==PLUS||LA4_0==TILDE) ) {
				alt4=2;
			}
			else if ( (LA4_0==PRINT) && (((printFunction)||(!printFunction)))) {
				alt4=2;
			}
			else if ( (LA4_0==ASSERT||LA4_0==BREAK||(LA4_0 >= COMPLEX && LA4_0 <= CONTINUE)||LA4_0==DELETE||LA4_0==EXEC||LA4_0==FLOAT||(LA4_0 >= FROM && LA4_0 <= GLOBAL)||LA4_0==IMPORT||LA4_0==INT||LA4_0==LAMBDA||LA4_0==LONGINT||LA4_0==PASS||LA4_0==RAISE||LA4_0==RETURN||LA4_0==STRING||LA4_0==YIELD) ) {
				alt4=2;
			}
			else if ( (LA4_0==AT||LA4_0==CLASS||LA4_0==DEF||LA4_0==FOR||LA4_0==IF||LA4_0==TRY||(LA4_0 >= WHILE && LA4_0 <= WITH)) ) {
				alt4=3;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 4, 0, input);
				throw nvae;
			}

			switch (alt4) {
				case 1 :
					// Python.g:322:7: ( NEWLINE )* EOF
					{
					root_0 = (PythonTree)adaptor.nil();


					// Python.g:322:7: ( NEWLINE )*
					loop1:
					while (true) {
						int alt1=2;
						int LA1_0 = input.LA(1);
						if ( (LA1_0==NEWLINE) ) {
							alt1=1;
						}

						switch (alt1) {
						case 1 :
							// Python.g:322:7: NEWLINE
							{
							NEWLINE1=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_single_input118); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							NEWLINE1_tree = (PythonTree)adaptor.create(NEWLINE1);
							adaptor.addChild(root_0, NEWLINE1_tree);
							}

							}
							break;

						default :
							break loop1;
						}
					}

					EOF2=(Token)match(input,EOF,FOLLOW_EOF_in_single_input121); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					EOF2_tree = (PythonTree)adaptor.create(EOF2);
					adaptor.addChild(root_0, EOF2_tree);
					}

					if ( state.backtracking==0 ) {
					        mtype = new Interactive((retval.start), new ArrayList<stmt>());
					      }
					}
					break;
				case 2 :
					// Python.g:326:7: simple_stmt ( NEWLINE )* EOF
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_simple_stmt_in_single_input137);
					simple_stmt3=simple_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, simple_stmt3.getTree());

					// Python.g:326:19: ( NEWLINE )*
					loop2:
					while (true) {
						int alt2=2;
						int LA2_0 = input.LA(1);
						if ( (LA2_0==NEWLINE) ) {
							alt2=1;
						}

						switch (alt2) {
						case 1 :
							// Python.g:326:19: NEWLINE
							{
							NEWLINE4=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_single_input139); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							NEWLINE4_tree = (PythonTree)adaptor.create(NEWLINE4);
							adaptor.addChild(root_0, NEWLINE4_tree);
							}

							}
							break;

						default :
							break loop2;
						}
					}

					EOF5=(Token)match(input,EOF,FOLLOW_EOF_in_single_input142); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					EOF5_tree = (PythonTree)adaptor.create(EOF5);
					adaptor.addChild(root_0, EOF5_tree);
					}

					if ( state.backtracking==0 ) {
					        mtype = new Interactive((retval.start), actions.castStmts((simple_stmt3!=null?((PythonParser.simple_stmt_return)simple_stmt3).stypes:null)));
					      }
					}
					break;
				case 3 :
					// Python.g:330:7: compound_stmt ( NEWLINE )+ EOF
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_compound_stmt_in_single_input158);
					compound_stmt6=compound_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, compound_stmt6.getTree());

					// Python.g:330:21: ( NEWLINE )+
					int cnt3=0;
					loop3:
					while (true) {
						int alt3=2;
						int LA3_0 = input.LA(1);
						if ( (LA3_0==NEWLINE) ) {
							alt3=1;
						}

						switch (alt3) {
						case 1 :
							// Python.g:330:21: NEWLINE
							{
							NEWLINE7=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_single_input160); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							NEWLINE7_tree = (PythonTree)adaptor.create(NEWLINE7);
							adaptor.addChild(root_0, NEWLINE7_tree);
							}

							}
							break;

						default :
							if ( cnt3 >= 1 ) break loop3;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(3, input);
							throw eee;
						}
						cnt3++;
					}

					EOF8=(Token)match(input,EOF,FOLLOW_EOF_in_single_input163); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					EOF8_tree = (PythonTree)adaptor.create(EOF8);
					adaptor.addChild(root_0, EOF8_tree);
					}

					if ( state.backtracking==0 ) {
					        mtype = new Interactive((retval.start), actions.castStmts((compound_stmt6!=null?((PythonTree)compound_stmt6.getTree()):null)));
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = mtype;
			}
		}
		catch (RecognitionException re) {

			        reportError(re);
			        errorHandler.recover(this, input,re);
			        PythonTree badNode = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			        retval.tree = new ErrorMod(badNode);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "single_input"


	public static class file_input_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "file_input"
	// Python.g:344:1: file_input : ( NEWLINE | stmt )* EOF ;
	public final PythonParser.file_input_return file_input() throws RecognitionException {
		PythonParser.file_input_return retval = new PythonParser.file_input_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NEWLINE9=null;
		Token EOF11=null;
		ParserRuleReturnScope stmt10 =null;

		PythonTree NEWLINE9_tree=null;
		PythonTree EOF11_tree=null;


		    mod mtype = null;
		    List stypes = new ArrayList();

		try {
			// Python.g:362:5: ( ( NEWLINE | stmt )* EOF )
			// Python.g:362:7: ( NEWLINE | stmt )* EOF
			{
			root_0 = (PythonTree)adaptor.nil();


			// Python.g:362:7: ( NEWLINE | stmt )*
			loop5:
			while (true) {
				int alt5=3;
				int LA5_0 = input.LA(1);
				if ( (LA5_0==NEWLINE) ) {
					alt5=1;
				}
				else if ( (LA5_0==BACKQUOTE||(LA5_0 >= LBRACK && LA5_0 <= LCURLY)||(LA5_0 >= LPAREN && LA5_0 <= MINUS)||LA5_0==NAME||LA5_0==NOT||LA5_0==PLUS||LA5_0==TILDE) ) {
					alt5=2;
				}
				else if ( (LA5_0==PRINT) && (((printFunction)||(!printFunction)))) {
					alt5=2;
				}
				else if ( (LA5_0==ASSERT||LA5_0==AT||LA5_0==BREAK||LA5_0==CLASS||(LA5_0 >= COMPLEX && LA5_0 <= CONTINUE)||(LA5_0 >= DEF && LA5_0 <= DELETE)||LA5_0==EXEC||(LA5_0 >= FLOAT && LA5_0 <= GLOBAL)||(LA5_0 >= IF && LA5_0 <= IMPORT)||LA5_0==INT||LA5_0==LAMBDA||LA5_0==LONGINT||LA5_0==PASS||LA5_0==RAISE||LA5_0==RETURN||LA5_0==STRING||LA5_0==TRY||(LA5_0 >= WHILE && LA5_0 <= WITH)||LA5_0==YIELD) ) {
					alt5=2;
				}

				switch (alt5) {
				case 1 :
					// Python.g:362:8: NEWLINE
					{
					NEWLINE9=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_file_input215); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NEWLINE9_tree = (PythonTree)adaptor.create(NEWLINE9);
					adaptor.addChild(root_0, NEWLINE9_tree);
					}

					}
					break;
				case 2 :
					// Python.g:363:9: stmt
					{
					pushFollow(FOLLOW_stmt_in_file_input225);
					stmt10=stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, stmt10.getTree());

					if ( state.backtracking==0 ) {
					          if ((stmt10!=null?((PythonParser.stmt_return)stmt10).stypes:null) != null) {
					              stypes.addAll((stmt10!=null?((PythonParser.stmt_return)stmt10).stypes:null));
					          }
					      }
					}
					break;

				default :
					break loop5;
				}
			}

			EOF11=(Token)match(input,EOF,FOLLOW_EOF_in_file_input244); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			EOF11_tree = (PythonTree)adaptor.create(EOF11);
			adaptor.addChild(root_0, EOF11_tree);
			}

			if ( state.backtracking==0 ) {
			             mtype = new Module((retval.start), actions.castStmts(stypes));
			         }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (!stypes.isEmpty()) {
			        //The EOF token messes up the end offsets, so set them manually.
			        //XXX: this may no longer be true now that PythonTokenSource is
			        //     adjusting EOF offsets -- but needs testing before I remove
			        //     this.
			        PythonTree stop = (PythonTree)stypes.get(stypes.size() -1);
			        mtype.setCharStopIndex(stop.getCharStopIndex());
			        mtype.setTokenStopIndex(stop.getTokenStopIndex());
			    }

			    retval.tree = mtype;
			}
		}
		catch (RecognitionException re) {

			        reportError(re);
			        errorHandler.recover(this, input,re);
			        PythonTree badNode = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			        retval.tree = new ErrorMod(badNode);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "file_input"


	public static class eval_input_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "eval_input"
	// Python.g:383:1: eval_input : ( LEADING_WS )? ( NEWLINE )* testlist[expr_contextType.Load] ( NEWLINE )* EOF ;
	public final PythonParser.eval_input_return eval_input() throws RecognitionException {
		PythonParser.eval_input_return retval = new PythonParser.eval_input_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token LEADING_WS12=null;
		Token NEWLINE13=null;
		Token NEWLINE15=null;
		Token EOF16=null;
		ParserRuleReturnScope testlist14 =null;

		PythonTree LEADING_WS12_tree=null;
		PythonTree NEWLINE13_tree=null;
		PythonTree NEWLINE15_tree=null;
		PythonTree EOF16_tree=null;


		    mod mtype = null;

		try {
			// Python.g:390:5: ( ( LEADING_WS )? ( NEWLINE )* testlist[expr_contextType.Load] ( NEWLINE )* EOF )
			// Python.g:390:7: ( LEADING_WS )? ( NEWLINE )* testlist[expr_contextType.Load] ( NEWLINE )* EOF
			{
			root_0 = (PythonTree)adaptor.nil();


			// Python.g:390:7: ( LEADING_WS )?
			int alt6=2;
			int LA6_0 = input.LA(1);
			if ( (LA6_0==LEADING_WS) ) {
				alt6=1;
			}
			switch (alt6) {
				case 1 :
					// Python.g:390:7: LEADING_WS
					{
					LEADING_WS12=(Token)match(input,LEADING_WS,FOLLOW_LEADING_WS_in_eval_input298); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LEADING_WS12_tree = (PythonTree)adaptor.create(LEADING_WS12);
					adaptor.addChild(root_0, LEADING_WS12_tree);
					}

					}
					break;

			}

			// Python.g:390:19: ( NEWLINE )*
			loop7:
			while (true) {
				int alt7=2;
				int LA7_0 = input.LA(1);
				if ( (LA7_0==NEWLINE) ) {
					alt7=1;
				}

				switch (alt7) {
				case 1 :
					// Python.g:390:20: NEWLINE
					{
					NEWLINE13=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_eval_input302); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NEWLINE13_tree = (PythonTree)adaptor.create(NEWLINE13);
					adaptor.addChild(root_0, NEWLINE13_tree);
					}

					}
					break;

				default :
					break loop7;
				}
			}

			pushFollow(FOLLOW_testlist_in_eval_input306);
			testlist14=testlist(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist14.getTree());

			// Python.g:390:62: ( NEWLINE )*
			loop8:
			while (true) {
				int alt8=2;
				int LA8_0 = input.LA(1);
				if ( (LA8_0==NEWLINE) ) {
					alt8=1;
				}

				switch (alt8) {
				case 1 :
					// Python.g:390:63: NEWLINE
					{
					NEWLINE15=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_eval_input310); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NEWLINE15_tree = (PythonTree)adaptor.create(NEWLINE15);
					adaptor.addChild(root_0, NEWLINE15_tree);
					}

					}
					break;

				default :
					break loop8;
				}
			}

			EOF16=(Token)match(input,EOF,FOLLOW_EOF_in_eval_input314); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			EOF16_tree = (PythonTree)adaptor.create(EOF16);
			adaptor.addChild(root_0, EOF16_tree);
			}

			if ( state.backtracking==0 ) {
			        mtype = new Expression((retval.start), actions.castExpr((testlist14!=null?((PythonTree)testlist14.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = mtype;
			}
		}
		catch (RecognitionException re) {

			        reportError(re);
			        errorHandler.recover(this, input,re);
			        PythonTree badNode = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
			        retval.tree = new ErrorMod(badNode);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "eval_input"


	public static class dotted_attr_return extends ParserRuleReturnScope {
		public expr etype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "dotted_attr"
	// Python.g:405:1: dotted_attr returns [expr etype] : n1= NAME ( ( DOT n2+= NAME )+ |) ;
	public final PythonParser.dotted_attr_return dotted_attr() throws RecognitionException {
		PythonParser.dotted_attr_return retval = new PythonParser.dotted_attr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token n1=null;
		Token DOT17=null;
		Token n2=null;
		List<Object> list_n2=null;

		PythonTree n1_tree=null;
		PythonTree DOT17_tree=null;
		PythonTree n2_tree=null;

		try {
			// Python.g:407:5: (n1= NAME ( ( DOT n2+= NAME )+ |) )
			// Python.g:407:7: n1= NAME ( ( DOT n2+= NAME )+ |)
			{
			root_0 = (PythonTree)adaptor.nil();


			n1=(Token)match(input,NAME,FOLLOW_NAME_in_dotted_attr366); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			n1_tree = (PythonTree)adaptor.create(n1);
			adaptor.addChild(root_0, n1_tree);
			}

			// Python.g:408:7: ( ( DOT n2+= NAME )+ |)
			int alt10=2;
			int LA10_0 = input.LA(1);
			if ( (LA10_0==DOT) ) {
				alt10=1;
			}
			else if ( (LA10_0==LPAREN||LA10_0==NEWLINE) ) {
				alt10=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 10, 0, input);
				throw nvae;
			}

			switch (alt10) {
				case 1 :
					// Python.g:408:9: ( DOT n2+= NAME )+
					{
					// Python.g:408:9: ( DOT n2+= NAME )+
					int cnt9=0;
					loop9:
					while (true) {
						int alt9=2;
						int LA9_0 = input.LA(1);
						if ( (LA9_0==DOT) ) {
							alt9=1;
						}

						switch (alt9) {
						case 1 :
							// Python.g:408:10: DOT n2+= NAME
							{
							DOT17=(Token)match(input,DOT,FOLLOW_DOT_in_dotted_attr377); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							DOT17_tree = (PythonTree)adaptor.create(DOT17);
							adaptor.addChild(root_0, DOT17_tree);
							}

							n2=(Token)match(input,NAME,FOLLOW_NAME_in_dotted_attr381); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							n2_tree = (PythonTree)adaptor.create(n2);
							adaptor.addChild(root_0, n2_tree);
							}

							if (list_n2==null) list_n2=new ArrayList<Object>();
							list_n2.add(n2);
							}
							break;

						default :
							if ( cnt9 >= 1 ) break loop9;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(9, input);
							throw eee;
						}
						cnt9++;
					}

					if ( state.backtracking==0 ) {
					            retval.etype = actions.makeDottedAttr(n1, list_n2);
					        }
					}
					break;
				case 2 :
					// Python.g:413:9: 
					{
					if ( state.backtracking==0 ) {
					            retval.etype = actions.makeNameNode(n1);
					        }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "dotted_attr"


	public static class name_or_print_return extends ParserRuleReturnScope {
		public Token tok;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "name_or_print"
	// Python.g:421:1: name_or_print returns [Token tok] : ( NAME |{...}? => PRINT );
	public final PythonParser.name_or_print_return name_or_print() throws RecognitionException {
		PythonParser.name_or_print_return retval = new PythonParser.name_or_print_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NAME18=null;
		Token PRINT19=null;

		PythonTree NAME18_tree=null;
		PythonTree PRINT19_tree=null;

		try {
			// Python.g:423:5: ( NAME |{...}? => PRINT )
			int alt11=2;
			int LA11_0 = input.LA(1);
			if ( (LA11_0==NAME) ) {
				alt11=1;
			}
			else if ( (LA11_0==PRINT) && ((printFunction))) {
				alt11=2;
			}

			switch (alt11) {
				case 1 :
					// Python.g:423:7: NAME
					{
					root_0 = (PythonTree)adaptor.nil();


					NAME18=(Token)match(input,NAME,FOLLOW_NAME_in_name_or_print446); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NAME18_tree = (PythonTree)adaptor.create(NAME18);
					adaptor.addChild(root_0, NAME18_tree);
					}

					if ( state.backtracking==0 ) {
					        retval.tok = (retval.start);
					    }
					}
					break;
				case 2 :
					// Python.g:426:7: {...}? => PRINT
					{
					root_0 = (PythonTree)adaptor.nil();


					if ( !((printFunction)) ) {
						if (state.backtracking>0) {state.failed=true; return retval;}
						throw new FailedPredicateException(input, "name_or_print", "printFunction");
					}
					PRINT19=(Token)match(input,PRINT,FOLLOW_PRINT_in_name_or_print460); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					PRINT19_tree = (PythonTree)adaptor.create(PRINT19);
					adaptor.addChild(root_0, PRINT19_tree);
					}

					if ( state.backtracking==0 ) {
					        retval.tok = (retval.start);
					    }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "name_or_print"


	public static class attr_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "attr"
	// Python.g:435:1: attr : ( NAME | AND | AS | ASSERT | BREAK | CLASS | CONTINUE | DEF | DELETE | ELIF | EXCEPT | EXEC | FINALLY | FROM | FOR | GLOBAL | IF | IMPORT | IN | IS | LAMBDA | NOT | OR | ORELSE | PASS | PRINT | RAISE | RETURN | TRY | WHILE | WITH | YIELD );
	public final PythonParser.attr_return attr() throws RecognitionException {
		PythonParser.attr_return retval = new PythonParser.attr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token set20=null;

		PythonTree set20_tree=null;

		try {
			// Python.g:436:5: ( NAME | AND | AS | ASSERT | BREAK | CLASS | CONTINUE | DEF | DELETE | ELIF | EXCEPT | EXEC | FINALLY | FROM | FOR | GLOBAL | IF | IMPORT | IN | IS | LAMBDA | NOT | OR | ORELSE | PASS | PRINT | RAISE | RETURN | TRY | WHILE | WITH | YIELD )
			// Python.g:
			{
			root_0 = (PythonTree)adaptor.nil();


			set20=input.LT(1);
			if ( (input.LA(1) >= AND && input.LA(1) <= ASSERT)||input.LA(1)==BREAK||input.LA(1)==CLASS||input.LA(1)==CONTINUE||(input.LA(1) >= DEF && input.LA(1) <= DELETE)||input.LA(1)==ELIF||(input.LA(1) >= EXCEPT && input.LA(1) <= EXEC)||input.LA(1)==FINALLY||(input.LA(1) >= FOR && input.LA(1) <= GLOBAL)||(input.LA(1) >= IF && input.LA(1) <= IN)||(input.LA(1) >= IS && input.LA(1) <= LAMBDA)||input.LA(1)==NAME||input.LA(1)==NOT||(input.LA(1) >= OR && input.LA(1) <= PASS)||(input.LA(1) >= PRINT && input.LA(1) <= RAISE)||input.LA(1)==RETURN||input.LA(1)==TRY||(input.LA(1) >= WHILE && input.LA(1) <= WITH)||input.LA(1)==YIELD ) {
				input.consume();
				if ( state.backtracking==0 ) adaptor.addChild(root_0, (PythonTree)adaptor.create(set20));
				state.errorRecovery=false;
				state.failed=false;
			}
			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				MismatchedSetException mse = new MismatchedSetException(null,input);
				throw mse;
			}
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "attr"


	public static class decorator_return extends ParserRuleReturnScope {
		public expr etype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "decorator"
	// Python.g:471:1: decorator returns [expr etype] : AT dotted_attr ( LPAREN ( arglist |) RPAREN |) NEWLINE ;
	public final PythonParser.decorator_return decorator() throws RecognitionException {
		PythonParser.decorator_return retval = new PythonParser.decorator_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token AT21=null;
		Token LPAREN23=null;
		Token RPAREN25=null;
		Token NEWLINE26=null;
		ParserRuleReturnScope dotted_attr22 =null;
		ParserRuleReturnScope arglist24 =null;

		PythonTree AT21_tree=null;
		PythonTree LPAREN23_tree=null;
		PythonTree RPAREN25_tree=null;
		PythonTree NEWLINE26_tree=null;

		try {
			// Python.g:476:5: ( AT dotted_attr ( LPAREN ( arglist |) RPAREN |) NEWLINE )
			// Python.g:476:7: AT dotted_attr ( LPAREN ( arglist |) RPAREN |) NEWLINE
			{
			root_0 = (PythonTree)adaptor.nil();


			AT21=(Token)match(input,AT,FOLLOW_AT_in_decorator762); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			AT21_tree = (PythonTree)adaptor.create(AT21);
			adaptor.addChild(root_0, AT21_tree);
			}

			pushFollow(FOLLOW_dotted_attr_in_decorator764);
			dotted_attr22=dotted_attr();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, dotted_attr22.getTree());

			// Python.g:477:5: ( LPAREN ( arglist |) RPAREN |)
			int alt13=2;
			int LA13_0 = input.LA(1);
			if ( (LA13_0==LPAREN) ) {
				alt13=1;
			}
			else if ( (LA13_0==NEWLINE) ) {
				alt13=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 13, 0, input);
				throw nvae;
			}

			switch (alt13) {
				case 1 :
					// Python.g:477:7: LPAREN ( arglist |) RPAREN
					{
					LPAREN23=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_decorator772); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LPAREN23_tree = (PythonTree)adaptor.create(LPAREN23);
					adaptor.addChild(root_0, LPAREN23_tree);
					}

					// Python.g:478:7: ( arglist |)
					int alt12=2;
					int LA12_0 = input.LA(1);
					if ( (LA12_0==BACKQUOTE||(LA12_0 >= LBRACK && LA12_0 <= LCURLY)||(LA12_0 >= LPAREN && LA12_0 <= MINUS)||LA12_0==NAME||LA12_0==NOT||LA12_0==PLUS||LA12_0==TILDE) ) {
						alt12=1;
					}
					else if ( (LA12_0==PRINT) && ((printFunction))) {
						alt12=1;
					}
					else if ( (LA12_0==COMPLEX||LA12_0==DOUBLESTAR||LA12_0==FLOAT||LA12_0==INT||LA12_0==LAMBDA||LA12_0==LONGINT||LA12_0==STAR||LA12_0==STRING) ) {
						alt12=1;
					}
					else if ( (LA12_0==RPAREN) ) {
						alt12=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 12, 0, input);
						throw nvae;
					}

					switch (alt12) {
						case 1 :
							// Python.g:478:9: arglist
							{
							pushFollow(FOLLOW_arglist_in_decorator782);
							arglist24=arglist();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, arglist24.getTree());

							if ( state.backtracking==0 ) {
							            retval.etype = actions.makeCall(LPAREN23, (dotted_attr22!=null?((PythonParser.dotted_attr_return)dotted_attr22).etype:null), (arglist24!=null?((PythonParser.arglist_return)arglist24).args:null), (arglist24!=null?((PythonParser.arglist_return)arglist24).keywords:null),
							                     (arglist24!=null?((PythonParser.arglist_return)arglist24).starargs:null), (arglist24!=null?((PythonParser.arglist_return)arglist24).kwargs:null));
							        }
							}
							break;
						case 2 :
							// Python.g:484:9: 
							{
							if ( state.backtracking==0 ) {
							            retval.etype = actions.makeCall(LPAREN23, (dotted_attr22!=null?((PythonParser.dotted_attr_return)dotted_attr22).etype:null));
							        }
							}
							break;

					}

					RPAREN25=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_decorator826); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RPAREN25_tree = (PythonTree)adaptor.create(RPAREN25);
					adaptor.addChild(root_0, RPAREN25_tree);
					}

					}
					break;
				case 2 :
					// Python.g:490:7: 
					{
					if ( state.backtracking==0 ) {
					          retval.etype = (dotted_attr22!=null?((PythonParser.dotted_attr_return)dotted_attr22).etype:null);
					      }
					}
					break;

			}

			NEWLINE26=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_decorator848); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			NEWLINE26_tree = (PythonTree)adaptor.create(NEWLINE26);
			adaptor.addChild(root_0, NEWLINE26_tree);
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = retval.etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "decorator"


	public static class decorators_return extends ParserRuleReturnScope {
		public List etypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "decorators"
	// Python.g:497:1: decorators returns [List etypes] : (d+= decorator )+ ;
	public final PythonParser.decorators_return decorators() throws RecognitionException {
		PythonParser.decorators_return retval = new PythonParser.decorators_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		List<Object> list_d=null;
		RuleReturnScope d = null;

		try {
			// Python.g:499:5: ( (d+= decorator )+ )
			// Python.g:499:7: (d+= decorator )+
			{
			root_0 = (PythonTree)adaptor.nil();


			// Python.g:499:8: (d+= decorator )+
			int cnt14=0;
			loop14:
			while (true) {
				int alt14=2;
				int LA14_0 = input.LA(1);
				if ( (LA14_0==AT) ) {
					alt14=1;
				}

				switch (alt14) {
				case 1 :
					// Python.g:499:8: d+= decorator
					{
					pushFollow(FOLLOW_decorator_in_decorators876);
					d=decorator();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, d.getTree());

					if (list_d==null) list_d=new ArrayList<Object>();
					list_d.add(d.getTree());
					}
					break;

				default :
					if ( cnt14 >= 1 ) break loop14;
					if (state.backtracking>0) {state.failed=true; return retval;}
					EarlyExitException eee = new EarlyExitException(14, input);
					throw eee;
				}
				cnt14++;
			}

			if ( state.backtracking==0 ) {
			          retval.etypes = list_d;
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "decorators"


	public static class funcdef_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "funcdef"
	// Python.g:506:1: funcdef : ( decorators )? DEF name_or_print parameters COLON suite[false] ;
	public final PythonParser.funcdef_return funcdef() throws RecognitionException {
		PythonParser.funcdef_return retval = new PythonParser.funcdef_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token DEF28=null;
		Token COLON31=null;
		ParserRuleReturnScope decorators27 =null;
		ParserRuleReturnScope name_or_print29 =null;
		ParserRuleReturnScope parameters30 =null;
		ParserRuleReturnScope suite32 =null;

		PythonTree DEF28_tree=null;
		PythonTree COLON31_tree=null;


		    stmt stype = null;

		try {
			// Python.g:514:5: ( ( decorators )? DEF name_or_print parameters COLON suite[false] )
			// Python.g:514:7: ( decorators )? DEF name_or_print parameters COLON suite[false]
			{
			root_0 = (PythonTree)adaptor.nil();


			// Python.g:514:7: ( decorators )?
			int alt15=2;
			int LA15_0 = input.LA(1);
			if ( (LA15_0==AT) ) {
				alt15=1;
			}
			switch (alt15) {
				case 1 :
					// Python.g:514:7: decorators
					{
					pushFollow(FOLLOW_decorators_in_funcdef914);
					decorators27=decorators();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, decorators27.getTree());

					}
					break;

			}

			DEF28=(Token)match(input,DEF,FOLLOW_DEF_in_funcdef917); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			DEF28_tree = (PythonTree)adaptor.create(DEF28);
			adaptor.addChild(root_0, DEF28_tree);
			}

			pushFollow(FOLLOW_name_or_print_in_funcdef919);
			name_or_print29=name_or_print();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, name_or_print29.getTree());

			pushFollow(FOLLOW_parameters_in_funcdef921);
			parameters30=parameters();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, parameters30.getTree());

			COLON31=(Token)match(input,COLON,FOLLOW_COLON_in_funcdef923); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON31_tree = (PythonTree)adaptor.create(COLON31);
			adaptor.addChild(root_0, COLON31_tree);
			}

			pushFollow(FOLLOW_suite_in_funcdef925);
			suite32=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, suite32.getTree());

			if ( state.backtracking==0 ) {
			        Token t = DEF28;
			        if ((decorators27!=null?(decorators27.start):null) != null) {
			            t = (decorators27!=null?(decorators27.start):null);
			        }
			        stype = actions.makeFuncdef(t, (name_or_print29!=null?(name_or_print29.start):null), (parameters30!=null?((PythonParser.parameters_return)parameters30).args:null), (suite32!=null?((PythonParser.suite_return)suite32).stypes:null), (decorators27!=null?((PythonParser.decorators_return)decorators27).etypes:null));
			    }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "funcdef"


	public static class parameters_return extends ParserRuleReturnScope {
		public arguments args;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "parameters"
	// Python.g:525:1: parameters returns [arguments args] : LPAREN ( varargslist |) RPAREN ;
	public final PythonParser.parameters_return parameters() throws RecognitionException {
		PythonParser.parameters_return retval = new PythonParser.parameters_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token LPAREN33=null;
		Token RPAREN35=null;
		ParserRuleReturnScope varargslist34 =null;

		PythonTree LPAREN33_tree=null;
		PythonTree RPAREN35_tree=null;

		try {
			// Python.g:527:5: ( LPAREN ( varargslist |) RPAREN )
			// Python.g:527:7: LPAREN ( varargslist |) RPAREN
			{
			root_0 = (PythonTree)adaptor.nil();


			LPAREN33=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_parameters958); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			LPAREN33_tree = (PythonTree)adaptor.create(LPAREN33);
			adaptor.addChild(root_0, LPAREN33_tree);
			}

			// Python.g:528:7: ( varargslist |)
			int alt16=2;
			int LA16_0 = input.LA(1);
			if ( (LA16_0==DOUBLESTAR||LA16_0==LPAREN||LA16_0==NAME||LA16_0==STAR) ) {
				alt16=1;
			}
			else if ( (LA16_0==RPAREN) ) {
				alt16=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 16, 0, input);
				throw nvae;
			}

			switch (alt16) {
				case 1 :
					// Python.g:528:8: varargslist
					{
					pushFollow(FOLLOW_varargslist_in_parameters967);
					varargslist34=varargslist();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, varargslist34.getTree());

					if ( state.backtracking==0 ) {
					              retval.args = (varargslist34!=null?((PythonParser.varargslist_return)varargslist34).args:null);
					        }
					}
					break;
				case 2 :
					// Python.g:533:9: 
					{
					if ( state.backtracking==0 ) {
					            retval.args = new arguments((retval.start), new ArrayList<expr>(), (Name)null, null, new ArrayList<expr>());
					        }
					}
					break;

			}

			RPAREN35=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_parameters1011); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			RPAREN35_tree = (PythonTree)adaptor.create(RPAREN35);
			adaptor.addChild(root_0, RPAREN35_tree);
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "parameters"


	public static class defparameter_return extends ParserRuleReturnScope {
		public expr etype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "defparameter"
	// Python.g:541:1: defparameter[List defaults] returns [expr etype] : fpdef[expr_contextType.Param] ( ASSIGN test[expr_contextType.Load] )? ;
	public final PythonParser.defparameter_return defparameter(List defaults) throws RecognitionException {
		PythonParser.defparameter_return retval = new PythonParser.defparameter_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token ASSIGN37=null;
		ParserRuleReturnScope fpdef36 =null;
		ParserRuleReturnScope test38 =null;

		PythonTree ASSIGN37_tree=null;

		try {
			// Python.g:546:5: ( fpdef[expr_contextType.Param] ( ASSIGN test[expr_contextType.Load] )? )
			// Python.g:546:7: fpdef[expr_contextType.Param] ( ASSIGN test[expr_contextType.Load] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_fpdef_in_defparameter1044);
			fpdef36=fpdef(expr_contextType.Param);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, fpdef36.getTree());

			// Python.g:546:37: ( ASSIGN test[expr_contextType.Load] )?
			int alt17=2;
			int LA17_0 = input.LA(1);
			if ( (LA17_0==ASSIGN) ) {
				alt17=1;
			}
			switch (alt17) {
				case 1 :
					// Python.g:546:38: ASSIGN test[expr_contextType.Load]
					{
					ASSIGN37=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_defparameter1048); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ASSIGN37_tree = (PythonTree)adaptor.create(ASSIGN37);
					adaptor.addChild(root_0, ASSIGN37_tree);
					}

					pushFollow(FOLLOW_test_in_defparameter1050);
					test38=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, test38.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          retval.etype = actions.castExpr((fpdef36!=null?((PythonTree)fpdef36.getTree()):null));
			          if (ASSIGN37 != null) {
			              defaults.add((test38!=null?((PythonTree)test38.getTree()):null));
			          } else if (!defaults.isEmpty()) {
			              throw new ParseException("non-default argument follows default argument",
			                  (fpdef36!=null?((PythonTree)fpdef36.getTree()):null), true);
			          }
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = retval.etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "defparameter"


	public static class varargslist_return extends ParserRuleReturnScope {
		public arguments args;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "varargslist"
	// Python.g:561:1: varargslist returns [arguments args] : (d+= defparameter[defaults] ( options {greedy=true; } : COMMA d+= defparameter[defaults] )* ( COMMA ( STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )? )? | STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME );
	public final PythonParser.varargslist_return varargslist() throws RecognitionException {
		PythonParser.varargslist_return retval = new PythonParser.varargslist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token starargs=null;
		Token kwargs=null;
		Token COMMA39=null;
		Token COMMA40=null;
		Token STAR41=null;
		Token COMMA42=null;
		Token DOUBLESTAR43=null;
		Token DOUBLESTAR44=null;
		Token STAR45=null;
		Token COMMA46=null;
		Token DOUBLESTAR47=null;
		Token DOUBLESTAR48=null;
		List<Object> list_d=null;
		RuleReturnScope d = null;
		PythonTree starargs_tree=null;
		PythonTree kwargs_tree=null;
		PythonTree COMMA39_tree=null;
		PythonTree COMMA40_tree=null;
		PythonTree STAR41_tree=null;
		PythonTree COMMA42_tree=null;
		PythonTree DOUBLESTAR43_tree=null;
		PythonTree DOUBLESTAR44_tree=null;
		PythonTree STAR45_tree=null;
		PythonTree COMMA46_tree=null;
		PythonTree DOUBLESTAR47_tree=null;
		PythonTree DOUBLESTAR48_tree=null;


		    List defaults = new ArrayList();

		try {
			// Python.g:566:5: (d+= defparameter[defaults] ( options {greedy=true; } : COMMA d+= defparameter[defaults] )* ( COMMA ( STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )? )? | STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )
			int alt23=3;
			switch ( input.LA(1) ) {
			case LPAREN:
			case NAME:
				{
				alt23=1;
				}
				break;
			case STAR:
				{
				alt23=2;
				}
				break;
			case DOUBLESTAR:
				{
				alt23=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 23, 0, input);
				throw nvae;
			}
			switch (alt23) {
				case 1 :
					// Python.g:566:7: d+= defparameter[defaults] ( options {greedy=true; } : COMMA d+= defparameter[defaults] )* ( COMMA ( STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )? )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_defparameter_in_varargslist1096);
					d=defparameter(defaults);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, d.getTree());

					if (list_d==null) list_d=new ArrayList<Object>();
					list_d.add(d.getTree());
					// Python.g:566:33: ( options {greedy=true; } : COMMA d+= defparameter[defaults] )*
					loop18:
					while (true) {
						int alt18=2;
						int LA18_0 = input.LA(1);
						if ( (LA18_0==COMMA) ) {
							int LA18_1 = input.LA(2);
							if ( (LA18_1==LPAREN||LA18_1==NAME) ) {
								alt18=1;
							}

						}

						switch (alt18) {
						case 1 :
							// Python.g:566:57: COMMA d+= defparameter[defaults]
							{
							COMMA39=(Token)match(input,COMMA,FOLLOW_COMMA_in_varargslist1107); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA39_tree = (PythonTree)adaptor.create(COMMA39);
							adaptor.addChild(root_0, COMMA39_tree);
							}

							pushFollow(FOLLOW_defparameter_in_varargslist1111);
							d=defparameter(defaults);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, d.getTree());

							if (list_d==null) list_d=new ArrayList<Object>();
							list_d.add(d.getTree());
							}
							break;

						default :
							break loop18;
						}
					}

					// Python.g:567:7: ( COMMA ( STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )? )?
					int alt21=2;
					int LA21_0 = input.LA(1);
					if ( (LA21_0==COMMA) ) {
						alt21=1;
					}
					switch (alt21) {
						case 1 :
							// Python.g:567:8: COMMA ( STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )?
							{
							COMMA40=(Token)match(input,COMMA,FOLLOW_COMMA_in_varargslist1123); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA40_tree = (PythonTree)adaptor.create(COMMA40);
							adaptor.addChild(root_0, COMMA40_tree);
							}

							// Python.g:568:11: ( STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )? | DOUBLESTAR kwargs= NAME )?
							int alt20=3;
							int LA20_0 = input.LA(1);
							if ( (LA20_0==STAR) ) {
								alt20=1;
							}
							else if ( (LA20_0==DOUBLESTAR) ) {
								alt20=2;
							}
							switch (alt20) {
								case 1 :
									// Python.g:568:12: STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )?
									{
									STAR41=(Token)match(input,STAR,FOLLOW_STAR_in_varargslist1136); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									STAR41_tree = (PythonTree)adaptor.create(STAR41);
									adaptor.addChild(root_0, STAR41_tree);
									}

									starargs=(Token)match(input,NAME,FOLLOW_NAME_in_varargslist1140); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									starargs_tree = (PythonTree)adaptor.create(starargs);
									adaptor.addChild(root_0, starargs_tree);
									}

									// Python.g:568:31: ( COMMA DOUBLESTAR kwargs= NAME )?
									int alt19=2;
									int LA19_0 = input.LA(1);
									if ( (LA19_0==COMMA) ) {
										alt19=1;
									}
									switch (alt19) {
										case 1 :
											// Python.g:568:32: COMMA DOUBLESTAR kwargs= NAME
											{
											COMMA42=(Token)match(input,COMMA,FOLLOW_COMMA_in_varargslist1143); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											COMMA42_tree = (PythonTree)adaptor.create(COMMA42);
											adaptor.addChild(root_0, COMMA42_tree);
											}

											DOUBLESTAR43=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist1145); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											DOUBLESTAR43_tree = (PythonTree)adaptor.create(DOUBLESTAR43);
											adaptor.addChild(root_0, DOUBLESTAR43_tree);
											}

											kwargs=(Token)match(input,NAME,FOLLOW_NAME_in_varargslist1149); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											kwargs_tree = (PythonTree)adaptor.create(kwargs);
											adaptor.addChild(root_0, kwargs_tree);
											}

											}
											break;

									}

									}
									break;
								case 2 :
									// Python.g:569:13: DOUBLESTAR kwargs= NAME
									{
									DOUBLESTAR44=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist1165); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									DOUBLESTAR44_tree = (PythonTree)adaptor.create(DOUBLESTAR44);
									adaptor.addChild(root_0, DOUBLESTAR44_tree);
									}

									kwargs=(Token)match(input,NAME,FOLLOW_NAME_in_varargslist1169); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									kwargs_tree = (PythonTree)adaptor.create(kwargs);
									adaptor.addChild(root_0, kwargs_tree);
									}

									}
									break;

							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          retval.args = actions.makeArgumentsType((retval.start), list_d, starargs, kwargs, defaults);
					      }
					}
					break;
				case 2 :
					// Python.g:575:7: STAR starargs= NAME ( COMMA DOUBLESTAR kwargs= NAME )?
					{
					root_0 = (PythonTree)adaptor.nil();


					STAR45=(Token)match(input,STAR,FOLLOW_STAR_in_varargslist1207); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					STAR45_tree = (PythonTree)adaptor.create(STAR45);
					adaptor.addChild(root_0, STAR45_tree);
					}

					starargs=(Token)match(input,NAME,FOLLOW_NAME_in_varargslist1211); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					starargs_tree = (PythonTree)adaptor.create(starargs);
					adaptor.addChild(root_0, starargs_tree);
					}

					// Python.g:575:26: ( COMMA DOUBLESTAR kwargs= NAME )?
					int alt22=2;
					int LA22_0 = input.LA(1);
					if ( (LA22_0==COMMA) ) {
						alt22=1;
					}
					switch (alt22) {
						case 1 :
							// Python.g:575:27: COMMA DOUBLESTAR kwargs= NAME
							{
							COMMA46=(Token)match(input,COMMA,FOLLOW_COMMA_in_varargslist1214); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA46_tree = (PythonTree)adaptor.create(COMMA46);
							adaptor.addChild(root_0, COMMA46_tree);
							}

							DOUBLESTAR47=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist1216); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							DOUBLESTAR47_tree = (PythonTree)adaptor.create(DOUBLESTAR47);
							adaptor.addChild(root_0, DOUBLESTAR47_tree);
							}

							kwargs=(Token)match(input,NAME,FOLLOW_NAME_in_varargslist1220); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							kwargs_tree = (PythonTree)adaptor.create(kwargs);
							adaptor.addChild(root_0, kwargs_tree);
							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          retval.args = actions.makeArgumentsType((retval.start), list_d, starargs, kwargs, defaults);
					      }
					}
					break;
				case 3 :
					// Python.g:579:7: DOUBLESTAR kwargs= NAME
					{
					root_0 = (PythonTree)adaptor.nil();


					DOUBLESTAR48=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_varargslist1238); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOUBLESTAR48_tree = (PythonTree)adaptor.create(DOUBLESTAR48);
					adaptor.addChild(root_0, DOUBLESTAR48_tree);
					}

					kwargs=(Token)match(input,NAME,FOLLOW_NAME_in_varargslist1242); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					kwargs_tree = (PythonTree)adaptor.create(kwargs);
					adaptor.addChild(root_0, kwargs_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.args = actions.makeArgumentsType((retval.start), list_d, null, kwargs, defaults);
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "varargslist"


	public static class fpdef_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "fpdef"
	// Python.g:586:1: fpdef[expr_contextType ctype] : ( NAME | ( LPAREN fpdef[null] COMMA )=> LPAREN fplist RPAREN | LPAREN ! fplist RPAREN !);
	public final PythonParser.fpdef_return fpdef(expr_contextType ctype) throws RecognitionException {
		PythonParser.fpdef_return retval = new PythonParser.fpdef_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NAME49=null;
		Token LPAREN50=null;
		Token RPAREN52=null;
		Token LPAREN53=null;
		Token RPAREN55=null;
		ParserRuleReturnScope fplist51 =null;
		ParserRuleReturnScope fplist54 =null;

		PythonTree NAME49_tree=null;
		PythonTree LPAREN50_tree=null;
		PythonTree RPAREN52_tree=null;
		PythonTree LPAREN53_tree=null;
		PythonTree RPAREN55_tree=null;


		    expr etype = null;

		try {
			// Python.g:596:5: ( NAME | ( LPAREN fpdef[null] COMMA )=> LPAREN fplist RPAREN | LPAREN ! fplist RPAREN !)
			int alt24=3;
			int LA24_0 = input.LA(1);
			if ( (LA24_0==NAME) ) {
				alt24=1;
			}
			else if ( (LA24_0==LPAREN) ) {
				int LA24_2 = input.LA(2);
				if ( (synpred1_Python()) ) {
					alt24=2;
				}
				else if ( (true) ) {
					alt24=3;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 24, 0, input);
				throw nvae;
			}

			switch (alt24) {
				case 1 :
					// Python.g:596:7: NAME
					{
					root_0 = (PythonTree)adaptor.nil();


					NAME49=(Token)match(input,NAME,FOLLOW_NAME_in_fpdef1279); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NAME49_tree = (PythonTree)adaptor.create(NAME49);
					adaptor.addChild(root_0, NAME49_tree);
					}

					if ( state.backtracking==0 ) {
					          etype = new Name(NAME49, (NAME49!=null?NAME49.getText():null), ctype);
					      }
					}
					break;
				case 2 :
					// Python.g:600:7: ( LPAREN fpdef[null] COMMA )=> LPAREN fplist RPAREN
					{
					root_0 = (PythonTree)adaptor.nil();


					LPAREN50=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_fpdef1306); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LPAREN50_tree = (PythonTree)adaptor.create(LPAREN50);
					adaptor.addChild(root_0, LPAREN50_tree);
					}

					pushFollow(FOLLOW_fplist_in_fpdef1308);
					fplist51=fplist();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, fplist51.getTree());

					RPAREN52=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_fpdef1310); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RPAREN52_tree = (PythonTree)adaptor.create(RPAREN52);
					adaptor.addChild(root_0, RPAREN52_tree);
					}

					if ( state.backtracking==0 ) {
					          etype = new Tuple((fplist51!=null?(fplist51.start):null), actions.castExprs((fplist51!=null?((PythonParser.fplist_return)fplist51).etypes:null)), expr_contextType.Store);
					      }
					}
					break;
				case 3 :
					// Python.g:604:7: LPAREN ! fplist RPAREN !
					{
					root_0 = (PythonTree)adaptor.nil();


					LPAREN53=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_fpdef1326); if (state.failed) return retval;
					pushFollow(FOLLOW_fplist_in_fpdef1329);
					fplist54=fplist();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, fplist54.getTree());

					RPAREN55=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_fpdef1331); if (state.failed) return retval;
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			    actions.checkAssign(actions.castExpr(retval.tree));
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fpdef"


	public static class fplist_return extends ParserRuleReturnScope {
		public List etypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "fplist"
	// Python.g:608:1: fplist returns [List etypes] :f+= fpdef[expr_contextType.Store] ( options {greedy=true; } : COMMA f+= fpdef[expr_contextType.Store] )* ( COMMA )? ;
	public final PythonParser.fplist_return fplist() throws RecognitionException {
		PythonParser.fplist_return retval = new PythonParser.fplist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA56=null;
		Token COMMA57=null;
		List<Object> list_f=null;
		RuleReturnScope f = null;
		PythonTree COMMA56_tree=null;
		PythonTree COMMA57_tree=null;

		try {
			// Python.g:610:5: (f+= fpdef[expr_contextType.Store] ( options {greedy=true; } : COMMA f+= fpdef[expr_contextType.Store] )* ( COMMA )? )
			// Python.g:610:7: f+= fpdef[expr_contextType.Store] ( options {greedy=true; } : COMMA f+= fpdef[expr_contextType.Store] )* ( COMMA )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_fpdef_in_fplist1360);
			f=fpdef(expr_contextType.Store);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, f.getTree());

			if (list_f==null) list_f=new ArrayList<Object>();
			list_f.add(f.getTree());
			// Python.g:611:7: ( options {greedy=true; } : COMMA f+= fpdef[expr_contextType.Store] )*
			loop25:
			while (true) {
				int alt25=2;
				int LA25_0 = input.LA(1);
				if ( (LA25_0==COMMA) ) {
					int LA25_1 = input.LA(2);
					if ( (LA25_1==LPAREN||LA25_1==NAME) ) {
						alt25=1;
					}

				}

				switch (alt25) {
				case 1 :
					// Python.g:611:31: COMMA f+= fpdef[expr_contextType.Store]
					{
					COMMA56=(Token)match(input,COMMA,FOLLOW_COMMA_in_fplist1377); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA56_tree = (PythonTree)adaptor.create(COMMA56);
					adaptor.addChild(root_0, COMMA56_tree);
					}

					pushFollow(FOLLOW_fpdef_in_fplist1381);
					f=fpdef(expr_contextType.Store);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, f.getTree());

					if (list_f==null) list_f=new ArrayList<Object>();
					list_f.add(f.getTree());
					}
					break;

				default :
					break loop25;
				}
			}

			// Python.g:611:72: ( COMMA )?
			int alt26=2;
			int LA26_0 = input.LA(1);
			if ( (LA26_0==COMMA) ) {
				alt26=1;
			}
			switch (alt26) {
				case 1 :
					// Python.g:611:73: COMMA
					{
					COMMA57=(Token)match(input,COMMA,FOLLOW_COMMA_in_fplist1387); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA57_tree = (PythonTree)adaptor.create(COMMA57);
					adaptor.addChild(root_0, COMMA57_tree);
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          retval.etypes = list_f;
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "fplist"


	public static class stmt_return extends ParserRuleReturnScope {
		public List stypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "stmt"
	// Python.g:618:1: stmt returns [List stypes] : ( simple_stmt | compound_stmt );
	public final PythonParser.stmt_return stmt() throws RecognitionException {
		PythonParser.stmt_return retval = new PythonParser.stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope simple_stmt58 =null;
		ParserRuleReturnScope compound_stmt59 =null;


		try {
			// Python.g:620:5: ( simple_stmt | compound_stmt )
			int alt27=2;
			int LA27_0 = input.LA(1);
			if ( (LA27_0==BACKQUOTE||(LA27_0 >= LBRACK && LA27_0 <= LCURLY)||(LA27_0 >= LPAREN && LA27_0 <= MINUS)||LA27_0==NAME||LA27_0==NOT||LA27_0==PLUS||LA27_0==TILDE) ) {
				alt27=1;
			}
			else if ( (LA27_0==PRINT) && (((printFunction)||(!printFunction)))) {
				alt27=1;
			}
			else if ( (LA27_0==ASSERT||LA27_0==BREAK||(LA27_0 >= COMPLEX && LA27_0 <= CONTINUE)||LA27_0==DELETE||LA27_0==EXEC||LA27_0==FLOAT||(LA27_0 >= FROM && LA27_0 <= GLOBAL)||LA27_0==IMPORT||LA27_0==INT||LA27_0==LAMBDA||LA27_0==LONGINT||LA27_0==PASS||LA27_0==RAISE||LA27_0==RETURN||LA27_0==STRING||LA27_0==YIELD) ) {
				alt27=1;
			}
			else if ( (LA27_0==AT||LA27_0==CLASS||LA27_0==DEF||LA27_0==FOR||LA27_0==IF||LA27_0==TRY||(LA27_0 >= WHILE && LA27_0 <= WITH)) ) {
				alt27=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 27, 0, input);
				throw nvae;
			}

			switch (alt27) {
				case 1 :
					// Python.g:620:7: simple_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_simple_stmt_in_stmt1423);
					simple_stmt58=simple_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, simple_stmt58.getTree());

					if ( state.backtracking==0 ) {
					          retval.stypes = (simple_stmt58!=null?((PythonParser.simple_stmt_return)simple_stmt58).stypes:null);
					      }
					}
					break;
				case 2 :
					// Python.g:624:7: compound_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_compound_stmt_in_stmt1439);
					compound_stmt59=compound_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, compound_stmt59.getTree());

					if ( state.backtracking==0 ) {
					          retval.stypes = new ArrayList();
					          retval.stypes.add((compound_stmt59!=null?((PythonTree)compound_stmt59.getTree()):null));
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "stmt"


	public static class simple_stmt_return extends ParserRuleReturnScope {
		public List stypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "simple_stmt"
	// Python.g:632:1: simple_stmt returns [List stypes] :s+= small_stmt ( options {greedy=true; } : SEMI s+= small_stmt )* ( SEMI )? NEWLINE ;
	public final PythonParser.simple_stmt_return simple_stmt() throws RecognitionException {
		PythonParser.simple_stmt_return retval = new PythonParser.simple_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token SEMI60=null;
		Token SEMI61=null;
		Token NEWLINE62=null;
		List<Object> list_s=null;
		RuleReturnScope s = null;
		PythonTree SEMI60_tree=null;
		PythonTree SEMI61_tree=null;
		PythonTree NEWLINE62_tree=null;

		try {
			// Python.g:634:5: (s+= small_stmt ( options {greedy=true; } : SEMI s+= small_stmt )* ( SEMI )? NEWLINE )
			// Python.g:634:7: s+= small_stmt ( options {greedy=true; } : SEMI s+= small_stmt )* ( SEMI )? NEWLINE
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_small_stmt_in_simple_stmt1475);
			s=small_stmt();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, s.getTree());

			if (list_s==null) list_s=new ArrayList<Object>();
			list_s.add(s.getTree());
			// Python.g:634:21: ( options {greedy=true; } : SEMI s+= small_stmt )*
			loop28:
			while (true) {
				int alt28=2;
				int LA28_0 = input.LA(1);
				if ( (LA28_0==SEMI) ) {
					int LA28_1 = input.LA(2);
					if ( (LA28_1==ASSERT||(LA28_1 >= BACKQUOTE && LA28_1 <= BREAK)||(LA28_1 >= COMPLEX && LA28_1 <= CONTINUE)||LA28_1==DELETE||LA28_1==EXEC||LA28_1==FLOAT||(LA28_1 >= FROM && LA28_1 <= GLOBAL)||LA28_1==IMPORT||LA28_1==INT||(LA28_1 >= LAMBDA && LA28_1 <= LCURLY)||(LA28_1 >= LONGINT && LA28_1 <= MINUS)||LA28_1==NAME||LA28_1==NOT||LA28_1==PASS||LA28_1==PLUS||(LA28_1 >= PRINT && LA28_1 <= RAISE)||LA28_1==RETURN||(LA28_1 >= STRING && LA28_1 <= TILDE)||LA28_1==YIELD) ) {
						alt28=1;
					}

				}

				switch (alt28) {
				case 1 :
					// Python.g:634:45: SEMI s+= small_stmt
					{
					SEMI60=(Token)match(input,SEMI,FOLLOW_SEMI_in_simple_stmt1485); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					SEMI60_tree = (PythonTree)adaptor.create(SEMI60);
					adaptor.addChild(root_0, SEMI60_tree);
					}

					pushFollow(FOLLOW_small_stmt_in_simple_stmt1489);
					s=small_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, s.getTree());

					if (list_s==null) list_s=new ArrayList<Object>();
					list_s.add(s.getTree());
					}
					break;

				default :
					break loop28;
				}
			}

			// Python.g:634:66: ( SEMI )?
			int alt29=2;
			int LA29_0 = input.LA(1);
			if ( (LA29_0==SEMI) ) {
				alt29=1;
			}
			switch (alt29) {
				case 1 :
					// Python.g:634:67: SEMI
					{
					SEMI61=(Token)match(input,SEMI,FOLLOW_SEMI_in_simple_stmt1494); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					SEMI61_tree = (PythonTree)adaptor.create(SEMI61);
					adaptor.addChild(root_0, SEMI61_tree);
					}

					}
					break;

			}

			NEWLINE62=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_simple_stmt1498); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			NEWLINE62_tree = (PythonTree)adaptor.create(NEWLINE62);
			adaptor.addChild(root_0, NEWLINE62_tree);
			}

			if ( state.backtracking==0 ) {
			          retval.stypes = list_s;
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "simple_stmt"


	public static class small_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "small_stmt"
	// Python.g:642:1: small_stmt : ( expr_stmt | del_stmt | pass_stmt | flow_stmt | import_stmt | global_stmt | exec_stmt | assert_stmt |{...}? => print_stmt );
	public final PythonParser.small_stmt_return small_stmt() throws RecognitionException {
		PythonParser.small_stmt_return retval = new PythonParser.small_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope expr_stmt63 =null;
		ParserRuleReturnScope del_stmt64 =null;
		ParserRuleReturnScope pass_stmt65 =null;
		ParserRuleReturnScope flow_stmt66 =null;
		ParserRuleReturnScope import_stmt67 =null;
		ParserRuleReturnScope global_stmt68 =null;
		ParserRuleReturnScope exec_stmt69 =null;
		ParserRuleReturnScope assert_stmt70 =null;
		ParserRuleReturnScope print_stmt71 =null;


		try {
			// Python.g:642:12: ( expr_stmt | del_stmt | pass_stmt | flow_stmt | import_stmt | global_stmt | exec_stmt | assert_stmt |{...}? => print_stmt )
			int alt30=9;
			int LA30_0 = input.LA(1);
			if ( (LA30_0==BACKQUOTE||LA30_0==COMPLEX||LA30_0==FLOAT||LA30_0==INT||(LA30_0 >= LAMBDA && LA30_0 <= LCURLY)||(LA30_0 >= LONGINT && LA30_0 <= MINUS)||LA30_0==NAME||LA30_0==NOT||LA30_0==PLUS||(LA30_0 >= STRING && LA30_0 <= TILDE)) ) {
				alt30=1;
			}
			else if ( (LA30_0==PRINT) && (((printFunction)||(!printFunction)))) {
				int LA30_2 = input.LA(2);
				if ( ((printFunction)) ) {
					alt30=1;
				}
				else if ( ((!printFunction)) ) {
					alt30=9;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 30, 2, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA30_0==DELETE) ) {
				alt30=2;
			}
			else if ( (LA30_0==PASS) ) {
				alt30=3;
			}
			else if ( (LA30_0==BREAK||LA30_0==CONTINUE||LA30_0==RAISE||LA30_0==RETURN||LA30_0==YIELD) ) {
				alt30=4;
			}
			else if ( (LA30_0==FROM||LA30_0==IMPORT) ) {
				alt30=5;
			}
			else if ( (LA30_0==GLOBAL) ) {
				alt30=6;
			}
			else if ( (LA30_0==EXEC) ) {
				alt30=7;
			}
			else if ( (LA30_0==ASSERT) ) {
				alt30=8;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 30, 0, input);
				throw nvae;
			}

			switch (alt30) {
				case 1 :
					// Python.g:642:14: expr_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_expr_stmt_in_small_stmt1521);
					expr_stmt63=expr_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, expr_stmt63.getTree());

					}
					break;
				case 2 :
					// Python.g:643:14: del_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_del_stmt_in_small_stmt1536);
					del_stmt64=del_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, del_stmt64.getTree());

					}
					break;
				case 3 :
					// Python.g:644:14: pass_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_pass_stmt_in_small_stmt1551);
					pass_stmt65=pass_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, pass_stmt65.getTree());

					}
					break;
				case 4 :
					// Python.g:645:14: flow_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_flow_stmt_in_small_stmt1566);
					flow_stmt66=flow_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, flow_stmt66.getTree());

					}
					break;
				case 5 :
					// Python.g:646:14: import_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_import_stmt_in_small_stmt1581);
					import_stmt67=import_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, import_stmt67.getTree());

					}
					break;
				case 6 :
					// Python.g:647:14: global_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_global_stmt_in_small_stmt1596);
					global_stmt68=global_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, global_stmt68.getTree());

					}
					break;
				case 7 :
					// Python.g:648:14: exec_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_exec_stmt_in_small_stmt1611);
					exec_stmt69=exec_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, exec_stmt69.getTree());

					}
					break;
				case 8 :
					// Python.g:649:14: assert_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_assert_stmt_in_small_stmt1626);
					assert_stmt70=assert_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, assert_stmt70.getTree());

					}
					break;
				case 9 :
					// Python.g:650:14: {...}? => print_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					if ( !((!printFunction)) ) {
						if (state.backtracking>0) {state.failed=true; return retval;}
						throw new FailedPredicateException(input, "small_stmt", "!printFunction");
					}
					pushFollow(FOLLOW_print_stmt_in_small_stmt1645);
					print_stmt71=print_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, print_stmt71.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "small_stmt"


	public static class expr_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "expr_stmt"
	// Python.g:655:1: expr_stmt : ( ( testlist[null] augassign )=>lhs= testlist[expr_contextType.AugStore] ( (aay= augassign y1= yield_expr ) | (aat= augassign rhs= testlist[expr_contextType.Load] ) ) | ( testlist[null] ASSIGN )=>lhs= testlist[expr_contextType.Store] (| ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ ) | ( (ay= ASSIGN y2+= yield_expr )+ ) ) |lhs= testlist[expr_contextType.Load] ) ;
	public final PythonParser.expr_stmt_return expr_stmt() throws RecognitionException {
		PythonParser.expr_stmt_return retval = new PythonParser.expr_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token at=null;
		Token ay=null;
		List<Object> list_t=null;
		List<Object> list_y2=null;
		ParserRuleReturnScope lhs =null;
		ParserRuleReturnScope aay =null;
		ParserRuleReturnScope y1 =null;
		ParserRuleReturnScope aat =null;
		ParserRuleReturnScope rhs =null;
		RuleReturnScope t = null;
		RuleReturnScope y2 = null;
		PythonTree at_tree=null;
		PythonTree ay_tree=null;


		    stmt stype = null;

		try {
			// Python.g:664:5: ( ( ( testlist[null] augassign )=>lhs= testlist[expr_contextType.AugStore] ( (aay= augassign y1= yield_expr ) | (aat= augassign rhs= testlist[expr_contextType.Load] ) ) | ( testlist[null] ASSIGN )=>lhs= testlist[expr_contextType.Store] (| ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ ) | ( (ay= ASSIGN y2+= yield_expr )+ ) ) |lhs= testlist[expr_contextType.Load] ) )
			// Python.g:664:7: ( ( testlist[null] augassign )=>lhs= testlist[expr_contextType.AugStore] ( (aay= augassign y1= yield_expr ) | (aat= augassign rhs= testlist[expr_contextType.Load] ) ) | ( testlist[null] ASSIGN )=>lhs= testlist[expr_contextType.Store] (| ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ ) | ( (ay= ASSIGN y2+= yield_expr )+ ) ) |lhs= testlist[expr_contextType.Load] )
			{
			root_0 = (PythonTree)adaptor.nil();


			// Python.g:664:7: ( ( testlist[null] augassign )=>lhs= testlist[expr_contextType.AugStore] ( (aay= augassign y1= yield_expr ) | (aat= augassign rhs= testlist[expr_contextType.Load] ) ) | ( testlist[null] ASSIGN )=>lhs= testlist[expr_contextType.Store] (| ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ ) | ( (ay= ASSIGN y2+= yield_expr )+ ) ) |lhs= testlist[expr_contextType.Load] )
			int alt35=3;
			int LA35_0 = input.LA(1);
			if ( (LA35_0==NOT) ) {
				int LA35_1 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==PLUS) ) {
				int LA35_2 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==MINUS) ) {
				int LA35_3 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==TILDE) ) {
				int LA35_4 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==LPAREN) ) {
				int LA35_5 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==LBRACK) ) {
				int LA35_6 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==LCURLY) ) {
				int LA35_7 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==BACKQUOTE) ) {
				int LA35_8 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==NAME) ) {
				int LA35_9 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==PRINT) && ((printFunction))) {
				int LA35_10 = input.LA(2);
				if ( (((printFunction)&&synpred2_Python())) ) {
					alt35=1;
				}
				else if ( (((printFunction)&&synpred3_Python())) ) {
					alt35=2;
				}
				else if ( ((printFunction)) ) {
					alt35=3;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 35, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA35_0==INT) ) {
				int LA35_11 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==LONGINT) ) {
				int LA35_12 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==FLOAT) ) {
				int LA35_13 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==COMPLEX) ) {
				int LA35_14 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==STRING) ) {
				int LA35_15 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}
			else if ( (LA35_0==LAMBDA) ) {
				int LA35_16 = input.LA(2);
				if ( (synpred2_Python()) ) {
					alt35=1;
				}
				else if ( (synpred3_Python()) ) {
					alt35=2;
				}
				else if ( (true) ) {
					alt35=3;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 35, 0, input);
				throw nvae;
			}

			switch (alt35) {
				case 1 :
					// Python.g:664:8: ( testlist[null] augassign )=>lhs= testlist[expr_contextType.AugStore] ( (aay= augassign y1= yield_expr ) | (aat= augassign rhs= testlist[expr_contextType.Load] ) )
					{
					pushFollow(FOLLOW_testlist_in_expr_stmt1693);
					lhs=testlist(expr_contextType.AugStore);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, lhs.getTree());

					// Python.g:665:9: ( (aay= augassign y1= yield_expr ) | (aat= augassign rhs= testlist[expr_contextType.Load] ) )
					int alt31=2;
					switch ( input.LA(1) ) {
					case PLUSEQUAL:
						{
						int LA31_1 = input.LA(2);
						if ( (LA31_1==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_1==BACKQUOTE||LA31_1==COMPLEX||LA31_1==FLOAT||LA31_1==INT||(LA31_1 >= LAMBDA && LA31_1 <= LCURLY)||(LA31_1 >= LONGINT && LA31_1 <= MINUS)||LA31_1==NAME||LA31_1==NOT||LA31_1==PLUS||LA31_1==PRINT||(LA31_1 >= STRING && LA31_1 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 1, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case MINUSEQUAL:
						{
						int LA31_2 = input.LA(2);
						if ( (LA31_2==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_2==BACKQUOTE||LA31_2==COMPLEX||LA31_2==FLOAT||LA31_2==INT||(LA31_2 >= LAMBDA && LA31_2 <= LCURLY)||(LA31_2 >= LONGINT && LA31_2 <= MINUS)||LA31_2==NAME||LA31_2==NOT||LA31_2==PLUS||LA31_2==PRINT||(LA31_2 >= STRING && LA31_2 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 2, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case STAREQUAL:
						{
						int LA31_3 = input.LA(2);
						if ( (LA31_3==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_3==BACKQUOTE||LA31_3==COMPLEX||LA31_3==FLOAT||LA31_3==INT||(LA31_3 >= LAMBDA && LA31_3 <= LCURLY)||(LA31_3 >= LONGINT && LA31_3 <= MINUS)||LA31_3==NAME||LA31_3==NOT||LA31_3==PLUS||LA31_3==PRINT||(LA31_3 >= STRING && LA31_3 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 3, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case SLASHEQUAL:
						{
						int LA31_4 = input.LA(2);
						if ( (LA31_4==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_4==BACKQUOTE||LA31_4==COMPLEX||LA31_4==FLOAT||LA31_4==INT||(LA31_4 >= LAMBDA && LA31_4 <= LCURLY)||(LA31_4 >= LONGINT && LA31_4 <= MINUS)||LA31_4==NAME||LA31_4==NOT||LA31_4==PLUS||LA31_4==PRINT||(LA31_4 >= STRING && LA31_4 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 4, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case PERCENTEQUAL:
						{
						int LA31_5 = input.LA(2);
						if ( (LA31_5==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_5==BACKQUOTE||LA31_5==COMPLEX||LA31_5==FLOAT||LA31_5==INT||(LA31_5 >= LAMBDA && LA31_5 <= LCURLY)||(LA31_5 >= LONGINT && LA31_5 <= MINUS)||LA31_5==NAME||LA31_5==NOT||LA31_5==PLUS||LA31_5==PRINT||(LA31_5 >= STRING && LA31_5 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 5, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case AMPEREQUAL:
						{
						int LA31_6 = input.LA(2);
						if ( (LA31_6==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_6==BACKQUOTE||LA31_6==COMPLEX||LA31_6==FLOAT||LA31_6==INT||(LA31_6 >= LAMBDA && LA31_6 <= LCURLY)||(LA31_6 >= LONGINT && LA31_6 <= MINUS)||LA31_6==NAME||LA31_6==NOT||LA31_6==PLUS||LA31_6==PRINT||(LA31_6 >= STRING && LA31_6 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 6, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case VBAREQUAL:
						{
						int LA31_7 = input.LA(2);
						if ( (LA31_7==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_7==BACKQUOTE||LA31_7==COMPLEX||LA31_7==FLOAT||LA31_7==INT||(LA31_7 >= LAMBDA && LA31_7 <= LCURLY)||(LA31_7 >= LONGINT && LA31_7 <= MINUS)||LA31_7==NAME||LA31_7==NOT||LA31_7==PLUS||LA31_7==PRINT||(LA31_7 >= STRING && LA31_7 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 7, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case CIRCUMFLEXEQUAL:
						{
						int LA31_8 = input.LA(2);
						if ( (LA31_8==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_8==BACKQUOTE||LA31_8==COMPLEX||LA31_8==FLOAT||LA31_8==INT||(LA31_8 >= LAMBDA && LA31_8 <= LCURLY)||(LA31_8 >= LONGINT && LA31_8 <= MINUS)||LA31_8==NAME||LA31_8==NOT||LA31_8==PLUS||LA31_8==PRINT||(LA31_8 >= STRING && LA31_8 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 8, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case LEFTSHIFTEQUAL:
						{
						int LA31_9 = input.LA(2);
						if ( (LA31_9==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_9==BACKQUOTE||LA31_9==COMPLEX||LA31_9==FLOAT||LA31_9==INT||(LA31_9 >= LAMBDA && LA31_9 <= LCURLY)||(LA31_9 >= LONGINT && LA31_9 <= MINUS)||LA31_9==NAME||LA31_9==NOT||LA31_9==PLUS||LA31_9==PRINT||(LA31_9 >= STRING && LA31_9 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 9, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case RIGHTSHIFTEQUAL:
						{
						int LA31_10 = input.LA(2);
						if ( (LA31_10==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_10==BACKQUOTE||LA31_10==COMPLEX||LA31_10==FLOAT||LA31_10==INT||(LA31_10 >= LAMBDA && LA31_10 <= LCURLY)||(LA31_10 >= LONGINT && LA31_10 <= MINUS)||LA31_10==NAME||LA31_10==NOT||LA31_10==PLUS||LA31_10==PRINT||(LA31_10 >= STRING && LA31_10 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 10, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case DOUBLESTAREQUAL:
						{
						int LA31_11 = input.LA(2);
						if ( (LA31_11==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_11==BACKQUOTE||LA31_11==COMPLEX||LA31_11==FLOAT||LA31_11==INT||(LA31_11 >= LAMBDA && LA31_11 <= LCURLY)||(LA31_11 >= LONGINT && LA31_11 <= MINUS)||LA31_11==NAME||LA31_11==NOT||LA31_11==PLUS||LA31_11==PRINT||(LA31_11 >= STRING && LA31_11 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 11, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					case DOUBLESLASHEQUAL:
						{
						int LA31_12 = input.LA(2);
						if ( (LA31_12==YIELD) ) {
							alt31=1;
						}
						else if ( (LA31_12==BACKQUOTE||LA31_12==COMPLEX||LA31_12==FLOAT||LA31_12==INT||(LA31_12 >= LAMBDA && LA31_12 <= LCURLY)||(LA31_12 >= LONGINT && LA31_12 <= MINUS)||LA31_12==NAME||LA31_12==NOT||LA31_12==PLUS||LA31_12==PRINT||(LA31_12 >= STRING && LA31_12 <= TILDE)) ) {
							alt31=2;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 31, 12, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

						}
						break;
					default:
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 31, 0, input);
						throw nvae;
					}
					switch (alt31) {
						case 1 :
							// Python.g:665:11: (aay= augassign y1= yield_expr )
							{
							// Python.g:665:11: (aay= augassign y1= yield_expr )
							// Python.g:665:12: aay= augassign y1= yield_expr
							{
							pushFollow(FOLLOW_augassign_in_expr_stmt1709);
							aay=augassign();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, aay.getTree());

							pushFollow(FOLLOW_yield_expr_in_expr_stmt1713);
							y1=yield_expr();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, y1.getTree());

							if ( state.backtracking==0 ) {
							               actions.checkAugAssign(actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)));
							               stype = new AugAssign((lhs!=null?((PythonTree)lhs.getTree()):null), actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)), (aay!=null?((PythonParser.augassign_return)aay).op:null), actions.castExpr((y1!=null?((PythonParser.yield_expr_return)y1).etype:null)));
							           }
							}

							}
							break;
						case 2 :
							// Python.g:671:11: (aat= augassign rhs= testlist[expr_contextType.Load] )
							{
							// Python.g:671:11: (aat= augassign rhs= testlist[expr_contextType.Load] )
							// Python.g:671:12: aat= augassign rhs= testlist[expr_contextType.Load]
							{
							pushFollow(FOLLOW_augassign_in_expr_stmt1753);
							aat=augassign();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, aat.getTree());

							pushFollow(FOLLOW_testlist_in_expr_stmt1757);
							rhs=testlist(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, rhs.getTree());

							if ( state.backtracking==0 ) {
							               actions.checkAugAssign(actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)));
							               stype = new AugAssign((lhs!=null?((PythonTree)lhs.getTree()):null), actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)), (aat!=null?((PythonParser.augassign_return)aat).op:null), actions.castExpr((rhs!=null?((PythonTree)rhs.getTree()):null)));
							           }
							}

							}
							break;

					}

					}
					break;
				case 2 :
					// Python.g:678:7: ( testlist[null] ASSIGN )=>lhs= testlist[expr_contextType.Store] (| ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ ) | ( (ay= ASSIGN y2+= yield_expr )+ ) )
					{
					pushFollow(FOLLOW_testlist_in_expr_stmt1812);
					lhs=testlist(expr_contextType.Store);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, lhs.getTree());

					// Python.g:679:9: (| ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ ) | ( (ay= ASSIGN y2+= yield_expr )+ ) )
					int alt34=3;
					int LA34_0 = input.LA(1);
					if ( (LA34_0==NEWLINE||LA34_0==SEMI) ) {
						alt34=1;
					}
					else if ( (LA34_0==ASSIGN) ) {
						int LA34_2 = input.LA(2);
						if ( (LA34_2==BACKQUOTE||LA34_2==COMPLEX||LA34_2==FLOAT||LA34_2==INT||(LA34_2 >= LAMBDA && LA34_2 <= LCURLY)||(LA34_2 >= LONGINT && LA34_2 <= MINUS)||LA34_2==NAME||LA34_2==NOT||LA34_2==PLUS||LA34_2==PRINT||(LA34_2 >= STRING && LA34_2 <= TILDE)) ) {
							alt34=2;
						}
						else if ( (LA34_2==YIELD) ) {
							alt34=3;
						}

						else {
							if (state.backtracking>0) {state.failed=true; return retval;}
							int nvaeMark = input.mark();
							try {
								input.consume();
								NoViableAltException nvae =
									new NoViableAltException("", 34, 2, input);
								throw nvae;
							} finally {
								input.rewind(nvaeMark);
							}
						}

					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 34, 0, input);
						throw nvae;
					}

					switch (alt34) {
						case 1 :
							// Python.g:680:9: 
							{
							}
							break;
						case 2 :
							// Python.g:680:11: ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ )
							{
							// Python.g:680:11: ( (at= ASSIGN t+= testlist[expr_contextType.Store] )+ )
							// Python.g:680:12: (at= ASSIGN t+= testlist[expr_contextType.Store] )+
							{
							// Python.g:680:12: (at= ASSIGN t+= testlist[expr_contextType.Store] )+
							int cnt32=0;
							loop32:
							while (true) {
								int alt32=2;
								int LA32_0 = input.LA(1);
								if ( (LA32_0==ASSIGN) ) {
									alt32=1;
								}

								switch (alt32) {
								case 1 :
									// Python.g:680:13: at= ASSIGN t+= testlist[expr_contextType.Store]
									{
									at=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_expr_stmt1839); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									at_tree = (PythonTree)adaptor.create(at);
									adaptor.addChild(root_0, at_tree);
									}

									pushFollow(FOLLOW_testlist_in_expr_stmt1843);
									t=testlist(expr_contextType.Store);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

									if (list_t==null) list_t=new ArrayList<Object>();
									list_t.add(t.getTree());
									}
									break;

								default :
									if ( cnt32 >= 1 ) break loop32;
									if (state.backtracking>0) {state.failed=true; return retval;}
									EarlyExitException eee = new EarlyExitException(32, input);
									throw eee;
								}
								cnt32++;
							}

							if ( state.backtracking==0 ) {
							                stype = new Assign((lhs!=null?((PythonTree)lhs.getTree()):null), actions.makeAssignTargets(
							                    actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)), list_t), actions.makeAssignValue(list_t));
							            }
							}

							}
							break;
						case 3 :
							// Python.g:686:11: ( (ay= ASSIGN y2+= yield_expr )+ )
							{
							// Python.g:686:11: ( (ay= ASSIGN y2+= yield_expr )+ )
							// Python.g:686:12: (ay= ASSIGN y2+= yield_expr )+
							{
							// Python.g:686:12: (ay= ASSIGN y2+= yield_expr )+
							int cnt33=0;
							loop33:
							while (true) {
								int alt33=2;
								int LA33_0 = input.LA(1);
								if ( (LA33_0==ASSIGN) ) {
									alt33=1;
								}

								switch (alt33) {
								case 1 :
									// Python.g:686:13: ay= ASSIGN y2+= yield_expr
									{
									ay=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_expr_stmt1888); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									ay_tree = (PythonTree)adaptor.create(ay);
									adaptor.addChild(root_0, ay_tree);
									}

									pushFollow(FOLLOW_yield_expr_in_expr_stmt1892);
									y2=yield_expr();
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, y2.getTree());

									if (list_y2==null) list_y2=new ArrayList<Object>();
									list_y2.add(y2.getTree());
									}
									break;

								default :
									if ( cnt33 >= 1 ) break loop33;
									if (state.backtracking>0) {state.failed=true; return retval;}
									EarlyExitException eee = new EarlyExitException(33, input);
									throw eee;
								}
								cnt33++;
							}

							if ( state.backtracking==0 ) {
							                stype = new Assign((lhs!=null?(lhs.start):null), actions.makeAssignTargets(
							                    actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)), list_y2), actions.makeAssignValue(list_y2));
							            }
							}

							}
							break;

					}

					}
					break;
				case 3 :
					// Python.g:693:7: lhs= testlist[expr_contextType.Load]
					{
					pushFollow(FOLLOW_testlist_in_expr_stmt1940);
					lhs=testlist(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, lhs.getTree());

					if ( state.backtracking==0 ) {
					          stype = new Expr((lhs!=null?(lhs.start):null), actions.castExpr((lhs!=null?((PythonTree)lhs.getTree()):null)));
					      }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (stype != null) {
			        retval.tree = stype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "expr_stmt"


	public static class augassign_return extends ParserRuleReturnScope {
		public operatorType op;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "augassign"
	// Python.g:702:1: augassign returns [operatorType op] : ( PLUSEQUAL | MINUSEQUAL | STAREQUAL | SLASHEQUAL | PERCENTEQUAL | AMPEREQUAL | VBAREQUAL | CIRCUMFLEXEQUAL | LEFTSHIFTEQUAL | RIGHTSHIFTEQUAL | DOUBLESTAREQUAL | DOUBLESLASHEQUAL );
	public final PythonParser.augassign_return augassign() throws RecognitionException {
		PythonParser.augassign_return retval = new PythonParser.augassign_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token PLUSEQUAL72=null;
		Token MINUSEQUAL73=null;
		Token STAREQUAL74=null;
		Token SLASHEQUAL75=null;
		Token PERCENTEQUAL76=null;
		Token AMPEREQUAL77=null;
		Token VBAREQUAL78=null;
		Token CIRCUMFLEXEQUAL79=null;
		Token LEFTSHIFTEQUAL80=null;
		Token RIGHTSHIFTEQUAL81=null;
		Token DOUBLESTAREQUAL82=null;
		Token DOUBLESLASHEQUAL83=null;

		PythonTree PLUSEQUAL72_tree=null;
		PythonTree MINUSEQUAL73_tree=null;
		PythonTree STAREQUAL74_tree=null;
		PythonTree SLASHEQUAL75_tree=null;
		PythonTree PERCENTEQUAL76_tree=null;
		PythonTree AMPEREQUAL77_tree=null;
		PythonTree VBAREQUAL78_tree=null;
		PythonTree CIRCUMFLEXEQUAL79_tree=null;
		PythonTree LEFTSHIFTEQUAL80_tree=null;
		PythonTree RIGHTSHIFTEQUAL81_tree=null;
		PythonTree DOUBLESTAREQUAL82_tree=null;
		PythonTree DOUBLESLASHEQUAL83_tree=null;

		try {
			// Python.g:704:5: ( PLUSEQUAL | MINUSEQUAL | STAREQUAL | SLASHEQUAL | PERCENTEQUAL | AMPEREQUAL | VBAREQUAL | CIRCUMFLEXEQUAL | LEFTSHIFTEQUAL | RIGHTSHIFTEQUAL | DOUBLESTAREQUAL | DOUBLESLASHEQUAL )
			int alt36=12;
			switch ( input.LA(1) ) {
			case PLUSEQUAL:
				{
				alt36=1;
				}
				break;
			case MINUSEQUAL:
				{
				alt36=2;
				}
				break;
			case STAREQUAL:
				{
				alt36=3;
				}
				break;
			case SLASHEQUAL:
				{
				alt36=4;
				}
				break;
			case PERCENTEQUAL:
				{
				alt36=5;
				}
				break;
			case AMPEREQUAL:
				{
				alt36=6;
				}
				break;
			case VBAREQUAL:
				{
				alt36=7;
				}
				break;
			case CIRCUMFLEXEQUAL:
				{
				alt36=8;
				}
				break;
			case LEFTSHIFTEQUAL:
				{
				alt36=9;
				}
				break;
			case RIGHTSHIFTEQUAL:
				{
				alt36=10;
				}
				break;
			case DOUBLESTAREQUAL:
				{
				alt36=11;
				}
				break;
			case DOUBLESLASHEQUAL:
				{
				alt36=12;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 36, 0, input);
				throw nvae;
			}
			switch (alt36) {
				case 1 :
					// Python.g:704:7: PLUSEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					PLUSEQUAL72=(Token)match(input,PLUSEQUAL,FOLLOW_PLUSEQUAL_in_augassign1982); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					PLUSEQUAL72_tree = (PythonTree)adaptor.create(PLUSEQUAL72);
					adaptor.addChild(root_0, PLUSEQUAL72_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.Add;
					        }
					}
					break;
				case 2 :
					// Python.g:708:7: MINUSEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					MINUSEQUAL73=(Token)match(input,MINUSEQUAL,FOLLOW_MINUSEQUAL_in_augassign2000); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					MINUSEQUAL73_tree = (PythonTree)adaptor.create(MINUSEQUAL73);
					adaptor.addChild(root_0, MINUSEQUAL73_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.Sub;
					        }
					}
					break;
				case 3 :
					// Python.g:712:7: STAREQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					STAREQUAL74=(Token)match(input,STAREQUAL,FOLLOW_STAREQUAL_in_augassign2018); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					STAREQUAL74_tree = (PythonTree)adaptor.create(STAREQUAL74);
					adaptor.addChild(root_0, STAREQUAL74_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.Mult;
					        }
					}
					break;
				case 4 :
					// Python.g:716:7: SLASHEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					SLASHEQUAL75=(Token)match(input,SLASHEQUAL,FOLLOW_SLASHEQUAL_in_augassign2036); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					SLASHEQUAL75_tree = (PythonTree)adaptor.create(SLASHEQUAL75);
					adaptor.addChild(root_0, SLASHEQUAL75_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.Div;
					        }
					}
					break;
				case 5 :
					// Python.g:720:7: PERCENTEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					PERCENTEQUAL76=(Token)match(input,PERCENTEQUAL,FOLLOW_PERCENTEQUAL_in_augassign2054); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					PERCENTEQUAL76_tree = (PythonTree)adaptor.create(PERCENTEQUAL76);
					adaptor.addChild(root_0, PERCENTEQUAL76_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.Mod;
					        }
					}
					break;
				case 6 :
					// Python.g:724:7: AMPEREQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					AMPEREQUAL77=(Token)match(input,AMPEREQUAL,FOLLOW_AMPEREQUAL_in_augassign2072); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					AMPEREQUAL77_tree = (PythonTree)adaptor.create(AMPEREQUAL77);
					adaptor.addChild(root_0, AMPEREQUAL77_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.BitAnd;
					        }
					}
					break;
				case 7 :
					// Python.g:728:7: VBAREQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					VBAREQUAL78=(Token)match(input,VBAREQUAL,FOLLOW_VBAREQUAL_in_augassign2090); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					VBAREQUAL78_tree = (PythonTree)adaptor.create(VBAREQUAL78);
					adaptor.addChild(root_0, VBAREQUAL78_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.BitOr;
					        }
					}
					break;
				case 8 :
					// Python.g:732:7: CIRCUMFLEXEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					CIRCUMFLEXEQUAL79=(Token)match(input,CIRCUMFLEXEQUAL,FOLLOW_CIRCUMFLEXEQUAL_in_augassign2108); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					CIRCUMFLEXEQUAL79_tree = (PythonTree)adaptor.create(CIRCUMFLEXEQUAL79);
					adaptor.addChild(root_0, CIRCUMFLEXEQUAL79_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.BitXor;
					        }
					}
					break;
				case 9 :
					// Python.g:736:7: LEFTSHIFTEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					LEFTSHIFTEQUAL80=(Token)match(input,LEFTSHIFTEQUAL,FOLLOW_LEFTSHIFTEQUAL_in_augassign2126); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LEFTSHIFTEQUAL80_tree = (PythonTree)adaptor.create(LEFTSHIFTEQUAL80);
					adaptor.addChild(root_0, LEFTSHIFTEQUAL80_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.LShift;
					        }
					}
					break;
				case 10 :
					// Python.g:740:7: RIGHTSHIFTEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					RIGHTSHIFTEQUAL81=(Token)match(input,RIGHTSHIFTEQUAL,FOLLOW_RIGHTSHIFTEQUAL_in_augassign2144); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RIGHTSHIFTEQUAL81_tree = (PythonTree)adaptor.create(RIGHTSHIFTEQUAL81);
					adaptor.addChild(root_0, RIGHTSHIFTEQUAL81_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.RShift;
					        }
					}
					break;
				case 11 :
					// Python.g:744:7: DOUBLESTAREQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					DOUBLESTAREQUAL82=(Token)match(input,DOUBLESTAREQUAL,FOLLOW_DOUBLESTAREQUAL_in_augassign2162); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOUBLESTAREQUAL82_tree = (PythonTree)adaptor.create(DOUBLESTAREQUAL82);
					adaptor.addChild(root_0, DOUBLESTAREQUAL82_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.Pow;
					        }
					}
					break;
				case 12 :
					// Python.g:748:7: DOUBLESLASHEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					DOUBLESLASHEQUAL83=(Token)match(input,DOUBLESLASHEQUAL,FOLLOW_DOUBLESLASHEQUAL_in_augassign2180); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOUBLESLASHEQUAL83_tree = (PythonTree)adaptor.create(DOUBLESLASHEQUAL83);
					adaptor.addChild(root_0, DOUBLESLASHEQUAL83_tree);
					}

					if ( state.backtracking==0 ) {
					            retval.op = operatorType.FloorDiv;
					        }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "augassign"


	public static class print_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "print_stmt"
	// Python.g:756:1: print_stmt : PRINT (t1= printlist | RIGHTSHIFT t2= printlist2 |) ;
	public final PythonParser.print_stmt_return print_stmt() throws RecognitionException {
		PythonParser.print_stmt_return retval = new PythonParser.print_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token PRINT84=null;
		Token RIGHTSHIFT85=null;
		ParserRuleReturnScope t1 =null;
		ParserRuleReturnScope t2 =null;

		PythonTree PRINT84_tree=null;
		PythonTree RIGHTSHIFT85_tree=null;


		    stmt stype = null;

		try {
			// Python.g:764:5: ( PRINT (t1= printlist | RIGHTSHIFT t2= printlist2 |) )
			// Python.g:764:7: PRINT (t1= printlist | RIGHTSHIFT t2= printlist2 |)
			{
			root_0 = (PythonTree)adaptor.nil();


			PRINT84=(Token)match(input,PRINT,FOLLOW_PRINT_in_print_stmt2220); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			PRINT84_tree = (PythonTree)adaptor.create(PRINT84);
			adaptor.addChild(root_0, PRINT84_tree);
			}

			// Python.g:765:7: (t1= printlist | RIGHTSHIFT t2= printlist2 |)
			int alt37=3;
			int LA37_0 = input.LA(1);
			if ( (LA37_0==BACKQUOTE||(LA37_0 >= LBRACK && LA37_0 <= LCURLY)||(LA37_0 >= LPAREN && LA37_0 <= MINUS)||LA37_0==NAME||LA37_0==NOT||LA37_0==PLUS||LA37_0==TILDE) ) {
				alt37=1;
			}
			else if ( (LA37_0==PRINT) && ((printFunction))) {
				alt37=1;
			}
			else if ( (LA37_0==COMPLEX||LA37_0==FLOAT||LA37_0==INT||LA37_0==LAMBDA||LA37_0==LONGINT||LA37_0==STRING) ) {
				alt37=1;
			}
			else if ( (LA37_0==RIGHTSHIFT) ) {
				alt37=2;
			}
			else if ( (LA37_0==NEWLINE||LA37_0==SEMI) ) {
				alt37=3;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 37, 0, input);
				throw nvae;
			}

			switch (alt37) {
				case 1 :
					// Python.g:765:8: t1= printlist
					{
					pushFollow(FOLLOW_printlist_in_print_stmt2231);
					t1=printlist();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t1.getTree());

					if ( state.backtracking==0 ) {
					           stype = new Print(PRINT84, null, actions.castExprs((t1!=null?((PythonParser.printlist_return)t1).elts:null)), (t1!=null?((PythonParser.printlist_return)t1).newline:false));
					       }
					}
					break;
				case 2 :
					// Python.g:769:9: RIGHTSHIFT t2= printlist2
					{
					RIGHTSHIFT85=(Token)match(input,RIGHTSHIFT,FOLLOW_RIGHTSHIFT_in_print_stmt2250); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RIGHTSHIFT85_tree = (PythonTree)adaptor.create(RIGHTSHIFT85);
					adaptor.addChild(root_0, RIGHTSHIFT85_tree);
					}

					pushFollow(FOLLOW_printlist2_in_print_stmt2254);
					t2=printlist2();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t2.getTree());

					if ( state.backtracking==0 ) {
					           stype = new Print(PRINT84, actions.castExpr((t2!=null?((PythonParser.printlist2_return)t2).elts:null).get(0)), actions.castExprs((t2!=null?((PythonParser.printlist2_return)t2).elts:null), 1), (t2!=null?((PythonParser.printlist2_return)t2).newline:false));
					       }
					}
					break;
				case 3 :
					// Python.g:774:8: 
					{
					if ( state.backtracking==0 ) {
					           stype = new Print(PRINT84, null, new ArrayList<expr>(), true);
					       }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "print_stmt"


	public static class printlist_return extends ParserRuleReturnScope {
		public boolean newline;
		public List elts;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "printlist"
	// Python.g:781:1: printlist returns [boolean newline, List elts] : ( ( test[null] COMMA )=>t+= test[expr_contextType.Load] ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )* (trailcomma= COMMA )? |t+= test[expr_contextType.Load] );
	public final PythonParser.printlist_return printlist() throws RecognitionException {
		PythonParser.printlist_return retval = new PythonParser.printlist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token trailcomma=null;
		Token COMMA86=null;
		List<Object> list_t=null;
		RuleReturnScope t = null;
		PythonTree trailcomma_tree=null;
		PythonTree COMMA86_tree=null;

		try {
			// Python.g:783:5: ( ( test[null] COMMA )=>t+= test[expr_contextType.Load] ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )* (trailcomma= COMMA )? |t+= test[expr_contextType.Load] )
			int alt40=2;
			int LA40_0 = input.LA(1);
			if ( (LA40_0==NOT) ) {
				int LA40_1 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==PLUS) ) {
				int LA40_2 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==MINUS) ) {
				int LA40_3 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==TILDE) ) {
				int LA40_4 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==LPAREN) ) {
				int LA40_5 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==LBRACK) ) {
				int LA40_6 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==LCURLY) ) {
				int LA40_7 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==BACKQUOTE) ) {
				int LA40_8 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==NAME) ) {
				int LA40_9 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==PRINT) && ((printFunction))) {
				int LA40_10 = input.LA(2);
				if ( (((printFunction)&&synpred4_Python())) ) {
					alt40=1;
				}
				else if ( ((printFunction)) ) {
					alt40=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 40, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA40_0==INT) ) {
				int LA40_11 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==LONGINT) ) {
				int LA40_12 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==FLOAT) ) {
				int LA40_13 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==COMPLEX) ) {
				int LA40_14 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==STRING) ) {
				int LA40_15 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}
			else if ( (LA40_0==LAMBDA) ) {
				int LA40_16 = input.LA(2);
				if ( (synpred4_Python()) ) {
					alt40=1;
				}
				else if ( (true) ) {
					alt40=2;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 40, 0, input);
				throw nvae;
			}

			switch (alt40) {
				case 1 :
					// Python.g:783:7: ( test[null] COMMA )=>t+= test[expr_contextType.Load] ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )* (trailcomma= COMMA )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_printlist2334);
					t=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					// Python.g:784:39: ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )*
					loop38:
					while (true) {
						int alt38=2;
						int LA38_0 = input.LA(1);
						if ( (LA38_0==COMMA) ) {
							int LA38_1 = input.LA(2);
							if ( (LA38_1==BACKQUOTE||LA38_1==COMPLEX||LA38_1==FLOAT||LA38_1==INT||(LA38_1 >= LAMBDA && LA38_1 <= LCURLY)||(LA38_1 >= LONGINT && LA38_1 <= MINUS)||LA38_1==NAME||LA38_1==NOT||LA38_1==PLUS||LA38_1==PRINT||(LA38_1 >= STRING && LA38_1 <= TILDE)) ) {
								alt38=1;
							}

						}

						switch (alt38) {
						case 1 :
							// Python.g:784:56: COMMA t+= test[expr_contextType.Load]
							{
							COMMA86=(Token)match(input,COMMA,FOLLOW_COMMA_in_printlist2346); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA86_tree = (PythonTree)adaptor.create(COMMA86);
							adaptor.addChild(root_0, COMMA86_tree);
							}

							pushFollow(FOLLOW_test_in_printlist2350);
							t=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

							if (list_t==null) list_t=new ArrayList<Object>();
							list_t.add(t.getTree());
							}
							break;

						default :
							break loop38;
						}
					}

					// Python.g:784:95: (trailcomma= COMMA )?
					int alt39=2;
					int LA39_0 = input.LA(1);
					if ( (LA39_0==COMMA) ) {
						alt39=1;
					}
					switch (alt39) {
						case 1 :
							// Python.g:784:96: trailcomma= COMMA
							{
							trailcomma=(Token)match(input,COMMA,FOLLOW_COMMA_in_printlist2358); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							trailcomma_tree = (PythonTree)adaptor.create(trailcomma);
							adaptor.addChild(root_0, trailcomma_tree);
							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					           retval.elts =list_t;
					           if (trailcomma == null) {
					               retval.newline = true;
					           } else {
					               retval.newline = false;
					           }
					       }
					}
					break;
				case 2 :
					// Python.g:793:7: t+= test[expr_contextType.Load]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_printlist2379);
					t=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					if ( state.backtracking==0 ) {
					          retval.elts =list_t;
					          retval.newline = true;
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "printlist"


	public static class printlist2_return extends ParserRuleReturnScope {
		public boolean newline;
		public List elts;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "printlist2"
	// Python.g:802:1: printlist2 returns [boolean newline, List elts] : ( ( test[null] COMMA test[null] )=>t+= test[expr_contextType.Load] ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )* (trailcomma= COMMA )? |t+= test[expr_contextType.Load] );
	public final PythonParser.printlist2_return printlist2() throws RecognitionException {
		PythonParser.printlist2_return retval = new PythonParser.printlist2_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token trailcomma=null;
		Token COMMA87=null;
		List<Object> list_t=null;
		RuleReturnScope t = null;
		PythonTree trailcomma_tree=null;
		PythonTree COMMA87_tree=null;

		try {
			// Python.g:804:5: ( ( test[null] COMMA test[null] )=>t+= test[expr_contextType.Load] ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )* (trailcomma= COMMA )? |t+= test[expr_contextType.Load] )
			int alt43=2;
			int LA43_0 = input.LA(1);
			if ( (LA43_0==NOT) ) {
				int LA43_1 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==PLUS) ) {
				int LA43_2 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==MINUS) ) {
				int LA43_3 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==TILDE) ) {
				int LA43_4 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==LPAREN) ) {
				int LA43_5 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==LBRACK) ) {
				int LA43_6 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==LCURLY) ) {
				int LA43_7 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==BACKQUOTE) ) {
				int LA43_8 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==NAME) ) {
				int LA43_9 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==PRINT) && ((printFunction))) {
				int LA43_10 = input.LA(2);
				if ( (((printFunction)&&synpred5_Python())) ) {
					alt43=1;
				}
				else if ( ((printFunction)) ) {
					alt43=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 43, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA43_0==INT) ) {
				int LA43_11 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==LONGINT) ) {
				int LA43_12 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==FLOAT) ) {
				int LA43_13 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==COMPLEX) ) {
				int LA43_14 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==STRING) ) {
				int LA43_15 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}
			else if ( (LA43_0==LAMBDA) ) {
				int LA43_16 = input.LA(2);
				if ( (synpred5_Python()) ) {
					alt43=1;
				}
				else if ( (true) ) {
					alt43=2;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 43, 0, input);
				throw nvae;
			}

			switch (alt43) {
				case 1 :
					// Python.g:804:7: ( test[null] COMMA test[null] )=>t+= test[expr_contextType.Load] ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )* (trailcomma= COMMA )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_printlist22436);
					t=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					// Python.g:805:39: ( options {k=2; } : COMMA t+= test[expr_contextType.Load] )*
					loop41:
					while (true) {
						int alt41=2;
						int LA41_0 = input.LA(1);
						if ( (LA41_0==COMMA) ) {
							int LA41_1 = input.LA(2);
							if ( (LA41_1==BACKQUOTE||LA41_1==COMPLEX||LA41_1==FLOAT||LA41_1==INT||(LA41_1 >= LAMBDA && LA41_1 <= LCURLY)||(LA41_1 >= LONGINT && LA41_1 <= MINUS)||LA41_1==NAME||LA41_1==NOT||LA41_1==PLUS||LA41_1==PRINT||(LA41_1 >= STRING && LA41_1 <= TILDE)) ) {
								alt41=1;
							}

						}

						switch (alt41) {
						case 1 :
							// Python.g:805:56: COMMA t+= test[expr_contextType.Load]
							{
							COMMA87=(Token)match(input,COMMA,FOLLOW_COMMA_in_printlist22448); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA87_tree = (PythonTree)adaptor.create(COMMA87);
							adaptor.addChild(root_0, COMMA87_tree);
							}

							pushFollow(FOLLOW_test_in_printlist22452);
							t=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

							if (list_t==null) list_t=new ArrayList<Object>();
							list_t.add(t.getTree());
							}
							break;

						default :
							break loop41;
						}
					}

					// Python.g:805:95: (trailcomma= COMMA )?
					int alt42=2;
					int LA42_0 = input.LA(1);
					if ( (LA42_0==COMMA) ) {
						alt42=1;
					}
					switch (alt42) {
						case 1 :
							// Python.g:805:96: trailcomma= COMMA
							{
							trailcomma=(Token)match(input,COMMA,FOLLOW_COMMA_in_printlist22460); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							trailcomma_tree = (PythonTree)adaptor.create(trailcomma);
							adaptor.addChild(root_0, trailcomma_tree);
							}

							}
							break;

					}

					if ( state.backtracking==0 ) { retval.elts =list_t;
					           if (trailcomma == null) {
					               retval.newline = true;
					           } else {
					               retval.newline = false;
					           }
					       }
					}
					break;
				case 2 :
					// Python.g:813:7: t+= test[expr_contextType.Load]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_printlist22481);
					t=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					if ( state.backtracking==0 ) {
					          retval.elts =list_t;
					          retval.newline = true;
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "printlist2"


	public static class del_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "del_stmt"
	// Python.g:821:1: del_stmt : DELETE del_list ;
	public final PythonParser.del_stmt_return del_stmt() throws RecognitionException {
		PythonParser.del_stmt_return retval = new PythonParser.del_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token DELETE88=null;
		ParserRuleReturnScope del_list89 =null;

		PythonTree DELETE88_tree=null;


		    stmt stype = null;

		try {
			// Python.g:828:5: ( DELETE del_list )
			// Python.g:828:7: DELETE del_list
			{
			root_0 = (PythonTree)adaptor.nil();


			DELETE88=(Token)match(input,DELETE,FOLLOW_DELETE_in_del_stmt2518); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			DELETE88_tree = (PythonTree)adaptor.create(DELETE88);
			adaptor.addChild(root_0, DELETE88_tree);
			}

			pushFollow(FOLLOW_del_list_in_del_stmt2520);
			del_list89=del_list();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, del_list89.getTree());

			if ( state.backtracking==0 ) {
			          stype = new Delete(DELETE88, (del_list89!=null?((PythonParser.del_list_return)del_list89).etypes:null));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "del_stmt"


	public static class pass_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "pass_stmt"
	// Python.g:835:1: pass_stmt : PASS ;
	public final PythonParser.pass_stmt_return pass_stmt() throws RecognitionException {
		PythonParser.pass_stmt_return retval = new PythonParser.pass_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token PASS90=null;

		PythonTree PASS90_tree=null;


		    stmt stype = null;

		try {
			// Python.g:842:5: ( PASS )
			// Python.g:842:7: PASS
			{
			root_0 = (PythonTree)adaptor.nil();


			PASS90=(Token)match(input,PASS,FOLLOW_PASS_in_pass_stmt2556); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			PASS90_tree = (PythonTree)adaptor.create(PASS90);
			adaptor.addChild(root_0, PASS90_tree);
			}

			if ( state.backtracking==0 ) {
			          stype = new Pass(PASS90);
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "pass_stmt"


	public static class flow_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "flow_stmt"
	// Python.g:849:1: flow_stmt : ( break_stmt | continue_stmt | return_stmt | raise_stmt | yield_stmt );
	public final PythonParser.flow_stmt_return flow_stmt() throws RecognitionException {
		PythonParser.flow_stmt_return retval = new PythonParser.flow_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope break_stmt91 =null;
		ParserRuleReturnScope continue_stmt92 =null;
		ParserRuleReturnScope return_stmt93 =null;
		ParserRuleReturnScope raise_stmt94 =null;
		ParserRuleReturnScope yield_stmt95 =null;


		try {
			// Python.g:850:5: ( break_stmt | continue_stmt | return_stmt | raise_stmt | yield_stmt )
			int alt44=5;
			switch ( input.LA(1) ) {
			case BREAK:
				{
				alt44=1;
				}
				break;
			case CONTINUE:
				{
				alt44=2;
				}
				break;
			case RETURN:
				{
				alt44=3;
				}
				break;
			case RAISE:
				{
				alt44=4;
				}
				break;
			case YIELD:
				{
				alt44=5;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 44, 0, input);
				throw nvae;
			}
			switch (alt44) {
				case 1 :
					// Python.g:850:7: break_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_break_stmt_in_flow_stmt2582);
					break_stmt91=break_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, break_stmt91.getTree());

					}
					break;
				case 2 :
					// Python.g:851:7: continue_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_continue_stmt_in_flow_stmt2590);
					continue_stmt92=continue_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, continue_stmt92.getTree());

					}
					break;
				case 3 :
					// Python.g:852:7: return_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_return_stmt_in_flow_stmt2598);
					return_stmt93=return_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, return_stmt93.getTree());

					}
					break;
				case 4 :
					// Python.g:853:7: raise_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_raise_stmt_in_flow_stmt2606);
					raise_stmt94=raise_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, raise_stmt94.getTree());

					}
					break;
				case 5 :
					// Python.g:854:7: yield_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_yield_stmt_in_flow_stmt2614);
					yield_stmt95=yield_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, yield_stmt95.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "flow_stmt"


	public static class break_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "break_stmt"
	// Python.g:858:1: break_stmt : BREAK ;
	public final PythonParser.break_stmt_return break_stmt() throws RecognitionException {
		PythonParser.break_stmt_return retval = new PythonParser.break_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token BREAK96=null;

		PythonTree BREAK96_tree=null;


		    stmt stype = null;

		try {
			// Python.g:865:5: ( BREAK )
			// Python.g:865:7: BREAK
			{
			root_0 = (PythonTree)adaptor.nil();


			BREAK96=(Token)match(input,BREAK,FOLLOW_BREAK_in_break_stmt2642); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			BREAK96_tree = (PythonTree)adaptor.create(BREAK96);
			adaptor.addChild(root_0, BREAK96_tree);
			}

			if ( state.backtracking==0 ) {
			          stype = new Break(BREAK96);
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "break_stmt"


	public static class continue_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "continue_stmt"
	// Python.g:872:1: continue_stmt : CONTINUE ;
	public final PythonParser.continue_stmt_return continue_stmt() throws RecognitionException {
		PythonParser.continue_stmt_return retval = new PythonParser.continue_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token CONTINUE97=null;

		PythonTree CONTINUE97_tree=null;


		    stmt stype = null;

		try {
			// Python.g:879:5: ( CONTINUE )
			// Python.g:879:7: CONTINUE
			{
			root_0 = (PythonTree)adaptor.nil();


			CONTINUE97=(Token)match(input,CONTINUE,FOLLOW_CONTINUE_in_continue_stmt2678); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			CONTINUE97_tree = (PythonTree)adaptor.create(CONTINUE97);
			adaptor.addChild(root_0, CONTINUE97_tree);
			}

			if ( state.backtracking==0 ) {
			          if (!suite_stack.isEmpty() && suite_stack.peek().continueIllegal) {
			              errorHandler.error("'continue' not supported inside 'finally' clause",
			                  new PythonTree((retval.start)), true);
			          }
			          stype = new Continue(CONTINUE97);
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "continue_stmt"


	public static class return_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "return_stmt"
	// Python.g:890:1: return_stmt : RETURN ( testlist[expr_contextType.Load] |) ;
	public final PythonParser.return_stmt_return return_stmt() throws RecognitionException {
		PythonParser.return_stmt_return retval = new PythonParser.return_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token RETURN98=null;
		ParserRuleReturnScope testlist99 =null;

		PythonTree RETURN98_tree=null;


		    stmt stype = null;

		try {
			// Python.g:897:5: ( RETURN ( testlist[expr_contextType.Load] |) )
			// Python.g:897:7: RETURN ( testlist[expr_contextType.Load] |)
			{
			root_0 = (PythonTree)adaptor.nil();


			RETURN98=(Token)match(input,RETURN,FOLLOW_RETURN_in_return_stmt2714); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			RETURN98_tree = (PythonTree)adaptor.create(RETURN98);
			adaptor.addChild(root_0, RETURN98_tree);
			}

			// Python.g:898:7: ( testlist[expr_contextType.Load] |)
			int alt45=2;
			int LA45_0 = input.LA(1);
			if ( (LA45_0==BACKQUOTE||(LA45_0 >= LBRACK && LA45_0 <= LCURLY)||(LA45_0 >= LPAREN && LA45_0 <= MINUS)||LA45_0==NAME||LA45_0==NOT||LA45_0==PLUS||LA45_0==TILDE) ) {
				alt45=1;
			}
			else if ( (LA45_0==PRINT) && ((printFunction))) {
				alt45=1;
			}
			else if ( (LA45_0==COMPLEX||LA45_0==FLOAT||LA45_0==INT||LA45_0==LAMBDA||LA45_0==LONGINT||LA45_0==STRING) ) {
				alt45=1;
			}
			else if ( (LA45_0==NEWLINE||LA45_0==SEMI) ) {
				alt45=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 45, 0, input);
				throw nvae;
			}

			switch (alt45) {
				case 1 :
					// Python.g:898:8: testlist[expr_contextType.Load]
					{
					pushFollow(FOLLOW_testlist_in_return_stmt2723);
					testlist99=testlist(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist99.getTree());

					if ( state.backtracking==0 ) {
					           stype = new Return(RETURN98, actions.castExpr((testlist99!=null?((PythonTree)testlist99.getTree()):null)));
					       }
					}
					break;
				case 2 :
					// Python.g:903:8: 
					{
					if ( state.backtracking==0 ) {
					           stype = new Return(RETURN98, null);
					       }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "return_stmt"


	public static class yield_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "yield_stmt"
	// Python.g:910:1: yield_stmt : yield_expr ;
	public final PythonParser.yield_stmt_return yield_stmt() throws RecognitionException {
		PythonParser.yield_stmt_return retval = new PythonParser.yield_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope yield_expr100 =null;



		    stmt stype = null;

		try {
			// Python.g:917:5: ( yield_expr )
			// Python.g:917:7: yield_expr
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_yield_expr_in_yield_stmt2788);
			yield_expr100=yield_expr();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, yield_expr100.getTree());

			if ( state.backtracking==0 ) {
			        stype = new Expr((yield_expr100!=null?(yield_expr100.start):null), actions.castExpr((yield_expr100!=null?((PythonParser.yield_expr_return)yield_expr100).etype:null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "yield_stmt"


	public static class raise_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "raise_stmt"
	// Python.g:924:1: raise_stmt : RAISE (t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )? )? )? ;
	public final PythonParser.raise_stmt_return raise_stmt() throws RecognitionException {
		PythonParser.raise_stmt_return retval = new PythonParser.raise_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token RAISE101=null;
		Token COMMA102=null;
		Token COMMA103=null;
		ParserRuleReturnScope t1 =null;
		ParserRuleReturnScope t2 =null;
		ParserRuleReturnScope t3 =null;

		PythonTree RAISE101_tree=null;
		PythonTree COMMA102_tree=null;
		PythonTree COMMA103_tree=null;


		    stmt stype = null;

		try {
			// Python.g:931:5: ( RAISE (t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )? )? )? )
			// Python.g:931:7: RAISE (t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )? )? )?
			{
			root_0 = (PythonTree)adaptor.nil();


			RAISE101=(Token)match(input,RAISE,FOLLOW_RAISE_in_raise_stmt2824); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			RAISE101_tree = (PythonTree)adaptor.create(RAISE101);
			adaptor.addChild(root_0, RAISE101_tree);
			}

			// Python.g:931:13: (t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )? )? )?
			int alt48=2;
			int LA48_0 = input.LA(1);
			if ( (LA48_0==BACKQUOTE||(LA48_0 >= LBRACK && LA48_0 <= LCURLY)||(LA48_0 >= LPAREN && LA48_0 <= MINUS)||LA48_0==NAME||LA48_0==NOT||LA48_0==PLUS||LA48_0==TILDE) ) {
				alt48=1;
			}
			else if ( (LA48_0==PRINT) && ((printFunction))) {
				alt48=1;
			}
			else if ( (LA48_0==COMPLEX||LA48_0==FLOAT||LA48_0==INT||LA48_0==LAMBDA||LA48_0==LONGINT||LA48_0==STRING) ) {
				alt48=1;
			}
			switch (alt48) {
				case 1 :
					// Python.g:931:14: t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )? )?
					{
					pushFollow(FOLLOW_test_in_raise_stmt2829);
					t1=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t1.getTree());

					// Python.g:931:45: ( COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )? )?
					int alt47=2;
					int LA47_0 = input.LA(1);
					if ( (LA47_0==COMMA) ) {
						alt47=1;
					}
					switch (alt47) {
						case 1 :
							// Python.g:931:46: COMMA t2= test[expr_contextType.Load] ( COMMA t3= test[expr_contextType.Load] )?
							{
							COMMA102=(Token)match(input,COMMA,FOLLOW_COMMA_in_raise_stmt2833); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA102_tree = (PythonTree)adaptor.create(COMMA102);
							adaptor.addChild(root_0, COMMA102_tree);
							}

							pushFollow(FOLLOW_test_in_raise_stmt2837);
							t2=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t2.getTree());

							// Python.g:932:9: ( COMMA t3= test[expr_contextType.Load] )?
							int alt46=2;
							int LA46_0 = input.LA(1);
							if ( (LA46_0==COMMA) ) {
								alt46=1;
							}
							switch (alt46) {
								case 1 :
									// Python.g:932:10: COMMA t3= test[expr_contextType.Load]
									{
									COMMA103=(Token)match(input,COMMA,FOLLOW_COMMA_in_raise_stmt2849); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									COMMA103_tree = (PythonTree)adaptor.create(COMMA103);
									adaptor.addChild(root_0, COMMA103_tree);
									}

									pushFollow(FOLLOW_test_in_raise_stmt2853);
									t3=test(expr_contextType.Load);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, t3.getTree());

									}
									break;

							}

							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          stype = new Raise(RAISE101, actions.castExpr((t1!=null?((PythonTree)t1.getTree()):null)), actions.castExpr((t2!=null?((PythonTree)t2.getTree()):null)), actions.castExpr((t3!=null?((PythonTree)t3.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "raise_stmt"


	public static class import_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "import_stmt"
	// Python.g:939:1: import_stmt : ( import_name | import_from );
	public final PythonParser.import_stmt_return import_stmt() throws RecognitionException {
		PythonParser.import_stmt_return retval = new PythonParser.import_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope import_name104 =null;
		ParserRuleReturnScope import_from105 =null;


		try {
			// Python.g:940:5: ( import_name | import_from )
			int alt49=2;
			int LA49_0 = input.LA(1);
			if ( (LA49_0==IMPORT) ) {
				alt49=1;
			}
			else if ( (LA49_0==FROM) ) {
				alt49=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 49, 0, input);
				throw nvae;
			}

			switch (alt49) {
				case 1 :
					// Python.g:940:7: import_name
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_import_name_in_import_stmt2886);
					import_name104=import_name();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, import_name104.getTree());

					}
					break;
				case 2 :
					// Python.g:941:7: import_from
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_import_from_in_import_stmt2894);
					import_from105=import_from();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, import_from105.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "import_stmt"


	public static class import_name_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "import_name"
	// Python.g:945:1: import_name : IMPORT dotted_as_names ;
	public final PythonParser.import_name_return import_name() throws RecognitionException {
		PythonParser.import_name_return retval = new PythonParser.import_name_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token IMPORT106=null;
		ParserRuleReturnScope dotted_as_names107 =null;

		PythonTree IMPORT106_tree=null;


		    stmt stype = null;

		try {
			// Python.g:952:5: ( IMPORT dotted_as_names )
			// Python.g:952:7: IMPORT dotted_as_names
			{
			root_0 = (PythonTree)adaptor.nil();


			IMPORT106=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_import_name2922); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IMPORT106_tree = (PythonTree)adaptor.create(IMPORT106);
			adaptor.addChild(root_0, IMPORT106_tree);
			}

			pushFollow(FOLLOW_dotted_as_names_in_import_name2924);
			dotted_as_names107=dotted_as_names();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, dotted_as_names107.getTree());

			if ( state.backtracking==0 ) {
			          stype = new Import(IMPORT106, (dotted_as_names107!=null?((PythonParser.dotted_as_names_return)dotted_as_names107).atypes:null));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "import_name"


	public static class import_from_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "import_from"
	// Python.g:960:1: import_from : FROM ( (d+= DOT )* dotted_name | (d+= DOT )+ ) IMPORT ( STAR |i1= import_as_names | LPAREN i2= import_as_names ( COMMA )? RPAREN ) ;
	public final PythonParser.import_from_return import_from() throws RecognitionException {
		PythonParser.import_from_return retval = new PythonParser.import_from_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token FROM108=null;
		Token IMPORT110=null;
		Token STAR111=null;
		Token LPAREN112=null;
		Token COMMA113=null;
		Token RPAREN114=null;
		Token d=null;
		List<Object> list_d=null;
		ParserRuleReturnScope i1 =null;
		ParserRuleReturnScope i2 =null;
		ParserRuleReturnScope dotted_name109 =null;

		PythonTree FROM108_tree=null;
		PythonTree IMPORT110_tree=null;
		PythonTree STAR111_tree=null;
		PythonTree LPAREN112_tree=null;
		PythonTree COMMA113_tree=null;
		PythonTree RPAREN114_tree=null;
		PythonTree d_tree=null;


		    stmt stype = null;

		try {
			// Python.g:967:5: ( FROM ( (d+= DOT )* dotted_name | (d+= DOT )+ ) IMPORT ( STAR |i1= import_as_names | LPAREN i2= import_as_names ( COMMA )? RPAREN ) )
			// Python.g:967:7: FROM ( (d+= DOT )* dotted_name | (d+= DOT )+ ) IMPORT ( STAR |i1= import_as_names | LPAREN i2= import_as_names ( COMMA )? RPAREN )
			{
			root_0 = (PythonTree)adaptor.nil();


			FROM108=(Token)match(input,FROM,FOLLOW_FROM_in_import_from2961); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			FROM108_tree = (PythonTree)adaptor.create(FROM108);
			adaptor.addChild(root_0, FROM108_tree);
			}

			// Python.g:967:12: ( (d+= DOT )* dotted_name | (d+= DOT )+ )
			int alt52=2;
			alt52 = dfa52.predict(input);
			switch (alt52) {
				case 1 :
					// Python.g:967:13: (d+= DOT )* dotted_name
					{
					// Python.g:967:14: (d+= DOT )*
					loop50:
					while (true) {
						int alt50=2;
						int LA50_0 = input.LA(1);
						if ( (LA50_0==DOT) ) {
							alt50=1;
						}

						switch (alt50) {
						case 1 :
							// Python.g:967:14: d+= DOT
							{
							d=(Token)match(input,DOT,FOLLOW_DOT_in_import_from2966); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							d_tree = (PythonTree)adaptor.create(d);
							adaptor.addChild(root_0, d_tree);
							}

							if (list_d==null) list_d=new ArrayList<Object>();
							list_d.add(d);
							}
							break;

						default :
							break loop50;
						}
					}

					pushFollow(FOLLOW_dotted_name_in_import_from2969);
					dotted_name109=dotted_name();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, dotted_name109.getTree());

					}
					break;
				case 2 :
					// Python.g:967:35: (d+= DOT )+
					{
					// Python.g:967:36: (d+= DOT )+
					int cnt51=0;
					loop51:
					while (true) {
						int alt51=2;
						int LA51_0 = input.LA(1);
						if ( (LA51_0==DOT) ) {
							alt51=1;
						}

						switch (alt51) {
						case 1 :
							// Python.g:967:36: d+= DOT
							{
							d=(Token)match(input,DOT,FOLLOW_DOT_in_import_from2975); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							d_tree = (PythonTree)adaptor.create(d);
							adaptor.addChild(root_0, d_tree);
							}

							if (list_d==null) list_d=new ArrayList<Object>();
							list_d.add(d);
							}
							break;

						default :
							if ( cnt51 >= 1 ) break loop51;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(51, input);
							throw eee;
						}
						cnt51++;
					}

					}
					break;

			}

			IMPORT110=(Token)match(input,IMPORT,FOLLOW_IMPORT_in_import_from2979); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IMPORT110_tree = (PythonTree)adaptor.create(IMPORT110);
			adaptor.addChild(root_0, IMPORT110_tree);
			}

			// Python.g:968:9: ( STAR |i1= import_as_names | LPAREN i2= import_as_names ( COMMA )? RPAREN )
			int alt54=3;
			switch ( input.LA(1) ) {
			case STAR:
				{
				alt54=1;
				}
				break;
			case NAME:
				{
				alt54=2;
				}
				break;
			case LPAREN:
				{
				alt54=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 54, 0, input);
				throw nvae;
			}
			switch (alt54) {
				case 1 :
					// Python.g:968:10: STAR
					{
					STAR111=(Token)match(input,STAR,FOLLOW_STAR_in_import_from2990); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					STAR111_tree = (PythonTree)adaptor.create(STAR111);
					adaptor.addChild(root_0, STAR111_tree);
					}

					if ( state.backtracking==0 ) {
					             stype = new ImportFrom(FROM108, actions.makeFromText(list_d, (dotted_name109!=null?((PythonParser.dotted_name_return)dotted_name109).names:null)),
					                 actions.makeModuleNameNode(list_d, (dotted_name109!=null?((PythonParser.dotted_name_return)dotted_name109).names:null)),
					                 actions.makeStarAlias(STAR111), actions.makeLevel(list_d));
					         }
					}
					break;
				case 2 :
					// Python.g:974:11: i1= import_as_names
					{
					pushFollow(FOLLOW_import_as_names_in_import_from3015);
					i1=import_as_names();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, i1.getTree());

					if ( state.backtracking==0 ) {
					             String dottedText = (dotted_name109!=null?input.toString(dotted_name109.start,dotted_name109.stop):null);
					             if (dottedText != null && dottedText.equals("__future__")) {
					                 List<alias> aliases = (i1!=null?((PythonParser.import_as_names_return)i1).atypes:null);
					                 for(alias a: aliases) {
					                     if (a != null) {
					                         if (a.getInternalName().equals("print_function")) {
					                             printFunction = true;
					                         } else if (a.getInternalName().equals("unicode_literals")) {
					                             unicodeLiterals = true;
					                         }
					                     }
					                 }
					             }
					             stype = new ImportFrom(FROM108, actions.makeFromText(list_d, (dotted_name109!=null?((PythonParser.dotted_name_return)dotted_name109).names:null)),
					                 actions.makeModuleNameNode(list_d, (dotted_name109!=null?((PythonParser.dotted_name_return)dotted_name109).names:null)),
					                 actions.makeAliases((i1!=null?((PythonParser.import_as_names_return)i1).atypes:null)), actions.makeLevel(list_d));
					         }
					}
					break;
				case 3 :
					// Python.g:993:11: LPAREN i2= import_as_names ( COMMA )? RPAREN
					{
					LPAREN112=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_import_from3038); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LPAREN112_tree = (PythonTree)adaptor.create(LPAREN112);
					adaptor.addChild(root_0, LPAREN112_tree);
					}

					pushFollow(FOLLOW_import_as_names_in_import_from3042);
					i2=import_as_names();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, i2.getTree());

					// Python.g:993:37: ( COMMA )?
					int alt53=2;
					int LA53_0 = input.LA(1);
					if ( (LA53_0==COMMA) ) {
						alt53=1;
					}
					switch (alt53) {
						case 1 :
							// Python.g:993:37: COMMA
							{
							COMMA113=(Token)match(input,COMMA,FOLLOW_COMMA_in_import_from3044); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA113_tree = (PythonTree)adaptor.create(COMMA113);
							adaptor.addChild(root_0, COMMA113_tree);
							}

							}
							break;

					}

					RPAREN114=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_import_from3047); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RPAREN114_tree = (PythonTree)adaptor.create(RPAREN114);
					adaptor.addChild(root_0, RPAREN114_tree);
					}

					if ( state.backtracking==0 ) {
					             //XXX: this is almost a complete C&P of the code above - is there some way
					             //     to factor it out?
					             String dottedText = (dotted_name109!=null?input.toString(dotted_name109.start,dotted_name109.stop):null);
					             if (dottedText != null && dottedText.equals("__future__")) {
					                 List<alias> aliases = (i2!=null?((PythonParser.import_as_names_return)i2).atypes:null);
					                 for(alias a: aliases) {
					                     if (a != null) {
					                         if (a.getInternalName().equals("print_function")) {
					                             printFunction = true;
					                         } else if (a.getInternalName().equals("unicode_literals")) {
					                             unicodeLiterals = true;
					                         }
					                     }
					                 }
					             }
					             stype = new ImportFrom(FROM108, actions.makeFromText(list_d, (dotted_name109!=null?((PythonParser.dotted_name_return)dotted_name109).names:null)),
					                 actions.makeModuleNameNode(list_d, (dotted_name109!=null?((PythonParser.dotted_name_return)dotted_name109).names:null)),
					                 actions.makeAliases((i2!=null?((PythonParser.import_as_names_return)i2).atypes:null)), actions.makeLevel(list_d));
					         }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "import_from"


	public static class import_as_names_return extends ParserRuleReturnScope {
		public List<alias> atypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "import_as_names"
	// Python.g:1018:1: import_as_names returns [List<alias> atypes] : n= import_as_name ( COMMA !n= import_as_name )* ;
	public final PythonParser.import_as_names_return import_as_names() throws RecognitionException {
		PythonParser.import_as_names_return retval = new PythonParser.import_as_names_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA115=null;
		ParserRuleReturnScope n =null;

		PythonTree COMMA115_tree=null;

		retval.atypes = new ArrayList<alias>();
		try {
			// Python.g:1021:5: (n= import_as_name ( COMMA !n= import_as_name )* )
			// Python.g:1021:7: n= import_as_name ( COMMA !n= import_as_name )*
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_import_as_name_in_import_as_names3104);
			n=import_as_name();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, n.getTree());

			if ( state.backtracking==0 ) {retval.atypes.add((n!=null?((PythonParser.import_as_name_return)n).atype:null));}
			// Python.g:1022:9: ( COMMA !n= import_as_name )*
			loop55:
			while (true) {
				int alt55=2;
				int LA55_0 = input.LA(1);
				if ( (LA55_0==COMMA) ) {
					int LA55_2 = input.LA(2);
					if ( (LA55_2==NAME) ) {
						alt55=1;
					}

				}

				switch (alt55) {
				case 1 :
					// Python.g:1022:10: COMMA !n= import_as_name
					{
					COMMA115=(Token)match(input,COMMA,FOLLOW_COMMA_in_import_as_names3117); if (state.failed) return retval;
					pushFollow(FOLLOW_import_as_name_in_import_as_names3122);
					n=import_as_name();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, n.getTree());

					if ( state.backtracking==0 ) {retval.atypes.add((n!=null?((PythonParser.import_as_name_return)n).atype:null));}
					}
					break;

				default :
					break loop55;
				}
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "import_as_names"


	public static class import_as_name_return extends ParserRuleReturnScope {
		public alias atype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "import_as_name"
	// Python.g:1026:1: import_as_name returns [alias atype] : name= NAME ( AS asname= NAME )? ;
	public final PythonParser.import_as_name_return import_as_name() throws RecognitionException {
		PythonParser.import_as_name_return retval = new PythonParser.import_as_name_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token name=null;
		Token asname=null;
		Token AS116=null;

		PythonTree name_tree=null;
		PythonTree asname_tree=null;
		PythonTree AS116_tree=null;

		try {
			// Python.g:1031:5: (name= NAME ( AS asname= NAME )? )
			// Python.g:1031:7: name= NAME ( AS asname= NAME )?
			{
			root_0 = (PythonTree)adaptor.nil();


			name=(Token)match(input,NAME,FOLLOW_NAME_in_import_as_name3159); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			name_tree = (PythonTree)adaptor.create(name);
			adaptor.addChild(root_0, name_tree);
			}

			// Python.g:1031:17: ( AS asname= NAME )?
			int alt56=2;
			int LA56_0 = input.LA(1);
			if ( (LA56_0==AS) ) {
				alt56=1;
			}
			switch (alt56) {
				case 1 :
					// Python.g:1031:18: AS asname= NAME
					{
					AS116=(Token)match(input,AS,FOLLOW_AS_in_import_as_name3162); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					AS116_tree = (PythonTree)adaptor.create(AS116);
					adaptor.addChild(root_0, AS116_tree);
					}

					asname=(Token)match(input,NAME,FOLLOW_NAME_in_import_as_name3166); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					asname_tree = (PythonTree)adaptor.create(asname);
					adaptor.addChild(root_0, asname_tree);
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			        retval.atype = new alias(actions.makeNameNode(name), actions.makeNameNode(asname));
			    }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = retval.atype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "import_as_name"


	public static class dotted_as_name_return extends ParserRuleReturnScope {
		public alias atype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "dotted_as_name"
	// Python.g:1039:1: dotted_as_name returns [alias atype] : dotted_name ( AS asname= NAME )? ;
	public final PythonParser.dotted_as_name_return dotted_as_name() throws RecognitionException {
		PythonParser.dotted_as_name_return retval = new PythonParser.dotted_as_name_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token asname=null;
		Token AS118=null;
		ParserRuleReturnScope dotted_name117 =null;

		PythonTree asname_tree=null;
		PythonTree AS118_tree=null;

		try {
			// Python.g:1044:5: ( dotted_name ( AS asname= NAME )? )
			// Python.g:1044:7: dotted_name ( AS asname= NAME )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_dotted_name_in_dotted_as_name3206);
			dotted_name117=dotted_name();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, dotted_name117.getTree());

			// Python.g:1044:19: ( AS asname= NAME )?
			int alt57=2;
			int LA57_0 = input.LA(1);
			if ( (LA57_0==AS) ) {
				alt57=1;
			}
			switch (alt57) {
				case 1 :
					// Python.g:1044:20: AS asname= NAME
					{
					AS118=(Token)match(input,AS,FOLLOW_AS_in_dotted_as_name3209); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					AS118_tree = (PythonTree)adaptor.create(AS118);
					adaptor.addChild(root_0, AS118_tree);
					}

					asname=(Token)match(input,NAME,FOLLOW_NAME_in_dotted_as_name3213); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					asname_tree = (PythonTree)adaptor.create(asname);
					adaptor.addChild(root_0, asname_tree);
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			        retval.atype = new alias((dotted_name117!=null?((PythonParser.dotted_name_return)dotted_name117).names:null), actions.makeNameNode(asname));
			    }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = retval.atype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "dotted_as_name"


	public static class dotted_as_names_return extends ParserRuleReturnScope {
		public List<alias> atypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "dotted_as_names"
	// Python.g:1051:1: dotted_as_names returns [List<alias> atypes] : d= dotted_as_name ( COMMA !d= dotted_as_name )* ;
	public final PythonParser.dotted_as_names_return dotted_as_names() throws RecognitionException {
		PythonParser.dotted_as_names_return retval = new PythonParser.dotted_as_names_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA119=null;
		ParserRuleReturnScope d =null;

		PythonTree COMMA119_tree=null;

		retval.atypes = new ArrayList<alias>();
		try {
			// Python.g:1054:5: (d= dotted_as_name ( COMMA !d= dotted_as_name )* )
			// Python.g:1054:7: d= dotted_as_name ( COMMA !d= dotted_as_name )*
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_dotted_as_name_in_dotted_as_names3257);
			d=dotted_as_name();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, d.getTree());

			if ( state.backtracking==0 ) {retval.atypes.add((d!=null?((PythonParser.dotted_as_name_return)d).atype:null));}
			// Python.g:1055:9: ( COMMA !d= dotted_as_name )*
			loop58:
			while (true) {
				int alt58=2;
				int LA58_0 = input.LA(1);
				if ( (LA58_0==COMMA) ) {
					alt58=1;
				}

				switch (alt58) {
				case 1 :
					// Python.g:1055:10: COMMA !d= dotted_as_name
					{
					COMMA119=(Token)match(input,COMMA,FOLLOW_COMMA_in_dotted_as_names3270); if (state.failed) return retval;
					pushFollow(FOLLOW_dotted_as_name_in_dotted_as_names3275);
					d=dotted_as_name();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, d.getTree());

					if ( state.backtracking==0 ) {retval.atypes.add((d!=null?((PythonParser.dotted_as_name_return)d).atype:null));}
					}
					break;

				default :
					break loop58;
				}
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "dotted_as_names"


	public static class dotted_name_return extends ParserRuleReturnScope {
		public List<Name> names;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "dotted_name"
	// Python.g:1059:1: dotted_name returns [List<Name> names] : NAME ( DOT dn= attr )* ;
	public final PythonParser.dotted_name_return dotted_name() throws RecognitionException {
		PythonParser.dotted_name_return retval = new PythonParser.dotted_name_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NAME120=null;
		Token DOT121=null;
		ParserRuleReturnScope dn =null;

		PythonTree NAME120_tree=null;
		PythonTree DOT121_tree=null;

		List<PythonTree> dnList = new ArrayList<>();
		try {
			// Python.g:1062:5: ( NAME ( DOT dn= attr )* )
			// Python.g:1062:7: NAME ( DOT dn= attr )*
			{
			root_0 = (PythonTree)adaptor.nil();


			NAME120=(Token)match(input,NAME,FOLLOW_NAME_in_dotted_name3313); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			NAME120_tree = (PythonTree)adaptor.create(NAME120);
			adaptor.addChild(root_0, NAME120_tree);
			}

			// Python.g:1062:12: ( DOT dn= attr )*
			loop59:
			while (true) {
				int alt59=2;
				int LA59_0 = input.LA(1);
				if ( (LA59_0==DOT) ) {
					alt59=1;
				}

				switch (alt59) {
				case 1 :
					// Python.g:1062:13: DOT dn= attr
					{
					DOT121=(Token)match(input,DOT,FOLLOW_DOT_in_dotted_name3316); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOT121_tree = (PythonTree)adaptor.create(DOT121);
					adaptor.addChild(root_0, DOT121_tree);
					}

					pushFollow(FOLLOW_attr_in_dotted_name3320);
					dn=attr();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, dn.getTree());

					if ( state.backtracking==0 ) {dnList.add((dn!=null?((PythonTree)dn.getTree()):null));}
					}
					break;

				default :
					break loop59;
				}
			}

			if ( state.backtracking==0 ) {retval.names = actions.makeDottedName(NAME120, dnList);}
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "dotted_name"


	public static class global_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "global_stmt"
	// Python.g:1067:1: global_stmt : GLOBAL n= NAME ( COMMA n= NAME )* ;
	public final PythonParser.global_stmt_return global_stmt() throws RecognitionException {
		PythonParser.global_stmt_return retval = new PythonParser.global_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token n=null;
		Token GLOBAL122=null;
		Token COMMA123=null;

		PythonTree n_tree=null;
		PythonTree GLOBAL122_tree=null;
		PythonTree COMMA123_tree=null;


		    stmt stype = null;
		    List<Token> names = new ArrayList<>();

		try {
			// Python.g:1075:5: ( GLOBAL n= NAME ( COMMA n= NAME )* )
			// Python.g:1075:7: GLOBAL n= NAME ( COMMA n= NAME )*
			{
			root_0 = (PythonTree)adaptor.nil();


			GLOBAL122=(Token)match(input,GLOBAL,FOLLOW_GLOBAL_in_global_stmt3362); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			GLOBAL122_tree = (PythonTree)adaptor.create(GLOBAL122);
			adaptor.addChild(root_0, GLOBAL122_tree);
			}

			n=(Token)match(input,NAME,FOLLOW_NAME_in_global_stmt3366); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			n_tree = (PythonTree)adaptor.create(n);
			adaptor.addChild(root_0, n_tree);
			}

			if ( state.backtracking==0 ) {names.add(n);}
			// Python.g:1075:38: ( COMMA n= NAME )*
			loop60:
			while (true) {
				int alt60=2;
				int LA60_0 = input.LA(1);
				if ( (LA60_0==COMMA) ) {
					alt60=1;
				}

				switch (alt60) {
				case 1 :
					// Python.g:1075:39: COMMA n= NAME
					{
					COMMA123=(Token)match(input,COMMA,FOLLOW_COMMA_in_global_stmt3371); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA123_tree = (PythonTree)adaptor.create(COMMA123);
					adaptor.addChild(root_0, COMMA123_tree);
					}

					n=(Token)match(input,NAME,FOLLOW_NAME_in_global_stmt3375); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					n_tree = (PythonTree)adaptor.create(n);
					adaptor.addChild(root_0, n_tree);
					}

					if ( state.backtracking==0 ) {names.add(n);}
					}
					break;

				default :
					break loop60;
				}
			}

			if ( state.backtracking==0 ) {
			          stype = new Global(GLOBAL122, actions.makeNames(names), actions.makeNameNodes(names));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "global_stmt"


	public static class exec_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "exec_stmt"
	// Python.g:1082:1: exec_stmt : EXEC expr[expr_contextType.Load] ( IN t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )? )? ;
	public final PythonParser.exec_stmt_return exec_stmt() throws RecognitionException {
		PythonParser.exec_stmt_return retval = new PythonParser.exec_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token EXEC124=null;
		Token IN126=null;
		Token COMMA127=null;
		ParserRuleReturnScope t1 =null;
		ParserRuleReturnScope t2 =null;
		ParserRuleReturnScope expr125 =null;

		PythonTree EXEC124_tree=null;
		PythonTree IN126_tree=null;
		PythonTree COMMA127_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1089:5: ( EXEC expr[expr_contextType.Load] ( IN t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )? )? )
			// Python.g:1089:7: EXEC expr[expr_contextType.Load] ( IN t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )? )?
			{
			root_0 = (PythonTree)adaptor.nil();


			EXEC124=(Token)match(input,EXEC,FOLLOW_EXEC_in_exec_stmt3415); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			EXEC124_tree = (PythonTree)adaptor.create(EXEC124);
			adaptor.addChild(root_0, EXEC124_tree);
			}

			pushFollow(FOLLOW_expr_in_exec_stmt3417);
			expr125=expr(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, expr125.getTree());

			// Python.g:1089:40: ( IN t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )? )?
			int alt62=2;
			int LA62_0 = input.LA(1);
			if ( (LA62_0==IN) ) {
				alt62=1;
			}
			switch (alt62) {
				case 1 :
					// Python.g:1089:41: IN t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )?
					{
					IN126=(Token)match(input,IN,FOLLOW_IN_in_exec_stmt3421); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					IN126_tree = (PythonTree)adaptor.create(IN126);
					adaptor.addChild(root_0, IN126_tree);
					}

					pushFollow(FOLLOW_test_in_exec_stmt3425);
					t1=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t1.getTree());

					// Python.g:1089:75: ( COMMA t2= test[expr_contextType.Load] )?
					int alt61=2;
					int LA61_0 = input.LA(1);
					if ( (LA61_0==COMMA) ) {
						alt61=1;
					}
					switch (alt61) {
						case 1 :
							// Python.g:1089:76: COMMA t2= test[expr_contextType.Load]
							{
							COMMA127=(Token)match(input,COMMA,FOLLOW_COMMA_in_exec_stmt3429); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA127_tree = (PythonTree)adaptor.create(COMMA127);
							adaptor.addChild(root_0, COMMA127_tree);
							}

							pushFollow(FOLLOW_test_in_exec_stmt3433);
							t2=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t2.getTree());

							}
							break;

					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			         stype = new Exec(EXEC124, actions.castExpr((expr125!=null?((PythonTree)expr125.getTree()):null)), actions.castExpr((t1!=null?((PythonTree)t1.getTree()):null)), actions.castExpr((t2!=null?((PythonTree)t2.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exec_stmt"


	public static class assert_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "assert_stmt"
	// Python.g:1096:1: assert_stmt : ASSERT t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )? ;
	public final PythonParser.assert_stmt_return assert_stmt() throws RecognitionException {
		PythonParser.assert_stmt_return retval = new PythonParser.assert_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token ASSERT128=null;
		Token COMMA129=null;
		ParserRuleReturnScope t1 =null;
		ParserRuleReturnScope t2 =null;

		PythonTree ASSERT128_tree=null;
		PythonTree COMMA129_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1103:5: ( ASSERT t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )? )
			// Python.g:1103:7: ASSERT t1= test[expr_contextType.Load] ( COMMA t2= test[expr_contextType.Load] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			ASSERT128=(Token)match(input,ASSERT,FOLLOW_ASSERT_in_assert_stmt3474); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			ASSERT128_tree = (PythonTree)adaptor.create(ASSERT128);
			adaptor.addChild(root_0, ASSERT128_tree);
			}

			pushFollow(FOLLOW_test_in_assert_stmt3478);
			t1=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, t1.getTree());

			// Python.g:1103:45: ( COMMA t2= test[expr_contextType.Load] )?
			int alt63=2;
			int LA63_0 = input.LA(1);
			if ( (LA63_0==COMMA) ) {
				alt63=1;
			}
			switch (alt63) {
				case 1 :
					// Python.g:1103:46: COMMA t2= test[expr_contextType.Load]
					{
					COMMA129=(Token)match(input,COMMA,FOLLOW_COMMA_in_assert_stmt3482); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA129_tree = (PythonTree)adaptor.create(COMMA129);
					adaptor.addChild(root_0, COMMA129_tree);
					}

					pushFollow(FOLLOW_test_in_assert_stmt3486);
					t2=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t2.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          stype = new Assert(ASSERT128, actions.castExpr((t1!=null?((PythonTree)t1.getTree()):null)), actions.castExpr((t2!=null?((PythonTree)t2.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "assert_stmt"


	public static class compound_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "compound_stmt"
	// Python.g:1110:1: compound_stmt : ( if_stmt | while_stmt | for_stmt | try_stmt | with_stmt | ( ( decorators )? DEF )=> funcdef | classdef );
	public final PythonParser.compound_stmt_return compound_stmt() throws RecognitionException {
		PythonParser.compound_stmt_return retval = new PythonParser.compound_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope if_stmt130 =null;
		ParserRuleReturnScope while_stmt131 =null;
		ParserRuleReturnScope for_stmt132 =null;
		ParserRuleReturnScope try_stmt133 =null;
		ParserRuleReturnScope with_stmt134 =null;
		ParserRuleReturnScope funcdef135 =null;
		ParserRuleReturnScope classdef136 =null;


		try {
			// Python.g:1111:5: ( if_stmt | while_stmt | for_stmt | try_stmt | with_stmt | ( ( decorators )? DEF )=> funcdef | classdef )
			int alt64=7;
			int LA64_0 = input.LA(1);
			if ( (LA64_0==IF) ) {
				alt64=1;
			}
			else if ( (LA64_0==WHILE) ) {
				alt64=2;
			}
			else if ( (LA64_0==FOR) ) {
				alt64=3;
			}
			else if ( (LA64_0==TRY) ) {
				alt64=4;
			}
			else if ( (LA64_0==WITH) ) {
				alt64=5;
			}
			else if ( (LA64_0==AT) ) {
				int LA64_6 = input.LA(2);
				if ( (synpred6_Python()) ) {
					alt64=6;
				}
				else if ( (true) ) {
					alt64=7;
				}

			}
			else if ( (LA64_0==DEF) && (synpred6_Python())) {
				alt64=6;
			}
			else if ( (LA64_0==CLASS) ) {
				alt64=7;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 64, 0, input);
				throw nvae;
			}

			switch (alt64) {
				case 1 :
					// Python.g:1111:7: if_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_if_stmt_in_compound_stmt3515);
					if_stmt130=if_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, if_stmt130.getTree());

					}
					break;
				case 2 :
					// Python.g:1112:7: while_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_while_stmt_in_compound_stmt3523);
					while_stmt131=while_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, while_stmt131.getTree());

					}
					break;
				case 3 :
					// Python.g:1113:7: for_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_for_stmt_in_compound_stmt3531);
					for_stmt132=for_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, for_stmt132.getTree());

					}
					break;
				case 4 :
					// Python.g:1114:7: try_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_try_stmt_in_compound_stmt3539);
					try_stmt133=try_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, try_stmt133.getTree());

					}
					break;
				case 5 :
					// Python.g:1115:7: with_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_with_stmt_in_compound_stmt3547);
					with_stmt134=with_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, with_stmt134.getTree());

					}
					break;
				case 6 :
					// Python.g:1116:7: ( ( decorators )? DEF )=> funcdef
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_funcdef_in_compound_stmt3564);
					funcdef135=funcdef();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, funcdef135.getTree());

					}
					break;
				case 7 :
					// Python.g:1117:7: classdef
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_classdef_in_compound_stmt3572);
					classdef136=classdef();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, classdef136.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "compound_stmt"


	public static class if_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "if_stmt"
	// Python.g:1121:1: if_stmt : IF test[expr_contextType.Load] COLON ifsuite= suite[false] ( elif_clause )? ;
	public final PythonParser.if_stmt_return if_stmt() throws RecognitionException {
		PythonParser.if_stmt_return retval = new PythonParser.if_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token IF137=null;
		Token COLON139=null;
		ParserRuleReturnScope ifsuite =null;
		ParserRuleReturnScope test138 =null;
		ParserRuleReturnScope elif_clause140 =null;

		PythonTree IF137_tree=null;
		PythonTree COLON139_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1128:5: ( IF test[expr_contextType.Load] COLON ifsuite= suite[false] ( elif_clause )? )
			// Python.g:1128:7: IF test[expr_contextType.Load] COLON ifsuite= suite[false] ( elif_clause )?
			{
			root_0 = (PythonTree)adaptor.nil();


			IF137=(Token)match(input,IF,FOLLOW_IF_in_if_stmt3600); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IF137_tree = (PythonTree)adaptor.create(IF137);
			adaptor.addChild(root_0, IF137_tree);
			}

			pushFollow(FOLLOW_test_in_if_stmt3602);
			test138=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, test138.getTree());

			COLON139=(Token)match(input,COLON,FOLLOW_COLON_in_if_stmt3605); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON139_tree = (PythonTree)adaptor.create(COLON139);
			adaptor.addChild(root_0, COLON139_tree);
			}

			pushFollow(FOLLOW_suite_in_if_stmt3609);
			ifsuite=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, ifsuite.getTree());

			// Python.g:1128:65: ( elif_clause )?
			int alt65=2;
			int LA65_0 = input.LA(1);
			if ( (LA65_0==ELIF||LA65_0==ORELSE) ) {
				alt65=1;
			}
			switch (alt65) {
				case 1 :
					// Python.g:1128:65: elif_clause
					{
					pushFollow(FOLLOW_elif_clause_in_if_stmt3612);
					elif_clause140=elif_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, elif_clause140.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          stype = new If(IF137, actions.castExpr((test138!=null?((PythonTree)test138.getTree()):null)), actions.castStmts((ifsuite!=null?((PythonParser.suite_return)ifsuite).stypes:null)),
			              actions.makeElse((elif_clause140!=null?((PythonParser.elif_clause_return)elif_clause140).stypes:null), (elif_clause140!=null?((PythonTree)elif_clause140.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "if_stmt"


	public static class elif_clause_return extends ParserRuleReturnScope {
		public List stypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "elif_clause"
	// Python.g:1136:1: elif_clause returns [List stypes] : ( else_clause | ELIF test[expr_contextType.Load] COLON suite[false] (e2= elif_clause |) );
	public final PythonParser.elif_clause_return elif_clause() throws RecognitionException {
		PythonParser.elif_clause_return retval = new PythonParser.elif_clause_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token ELIF142=null;
		Token COLON144=null;
		ParserRuleReturnScope e2 =null;
		ParserRuleReturnScope else_clause141 =null;
		ParserRuleReturnScope test143 =null;
		ParserRuleReturnScope suite145 =null;

		PythonTree ELIF142_tree=null;
		PythonTree COLON144_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1146:5: ( else_clause | ELIF test[expr_contextType.Load] COLON suite[false] (e2= elif_clause |) )
			int alt67=2;
			int LA67_0 = input.LA(1);
			if ( (LA67_0==ORELSE) ) {
				alt67=1;
			}
			else if ( (LA67_0==ELIF) ) {
				alt67=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 67, 0, input);
				throw nvae;
			}

			switch (alt67) {
				case 1 :
					// Python.g:1146:7: else_clause
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_else_clause_in_elif_clause3657);
					else_clause141=else_clause();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, else_clause141.getTree());

					if ( state.backtracking==0 ) {
					          retval.stypes = (else_clause141!=null?((PythonParser.else_clause_return)else_clause141).stypes:null);
					      }
					}
					break;
				case 2 :
					// Python.g:1150:7: ELIF test[expr_contextType.Load] COLON suite[false] (e2= elif_clause |)
					{
					root_0 = (PythonTree)adaptor.nil();


					ELIF142=(Token)match(input,ELIF,FOLLOW_ELIF_in_elif_clause3673); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ELIF142_tree = (PythonTree)adaptor.create(ELIF142);
					adaptor.addChild(root_0, ELIF142_tree);
					}

					pushFollow(FOLLOW_test_in_elif_clause3675);
					test143=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, test143.getTree());

					COLON144=(Token)match(input,COLON,FOLLOW_COLON_in_elif_clause3678); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COLON144_tree = (PythonTree)adaptor.create(COLON144);
					adaptor.addChild(root_0, COLON144_tree);
					}

					pushFollow(FOLLOW_suite_in_elif_clause3680);
					suite145=suite(false);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, suite145.getTree());

					// Python.g:1151:7: (e2= elif_clause |)
					int alt66=2;
					int LA66_0 = input.LA(1);
					if ( (LA66_0==ELIF||LA66_0==ORELSE) ) {
						alt66=1;
					}
					else if ( (LA66_0==EOF||LA66_0==ASSERT||(LA66_0 >= AT && LA66_0 <= BREAK)||LA66_0==CLASS||(LA66_0 >= COMPLEX && LA66_0 <= CONTINUE)||(LA66_0 >= DEDENT && LA66_0 <= DELETE)||LA66_0==EXEC||(LA66_0 >= FLOAT && LA66_0 <= GLOBAL)||(LA66_0 >= IF && LA66_0 <= IMPORT)||LA66_0==INT||(LA66_0 >= LAMBDA && LA66_0 <= LCURLY)||(LA66_0 >= LONGINT && LA66_0 <= MINUS)||(LA66_0 >= NAME && LA66_0 <= NOT)||LA66_0==PASS||LA66_0==PLUS||(LA66_0 >= PRINT && LA66_0 <= RAISE)||LA66_0==RETURN||(LA66_0 >= STRING && LA66_0 <= TILDE)||LA66_0==TRY||(LA66_0 >= WHILE && LA66_0 <= WITH)||LA66_0==YIELD) ) {
						alt66=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 66, 0, input);
						throw nvae;
					}

					switch (alt66) {
						case 1 :
							// Python.g:1151:8: e2= elif_clause
							{
							pushFollow(FOLLOW_elif_clause_in_elif_clause3692);
							e2=elif_clause();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, e2.getTree());

							if ( state.backtracking==0 ) {
							           stype = new If((test143!=null?(test143.start):null), actions.castExpr((test143!=null?((PythonTree)test143.getTree()):null)), actions.castStmts((suite145!=null?((PythonParser.suite_return)suite145).stypes:null)), actions.makeElse((e2!=null?((PythonParser.elif_clause_return)e2).stypes:null), (e2!=null?((PythonTree)e2.getTree()):null)));
							       }
							}
							break;
						case 2 :
							// Python.g:1156:8: 
							{
							if ( state.backtracking==0 ) {
							           stype = new If((test143!=null?(test143.start):null), actions.castExpr((test143!=null?((PythonTree)test143.getTree()):null)), actions.castStmts((suite145!=null?((PythonParser.suite_return)suite145).stypes:null)), new ArrayList<stmt>());
							       }
							}
							break;

					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   if (stype != null) {
			       retval.tree = stype;
			   }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "elif_clause"


	public static class else_clause_return extends ParserRuleReturnScope {
		public List stypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "else_clause"
	// Python.g:1163:1: else_clause returns [List stypes] : ORELSE COLON elsesuite= suite[false] ;
	public final PythonParser.else_clause_return else_clause() throws RecognitionException {
		PythonParser.else_clause_return retval = new PythonParser.else_clause_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token ORELSE146=null;
		Token COLON147=null;
		ParserRuleReturnScope elsesuite =null;

		PythonTree ORELSE146_tree=null;
		PythonTree COLON147_tree=null;

		try {
			// Python.g:1165:5: ( ORELSE COLON elsesuite= suite[false] )
			// Python.g:1165:7: ORELSE COLON elsesuite= suite[false]
			{
			root_0 = (PythonTree)adaptor.nil();


			ORELSE146=(Token)match(input,ORELSE,FOLLOW_ORELSE_in_else_clause3752); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			ORELSE146_tree = (PythonTree)adaptor.create(ORELSE146);
			adaptor.addChild(root_0, ORELSE146_tree);
			}

			COLON147=(Token)match(input,COLON,FOLLOW_COLON_in_else_clause3754); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON147_tree = (PythonTree)adaptor.create(COLON147);
			adaptor.addChild(root_0, COLON147_tree);
			}

			pushFollow(FOLLOW_suite_in_else_clause3758);
			elsesuite=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, elsesuite.getTree());

			if ( state.backtracking==0 ) {
			          retval.stypes = (elsesuite!=null?((PythonParser.suite_return)elsesuite).stypes:null);
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "else_clause"


	public static class while_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "while_stmt"
	// Python.g:1172:1: while_stmt : WHILE test[expr_contextType.Load] COLON s1= suite[false] ( ORELSE COLON s2= suite[false] )? ;
	public final PythonParser.while_stmt_return while_stmt() throws RecognitionException {
		PythonParser.while_stmt_return retval = new PythonParser.while_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token WHILE148=null;
		Token COLON150=null;
		Token ORELSE151=null;
		Token COLON152=null;
		ParserRuleReturnScope s1 =null;
		ParserRuleReturnScope s2 =null;
		ParserRuleReturnScope test149 =null;

		PythonTree WHILE148_tree=null;
		PythonTree COLON150_tree=null;
		PythonTree ORELSE151_tree=null;
		PythonTree COLON152_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1179:5: ( WHILE test[expr_contextType.Load] COLON s1= suite[false] ( ORELSE COLON s2= suite[false] )? )
			// Python.g:1179:7: WHILE test[expr_contextType.Load] COLON s1= suite[false] ( ORELSE COLON s2= suite[false] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			WHILE148=(Token)match(input,WHILE,FOLLOW_WHILE_in_while_stmt3795); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			WHILE148_tree = (PythonTree)adaptor.create(WHILE148);
			adaptor.addChild(root_0, WHILE148_tree);
			}

			pushFollow(FOLLOW_test_in_while_stmt3797);
			test149=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, test149.getTree());

			COLON150=(Token)match(input,COLON,FOLLOW_COLON_in_while_stmt3800); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON150_tree = (PythonTree)adaptor.create(COLON150);
			adaptor.addChild(root_0, COLON150_tree);
			}

			pushFollow(FOLLOW_suite_in_while_stmt3804);
			s1=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, s1.getTree());

			// Python.g:1179:63: ( ORELSE COLON s2= suite[false] )?
			int alt68=2;
			int LA68_0 = input.LA(1);
			if ( (LA68_0==ORELSE) ) {
				alt68=1;
			}
			switch (alt68) {
				case 1 :
					// Python.g:1179:64: ORELSE COLON s2= suite[false]
					{
					ORELSE151=(Token)match(input,ORELSE,FOLLOW_ORELSE_in_while_stmt3808); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ORELSE151_tree = (PythonTree)adaptor.create(ORELSE151);
					adaptor.addChild(root_0, ORELSE151_tree);
					}

					COLON152=(Token)match(input,COLON,FOLLOW_COLON_in_while_stmt3810); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COLON152_tree = (PythonTree)adaptor.create(COLON152);
					adaptor.addChild(root_0, COLON152_tree);
					}

					pushFollow(FOLLOW_suite_in_while_stmt3814);
					s2=suite(false);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, s2.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          stype = actions.makeWhile(WHILE148, actions.castExpr((test149!=null?((PythonTree)test149.getTree()):null)), (s1!=null?((PythonParser.suite_return)s1).stypes:null), (s2!=null?((PythonParser.suite_return)s2).stypes:null));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "while_stmt"


	public static class for_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "for_stmt"
	// Python.g:1186:1: for_stmt : FOR exprlist[expr_contextType.Store] IN testlist[expr_contextType.Load] COLON s1= suite[false] ( ORELSE COLON s2= suite[false] )? ;
	public final PythonParser.for_stmt_return for_stmt() throws RecognitionException {
		PythonParser.for_stmt_return retval = new PythonParser.for_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token FOR153=null;
		Token IN155=null;
		Token COLON157=null;
		Token ORELSE158=null;
		Token COLON159=null;
		ParserRuleReturnScope s1 =null;
		ParserRuleReturnScope s2 =null;
		ParserRuleReturnScope exprlist154 =null;
		ParserRuleReturnScope testlist156 =null;

		PythonTree FOR153_tree=null;
		PythonTree IN155_tree=null;
		PythonTree COLON157_tree=null;
		PythonTree ORELSE158_tree=null;
		PythonTree COLON159_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1193:5: ( FOR exprlist[expr_contextType.Store] IN testlist[expr_contextType.Load] COLON s1= suite[false] ( ORELSE COLON s2= suite[false] )? )
			// Python.g:1193:7: FOR exprlist[expr_contextType.Store] IN testlist[expr_contextType.Load] COLON s1= suite[false] ( ORELSE COLON s2= suite[false] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			FOR153=(Token)match(input,FOR,FOLLOW_FOR_in_for_stmt3853); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			FOR153_tree = (PythonTree)adaptor.create(FOR153);
			adaptor.addChild(root_0, FOR153_tree);
			}

			pushFollow(FOLLOW_exprlist_in_for_stmt3855);
			exprlist154=exprlist(expr_contextType.Store);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, exprlist154.getTree());

			IN155=(Token)match(input,IN,FOLLOW_IN_in_for_stmt3858); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IN155_tree = (PythonTree)adaptor.create(IN155);
			adaptor.addChild(root_0, IN155_tree);
			}

			pushFollow(FOLLOW_testlist_in_for_stmt3860);
			testlist156=testlist(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist156.getTree());

			COLON157=(Token)match(input,COLON,FOLLOW_COLON_in_for_stmt3863); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON157_tree = (PythonTree)adaptor.create(COLON157);
			adaptor.addChild(root_0, COLON157_tree);
			}

			pushFollow(FOLLOW_suite_in_for_stmt3867);
			s1=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, s1.getTree());

			// Python.g:1194:9: ( ORELSE COLON s2= suite[false] )?
			int alt69=2;
			int LA69_0 = input.LA(1);
			if ( (LA69_0==ORELSE) ) {
				alt69=1;
			}
			switch (alt69) {
				case 1 :
					// Python.g:1194:10: ORELSE COLON s2= suite[false]
					{
					ORELSE158=(Token)match(input,ORELSE,FOLLOW_ORELSE_in_for_stmt3879); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ORELSE158_tree = (PythonTree)adaptor.create(ORELSE158);
					adaptor.addChild(root_0, ORELSE158_tree);
					}

					COLON159=(Token)match(input,COLON,FOLLOW_COLON_in_for_stmt3881); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COLON159_tree = (PythonTree)adaptor.create(COLON159);
					adaptor.addChild(root_0, COLON159_tree);
					}

					pushFollow(FOLLOW_suite_in_for_stmt3885);
					s2=suite(false);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, s2.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          stype = actions.makeFor(FOR153, (exprlist154!=null?((PythonParser.exprlist_return)exprlist154).etype:null), actions.castExpr((testlist156!=null?((PythonTree)testlist156.getTree()):null)), (s1!=null?((PythonParser.suite_return)s1).stypes:null), (s2!=null?((PythonParser.suite_return)s2).stypes:null));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "for_stmt"


	public static class try_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "try_stmt"
	// Python.g:1205:1: try_stmt : TRY COLON trysuite= suite[!$suite.isEmpty() && $suite::continueIllegal] ( (e= except_clause )+ ( ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal] )? ( FINALLY COLON finalsuite= suite[true] )? | FINALLY COLON finalsuite= suite[true] ) ;
	public final PythonParser.try_stmt_return try_stmt() throws RecognitionException {
		PythonParser.try_stmt_return retval = new PythonParser.try_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token TRY160=null;
		Token COLON161=null;
		Token ORELSE162=null;
		Token COLON163=null;
		Token FINALLY164=null;
		Token COLON165=null;
		Token FINALLY166=null;
		Token COLON167=null;
		ParserRuleReturnScope trysuite =null;
		ParserRuleReturnScope e =null;
		ParserRuleReturnScope elsesuite =null;
		ParserRuleReturnScope finalsuite =null;

		PythonTree TRY160_tree=null;
		PythonTree COLON161_tree=null;
		PythonTree ORELSE162_tree=null;
		PythonTree COLON163_tree=null;
		PythonTree FINALLY164_tree=null;
		PythonTree COLON165_tree=null;
		PythonTree FINALLY166_tree=null;
		PythonTree COLON167_tree=null;


		    stmt stype = null;
		    List<excepthandler> exceptClauses = new ArrayList<>();

		try {
			// Python.g:1213:5: ( TRY COLON trysuite= suite[!$suite.isEmpty() && $suite::continueIllegal] ( (e= except_clause )+ ( ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal] )? ( FINALLY COLON finalsuite= suite[true] )? | FINALLY COLON finalsuite= suite[true] ) )
			// Python.g:1213:7: TRY COLON trysuite= suite[!$suite.isEmpty() && $suite::continueIllegal] ( (e= except_clause )+ ( ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal] )? ( FINALLY COLON finalsuite= suite[true] )? | FINALLY COLON finalsuite= suite[true] )
			{
			root_0 = (PythonTree)adaptor.nil();


			TRY160=(Token)match(input,TRY,FOLLOW_TRY_in_try_stmt3928); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			TRY160_tree = (PythonTree)adaptor.create(TRY160);
			adaptor.addChild(root_0, TRY160_tree);
			}

			COLON161=(Token)match(input,COLON,FOLLOW_COLON_in_try_stmt3930); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON161_tree = (PythonTree)adaptor.create(COLON161);
			adaptor.addChild(root_0, COLON161_tree);
			}

			pushFollow(FOLLOW_suite_in_try_stmt3934);
			trysuite=suite(!suite_stack.isEmpty() && suite_stack.peek().continueIllegal);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, trysuite.getTree());

			// Python.g:1214:7: ( (e= except_clause )+ ( ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal] )? ( FINALLY COLON finalsuite= suite[true] )? | FINALLY COLON finalsuite= suite[true] )
			int alt73=2;
			int LA73_0 = input.LA(1);
			if ( (LA73_0==EXCEPT) ) {
				alt73=1;
			}
			else if ( (LA73_0==FINALLY) ) {
				alt73=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 73, 0, input);
				throw nvae;
			}

			switch (alt73) {
				case 1 :
					// Python.g:1214:9: (e= except_clause )+ ( ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal] )? ( FINALLY COLON finalsuite= suite[true] )?
					{
					// Python.g:1214:9: (e= except_clause )+
					int cnt70=0;
					loop70:
					while (true) {
						int alt70=2;
						int LA70_0 = input.LA(1);
						if ( (LA70_0==EXCEPT) ) {
							alt70=1;
						}

						switch (alt70) {
						case 1 :
							// Python.g:1214:10: e= except_clause
							{
							pushFollow(FOLLOW_except_clause_in_try_stmt3948);
							e=except_clause();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, e.getTree());

							if ( state.backtracking==0 ) {exceptClauses.add((excepthandler)(e!=null?((PythonTree)e.getTree()):null));}
							}
							break;

						default :
							if ( cnt70 >= 1 ) break loop70;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(70, input);
							throw eee;
						}
						cnt70++;
					}

					// Python.g:1215:13: ( ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal] )?
					int alt71=2;
					int LA71_0 = input.LA(1);
					if ( (LA71_0==ORELSE) ) {
						alt71=1;
					}
					switch (alt71) {
						case 1 :
							// Python.g:1215:14: ORELSE COLON elsesuite= suite[!$suite.isEmpty() && $suite::continueIllegal]
							{
							ORELSE162=(Token)match(input,ORELSE,FOLLOW_ORELSE_in_try_stmt3968); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							ORELSE162_tree = (PythonTree)adaptor.create(ORELSE162);
							adaptor.addChild(root_0, ORELSE162_tree);
							}

							COLON163=(Token)match(input,COLON,FOLLOW_COLON_in_try_stmt3970); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COLON163_tree = (PythonTree)adaptor.create(COLON163);
							adaptor.addChild(root_0, COLON163_tree);
							}

							pushFollow(FOLLOW_suite_in_try_stmt3974);
							elsesuite=suite(!suite_stack.isEmpty() && suite_stack.peek().continueIllegal);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, elsesuite.getTree());

							}
							break;

					}

					// Python.g:1216:13: ( FINALLY COLON finalsuite= suite[true] )?
					int alt72=2;
					int LA72_0 = input.LA(1);
					if ( (LA72_0==FINALLY) ) {
						alt72=1;
					}
					switch (alt72) {
						case 1 :
							// Python.g:1216:14: FINALLY COLON finalsuite= suite[true]
							{
							FINALLY164=(Token)match(input,FINALLY,FOLLOW_FINALLY_in_try_stmt3992); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							FINALLY164_tree = (PythonTree)adaptor.create(FINALLY164);
							adaptor.addChild(root_0, FINALLY164_tree);
							}

							COLON165=(Token)match(input,COLON,FOLLOW_COLON_in_try_stmt3994); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COLON165_tree = (PythonTree)adaptor.create(COLON165);
							adaptor.addChild(root_0, COLON165_tree);
							}

							pushFollow(FOLLOW_suite_in_try_stmt3998);
							finalsuite=suite(true);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, finalsuite.getTree());

							}
							break;

					}

					if ( state.backtracking==0 ) {
					            stype = actions.makeTryExcept(TRY160, (trysuite!=null?((PythonParser.suite_return)trysuite).stypes:null), exceptClauses, (elsesuite!=null?((PythonParser.suite_return)elsesuite).stypes:null), (finalsuite!=null?((PythonParser.suite_return)finalsuite).stypes:null));
					        }
					}
					break;
				case 2 :
					// Python.g:1220:9: FINALLY COLON finalsuite= suite[true]
					{
					FINALLY166=(Token)match(input,FINALLY,FOLLOW_FINALLY_in_try_stmt4021); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					FINALLY166_tree = (PythonTree)adaptor.create(FINALLY166);
					adaptor.addChild(root_0, FINALLY166_tree);
					}

					COLON167=(Token)match(input,COLON,FOLLOW_COLON_in_try_stmt4023); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COLON167_tree = (PythonTree)adaptor.create(COLON167);
					adaptor.addChild(root_0, COLON167_tree);
					}

					pushFollow(FOLLOW_suite_in_try_stmt4027);
					finalsuite=suite(true);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, finalsuite.getTree());

					if ( state.backtracking==0 ) {
					            stype = actions.makeTryFinally(TRY160, (trysuite!=null?((PythonParser.suite_return)trysuite).stypes:null), (finalsuite!=null?((PythonParser.suite_return)finalsuite).stypes:null));
					        }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "try_stmt"


	public static class with_stmt_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "with_stmt"
	// Python.g:1228:1: with_stmt : WITH w= with_item ( options {greedy=true; } : COMMA w= with_item )* COLON suite[false] ;
	public final PythonParser.with_stmt_return with_stmt() throws RecognitionException {
		PythonParser.with_stmt_return retval = new PythonParser.with_stmt_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token WITH168=null;
		Token COMMA169=null;
		Token COLON170=null;
		ParserRuleReturnScope w =null;
		ParserRuleReturnScope suite171 =null;

		PythonTree WITH168_tree=null;
		PythonTree COMMA169_tree=null;
		PythonTree COLON170_tree=null;


		    stmt stype = null;
		    List<With> withList = new ArrayList<>();

		try {
			// Python.g:1236:5: ( WITH w= with_item ( options {greedy=true; } : COMMA w= with_item )* COLON suite[false] )
			// Python.g:1236:7: WITH w= with_item ( options {greedy=true; } : COMMA w= with_item )* COLON suite[false]
			{
			root_0 = (PythonTree)adaptor.nil();


			WITH168=(Token)match(input,WITH,FOLLOW_WITH_in_with_stmt4076); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			WITH168_tree = (PythonTree)adaptor.create(WITH168);
			adaptor.addChild(root_0, WITH168_tree);
			}

			pushFollow(FOLLOW_with_item_in_with_stmt4080);
			w=with_item();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, w.getTree());

			if ( state.backtracking==0 ) {withList.add((With)(w!=null?((PythonTree)w.getTree()):null));}
			// Python.g:1237:9: ( options {greedy=true; } : COMMA w= with_item )*
			loop74:
			while (true) {
				int alt74=2;
				int LA74_0 = input.LA(1);
				if ( (LA74_0==COMMA) ) {
					alt74=1;
				}

				switch (alt74) {
				case 1 :
					// Python.g:1237:33: COMMA w= with_item
					{
					COMMA169=(Token)match(input,COMMA,FOLLOW_COMMA_in_with_stmt4100); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA169_tree = (PythonTree)adaptor.create(COMMA169);
					adaptor.addChild(root_0, COMMA169_tree);
					}

					pushFollow(FOLLOW_with_item_in_with_stmt4104);
					w=with_item();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, w.getTree());

					if ( state.backtracking==0 ) {withList.add((With)(w!=null?((PythonTree)w.getTree()):null));}
					}
					break;

				default :
					break loop74;
				}
			}

			COLON170=(Token)match(input,COLON,FOLLOW_COLON_in_with_stmt4118); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON170_tree = (PythonTree)adaptor.create(COLON170);
			adaptor.addChild(root_0, COLON170_tree);
			}

			pushFollow(FOLLOW_suite_in_with_stmt4120);
			suite171=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, suite171.getTree());

			if ( state.backtracking==0 ) {stype = actions.makeWith(WITH168, withList, (suite171!=null?((PythonParser.suite_return)suite171).stypes:null));}
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "with_stmt"


	public static class with_item_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "with_item"
	// Python.g:1243:1: with_item : test[expr_contextType.Load] ( AS expr[expr_contextType.Store] )? ;
	public final PythonParser.with_item_return with_item() throws RecognitionException {
		PythonParser.with_item_return retval = new PythonParser.with_item_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token AS173=null;
		ParserRuleReturnScope test172 =null;
		ParserRuleReturnScope expr174 =null;

		PythonTree AS173_tree=null;


		    stmt stype = null;

		try {
			// Python.g:1250:5: ( test[expr_contextType.Load] ( AS expr[expr_contextType.Store] )? )
			// Python.g:1250:7: test[expr_contextType.Load] ( AS expr[expr_contextType.Store] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_test_in_with_item4159);
			test172=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, test172.getTree());

			// Python.g:1250:35: ( AS expr[expr_contextType.Store] )?
			int alt75=2;
			int LA75_0 = input.LA(1);
			if ( (LA75_0==AS) ) {
				alt75=1;
			}
			switch (alt75) {
				case 1 :
					// Python.g:1250:36: AS expr[expr_contextType.Store]
					{
					AS173=(Token)match(input,AS,FOLLOW_AS_in_with_item4163); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					AS173_tree = (PythonTree)adaptor.create(AS173);
					adaptor.addChild(root_0, AS173_tree);
					}

					pushFollow(FOLLOW_expr_in_with_item4165);
					expr174=expr(expr_contextType.Store);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, expr174.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          expr item = actions.castExpr((test172!=null?((PythonTree)test172.getTree()):null));
			          expr var = null;
			          if ((expr174!=null?(expr174.start):null) != null) {
			              var = actions.castExpr((expr174!=null?((PythonTree)expr174.getTree()):null));
			              actions.checkAssign(var);
			          }
			          stype = new With((test172!=null?(test172.start):null), item, var, null);
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "with_item"


	public static class except_clause_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "except_clause"
	// Python.g:1263:1: except_clause : EXCEPT (t1= test[expr_contextType.Load] ( ( COMMA | AS ) t2= test[expr_contextType.Store] )? )? COLON suite[!$suite.isEmpty() && $suite::continueIllegal] ;
	public final PythonParser.except_clause_return except_clause() throws RecognitionException {
		PythonParser.except_clause_return retval = new PythonParser.except_clause_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token EXCEPT175=null;
		Token set176=null;
		Token COLON177=null;
		ParserRuleReturnScope t1 =null;
		ParserRuleReturnScope t2 =null;
		ParserRuleReturnScope suite178 =null;

		PythonTree EXCEPT175_tree=null;
		PythonTree set176_tree=null;
		PythonTree COLON177_tree=null;


		    excepthandler extype = null;

		try {
			// Python.g:1270:5: ( EXCEPT (t1= test[expr_contextType.Load] ( ( COMMA | AS ) t2= test[expr_contextType.Store] )? )? COLON suite[!$suite.isEmpty() && $suite::continueIllegal] )
			// Python.g:1270:7: EXCEPT (t1= test[expr_contextType.Load] ( ( COMMA | AS ) t2= test[expr_contextType.Store] )? )? COLON suite[!$suite.isEmpty() && $suite::continueIllegal]
			{
			root_0 = (PythonTree)adaptor.nil();


			EXCEPT175=(Token)match(input,EXCEPT,FOLLOW_EXCEPT_in_except_clause4204); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			EXCEPT175_tree = (PythonTree)adaptor.create(EXCEPT175);
			adaptor.addChild(root_0, EXCEPT175_tree);
			}

			// Python.g:1270:14: (t1= test[expr_contextType.Load] ( ( COMMA | AS ) t2= test[expr_contextType.Store] )? )?
			int alt77=2;
			int LA77_0 = input.LA(1);
			if ( (LA77_0==BACKQUOTE||(LA77_0 >= LBRACK && LA77_0 <= LCURLY)||(LA77_0 >= LPAREN && LA77_0 <= MINUS)||LA77_0==NAME||LA77_0==NOT||LA77_0==PLUS||LA77_0==TILDE) ) {
				alt77=1;
			}
			else if ( (LA77_0==PRINT) && ((printFunction))) {
				alt77=1;
			}
			else if ( (LA77_0==COMPLEX||LA77_0==FLOAT||LA77_0==INT||LA77_0==LAMBDA||LA77_0==LONGINT||LA77_0==STRING) ) {
				alt77=1;
			}
			switch (alt77) {
				case 1 :
					// Python.g:1270:15: t1= test[expr_contextType.Load] ( ( COMMA | AS ) t2= test[expr_contextType.Store] )?
					{
					pushFollow(FOLLOW_test_in_except_clause4209);
					t1=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t1.getTree());

					// Python.g:1270:46: ( ( COMMA | AS ) t2= test[expr_contextType.Store] )?
					int alt76=2;
					int LA76_0 = input.LA(1);
					if ( (LA76_0==AS||LA76_0==COMMA) ) {
						alt76=1;
					}
					switch (alt76) {
						case 1 :
							// Python.g:1270:47: ( COMMA | AS ) t2= test[expr_contextType.Store]
							{
							set176=input.LT(1);
							if ( input.LA(1)==AS||input.LA(1)==COMMA ) {
								input.consume();
								if ( state.backtracking==0 ) adaptor.addChild(root_0, (PythonTree)adaptor.create(set176));
								state.errorRecovery=false;
								state.failed=false;
							}
							else {
								if (state.backtracking>0) {state.failed=true; return retval;}
								MismatchedSetException mse = new MismatchedSetException(null,input);
								throw mse;
							}
							pushFollow(FOLLOW_test_in_except_clause4223);
							t2=test(expr_contextType.Store);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t2.getTree());

							}
							break;

					}

					}
					break;

			}

			COLON177=(Token)match(input,COLON,FOLLOW_COLON_in_except_clause4230); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON177_tree = (PythonTree)adaptor.create(COLON177);
			adaptor.addChild(root_0, COLON177_tree);
			}

			pushFollow(FOLLOW_suite_in_except_clause4232);
			suite178=suite(!suite_stack.isEmpty() && suite_stack.peek().continueIllegal);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, suite178.getTree());

			if ( state.backtracking==0 ) {
			          extype = new ExceptHandler(EXCEPT175, actions.castExpr((t1!=null?((PythonTree)t1.getTree()):null)), actions.castExpr((t2!=null?((PythonTree)t2.getTree()):null)),
			              actions.castStmts((suite178!=null?((PythonParser.suite_return)suite178).stypes:null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = extype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "except_clause"


	protected static class suite_scope {
		boolean continueIllegal;
	}
	protected Stack<suite_scope> suite_stack = new Stack<suite_scope>();

	public static class suite_return extends ParserRuleReturnScope {
		public List<stmt> stypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "suite"
	// Python.g:1278:1: suite[boolean fromFinally] returns [List<stmt> stypes] : ( simple_stmt | NEWLINE INDENT ( stmt )+ DEDENT );
	public final PythonParser.suite_return suite(boolean fromFinally) throws RecognitionException {
		suite_stack.push(new suite_scope());
		PythonParser.suite_return retval = new PythonParser.suite_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NEWLINE180=null;
		Token INDENT181=null;
		Token DEDENT183=null;
		ParserRuleReturnScope simple_stmt179 =null;
		ParserRuleReturnScope stmt182 =null;

		PythonTree NEWLINE180_tree=null;
		PythonTree INDENT181_tree=null;
		PythonTree DEDENT183_tree=null;


		    if (suite_stack.peek().continueIllegal || fromFinally) {
		        suite_stack.peek().continueIllegal = true;
		    } else {
		        suite_stack.peek().continueIllegal = false;
		    }
		    retval.stypes = new ArrayList();

		try {
			// Python.g:1291:5: ( simple_stmt | NEWLINE INDENT ( stmt )+ DEDENT )
			int alt79=2;
			int LA79_0 = input.LA(1);
			if ( (LA79_0==BACKQUOTE||(LA79_0 >= LBRACK && LA79_0 <= LCURLY)||(LA79_0 >= LPAREN && LA79_0 <= MINUS)||LA79_0==NAME||LA79_0==NOT||LA79_0==PLUS||LA79_0==TILDE) ) {
				alt79=1;
			}
			else if ( (LA79_0==PRINT) && (((printFunction)||(!printFunction)))) {
				alt79=1;
			}
			else if ( (LA79_0==ASSERT||LA79_0==BREAK||(LA79_0 >= COMPLEX && LA79_0 <= CONTINUE)||LA79_0==DELETE||LA79_0==EXEC||LA79_0==FLOAT||(LA79_0 >= FROM && LA79_0 <= GLOBAL)||LA79_0==IMPORT||LA79_0==INT||LA79_0==LAMBDA||LA79_0==LONGINT||LA79_0==PASS||LA79_0==RAISE||LA79_0==RETURN||LA79_0==STRING||LA79_0==YIELD) ) {
				alt79=1;
			}
			else if ( (LA79_0==NEWLINE) ) {
				alt79=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 79, 0, input);
				throw nvae;
			}

			switch (alt79) {
				case 1 :
					// Python.g:1291:7: simple_stmt
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_simple_stmt_in_suite4278);
					simple_stmt179=simple_stmt();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, simple_stmt179.getTree());

					if ( state.backtracking==0 ) {
					          retval.stypes = (simple_stmt179!=null?((PythonParser.simple_stmt_return)simple_stmt179).stypes:null);
					      }
					}
					break;
				case 2 :
					// Python.g:1295:7: NEWLINE INDENT ( stmt )+ DEDENT
					{
					root_0 = (PythonTree)adaptor.nil();


					NEWLINE180=(Token)match(input,NEWLINE,FOLLOW_NEWLINE_in_suite4294); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NEWLINE180_tree = (PythonTree)adaptor.create(NEWLINE180);
					adaptor.addChild(root_0, NEWLINE180_tree);
					}

					INDENT181=(Token)match(input,INDENT,FOLLOW_INDENT_in_suite4296); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					INDENT181_tree = (PythonTree)adaptor.create(INDENT181);
					adaptor.addChild(root_0, INDENT181_tree);
					}

					// Python.g:1296:7: ( stmt )+
					int cnt78=0;
					loop78:
					while (true) {
						int alt78=2;
						int LA78_0 = input.LA(1);
						if ( (LA78_0==BACKQUOTE||(LA78_0 >= LBRACK && LA78_0 <= LCURLY)||(LA78_0 >= LPAREN && LA78_0 <= MINUS)||LA78_0==NAME||LA78_0==NOT||LA78_0==PLUS||LA78_0==TILDE) ) {
							alt78=1;
						}
						else if ( (LA78_0==PRINT) && (((printFunction)||(!printFunction)))) {
							alt78=1;
						}
						else if ( (LA78_0==ASSERT||LA78_0==AT||LA78_0==BREAK||LA78_0==CLASS||(LA78_0 >= COMPLEX && LA78_0 <= CONTINUE)||(LA78_0 >= DEF && LA78_0 <= DELETE)||LA78_0==EXEC||(LA78_0 >= FLOAT && LA78_0 <= GLOBAL)||(LA78_0 >= IF && LA78_0 <= IMPORT)||LA78_0==INT||LA78_0==LAMBDA||LA78_0==LONGINT||LA78_0==PASS||LA78_0==RAISE||LA78_0==RETURN||LA78_0==STRING||LA78_0==TRY||(LA78_0 >= WHILE && LA78_0 <= WITH)||LA78_0==YIELD) ) {
							alt78=1;
						}

						switch (alt78) {
						case 1 :
							// Python.g:1296:8: stmt
							{
							pushFollow(FOLLOW_stmt_in_suite4305);
							stmt182=stmt();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, stmt182.getTree());

							if ( state.backtracking==0 ) {
							           if ((stmt182!=null?((PythonParser.stmt_return)stmt182).stypes:null) != null) {
							               retval.stypes.addAll((stmt182!=null?((PythonParser.stmt_return)stmt182).stypes:null));
							           }
							       }
							}
							break;

						default :
							if ( cnt78 >= 1 ) break loop78;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(78, input);
							throw eee;
						}
						cnt78++;
					}

					DEDENT183=(Token)match(input,DEDENT,FOLLOW_DEDENT_in_suite4325); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DEDENT183_tree = (PythonTree)adaptor.create(DEDENT183);
					adaptor.addChild(root_0, DEDENT183_tree);
					}

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
			suite_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "suite"


	public static class test_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "test"
	// Python.g:1306:1: test[expr_contextType ctype] : (o1= or_test[ctype] ( ( IF or_test[null] ORELSE )=> IF o2= or_test[ctype] ORELSE e= test[expr_contextType.Load] | -> or_test ) | lambdef );
	public final PythonParser.test_return test(expr_contextType ctype) throws RecognitionException {
		PythonParser.test_return retval = new PythonParser.test_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token IF184=null;
		Token ORELSE185=null;
		ParserRuleReturnScope o1 =null;
		ParserRuleReturnScope o2 =null;
		ParserRuleReturnScope e =null;
		ParserRuleReturnScope lambdef186 =null;

		PythonTree IF184_tree=null;
		PythonTree ORELSE185_tree=null;
		RewriteRuleTokenStream stream_IF=new RewriteRuleTokenStream(adaptor,"token IF");
		RewriteRuleTokenStream stream_ORELSE=new RewriteRuleTokenStream(adaptor,"token ORELSE");
		RewriteRuleSubtreeStream stream_or_test=new RewriteRuleSubtreeStream(adaptor,"rule or_test");
		RewriteRuleSubtreeStream stream_test=new RewriteRuleSubtreeStream(adaptor,"rule test");


		    expr etype = null;

		try {
			// Python.g:1315:5: (o1= or_test[ctype] ( ( IF or_test[null] ORELSE )=> IF o2= or_test[ctype] ORELSE e= test[expr_contextType.Load] | -> or_test ) | lambdef )
			int alt81=2;
			int LA81_0 = input.LA(1);
			if ( (LA81_0==BACKQUOTE||(LA81_0 >= LBRACK && LA81_0 <= LCURLY)||(LA81_0 >= LPAREN && LA81_0 <= MINUS)||LA81_0==NAME||LA81_0==NOT||LA81_0==PLUS||LA81_0==TILDE) ) {
				alt81=1;
			}
			else if ( (LA81_0==PRINT) && ((printFunction))) {
				alt81=1;
			}
			else if ( (LA81_0==COMPLEX||LA81_0==FLOAT||LA81_0==INT||LA81_0==LONGINT||LA81_0==STRING) ) {
				alt81=1;
			}
			else if ( (LA81_0==LAMBDA) ) {
				alt81=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 81, 0, input);
				throw nvae;
			}

			switch (alt81) {
				case 1 :
					// Python.g:1315:6: o1= or_test[ctype] ( ( IF or_test[null] ORELSE )=> IF o2= or_test[ctype] ORELSE e= test[expr_contextType.Load] | -> or_test )
					{
					pushFollow(FOLLOW_or_test_in_test4355);
					o1=or_test(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_or_test.add(o1.getTree());
					// Python.g:1316:7: ( ( IF or_test[null] ORELSE )=> IF o2= or_test[ctype] ORELSE e= test[expr_contextType.Load] | -> or_test )
					int alt80=2;
					int LA80_0 = input.LA(1);
					if ( (LA80_0==IF) ) {
						int LA80_1 = input.LA(2);
						if ( (synpred7_Python()) ) {
							alt80=1;
						}
						else if ( (true) ) {
							alt80=2;
						}

					}
					else if ( (LA80_0==EOF||LA80_0==AMPEREQUAL||LA80_0==AS||LA80_0==ASSIGN||LA80_0==BACKQUOTE||LA80_0==CIRCUMFLEXEQUAL||(LA80_0 >= COLON && LA80_0 <= COMMA)||LA80_0==DOUBLESLASHEQUAL||LA80_0==DOUBLESTAREQUAL||LA80_0==FOR||LA80_0==LEFTSHIFTEQUAL||LA80_0==MINUSEQUAL||LA80_0==NEWLINE||LA80_0==PERCENTEQUAL||LA80_0==PLUSEQUAL||(LA80_0 >= RBRACK && LA80_0 <= RCURLY)||(LA80_0 >= RIGHTSHIFTEQUAL && LA80_0 <= SEMI)||LA80_0==SLASHEQUAL||LA80_0==STAREQUAL||LA80_0==VBAREQUAL) ) {
						alt80=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 80, 0, input);
						throw nvae;
					}

					switch (alt80) {
						case 1 :
							// Python.g:1316:9: ( IF or_test[null] ORELSE )=> IF o2= or_test[ctype] ORELSE e= test[expr_contextType.Load]
							{
							IF184=(Token)match(input,IF,FOLLOW_IF_in_test4377); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_IF.add(IF184);

							pushFollow(FOLLOW_or_test_in_test4381);
							o2=or_test(ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_or_test.add(o2.getTree());
							ORELSE185=(Token)match(input,ORELSE,FOLLOW_ORELSE_in_test4384); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_ORELSE.add(ORELSE185);

							pushFollow(FOLLOW_test_in_test4388);
							e=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_test.add(e.getTree());
							if ( state.backtracking==0 ) {
							             etype = new IfExp((o1!=null?(o1.start):null), actions.castExpr((o2!=null?((PythonTree)o2.getTree()):null)), actions.castExpr((o1!=null?((PythonTree)o1.getTree()):null)), actions.castExpr((e!=null?((PythonTree)e.getTree()):null)));
							         }
							}
							break;
						case 2 :
							// Python.g:1321:6: 
							{

							// AST REWRITE
							// elements: or_test
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							if ( state.backtracking==0 ) {
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (PythonTree)adaptor.nil();
							// 1321:6: -> or_test
							{
								adaptor.addChild(root_0, stream_or_test.nextTree());
							}


							retval.tree = root_0;
							}

							}
							break;

					}

					}
					break;
				case 2 :
					// Python.g:1323:7: lambdef
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_lambdef_in_test4433);
					lambdef186=lambdef();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, lambdef186.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   if (etype != null) {
			       retval.tree = etype;
			   }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "test"


	public static class or_test_return extends ParserRuleReturnScope {
		public Token leftTok;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "or_test"
	// Python.g:1327:1: or_test[expr_contextType ctype] returns [Token leftTok] : left= and_test[ctype] ( (or= OR right+= and_test[ctype] )+ | -> $left) ;
	public final PythonParser.or_test_return or_test(expr_contextType ctype) throws RecognitionException {
		PythonParser.or_test_return retval = new PythonParser.or_test_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token or=null;
		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		RuleReturnScope right = null;
		PythonTree or_tree=null;
		RewriteRuleTokenStream stream_OR=new RewriteRuleTokenStream(adaptor,"token OR");
		RewriteRuleSubtreeStream stream_and_test=new RewriteRuleSubtreeStream(adaptor,"rule and_test");

		try {
			// Python.g:1338:5: (left= and_test[ctype] ( (or= OR right+= and_test[ctype] )+ | -> $left) )
			// Python.g:1338:7: left= and_test[ctype] ( (or= OR right+= and_test[ctype] )+ | -> $left)
			{
			pushFollow(FOLLOW_and_test_in_or_test4468);
			left=and_test(ctype);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_and_test.add(left.getTree());
			// Python.g:1339:9: ( (or= OR right+= and_test[ctype] )+ | -> $left)
			int alt83=2;
			int LA83_0 = input.LA(1);
			if ( (LA83_0==OR) ) {
				alt83=1;
			}
			else if ( (LA83_0==EOF||LA83_0==AMPEREQUAL||LA83_0==AS||LA83_0==ASSIGN||LA83_0==BACKQUOTE||LA83_0==CIRCUMFLEXEQUAL||(LA83_0 >= COLON && LA83_0 <= COMMA)||LA83_0==DOUBLESLASHEQUAL||LA83_0==DOUBLESTAREQUAL||LA83_0==FOR||LA83_0==IF||LA83_0==LEFTSHIFTEQUAL||LA83_0==MINUSEQUAL||LA83_0==NEWLINE||LA83_0==ORELSE||LA83_0==PERCENTEQUAL||LA83_0==PLUSEQUAL||(LA83_0 >= RBRACK && LA83_0 <= RCURLY)||(LA83_0 >= RIGHTSHIFTEQUAL && LA83_0 <= SEMI)||LA83_0==SLASHEQUAL||LA83_0==STAREQUAL||LA83_0==VBAREQUAL) ) {
				alt83=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 83, 0, input);
				throw nvae;
			}

			switch (alt83) {
				case 1 :
					// Python.g:1339:11: (or= OR right+= and_test[ctype] )+
					{
					// Python.g:1339:11: (or= OR right+= and_test[ctype] )+
					int cnt82=0;
					loop82:
					while (true) {
						int alt82=2;
						int LA82_0 = input.LA(1);
						if ( (LA82_0==OR) ) {
							alt82=1;
						}

						switch (alt82) {
						case 1 :
							// Python.g:1339:12: or= OR right+= and_test[ctype]
							{
							or=(Token)match(input,OR,FOLLOW_OR_in_or_test4484); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_OR.add(or);

							pushFollow(FOLLOW_and_test_in_or_test4488);
							right=and_test(ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_and_test.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							}
							break;

						default :
							if ( cnt82 >= 1 ) break loop82;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(82, input);
							throw eee;
						}
						cnt82++;
					}

					}
					break;
				case 2 :
					// Python.g:1342:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1342:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (or != null) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.and_test_return)left).leftTok:null) != null) {
			            tok = (left!=null?((PythonParser.and_test_return)left).leftTok:null);
			        }
			        retval.tree = actions.makeBoolOp(tok, (left!=null?((PythonTree)left.getTree()):null), boolopType.Or, list_right);
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "or_test"


	public static class and_test_return extends ParserRuleReturnScope {
		public Token leftTok;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "and_test"
	// Python.g:1347:1: and_test[expr_contextType ctype] returns [Token leftTok] : left= not_test[ctype] ( (and= AND right+= not_test[ctype] )+ | -> $left) ;
	public final PythonParser.and_test_return and_test(expr_contextType ctype) throws RecognitionException {
		PythonParser.and_test_return retval = new PythonParser.and_test_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token and=null;
		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		RuleReturnScope right = null;
		PythonTree and_tree=null;
		RewriteRuleTokenStream stream_AND=new RewriteRuleTokenStream(adaptor,"token AND");
		RewriteRuleSubtreeStream stream_not_test=new RewriteRuleSubtreeStream(adaptor,"rule not_test");

		try {
			// Python.g:1358:5: (left= not_test[ctype] ( (and= AND right+= not_test[ctype] )+ | -> $left) )
			// Python.g:1358:7: left= not_test[ctype] ( (and= AND right+= not_test[ctype] )+ | -> $left)
			{
			pushFollow(FOLLOW_not_test_in_and_test4569);
			left=not_test(ctype);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_not_test.add(left.getTree());
			// Python.g:1359:9: ( (and= AND right+= not_test[ctype] )+ | -> $left)
			int alt85=2;
			int LA85_0 = input.LA(1);
			if ( (LA85_0==AND) ) {
				alt85=1;
			}
			else if ( (LA85_0==EOF||LA85_0==AMPEREQUAL||LA85_0==AS||LA85_0==ASSIGN||LA85_0==BACKQUOTE||LA85_0==CIRCUMFLEXEQUAL||(LA85_0 >= COLON && LA85_0 <= COMMA)||LA85_0==DOUBLESLASHEQUAL||LA85_0==DOUBLESTAREQUAL||LA85_0==FOR||LA85_0==IF||LA85_0==LEFTSHIFTEQUAL||LA85_0==MINUSEQUAL||LA85_0==NEWLINE||(LA85_0 >= OR && LA85_0 <= ORELSE)||LA85_0==PERCENTEQUAL||LA85_0==PLUSEQUAL||(LA85_0 >= RBRACK && LA85_0 <= RCURLY)||(LA85_0 >= RIGHTSHIFTEQUAL && LA85_0 <= SEMI)||LA85_0==SLASHEQUAL||LA85_0==STAREQUAL||LA85_0==VBAREQUAL) ) {
				alt85=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 85, 0, input);
				throw nvae;
			}

			switch (alt85) {
				case 1 :
					// Python.g:1359:11: (and= AND right+= not_test[ctype] )+
					{
					// Python.g:1359:11: (and= AND right+= not_test[ctype] )+
					int cnt84=0;
					loop84:
					while (true) {
						int alt84=2;
						int LA84_0 = input.LA(1);
						if ( (LA84_0==AND) ) {
							alt84=1;
						}

						switch (alt84) {
						case 1 :
							// Python.g:1359:12: and= AND right+= not_test[ctype]
							{
							and=(Token)match(input,AND,FOLLOW_AND_in_and_test4585); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_AND.add(and);

							pushFollow(FOLLOW_not_test_in_and_test4589);
							right=not_test(ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_not_test.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							}
							break;

						default :
							if ( cnt84 >= 1 ) break loop84;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(84, input);
							throw eee;
						}
						cnt84++;
					}

					}
					break;
				case 2 :
					// Python.g:1362:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1362:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (and != null) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.not_test_return)left).leftTok:null) != null) {
			            tok = (left!=null?((PythonParser.not_test_return)left).leftTok:null);
			        }
			        retval.tree = actions.makeBoolOp(tok, (left!=null?((PythonTree)left.getTree()):null), boolopType.And, list_right);
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "and_test"


	public static class not_test_return extends ParserRuleReturnScope {
		public Token leftTok;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "not_test"
	// Python.g:1367:1: not_test[expr_contextType ctype] returns [Token leftTok] : ( NOT nt= not_test[ctype] | comparison[ctype] );
	public final PythonParser.not_test_return not_test(expr_contextType ctype) throws RecognitionException {
		PythonParser.not_test_return retval = new PythonParser.not_test_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token NOT187=null;
		ParserRuleReturnScope nt =null;
		ParserRuleReturnScope comparison188 =null;

		PythonTree NOT187_tree=null;


		    expr etype = null;

		try {
			// Python.g:1377:5: ( NOT nt= not_test[ctype] | comparison[ctype] )
			int alt86=2;
			int LA86_0 = input.LA(1);
			if ( (LA86_0==NOT) ) {
				alt86=1;
			}
			else if ( (LA86_0==BACKQUOTE||(LA86_0 >= LBRACK && LA86_0 <= LCURLY)||(LA86_0 >= LPAREN && LA86_0 <= MINUS)||LA86_0==NAME||LA86_0==PLUS||LA86_0==TILDE) ) {
				alt86=2;
			}
			else if ( (LA86_0==PRINT) && ((printFunction))) {
				alt86=2;
			}
			else if ( (LA86_0==COMPLEX||LA86_0==FLOAT||LA86_0==INT||LA86_0==LONGINT||LA86_0==STRING) ) {
				alt86=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 86, 0, input);
				throw nvae;
			}

			switch (alt86) {
				case 1 :
					// Python.g:1377:7: NOT nt= not_test[ctype]
					{
					root_0 = (PythonTree)adaptor.nil();


					NOT187=(Token)match(input,NOT,FOLLOW_NOT_in_not_test4673); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NOT187_tree = (PythonTree)adaptor.create(NOT187);
					adaptor.addChild(root_0, NOT187_tree);
					}

					pushFollow(FOLLOW_not_test_in_not_test4677);
					nt=not_test(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, nt.getTree());

					if ( state.backtracking==0 ) {
					          etype = new UnaryOp(NOT187, unaryopType.Not, actions.castExpr((nt!=null?((PythonTree)nt.getTree()):null)));
					      }
					}
					break;
				case 2 :
					// Python.g:1381:7: comparison[ctype]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_comparison_in_not_test4694);
					comparison188=comparison(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comparison188.getTree());

					if ( state.backtracking==0 ) {
					          retval.leftTok = (comparison188!=null?((PythonParser.comparison_return)comparison188).leftTok:null);
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   if (etype != null) {
			       retval.tree = etype;
			   }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "not_test"


	public static class comparison_return extends ParserRuleReturnScope {
		public Token leftTok;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "comparison"
	// Python.g:1388:1: comparison[expr_contextType ctype] returns [Token leftTok] : left= expr[ctype] ( ( comp_op right+= expr[ctype] )+ | -> $left) ;
	public final PythonParser.comparison_return comparison(expr_contextType ctype) throws RecognitionException {
		PythonParser.comparison_return retval = new PythonParser.comparison_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		ParserRuleReturnScope comp_op189 =null;
		RuleReturnScope right = null;
		RewriteRuleSubtreeStream stream_comp_op=new RewriteRuleSubtreeStream(adaptor,"rule comp_op");
		RewriteRuleSubtreeStream stream_expr=new RewriteRuleSubtreeStream(adaptor,"rule expr");


		    List cmps = new ArrayList();

		try {
			// Python.g:1400:5: (left= expr[ctype] ( ( comp_op right+= expr[ctype] )+ | -> $left) )
			// Python.g:1400:7: left= expr[ctype] ( ( comp_op right+= expr[ctype] )+ | -> $left)
			{
			pushFollow(FOLLOW_expr_in_comparison4743);
			left=expr(ctype);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_expr.add(left.getTree());
			// Python.g:1401:8: ( ( comp_op right+= expr[ctype] )+ | -> $left)
			int alt88=2;
			int LA88_0 = input.LA(1);
			if ( (LA88_0==ALT_NOTEQUAL||LA88_0==EQUAL||(LA88_0 >= GREATER && LA88_0 <= GREATEREQUAL)||LA88_0==IN||LA88_0==IS||(LA88_0 >= LESS && LA88_0 <= LESSEQUAL)||(LA88_0 >= NOT && LA88_0 <= NOTEQUAL)) ) {
				alt88=1;
			}
			else if ( (LA88_0==EOF||(LA88_0 >= AMPEREQUAL && LA88_0 <= AS)||LA88_0==ASSIGN||LA88_0==BACKQUOTE||LA88_0==CIRCUMFLEXEQUAL||(LA88_0 >= COLON && LA88_0 <= COMMA)||LA88_0==DOUBLESLASHEQUAL||LA88_0==DOUBLESTAREQUAL||LA88_0==FOR||LA88_0==IF||LA88_0==LEFTSHIFTEQUAL||LA88_0==MINUSEQUAL||LA88_0==NEWLINE||(LA88_0 >= OR && LA88_0 <= ORELSE)||LA88_0==PERCENTEQUAL||LA88_0==PLUSEQUAL||(LA88_0 >= RBRACK && LA88_0 <= RCURLY)||(LA88_0 >= RIGHTSHIFTEQUAL && LA88_0 <= SEMI)||LA88_0==SLASHEQUAL||LA88_0==STAREQUAL||LA88_0==VBAREQUAL) ) {
				alt88=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 88, 0, input);
				throw nvae;
			}

			switch (alt88) {
				case 1 :
					// Python.g:1401:10: ( comp_op right+= expr[ctype] )+
					{
					// Python.g:1401:10: ( comp_op right+= expr[ctype] )+
					int cnt87=0;
					loop87:
					while (true) {
						int alt87=2;
						int LA87_0 = input.LA(1);
						if ( (LA87_0==ALT_NOTEQUAL||LA87_0==EQUAL||(LA87_0 >= GREATER && LA87_0 <= GREATEREQUAL)||LA87_0==IN||LA87_0==IS||(LA87_0 >= LESS && LA87_0 <= LESSEQUAL)||(LA87_0 >= NOT && LA87_0 <= NOTEQUAL)) ) {
							alt87=1;
						}

						switch (alt87) {
						case 1 :
							// Python.g:1401:12: comp_op right+= expr[ctype]
							{
							pushFollow(FOLLOW_comp_op_in_comparison4757);
							comp_op189=comp_op();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_comp_op.add(comp_op189.getTree());
							pushFollow(FOLLOW_expr_in_comparison4761);
							right=expr(ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_expr.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							if ( state.backtracking==0 ) {
							               cmps.add((comp_op189!=null?((PythonParser.comp_op_return)comp_op189).op:null));
							           }
							}
							break;

						default :
							if ( cnt87 >= 1 ) break loop87;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(87, input);
							throw eee;
						}
						cnt87++;
					}

					}
					break;
				case 2 :
					// Python.g:1407:7: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1407:7: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.leftTok = (left!=null?((PythonParser.expr_return)left).leftTok:null);
			    if (!cmps.isEmpty()) {
			        retval.tree = new Compare((left!=null?(left.start):null), actions.castExpr((left!=null?((PythonTree)left.getTree()):null)), actions.makeCmpOps(cmps),
			            actions.castExprs(list_right));
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "comparison"


	public static class comp_op_return extends ParserRuleReturnScope {
		public cmpopType op;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "comp_op"
	// Python.g:1412:1: comp_op returns [cmpopType op] : ( LESS | GREATER | EQUAL | GREATEREQUAL | LESSEQUAL | ALT_NOTEQUAL | NOTEQUAL | IN | NOT IN | IS | IS NOT );
	public final PythonParser.comp_op_return comp_op() throws RecognitionException {
		PythonParser.comp_op_return retval = new PythonParser.comp_op_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token LESS190=null;
		Token GREATER191=null;
		Token EQUAL192=null;
		Token GREATEREQUAL193=null;
		Token LESSEQUAL194=null;
		Token ALT_NOTEQUAL195=null;
		Token NOTEQUAL196=null;
		Token IN197=null;
		Token NOT198=null;
		Token IN199=null;
		Token IS200=null;
		Token IS201=null;
		Token NOT202=null;

		PythonTree LESS190_tree=null;
		PythonTree GREATER191_tree=null;
		PythonTree EQUAL192_tree=null;
		PythonTree GREATEREQUAL193_tree=null;
		PythonTree LESSEQUAL194_tree=null;
		PythonTree ALT_NOTEQUAL195_tree=null;
		PythonTree NOTEQUAL196_tree=null;
		PythonTree IN197_tree=null;
		PythonTree NOT198_tree=null;
		PythonTree IN199_tree=null;
		PythonTree IS200_tree=null;
		PythonTree IS201_tree=null;
		PythonTree NOT202_tree=null;

		try {
			// Python.g:1414:5: ( LESS | GREATER | EQUAL | GREATEREQUAL | LESSEQUAL | ALT_NOTEQUAL | NOTEQUAL | IN | NOT IN | IS | IS NOT )
			int alt89=11;
			switch ( input.LA(1) ) {
			case LESS:
				{
				alt89=1;
				}
				break;
			case GREATER:
				{
				alt89=2;
				}
				break;
			case EQUAL:
				{
				alt89=3;
				}
				break;
			case GREATEREQUAL:
				{
				alt89=4;
				}
				break;
			case LESSEQUAL:
				{
				alt89=5;
				}
				break;
			case ALT_NOTEQUAL:
				{
				alt89=6;
				}
				break;
			case NOTEQUAL:
				{
				alt89=7;
				}
				break;
			case IN:
				{
				alt89=8;
				}
				break;
			case NOT:
				{
				alt89=9;
				}
				break;
			case IS:
				{
				int LA89_10 = input.LA(2);
				if ( (LA89_10==NOT) ) {
					alt89=11;
				}
				else if ( (LA89_10==BACKQUOTE||LA89_10==COMPLEX||LA89_10==FLOAT||LA89_10==INT||(LA89_10 >= LBRACK && LA89_10 <= LCURLY)||(LA89_10 >= LONGINT && LA89_10 <= MINUS)||LA89_10==NAME||LA89_10==PLUS||LA89_10==PRINT||(LA89_10 >= STRING && LA89_10 <= TILDE)) ) {
					alt89=10;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 89, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 89, 0, input);
				throw nvae;
			}
			switch (alt89) {
				case 1 :
					// Python.g:1414:7: LESS
					{
					root_0 = (PythonTree)adaptor.nil();


					LESS190=(Token)match(input,LESS,FOLLOW_LESS_in_comp_op4842); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LESS190_tree = (PythonTree)adaptor.create(LESS190);
					adaptor.addChild(root_0, LESS190_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.Lt;
					      }
					}
					break;
				case 2 :
					// Python.g:1418:7: GREATER
					{
					root_0 = (PythonTree)adaptor.nil();


					GREATER191=(Token)match(input,GREATER,FOLLOW_GREATER_in_comp_op4858); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					GREATER191_tree = (PythonTree)adaptor.create(GREATER191);
					adaptor.addChild(root_0, GREATER191_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.Gt;
					      }
					}
					break;
				case 3 :
					// Python.g:1422:7: EQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					EQUAL192=(Token)match(input,EQUAL,FOLLOW_EQUAL_in_comp_op4874); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					EQUAL192_tree = (PythonTree)adaptor.create(EQUAL192);
					adaptor.addChild(root_0, EQUAL192_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.Eq;
					      }
					}
					break;
				case 4 :
					// Python.g:1426:7: GREATEREQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					GREATEREQUAL193=(Token)match(input,GREATEREQUAL,FOLLOW_GREATEREQUAL_in_comp_op4890); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					GREATEREQUAL193_tree = (PythonTree)adaptor.create(GREATEREQUAL193);
					adaptor.addChild(root_0, GREATEREQUAL193_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.GtE;
					      }
					}
					break;
				case 5 :
					// Python.g:1430:7: LESSEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					LESSEQUAL194=(Token)match(input,LESSEQUAL,FOLLOW_LESSEQUAL_in_comp_op4906); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LESSEQUAL194_tree = (PythonTree)adaptor.create(LESSEQUAL194);
					adaptor.addChild(root_0, LESSEQUAL194_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.LtE;
					      }
					}
					break;
				case 6 :
					// Python.g:1434:7: ALT_NOTEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					ALT_NOTEQUAL195=(Token)match(input,ALT_NOTEQUAL,FOLLOW_ALT_NOTEQUAL_in_comp_op4922); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ALT_NOTEQUAL195_tree = (PythonTree)adaptor.create(ALT_NOTEQUAL195);
					adaptor.addChild(root_0, ALT_NOTEQUAL195_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.NotEq;
					      }
					}
					break;
				case 7 :
					// Python.g:1438:7: NOTEQUAL
					{
					root_0 = (PythonTree)adaptor.nil();


					NOTEQUAL196=(Token)match(input,NOTEQUAL,FOLLOW_NOTEQUAL_in_comp_op4938); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NOTEQUAL196_tree = (PythonTree)adaptor.create(NOTEQUAL196);
					adaptor.addChild(root_0, NOTEQUAL196_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.NotEq;
					      }
					}
					break;
				case 8 :
					// Python.g:1442:7: IN
					{
					root_0 = (PythonTree)adaptor.nil();


					IN197=(Token)match(input,IN,FOLLOW_IN_in_comp_op4954); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					IN197_tree = (PythonTree)adaptor.create(IN197);
					adaptor.addChild(root_0, IN197_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.In;
					      }
					}
					break;
				case 9 :
					// Python.g:1446:7: NOT IN
					{
					root_0 = (PythonTree)adaptor.nil();


					NOT198=(Token)match(input,NOT,FOLLOW_NOT_in_comp_op4970); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NOT198_tree = (PythonTree)adaptor.create(NOT198);
					adaptor.addChild(root_0, NOT198_tree);
					}

					IN199=(Token)match(input,IN,FOLLOW_IN_in_comp_op4972); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					IN199_tree = (PythonTree)adaptor.create(IN199);
					adaptor.addChild(root_0, IN199_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.NotIn;
					      }
					}
					break;
				case 10 :
					// Python.g:1450:7: IS
					{
					root_0 = (PythonTree)adaptor.nil();


					IS200=(Token)match(input,IS,FOLLOW_IS_in_comp_op4988); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					IS200_tree = (PythonTree)adaptor.create(IS200);
					adaptor.addChild(root_0, IS200_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.Is;
					      }
					}
					break;
				case 11 :
					// Python.g:1454:7: IS NOT
					{
					root_0 = (PythonTree)adaptor.nil();


					IS201=(Token)match(input,IS,FOLLOW_IS_in_comp_op5004); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					IS201_tree = (PythonTree)adaptor.create(IS201);
					adaptor.addChild(root_0, IS201_tree);
					}

					NOT202=(Token)match(input,NOT,FOLLOW_NOT_in_comp_op5006); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					NOT202_tree = (PythonTree)adaptor.create(NOT202);
					adaptor.addChild(root_0, NOT202_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = cmpopType.IsNot;
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "comp_op"


	protected static class expr_scope {
		expr_contextType ctype;
	}
	protected Stack<expr_scope> expr_stack = new Stack<expr_scope>();

	public static class expr_return extends ParserRuleReturnScope {
		public Token leftTok;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "expr"
	// Python.g:1461:1: expr[expr_contextType ect] returns [Token leftTok] : left= xor_expr ( (op= VBAR right+= xor_expr )+ | -> $left) ;
	public final PythonParser.expr_return expr(expr_contextType ect) throws RecognitionException {
		expr_stack.push(new expr_scope());
		PythonParser.expr_return retval = new PythonParser.expr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token op=null;
		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		RuleReturnScope right = null;
		PythonTree op_tree=null;
		RewriteRuleTokenStream stream_VBAR=new RewriteRuleTokenStream(adaptor,"token VBAR");
		RewriteRuleSubtreeStream stream_xor_expr=new RewriteRuleSubtreeStream(adaptor,"rule xor_expr");


		    expr_stack.peek().ctype = ect;

		try {
			// Python.g:1479:5: (left= xor_expr ( (op= VBAR right+= xor_expr )+ | -> $left) )
			// Python.g:1479:7: left= xor_expr ( (op= VBAR right+= xor_expr )+ | -> $left)
			{
			pushFollow(FOLLOW_xor_expr_in_expr5058);
			left=xor_expr();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_xor_expr.add(left.getTree());
			// Python.g:1480:9: ( (op= VBAR right+= xor_expr )+ | -> $left)
			int alt91=2;
			int LA91_0 = input.LA(1);
			if ( (LA91_0==VBAR) ) {
				alt91=1;
			}
			else if ( (LA91_0==EOF||LA91_0==ALT_NOTEQUAL||(LA91_0 >= AMPEREQUAL && LA91_0 <= AS)||LA91_0==ASSIGN||LA91_0==BACKQUOTE||LA91_0==CIRCUMFLEXEQUAL||(LA91_0 >= COLON && LA91_0 <= COMMA)||LA91_0==DOUBLESLASHEQUAL||LA91_0==DOUBLESTAREQUAL||LA91_0==EQUAL||LA91_0==FOR||(LA91_0 >= GREATER && LA91_0 <= IF)||LA91_0==IN||LA91_0==IS||(LA91_0 >= LEFTSHIFTEQUAL && LA91_0 <= LESSEQUAL)||LA91_0==MINUSEQUAL||(LA91_0 >= NEWLINE && LA91_0 <= ORELSE)||LA91_0==PERCENTEQUAL||LA91_0==PLUSEQUAL||(LA91_0 >= RBRACK && LA91_0 <= RCURLY)||(LA91_0 >= RIGHTSHIFTEQUAL && LA91_0 <= SEMI)||LA91_0==SLASHEQUAL||LA91_0==STAREQUAL||LA91_0==VBAREQUAL) ) {
				alt91=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 91, 0, input);
				throw nvae;
			}

			switch (alt91) {
				case 1 :
					// Python.g:1480:11: (op= VBAR right+= xor_expr )+
					{
					// Python.g:1480:11: (op= VBAR right+= xor_expr )+
					int cnt90=0;
					loop90:
					while (true) {
						int alt90=2;
						int LA90_0 = input.LA(1);
						if ( (LA90_0==VBAR) ) {
							alt90=1;
						}

						switch (alt90) {
						case 1 :
							// Python.g:1480:12: op= VBAR right+= xor_expr
							{
							op=(Token)match(input,VBAR,FOLLOW_VBAR_in_expr5073); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_VBAR.add(op);

							pushFollow(FOLLOW_xor_expr_in_expr5077);
							right=xor_expr();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_xor_expr.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							}
							break;

						default :
							if ( cnt90 >= 1 ) break loop90;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(90, input);
							throw eee;
						}
						cnt90++;
					}

					}
					break;
				case 2 :
					// Python.g:1483:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1483:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.leftTok = (left!=null?((PythonParser.xor_expr_return)left).lparen:null);
			    if (op != null) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.xor_expr_return)left).lparen:null) != null) {
			            tok = (left!=null?((PythonParser.xor_expr_return)left).lparen:null);
			        }
			        retval.tree = actions.makeBinOp(tok, (left!=null?((PythonTree)left.getTree()):null), operatorType.BitOr, list_right);
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
			expr_stack.pop();
		}
		return retval;
	}
	// $ANTLR end "expr"


	public static class xor_expr_return extends ParserRuleReturnScope {
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "xor_expr"
	// Python.g:1489:1: xor_expr returns [Token lparen = null] : left= and_expr ( (op= CIRCUMFLEX right+= and_expr )+ | -> $left) ;
	public final PythonParser.xor_expr_return xor_expr() throws RecognitionException {
		PythonParser.xor_expr_return retval = new PythonParser.xor_expr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token op=null;
		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		RuleReturnScope right = null;
		PythonTree op_tree=null;
		RewriteRuleTokenStream stream_CIRCUMFLEX=new RewriteRuleTokenStream(adaptor,"token CIRCUMFLEX");
		RewriteRuleSubtreeStream stream_and_expr=new RewriteRuleSubtreeStream(adaptor,"rule and_expr");

		try {
			// Python.g:1501:5: (left= and_expr ( (op= CIRCUMFLEX right+= and_expr )+ | -> $left) )
			// Python.g:1501:7: left= and_expr ( (op= CIRCUMFLEX right+= and_expr )+ | -> $left)
			{
			pushFollow(FOLLOW_and_expr_in_xor_expr5156);
			left=and_expr();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_and_expr.add(left.getTree());
			// Python.g:1502:9: ( (op= CIRCUMFLEX right+= and_expr )+ | -> $left)
			int alt93=2;
			int LA93_0 = input.LA(1);
			if ( (LA93_0==CIRCUMFLEX) ) {
				alt93=1;
			}
			else if ( (LA93_0==EOF||LA93_0==ALT_NOTEQUAL||(LA93_0 >= AMPEREQUAL && LA93_0 <= AS)||LA93_0==ASSIGN||LA93_0==BACKQUOTE||LA93_0==CIRCUMFLEXEQUAL||(LA93_0 >= COLON && LA93_0 <= COMMA)||LA93_0==DOUBLESLASHEQUAL||LA93_0==DOUBLESTAREQUAL||LA93_0==EQUAL||LA93_0==FOR||(LA93_0 >= GREATER && LA93_0 <= IF)||LA93_0==IN||LA93_0==IS||(LA93_0 >= LEFTSHIFTEQUAL && LA93_0 <= LESSEQUAL)||LA93_0==MINUSEQUAL||(LA93_0 >= NEWLINE && LA93_0 <= ORELSE)||LA93_0==PERCENTEQUAL||LA93_0==PLUSEQUAL||(LA93_0 >= RBRACK && LA93_0 <= RCURLY)||(LA93_0 >= RIGHTSHIFTEQUAL && LA93_0 <= SEMI)||LA93_0==SLASHEQUAL||LA93_0==STAREQUAL||(LA93_0 >= VBAR && LA93_0 <= VBAREQUAL)) ) {
				alt93=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 93, 0, input);
				throw nvae;
			}

			switch (alt93) {
				case 1 :
					// Python.g:1502:11: (op= CIRCUMFLEX right+= and_expr )+
					{
					// Python.g:1502:11: (op= CIRCUMFLEX right+= and_expr )+
					int cnt92=0;
					loop92:
					while (true) {
						int alt92=2;
						int LA92_0 = input.LA(1);
						if ( (LA92_0==CIRCUMFLEX) ) {
							alt92=1;
						}

						switch (alt92) {
						case 1 :
							// Python.g:1502:12: op= CIRCUMFLEX right+= and_expr
							{
							op=(Token)match(input,CIRCUMFLEX,FOLLOW_CIRCUMFLEX_in_xor_expr5171); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_CIRCUMFLEX.add(op);

							pushFollow(FOLLOW_and_expr_in_xor_expr5175);
							right=and_expr();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_and_expr.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							}
							break;

						default :
							if ( cnt92 >= 1 ) break loop92;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(92, input);
							throw eee;
						}
						cnt92++;
					}

					}
					break;
				case 2 :
					// Python.g:1505:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1505:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (op != null) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.and_expr_return)left).lparen:null) != null) {
			            tok = (left!=null?((PythonParser.and_expr_return)left).lparen:null);
			        }
			        retval.tree = actions.makeBinOp(tok, (left!=null?((PythonTree)left.getTree()):null), operatorType.BitXor, list_right);
			    }
			    retval.lparen = (left!=null?((PythonParser.and_expr_return)left).lparen:null);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "xor_expr"


	public static class and_expr_return extends ParserRuleReturnScope {
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "and_expr"
	// Python.g:1510:1: and_expr returns [Token lparen = null] : left= shift_expr ( (op= AMPER right+= shift_expr )+ | -> $left) ;
	public final PythonParser.and_expr_return and_expr() throws RecognitionException {
		PythonParser.and_expr_return retval = new PythonParser.and_expr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token op=null;
		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		RuleReturnScope right = null;
		PythonTree op_tree=null;
		RewriteRuleTokenStream stream_AMPER=new RewriteRuleTokenStream(adaptor,"token AMPER");
		RewriteRuleSubtreeStream stream_shift_expr=new RewriteRuleSubtreeStream(adaptor,"rule shift_expr");

		try {
			// Python.g:1522:5: (left= shift_expr ( (op= AMPER right+= shift_expr )+ | -> $left) )
			// Python.g:1522:7: left= shift_expr ( (op= AMPER right+= shift_expr )+ | -> $left)
			{
			pushFollow(FOLLOW_shift_expr_in_and_expr5253);
			left=shift_expr();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_shift_expr.add(left.getTree());
			// Python.g:1523:9: ( (op= AMPER right+= shift_expr )+ | -> $left)
			int alt95=2;
			int LA95_0 = input.LA(1);
			if ( (LA95_0==AMPER) ) {
				alt95=1;
			}
			else if ( (LA95_0==EOF||LA95_0==ALT_NOTEQUAL||(LA95_0 >= AMPEREQUAL && LA95_0 <= AS)||LA95_0==ASSIGN||LA95_0==BACKQUOTE||(LA95_0 >= CIRCUMFLEX && LA95_0 <= CIRCUMFLEXEQUAL)||(LA95_0 >= COLON && LA95_0 <= COMMA)||LA95_0==DOUBLESLASHEQUAL||LA95_0==DOUBLESTAREQUAL||LA95_0==EQUAL||LA95_0==FOR||(LA95_0 >= GREATER && LA95_0 <= IF)||LA95_0==IN||LA95_0==IS||(LA95_0 >= LEFTSHIFTEQUAL && LA95_0 <= LESSEQUAL)||LA95_0==MINUSEQUAL||(LA95_0 >= NEWLINE && LA95_0 <= ORELSE)||LA95_0==PERCENTEQUAL||LA95_0==PLUSEQUAL||(LA95_0 >= RBRACK && LA95_0 <= RCURLY)||(LA95_0 >= RIGHTSHIFTEQUAL && LA95_0 <= SEMI)||LA95_0==SLASHEQUAL||LA95_0==STAREQUAL||(LA95_0 >= VBAR && LA95_0 <= VBAREQUAL)) ) {
				alt95=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 95, 0, input);
				throw nvae;
			}

			switch (alt95) {
				case 1 :
					// Python.g:1523:11: (op= AMPER right+= shift_expr )+
					{
					// Python.g:1523:11: (op= AMPER right+= shift_expr )+
					int cnt94=0;
					loop94:
					while (true) {
						int alt94=2;
						int LA94_0 = input.LA(1);
						if ( (LA94_0==AMPER) ) {
							alt94=1;
						}

						switch (alt94) {
						case 1 :
							// Python.g:1523:12: op= AMPER right+= shift_expr
							{
							op=(Token)match(input,AMPER,FOLLOW_AMPER_in_and_expr5268); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_AMPER.add(op);

							pushFollow(FOLLOW_shift_expr_in_and_expr5272);
							right=shift_expr();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_shift_expr.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							}
							break;

						default :
							if ( cnt94 >= 1 ) break loop94;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(94, input);
							throw eee;
						}
						cnt94++;
					}

					}
					break;
				case 2 :
					// Python.g:1526:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1526:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (op != null) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.shift_expr_return)left).lparen:null) != null) {
			            tok = (left!=null?((PythonParser.shift_expr_return)left).lparen:null);
			        }
			        retval.tree = actions.makeBinOp(tok, (left!=null?((PythonTree)left.getTree()):null), operatorType.BitAnd, list_right);
			    }
			    retval.lparen = (left!=null?((PythonParser.shift_expr_return)left).lparen:null);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "and_expr"


	public static class shift_expr_return extends ParserRuleReturnScope {
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "shift_expr"
	// Python.g:1531:1: shift_expr returns [Token lparen = null] : left= arith_expr ( ( shift_op right+= arith_expr )+ | -> $left) ;
	public final PythonParser.shift_expr_return shift_expr() throws RecognitionException {
		PythonParser.shift_expr_return retval = new PythonParser.shift_expr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		ParserRuleReturnScope shift_op203 =null;
		RuleReturnScope right = null;
		RewriteRuleSubtreeStream stream_shift_op=new RewriteRuleSubtreeStream(adaptor,"rule shift_op");
		RewriteRuleSubtreeStream stream_arith_expr=new RewriteRuleSubtreeStream(adaptor,"rule arith_expr");


		    List ops = new ArrayList();
		    List toks = new ArrayList();

		try {
			// Python.g:1547:5: (left= arith_expr ( ( shift_op right+= arith_expr )+ | -> $left) )
			// Python.g:1547:7: left= arith_expr ( ( shift_op right+= arith_expr )+ | -> $left)
			{
			pushFollow(FOLLOW_arith_expr_in_shift_expr5355);
			left=arith_expr();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_arith_expr.add(left.getTree());
			// Python.g:1548:9: ( ( shift_op right+= arith_expr )+ | -> $left)
			int alt97=2;
			int LA97_0 = input.LA(1);
			if ( (LA97_0==LEFTSHIFT||LA97_0==RIGHTSHIFT) ) {
				alt97=1;
			}
			else if ( (LA97_0==EOF||(LA97_0 >= ALT_NOTEQUAL && LA97_0 <= AS)||LA97_0==ASSIGN||LA97_0==BACKQUOTE||(LA97_0 >= CIRCUMFLEX && LA97_0 <= CIRCUMFLEXEQUAL)||(LA97_0 >= COLON && LA97_0 <= COMMA)||LA97_0==DOUBLESLASHEQUAL||LA97_0==DOUBLESTAREQUAL||LA97_0==EQUAL||LA97_0==FOR||(LA97_0 >= GREATER && LA97_0 <= IF)||LA97_0==IN||LA97_0==IS||(LA97_0 >= LEFTSHIFTEQUAL && LA97_0 <= LESSEQUAL)||LA97_0==MINUSEQUAL||(LA97_0 >= NEWLINE && LA97_0 <= ORELSE)||LA97_0==PERCENTEQUAL||LA97_0==PLUSEQUAL||(LA97_0 >= RBRACK && LA97_0 <= RCURLY)||(LA97_0 >= RIGHTSHIFTEQUAL && LA97_0 <= SEMI)||LA97_0==SLASHEQUAL||LA97_0==STAREQUAL||(LA97_0 >= VBAR && LA97_0 <= VBAREQUAL)) ) {
				alt97=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 97, 0, input);
				throw nvae;
			}

			switch (alt97) {
				case 1 :
					// Python.g:1548:11: ( shift_op right+= arith_expr )+
					{
					// Python.g:1548:11: ( shift_op right+= arith_expr )+
					int cnt96=0;
					loop96:
					while (true) {
						int alt96=2;
						int LA96_0 = input.LA(1);
						if ( (LA96_0==LEFTSHIFT||LA96_0==RIGHTSHIFT) ) {
							alt96=1;
						}

						switch (alt96) {
						case 1 :
							// Python.g:1548:13: shift_op right+= arith_expr
							{
							pushFollow(FOLLOW_shift_op_in_shift_expr5369);
							shift_op203=shift_op();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_shift_op.add(shift_op203.getTree());
							pushFollow(FOLLOW_arith_expr_in_shift_expr5373);
							right=arith_expr();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_arith_expr.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							if ( state.backtracking==0 ) {
							                ops.add((shift_op203!=null?((PythonParser.shift_op_return)shift_op203).op:null));
							                toks.add((shift_op203!=null?(shift_op203.start):null));
							            }
							}
							break;

						default :
							if ( cnt96 >= 1 ) break loop96;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(96, input);
							throw eee;
						}
						cnt96++;
					}

					}
					break;
				case 2 :
					// Python.g:1555:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1555:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (!ops.isEmpty()) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.arith_expr_return)left).lparen:null) != null) {
			            tok = (left!=null?((PythonParser.arith_expr_return)left).lparen:null);
			        }
			        retval.tree = actions.makeBinOp(tok, (left!=null?((PythonTree)left.getTree()):null), ops, list_right, toks);
			    }
			    retval.lparen = (left!=null?((PythonParser.arith_expr_return)left).lparen:null);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "shift_expr"


	public static class shift_op_return extends ParserRuleReturnScope {
		public operatorType op;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "shift_op"
	// Python.g:1559:1: shift_op returns [operatorType op] : ( LEFTSHIFT | RIGHTSHIFT );
	public final PythonParser.shift_op_return shift_op() throws RecognitionException {
		PythonParser.shift_op_return retval = new PythonParser.shift_op_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token LEFTSHIFT204=null;
		Token RIGHTSHIFT205=null;

		PythonTree LEFTSHIFT204_tree=null;
		PythonTree RIGHTSHIFT205_tree=null;

		try {
			// Python.g:1561:5: ( LEFTSHIFT | RIGHTSHIFT )
			int alt98=2;
			int LA98_0 = input.LA(1);
			if ( (LA98_0==LEFTSHIFT) ) {
				alt98=1;
			}
			else if ( (LA98_0==RIGHTSHIFT) ) {
				alt98=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 98, 0, input);
				throw nvae;
			}

			switch (alt98) {
				case 1 :
					// Python.g:1561:7: LEFTSHIFT
					{
					root_0 = (PythonTree)adaptor.nil();


					LEFTSHIFT204=(Token)match(input,LEFTSHIFT,FOLLOW_LEFTSHIFT_in_shift_op5457); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LEFTSHIFT204_tree = (PythonTree)adaptor.create(LEFTSHIFT204);
					adaptor.addChild(root_0, LEFTSHIFT204_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.LShift;
					      }
					}
					break;
				case 2 :
					// Python.g:1565:7: RIGHTSHIFT
					{
					root_0 = (PythonTree)adaptor.nil();


					RIGHTSHIFT205=(Token)match(input,RIGHTSHIFT,FOLLOW_RIGHTSHIFT_in_shift_op5473); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RIGHTSHIFT205_tree = (PythonTree)adaptor.create(RIGHTSHIFT205);
					adaptor.addChild(root_0, RIGHTSHIFT205_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.RShift;
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "shift_op"


	public static class arith_expr_return extends ParserRuleReturnScope {
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "arith_expr"
	// Python.g:1572:1: arith_expr returns [Token lparen = null] : left= term ( ( arith_op right+= term )+ | -> $left) ;
	public final PythonParser.arith_expr_return arith_expr() throws RecognitionException {
		PythonParser.arith_expr_return retval = new PythonParser.arith_expr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		ParserRuleReturnScope arith_op206 =null;
		RuleReturnScope right = null;
		RewriteRuleSubtreeStream stream_term=new RewriteRuleSubtreeStream(adaptor,"rule term");
		RewriteRuleSubtreeStream stream_arith_op=new RewriteRuleSubtreeStream(adaptor,"rule arith_op");


		    List ops = new ArrayList();
		    List toks = new ArrayList();

		try {
			// Python.g:1588:5: (left= term ( ( arith_op right+= term )+ | -> $left) )
			// Python.g:1588:7: left= term ( ( arith_op right+= term )+ | -> $left)
			{
			pushFollow(FOLLOW_term_in_arith_expr5519);
			left=term();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_term.add(left.getTree());
			// Python.g:1589:9: ( ( arith_op right+= term )+ | -> $left)
			int alt100=2;
			int LA100_0 = input.LA(1);
			if ( (LA100_0==MINUS||LA100_0==PLUS) ) {
				alt100=1;
			}
			else if ( (LA100_0==EOF||(LA100_0 >= ALT_NOTEQUAL && LA100_0 <= AS)||LA100_0==ASSIGN||LA100_0==BACKQUOTE||(LA100_0 >= CIRCUMFLEX && LA100_0 <= CIRCUMFLEXEQUAL)||(LA100_0 >= COLON && LA100_0 <= COMMA)||LA100_0==DOUBLESLASHEQUAL||LA100_0==DOUBLESTAREQUAL||LA100_0==EQUAL||LA100_0==FOR||(LA100_0 >= GREATER && LA100_0 <= IF)||LA100_0==IN||LA100_0==IS||(LA100_0 >= LEFTSHIFT && LA100_0 <= LESSEQUAL)||LA100_0==MINUSEQUAL||(LA100_0 >= NEWLINE && LA100_0 <= ORELSE)||LA100_0==PERCENTEQUAL||LA100_0==PLUSEQUAL||(LA100_0 >= RBRACK && LA100_0 <= RCURLY)||(LA100_0 >= RIGHTSHIFT && LA100_0 <= SEMI)||LA100_0==SLASHEQUAL||LA100_0==STAREQUAL||(LA100_0 >= VBAR && LA100_0 <= VBAREQUAL)) ) {
				alt100=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 100, 0, input);
				throw nvae;
			}

			switch (alt100) {
				case 1 :
					// Python.g:1589:11: ( arith_op right+= term )+
					{
					// Python.g:1589:11: ( arith_op right+= term )+
					int cnt99=0;
					loop99:
					while (true) {
						int alt99=2;
						int LA99_0 = input.LA(1);
						if ( (LA99_0==MINUS||LA99_0==PLUS) ) {
							alt99=1;
						}

						switch (alt99) {
						case 1 :
							// Python.g:1589:12: arith_op right+= term
							{
							pushFollow(FOLLOW_arith_op_in_arith_expr5532);
							arith_op206=arith_op();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_arith_op.add(arith_op206.getTree());
							pushFollow(FOLLOW_term_in_arith_expr5536);
							right=term();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_term.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							if ( state.backtracking==0 ) {
							               ops.add((arith_op206!=null?((PythonParser.arith_op_return)arith_op206).op:null));
							               toks.add((arith_op206!=null?(arith_op206.start):null));
							           }
							}
							break;

						default :
							if ( cnt99 >= 1 ) break loop99;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(99, input);
							throw eee;
						}
						cnt99++;
					}

					}
					break;
				case 2 :
					// Python.g:1596:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1596:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (!ops.isEmpty()) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.term_return)left).lparen:null) != null) {
			            tok = (left!=null?((PythonParser.term_return)left).lparen:null);
			        }
			        retval.tree = actions.makeBinOp(tok, (left!=null?((PythonTree)left.getTree()):null), ops, list_right, toks);
			    }
			    retval.lparen = (left!=null?((PythonParser.term_return)left).lparen:null);
			}
		}
		catch (RewriteCardinalityException rce) {

			        PythonTree badNode = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), null);
			        retval.tree = badNode;
			        errorHandler.error("Internal Parser Error", badNode);
			    
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "arith_expr"


	public static class arith_op_return extends ParserRuleReturnScope {
		public operatorType op;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "arith_op"
	// Python.g:1608:1: arith_op returns [operatorType op] : ( PLUS | MINUS );
	public final PythonParser.arith_op_return arith_op() throws RecognitionException {
		PythonParser.arith_op_return retval = new PythonParser.arith_op_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token PLUS207=null;
		Token MINUS208=null;

		PythonTree PLUS207_tree=null;
		PythonTree MINUS208_tree=null;

		try {
			// Python.g:1610:5: ( PLUS | MINUS )
			int alt101=2;
			int LA101_0 = input.LA(1);
			if ( (LA101_0==PLUS) ) {
				alt101=1;
			}
			else if ( (LA101_0==MINUS) ) {
				alt101=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 101, 0, input);
				throw nvae;
			}

			switch (alt101) {
				case 1 :
					// Python.g:1610:7: PLUS
					{
					root_0 = (PythonTree)adaptor.nil();


					PLUS207=(Token)match(input,PLUS,FOLLOW_PLUS_in_arith_op5644); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					PLUS207_tree = (PythonTree)adaptor.create(PLUS207);
					adaptor.addChild(root_0, PLUS207_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.Add;
					      }
					}
					break;
				case 2 :
					// Python.g:1614:7: MINUS
					{
					root_0 = (PythonTree)adaptor.nil();


					MINUS208=(Token)match(input,MINUS,FOLLOW_MINUS_in_arith_op5660); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					MINUS208_tree = (PythonTree)adaptor.create(MINUS208);
					adaptor.addChild(root_0, MINUS208_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.Sub;
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "arith_op"


	public static class term_return extends ParserRuleReturnScope {
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "term"
	// Python.g:1621:1: term returns [Token lparen = null] : left= factor ( ( term_op right+= factor )+ | -> $left) ;
	public final PythonParser.term_return term() throws RecognitionException {
		PythonParser.term_return retval = new PythonParser.term_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		List<Object> list_right=null;
		ParserRuleReturnScope left =null;
		ParserRuleReturnScope term_op209 =null;
		RuleReturnScope right = null;
		RewriteRuleSubtreeStream stream_term_op=new RewriteRuleSubtreeStream(adaptor,"rule term_op");
		RewriteRuleSubtreeStream stream_factor=new RewriteRuleSubtreeStream(adaptor,"rule factor");


		    List ops = new ArrayList();
		    List toks = new ArrayList();

		try {
			// Python.g:1637:5: (left= factor ( ( term_op right+= factor )+ | -> $left) )
			// Python.g:1637:7: left= factor ( ( term_op right+= factor )+ | -> $left)
			{
			pushFollow(FOLLOW_factor_in_term5706);
			left=factor();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_factor.add(left.getTree());
			// Python.g:1638:9: ( ( term_op right+= factor )+ | -> $left)
			int alt103=2;
			int LA103_0 = input.LA(1);
			if ( (LA103_0==DOUBLESLASH||LA103_0==PERCENT||LA103_0==SLASH||LA103_0==STAR) ) {
				alt103=1;
			}
			else if ( (LA103_0==EOF||(LA103_0 >= ALT_NOTEQUAL && LA103_0 <= AS)||LA103_0==ASSIGN||LA103_0==BACKQUOTE||(LA103_0 >= CIRCUMFLEX && LA103_0 <= CIRCUMFLEXEQUAL)||(LA103_0 >= COLON && LA103_0 <= COMMA)||LA103_0==DOUBLESLASHEQUAL||LA103_0==DOUBLESTAREQUAL||LA103_0==EQUAL||LA103_0==FOR||(LA103_0 >= GREATER && LA103_0 <= IF)||LA103_0==IN||LA103_0==IS||(LA103_0 >= LEFTSHIFT && LA103_0 <= LESSEQUAL)||(LA103_0 >= MINUS && LA103_0 <= MINUSEQUAL)||(LA103_0 >= NEWLINE && LA103_0 <= ORELSE)||(LA103_0 >= PERCENTEQUAL && LA103_0 <= PLUSEQUAL)||(LA103_0 >= RBRACK && LA103_0 <= RCURLY)||(LA103_0 >= RIGHTSHIFT && LA103_0 <= SEMI)||LA103_0==SLASHEQUAL||LA103_0==STAREQUAL||(LA103_0 >= VBAR && LA103_0 <= VBAREQUAL)) ) {
				alt103=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 103, 0, input);
				throw nvae;
			}

			switch (alt103) {
				case 1 :
					// Python.g:1638:11: ( term_op right+= factor )+
					{
					// Python.g:1638:11: ( term_op right+= factor )+
					int cnt102=0;
					loop102:
					while (true) {
						int alt102=2;
						int LA102_0 = input.LA(1);
						if ( (LA102_0==DOUBLESLASH||LA102_0==PERCENT||LA102_0==SLASH||LA102_0==STAR) ) {
							alt102=1;
						}

						switch (alt102) {
						case 1 :
							// Python.g:1638:12: term_op right+= factor
							{
							pushFollow(FOLLOW_term_op_in_term5719);
							term_op209=term_op();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_term_op.add(term_op209.getTree());
							pushFollow(FOLLOW_factor_in_term5723);
							right=factor();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_factor.add(right.getTree());
							if (list_right==null) list_right=new ArrayList<Object>();
							list_right.add(right.getTree());
							if ( state.backtracking==0 ) {
							              ops.add((term_op209!=null?((PythonParser.term_op_return)term_op209).op:null));
							              toks.add((term_op209!=null?(term_op209.start):null));
							          }
							}
							break;

						default :
							if ( cnt102 >= 1 ) break loop102;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(102, input);
							throw eee;
						}
						cnt102++;
					}

					}
					break;
				case 2 :
					// Python.g:1645:8: 
					{

					// AST REWRITE
					// elements: left
					// token labels: 
					// rule labels: left, retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_left=new RewriteRuleSubtreeStream(adaptor,"rule left",left!=null?left.getTree():null);
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1645:8: -> $left
					{
						adaptor.addChild(root_0, stream_left.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.lparen = (left!=null?((PythonParser.factor_return)left).lparen:null);
			    if (!ops.isEmpty()) {
			        Token tok = (left!=null?(left.start):null);
			        if ((left!=null?((PythonParser.factor_return)left).lparen:null) != null) {
			            tok = (left!=null?((PythonParser.factor_return)left).lparen:null);
			        }
			        retval.tree = actions.makeBinOp(tok, (left!=null?((PythonTree)left.getTree()):null), ops, list_right, toks);
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "term"


	public static class term_op_return extends ParserRuleReturnScope {
		public operatorType op;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "term_op"
	// Python.g:1649:1: term_op returns [operatorType op] : ( STAR | SLASH | PERCENT | DOUBLESLASH );
	public final PythonParser.term_op_return term_op() throws RecognitionException {
		PythonParser.term_op_return retval = new PythonParser.term_op_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token STAR210=null;
		Token SLASH211=null;
		Token PERCENT212=null;
		Token DOUBLESLASH213=null;

		PythonTree STAR210_tree=null;
		PythonTree SLASH211_tree=null;
		PythonTree PERCENT212_tree=null;
		PythonTree DOUBLESLASH213_tree=null;

		try {
			// Python.g:1651:5: ( STAR | SLASH | PERCENT | DOUBLESLASH )
			int alt104=4;
			switch ( input.LA(1) ) {
			case STAR:
				{
				alt104=1;
				}
				break;
			case SLASH:
				{
				alt104=2;
				}
				break;
			case PERCENT:
				{
				alt104=3;
				}
				break;
			case DOUBLESLASH:
				{
				alt104=4;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 104, 0, input);
				throw nvae;
			}
			switch (alt104) {
				case 1 :
					// Python.g:1651:7: STAR
					{
					root_0 = (PythonTree)adaptor.nil();


					STAR210=(Token)match(input,STAR,FOLLOW_STAR_in_term_op5805); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					STAR210_tree = (PythonTree)adaptor.create(STAR210);
					adaptor.addChild(root_0, STAR210_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.Mult;
					      }
					}
					break;
				case 2 :
					// Python.g:1655:7: SLASH
					{
					root_0 = (PythonTree)adaptor.nil();


					SLASH211=(Token)match(input,SLASH,FOLLOW_SLASH_in_term_op5821); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					SLASH211_tree = (PythonTree)adaptor.create(SLASH211);
					adaptor.addChild(root_0, SLASH211_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.Div;
					      }
					}
					break;
				case 3 :
					// Python.g:1659:7: PERCENT
					{
					root_0 = (PythonTree)adaptor.nil();


					PERCENT212=(Token)match(input,PERCENT,FOLLOW_PERCENT_in_term_op5837); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					PERCENT212_tree = (PythonTree)adaptor.create(PERCENT212);
					adaptor.addChild(root_0, PERCENT212_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.Mod;
					      }
					}
					break;
				case 4 :
					// Python.g:1663:7: DOUBLESLASH
					{
					root_0 = (PythonTree)adaptor.nil();


					DOUBLESLASH213=(Token)match(input,DOUBLESLASH,FOLLOW_DOUBLESLASH_in_term_op5853); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOUBLESLASH213_tree = (PythonTree)adaptor.create(DOUBLESLASH213);
					adaptor.addChild(root_0, DOUBLESLASH213_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.op = operatorType.FloorDiv;
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "term_op"


	public static class factor_return extends ParserRuleReturnScope {
		public expr etype;
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "factor"
	// Python.g:1670:1: factor returns [expr etype, Token lparen = null] : ( PLUS p= factor | MINUS m= factor | TILDE t= factor | power );
	public final PythonParser.factor_return factor() throws RecognitionException {
		PythonParser.factor_return retval = new PythonParser.factor_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token PLUS214=null;
		Token MINUS215=null;
		Token TILDE216=null;
		ParserRuleReturnScope p =null;
		ParserRuleReturnScope m =null;
		ParserRuleReturnScope t =null;
		ParserRuleReturnScope power217 =null;

		PythonTree PLUS214_tree=null;
		PythonTree MINUS215_tree=null;
		PythonTree TILDE216_tree=null;

		try {
			// Python.g:1675:5: ( PLUS p= factor | MINUS m= factor | TILDE t= factor | power )
			int alt105=4;
			int LA105_0 = input.LA(1);
			if ( (LA105_0==PLUS) ) {
				alt105=1;
			}
			else if ( (LA105_0==MINUS) ) {
				alt105=2;
			}
			else if ( (LA105_0==TILDE) ) {
				alt105=3;
			}
			else if ( (LA105_0==BACKQUOTE||(LA105_0 >= LBRACK && LA105_0 <= LCURLY)||LA105_0==LPAREN||LA105_0==NAME) ) {
				alt105=4;
			}
			else if ( (LA105_0==PRINT) && ((printFunction))) {
				alt105=4;
			}
			else if ( (LA105_0==COMPLEX||LA105_0==FLOAT||LA105_0==INT||LA105_0==LONGINT||LA105_0==STRING) ) {
				alt105=4;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 105, 0, input);
				throw nvae;
			}

			switch (alt105) {
				case 1 :
					// Python.g:1675:7: PLUS p= factor
					{
					root_0 = (PythonTree)adaptor.nil();


					PLUS214=(Token)match(input,PLUS,FOLLOW_PLUS_in_factor5892); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					PLUS214_tree = (PythonTree)adaptor.create(PLUS214);
					adaptor.addChild(root_0, PLUS214_tree);
					}

					pushFollow(FOLLOW_factor_in_factor5896);
					p=factor();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, p.getTree());

					if ( state.backtracking==0 ) {
					          retval.etype = new UnaryOp(PLUS214, unaryopType.UAdd, (p!=null?((PythonParser.factor_return)p).etype:null));
					      }
					}
					break;
				case 2 :
					// Python.g:1679:7: MINUS m= factor
					{
					root_0 = (PythonTree)adaptor.nil();


					MINUS215=(Token)match(input,MINUS,FOLLOW_MINUS_in_factor5912); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					MINUS215_tree = (PythonTree)adaptor.create(MINUS215);
					adaptor.addChild(root_0, MINUS215_tree);
					}

					pushFollow(FOLLOW_factor_in_factor5916);
					m=factor();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, m.getTree());

					if ( state.backtracking==0 ) {
					          retval.etype = actions.negate(MINUS215, (m!=null?((PythonParser.factor_return)m).etype:null));
					      }
					}
					break;
				case 3 :
					// Python.g:1683:7: TILDE t= factor
					{
					root_0 = (PythonTree)adaptor.nil();


					TILDE216=(Token)match(input,TILDE,FOLLOW_TILDE_in_factor5932); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					TILDE216_tree = (PythonTree)adaptor.create(TILDE216);
					adaptor.addChild(root_0, TILDE216_tree);
					}

					pushFollow(FOLLOW_factor_in_factor5936);
					t=factor();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if ( state.backtracking==0 ) {
					          retval.etype = new UnaryOp(TILDE216, unaryopType.Invert, (t!=null?((PythonParser.factor_return)t).etype:null));
					      }
					}
					break;
				case 4 :
					// Python.g:1687:7: power
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_power_in_factor5952);
					power217=power();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, power217.getTree());

					if ( state.backtracking==0 ) {
					          retval.etype = actions.castExpr((power217!=null?((PythonTree)power217.getTree()):null));
					          retval.lparen = (power217!=null?((PythonParser.power_return)power217).lparen:null);
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = retval.etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "factor"


	public static class power_return extends ParserRuleReturnScope {
		public expr etype;
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "power"
	// Python.g:1695:1: power returns [expr etype, Token lparen = null] : atom (t+= trailer[$atom.start, $atom.tree] )* ( options {greedy=true; } :d= DOUBLESTAR factor )? ;
	public final PythonParser.power_return power() throws RecognitionException {
		PythonParser.power_return retval = new PythonParser.power_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token d=null;
		List<Object> list_t=null;
		ParserRuleReturnScope atom218 =null;
		ParserRuleReturnScope factor219 =null;
		RuleReturnScope t = null;
		PythonTree d_tree=null;

		try {
			// Python.g:1700:5: ( atom (t+= trailer[$atom.start, $atom.tree] )* ( options {greedy=true; } :d= DOUBLESTAR factor )? )
			// Python.g:1700:7: atom (t+= trailer[$atom.start, $atom.tree] )* ( options {greedy=true; } :d= DOUBLESTAR factor )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_atom_in_power5991);
			atom218=atom();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, atom218.getTree());

			// Python.g:1700:12: (t+= trailer[$atom.start, $atom.tree] )*
			loop106:
			while (true) {
				int alt106=2;
				int LA106_0 = input.LA(1);
				if ( (LA106_0==DOT||LA106_0==LBRACK||LA106_0==LPAREN) ) {
					alt106=1;
				}

				switch (alt106) {
				case 1 :
					// Python.g:1700:13: t+= trailer[$atom.start, $atom.tree]
					{
					pushFollow(FOLLOW_trailer_in_power5996);
					t=trailer((atom218!=null?(atom218.start):null), (atom218!=null?((PythonTree)atom218.getTree()):null));
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					}
					break;

				default :
					break loop106;
				}
			}

			// Python.g:1700:51: ( options {greedy=true; } :d= DOUBLESTAR factor )?
			int alt107=2;
			int LA107_0 = input.LA(1);
			if ( (LA107_0==DOUBLESTAR) ) {
				alt107=1;
			}
			switch (alt107) {
				case 1 :
					// Python.g:1700:75: d= DOUBLESTAR factor
					{
					d=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_power6011); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					d_tree = (PythonTree)adaptor.create(d);
					adaptor.addChild(root_0, d_tree);
					}

					pushFollow(FOLLOW_factor_in_power6013);
					factor219=factor();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, factor219.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          retval.lparen = (atom218!=null?((PythonParser.atom_return)atom218).lparen:null);
			          //XXX: This could be better.
			          retval.etype = actions.castExpr((atom218!=null?((PythonTree)atom218.getTree()):null));
			          if (list_t != null) {
			              for(Object o : list_t) {
			                  actions.recurseSetContext(retval.etype, expr_contextType.Load);
			                  if (o instanceof Call) {
			                      Call c = (Call)o;
			                      c.setFunc((PyObject)retval.etype);
			                      retval.etype = c;
			                  } else if (o instanceof Subscript) {
			                      Subscript c = (Subscript)o;
			                      c.setValue((PyObject)retval.etype);
			                      retval.etype = c;
			                  } else if (o instanceof Attribute) {
			                      Attribute c = (Attribute)o;
			                      c.setCharStartIndex(retval.etype.getCharStartIndex());
			                      c.setValue((PyObject)retval.etype);
			                      retval.etype = c;
			                  }
			              }
			          }
			          if (d != null) {
			              List right = new ArrayList();
			              right.add((factor219!=null?((PythonTree)factor219.getTree()):null));
			              retval.etype = actions.makeBinOp((atom218!=null?(atom218.start):null), retval.etype, operatorType.Pow, right);
			          }
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = retval.etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "power"


	public static class atom_return extends ParserRuleReturnScope {
		public Token lparen = null;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "atom"
	// Python.g:1737:1: atom returns [Token lparen = null] : ( LPAREN ( yield_expr | testlist_gexp -> testlist_gexp |) RPAREN | LBRACK ( listmaker[$LBRACK] -> listmaker |) RBRACK | LCURLY ( dictorsetmaker[$LCURLY] -> dictorsetmaker |) RCURLY |lb= BACKQUOTE testlist1[expr_contextType.Load] rb= BACKQUOTE | name_or_print | INT | LONGINT | FLOAT | COMPLEX | (S+= STRING )+ );
	public final PythonParser.atom_return atom() throws RecognitionException {
		PythonParser.atom_return retval = new PythonParser.atom_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token lb=null;
		Token rb=null;
		Token LPAREN220=null;
		Token RPAREN223=null;
		Token LBRACK224=null;
		Token RBRACK226=null;
		Token LCURLY227=null;
		Token RCURLY229=null;
		Token INT232=null;
		Token LONGINT233=null;
		Token FLOAT234=null;
		Token COMPLEX235=null;
		Token S=null;
		List<Object> list_S=null;
		ParserRuleReturnScope yield_expr221 =null;
		ParserRuleReturnScope testlist_gexp222 =null;
		ParserRuleReturnScope listmaker225 =null;
		ParserRuleReturnScope dictorsetmaker228 =null;
		ParserRuleReturnScope testlist1230 =null;
		ParserRuleReturnScope name_or_print231 =null;

		PythonTree lb_tree=null;
		PythonTree rb_tree=null;
		PythonTree LPAREN220_tree=null;
		PythonTree RPAREN223_tree=null;
		PythonTree LBRACK224_tree=null;
		PythonTree RBRACK226_tree=null;
		PythonTree LCURLY227_tree=null;
		PythonTree RCURLY229_tree=null;
		PythonTree INT232_tree=null;
		PythonTree LONGINT233_tree=null;
		PythonTree FLOAT234_tree=null;
		PythonTree COMPLEX235_tree=null;
		PythonTree S_tree=null;
		RewriteRuleTokenStream stream_RBRACK=new RewriteRuleTokenStream(adaptor,"token RBRACK");
		RewriteRuleTokenStream stream_LBRACK=new RewriteRuleTokenStream(adaptor,"token LBRACK");
		RewriteRuleTokenStream stream_LPAREN=new RewriteRuleTokenStream(adaptor,"token LPAREN");
		RewriteRuleTokenStream stream_LCURLY=new RewriteRuleTokenStream(adaptor,"token LCURLY");
		RewriteRuleTokenStream stream_RPAREN=new RewriteRuleTokenStream(adaptor,"token RPAREN");
		RewriteRuleTokenStream stream_RCURLY=new RewriteRuleTokenStream(adaptor,"token RCURLY");
		RewriteRuleSubtreeStream stream_listmaker=new RewriteRuleSubtreeStream(adaptor,"rule listmaker");
		RewriteRuleSubtreeStream stream_yield_expr=new RewriteRuleSubtreeStream(adaptor,"rule yield_expr");
		RewriteRuleSubtreeStream stream_testlist_gexp=new RewriteRuleSubtreeStream(adaptor,"rule testlist_gexp");
		RewriteRuleSubtreeStream stream_dictorsetmaker=new RewriteRuleSubtreeStream(adaptor,"rule dictorsetmaker");


		    expr etype = null;

		try {
			// Python.g:1747:5: ( LPAREN ( yield_expr | testlist_gexp -> testlist_gexp |) RPAREN | LBRACK ( listmaker[$LBRACK] -> listmaker |) RBRACK | LCURLY ( dictorsetmaker[$LCURLY] -> dictorsetmaker |) RCURLY |lb= BACKQUOTE testlist1[expr_contextType.Load] rb= BACKQUOTE | name_or_print | INT | LONGINT | FLOAT | COMPLEX | (S+= STRING )+ )
			int alt112=10;
			int LA112_0 = input.LA(1);
			if ( (LA112_0==LPAREN) ) {
				alt112=1;
			}
			else if ( (LA112_0==LBRACK) ) {
				alt112=2;
			}
			else if ( (LA112_0==LCURLY) ) {
				alt112=3;
			}
			else if ( (LA112_0==BACKQUOTE) ) {
				alt112=4;
			}
			else if ( (LA112_0==NAME) ) {
				alt112=5;
			}
			else if ( (LA112_0==PRINT) && ((printFunction))) {
				alt112=5;
			}
			else if ( (LA112_0==INT) ) {
				alt112=6;
			}
			else if ( (LA112_0==LONGINT) ) {
				alt112=7;
			}
			else if ( (LA112_0==FLOAT) ) {
				alt112=8;
			}
			else if ( (LA112_0==COMPLEX) ) {
				alt112=9;
			}
			else if ( (LA112_0==STRING) ) {
				alt112=10;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 112, 0, input);
				throw nvae;
			}

			switch (alt112) {
				case 1 :
					// Python.g:1747:7: LPAREN ( yield_expr | testlist_gexp -> testlist_gexp |) RPAREN
					{
					LPAREN220=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_atom6063); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_LPAREN.add(LPAREN220);

					if ( state.backtracking==0 ) {
					          retval.lparen = LPAREN220;
					      }
					// Python.g:1751:7: ( yield_expr | testlist_gexp -> testlist_gexp |)
					int alt108=3;
					int LA108_0 = input.LA(1);
					if ( (LA108_0==YIELD) ) {
						alt108=1;
					}
					else if ( (LA108_0==BACKQUOTE||(LA108_0 >= LBRACK && LA108_0 <= LCURLY)||(LA108_0 >= LPAREN && LA108_0 <= MINUS)||LA108_0==NAME||LA108_0==NOT||LA108_0==PLUS||LA108_0==TILDE) ) {
						alt108=2;
					}
					else if ( (LA108_0==PRINT) && ((printFunction))) {
						alt108=2;
					}
					else if ( (LA108_0==COMPLEX||LA108_0==FLOAT||LA108_0==INT||LA108_0==LAMBDA||LA108_0==LONGINT||LA108_0==STRING) ) {
						alt108=2;
					}
					else if ( (LA108_0==RPAREN) ) {
						alt108=3;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 108, 0, input);
						throw nvae;
					}

					switch (alt108) {
						case 1 :
							// Python.g:1751:9: yield_expr
							{
							pushFollow(FOLLOW_yield_expr_in_atom6081);
							yield_expr221=yield_expr();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_yield_expr.add(yield_expr221.getTree());
							if ( state.backtracking==0 ) {
							            etype = (yield_expr221!=null?((PythonParser.yield_expr_return)yield_expr221).etype:null);
							        }
							}
							break;
						case 2 :
							// Python.g:1755:9: testlist_gexp
							{
							pushFollow(FOLLOW_testlist_gexp_in_atom6101);
							testlist_gexp222=testlist_gexp();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_testlist_gexp.add(testlist_gexp222.getTree());

							// AST REWRITE
							// elements: testlist_gexp
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							if ( state.backtracking==0 ) {
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (PythonTree)adaptor.nil();
							// 1756:6: -> testlist_gexp
							{
								adaptor.addChild(root_0, stream_testlist_gexp.nextTree());
							}


							retval.tree = root_0;
							}

							}
							break;
						case 3 :
							// Python.g:1758:9: 
							{
							if ( state.backtracking==0 ) {
							            etype = new Tuple(LPAREN220, new ArrayList<expr>(), expr_stack.peek().ctype);
							        }
							}
							break;

					}

					RPAREN223=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_atom6144); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RPAREN.add(RPAREN223);

					}
					break;
				case 2 :
					// Python.g:1763:7: LBRACK ( listmaker[$LBRACK] -> listmaker |) RBRACK
					{
					LBRACK224=(Token)match(input,LBRACK,FOLLOW_LBRACK_in_atom6152); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_LBRACK.add(LBRACK224);

					// Python.g:1764:7: ( listmaker[$LBRACK] -> listmaker |)
					int alt109=2;
					int LA109_0 = input.LA(1);
					if ( (LA109_0==BACKQUOTE||(LA109_0 >= LBRACK && LA109_0 <= LCURLY)||(LA109_0 >= LPAREN && LA109_0 <= MINUS)||LA109_0==NAME||LA109_0==NOT||LA109_0==PLUS||LA109_0==TILDE) ) {
						alt109=1;
					}
					else if ( (LA109_0==PRINT) && ((printFunction))) {
						alt109=1;
					}
					else if ( (LA109_0==COMPLEX||LA109_0==FLOAT||LA109_0==INT||LA109_0==LAMBDA||LA109_0==LONGINT||LA109_0==STRING) ) {
						alt109=1;
					}
					else if ( (LA109_0==RBRACK) ) {
						alt109=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 109, 0, input);
						throw nvae;
					}

					switch (alt109) {
						case 1 :
							// Python.g:1764:8: listmaker[$LBRACK]
							{
							pushFollow(FOLLOW_listmaker_in_atom6161);
							listmaker225=listmaker(LBRACK224);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_listmaker.add(listmaker225.getTree());

							// AST REWRITE
							// elements: listmaker
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							if ( state.backtracking==0 ) {
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (PythonTree)adaptor.nil();
							// 1765:6: -> listmaker
							{
								adaptor.addChild(root_0, stream_listmaker.nextTree());
							}


							retval.tree = root_0;
							}

							}
							break;
						case 2 :
							// Python.g:1767:8: 
							{
							if ( state.backtracking==0 ) {
							           etype = new org.python.antlr.ast.List(LBRACK224, new ArrayList<expr>(), expr_stack.peek().ctype);
							       }
							}
							break;

					}

					RBRACK226=(Token)match(input,RBRACK,FOLLOW_RBRACK_in_atom6204); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RBRACK.add(RBRACK226);

					}
					break;
				case 3 :
					// Python.g:1772:7: LCURLY ( dictorsetmaker[$LCURLY] -> dictorsetmaker |) RCURLY
					{
					LCURLY227=(Token)match(input,LCURLY,FOLLOW_LCURLY_in_atom6212); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_LCURLY.add(LCURLY227);

					// Python.g:1773:8: ( dictorsetmaker[$LCURLY] -> dictorsetmaker |)
					int alt110=2;
					int LA110_0 = input.LA(1);
					if ( (LA110_0==BACKQUOTE||(LA110_0 >= LBRACK && LA110_0 <= LCURLY)||(LA110_0 >= LPAREN && LA110_0 <= MINUS)||LA110_0==NAME||LA110_0==NOT||LA110_0==PLUS||LA110_0==TILDE) ) {
						alt110=1;
					}
					else if ( (LA110_0==PRINT) && ((printFunction))) {
						alt110=1;
					}
					else if ( (LA110_0==COMPLEX||LA110_0==FLOAT||LA110_0==INT||LA110_0==LAMBDA||LA110_0==LONGINT||LA110_0==STRING) ) {
						alt110=1;
					}
					else if ( (LA110_0==RCURLY) ) {
						alt110=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 110, 0, input);
						throw nvae;
					}

					switch (alt110) {
						case 1 :
							// Python.g:1773:9: dictorsetmaker[$LCURLY]
							{
							pushFollow(FOLLOW_dictorsetmaker_in_atom6222);
							dictorsetmaker228=dictorsetmaker(LCURLY227);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_dictorsetmaker.add(dictorsetmaker228.getTree());

							// AST REWRITE
							// elements: dictorsetmaker
							// token labels: 
							// rule labels: retval
							// token list labels: 
							// rule list labels: 
							// wildcard labels: 
							if ( state.backtracking==0 ) {
							retval.tree = root_0;
							RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

							root_0 = (PythonTree)adaptor.nil();
							// 1774:7: -> dictorsetmaker
							{
								adaptor.addChild(root_0, stream_dictorsetmaker.nextTree());
							}


							retval.tree = root_0;
							}

							}
							break;
						case 2 :
							// Python.g:1776:9: 
							{
							if ( state.backtracking==0 ) {
							            etype = new Dict(LCURLY227, new ArrayList<expr>(), new ArrayList<expr>());
							        }
							}
							break;

					}

					RCURLY229=(Token)match(input,RCURLY,FOLLOW_RCURLY_in_atom6270); if (state.failed) return retval; 
					if ( state.backtracking==0 ) stream_RCURLY.add(RCURLY229);

					}
					break;
				case 4 :
					// Python.g:1781:8: lb= BACKQUOTE testlist1[expr_contextType.Load] rb= BACKQUOTE
					{
					root_0 = (PythonTree)adaptor.nil();


					lb=(Token)match(input,BACKQUOTE,FOLLOW_BACKQUOTE_in_atom6281); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					lb_tree = (PythonTree)adaptor.create(lb);
					adaptor.addChild(root_0, lb_tree);
					}

					pushFollow(FOLLOW_testlist1_in_atom6283);
					testlist1230=testlist1(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist1230.getTree());

					rb=(Token)match(input,BACKQUOTE,FOLLOW_BACKQUOTE_in_atom6288); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					rb_tree = (PythonTree)adaptor.create(rb);
					adaptor.addChild(root_0, rb_tree);
					}

					if ( state.backtracking==0 ) {
					           etype = new Repr(lb, actions.castExpr((testlist1230!=null?((PythonTree)testlist1230.getTree()):null)));
					       }
					}
					break;
				case 5 :
					// Python.g:1785:8: name_or_print
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_name_or_print_in_atom6306);
					name_or_print231=name_or_print();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, name_or_print231.getTree());

					if ( state.backtracking==0 ) {
					           etype = new Name((name_or_print231!=null?(name_or_print231.start):null), (name_or_print231!=null?input.toString(name_or_print231.start,name_or_print231.stop):null), expr_stack.peek().ctype);
					       }
					}
					break;
				case 6 :
					// Python.g:1789:8: INT
					{
					root_0 = (PythonTree)adaptor.nil();


					INT232=(Token)match(input,INT,FOLLOW_INT_in_atom6324); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					INT232_tree = (PythonTree)adaptor.create(INT232);
					adaptor.addChild(root_0, INT232_tree);
					}

					if ( state.backtracking==0 ) {
					           etype = new Num(INT232, actions.makeInt(INT232));
					       }
					}
					break;
				case 7 :
					// Python.g:1793:8: LONGINT
					{
					root_0 = (PythonTree)adaptor.nil();


					LONGINT233=(Token)match(input,LONGINT,FOLLOW_LONGINT_in_atom6342); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LONGINT233_tree = (PythonTree)adaptor.create(LONGINT233);
					adaptor.addChild(root_0, LONGINT233_tree);
					}

					if ( state.backtracking==0 ) {
					           etype = new Num(LONGINT233, actions.makeInt(LONGINT233));
					       }
					}
					break;
				case 8 :
					// Python.g:1797:8: FLOAT
					{
					root_0 = (PythonTree)adaptor.nil();


					FLOAT234=(Token)match(input,FLOAT,FOLLOW_FLOAT_in_atom6360); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					FLOAT234_tree = (PythonTree)adaptor.create(FLOAT234);
					adaptor.addChild(root_0, FLOAT234_tree);
					}

					if ( state.backtracking==0 ) {
					           etype = new Num(FLOAT234, actions.makeFloat(FLOAT234));
					       }
					}
					break;
				case 9 :
					// Python.g:1801:8: COMPLEX
					{
					root_0 = (PythonTree)adaptor.nil();


					COMPLEX235=(Token)match(input,COMPLEX,FOLLOW_COMPLEX_in_atom6378); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMPLEX235_tree = (PythonTree)adaptor.create(COMPLEX235);
					adaptor.addChild(root_0, COMPLEX235_tree);
					}

					if ( state.backtracking==0 ) {
					           etype = new Num(COMPLEX235, actions.makeComplex(COMPLEX235));
					       }
					}
					break;
				case 10 :
					// Python.g:1805:8: (S+= STRING )+
					{
					root_0 = (PythonTree)adaptor.nil();


					// Python.g:1805:8: (S+= STRING )+
					int cnt111=0;
					loop111:
					while (true) {
						int alt111=2;
						int LA111_0 = input.LA(1);
						if ( (LA111_0==STRING) ) {
							alt111=1;
						}

						switch (alt111) {
						case 1 :
							// Python.g:1805:9: S+= STRING
							{
							S=(Token)match(input,STRING,FOLLOW_STRING_in_atom6399); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							S_tree = (PythonTree)adaptor.create(S);
							adaptor.addChild(root_0, S_tree);
							}

							if (list_S==null) list_S=new ArrayList<Object>();
							list_S.add(S);
							}
							break;

						default :
							if ( cnt111 >= 1 ) break loop111;
							if (state.backtracking>0) {state.failed=true; return retval;}
							EarlyExitException eee = new EarlyExitException(111, input);
							throw eee;
						}
						cnt111++;
					}

					if ( state.backtracking==0 ) {
					           etype = new Str(actions.extractStringToken(list_S), actions.extractStrings(list_S, encoding, unicodeLiterals));
					       }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   if (etype != null) {
			       retval.tree = etype;
			   }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "atom"


	public static class listmaker_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "listmaker"
	// Python.g:1812:1: listmaker[Token lbrack] :t+= test[$expr::ctype] ( list_for[gens] | ( options {greedy=true; } : COMMA t+= test[$expr::ctype] )* ) ( COMMA )? ;
	public final PythonParser.listmaker_return listmaker(Token lbrack) throws RecognitionException {
		PythonParser.listmaker_return retval = new PythonParser.listmaker_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA237=null;
		Token COMMA238=null;
		List<Object> list_t=null;
		ParserRuleReturnScope list_for236 =null;
		RuleReturnScope t = null;
		PythonTree COMMA237_tree=null;
		PythonTree COMMA238_tree=null;


		    List gens = new ArrayList();
		    expr etype = null;

		try {
			// Python.g:1820:5: (t+= test[$expr::ctype] ( list_for[gens] | ( options {greedy=true; } : COMMA t+= test[$expr::ctype] )* ) ( COMMA )? )
			// Python.g:1820:7: t+= test[$expr::ctype] ( list_for[gens] | ( options {greedy=true; } : COMMA t+= test[$expr::ctype] )* ) ( COMMA )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_test_in_listmaker6442);
			t=test(expr_stack.peek().ctype);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

			if (list_t==null) list_t=new ArrayList<Object>();
			list_t.add(t.getTree());
			// Python.g:1821:9: ( list_for[gens] | ( options {greedy=true; } : COMMA t+= test[$expr::ctype] )* )
			int alt114=2;
			int LA114_0 = input.LA(1);
			if ( (LA114_0==FOR) ) {
				alt114=1;
			}
			else if ( (LA114_0==COMMA||LA114_0==RBRACK) ) {
				alt114=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 114, 0, input);
				throw nvae;
			}

			switch (alt114) {
				case 1 :
					// Python.g:1821:10: list_for[gens]
					{
					pushFollow(FOLLOW_list_for_in_listmaker6454);
					list_for236=list_for(gens);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, list_for236.getTree());

					if ( state.backtracking==0 ) {
					             Collections.reverse(gens);
					             List<comprehension> c = gens;
					             etype = new ListComp((retval.start), actions.castExpr(list_t.get(0)), c);
					         }
					}
					break;
				case 2 :
					// Python.g:1827:11: ( options {greedy=true; } : COMMA t+= test[$expr::ctype] )*
					{
					// Python.g:1827:11: ( options {greedy=true; } : COMMA t+= test[$expr::ctype] )*
					loop113:
					while (true) {
						int alt113=2;
						int LA113_0 = input.LA(1);
						if ( (LA113_0==COMMA) ) {
							int LA113_1 = input.LA(2);
							if ( (LA113_1==BACKQUOTE||LA113_1==COMPLEX||LA113_1==FLOAT||LA113_1==INT||(LA113_1 >= LAMBDA && LA113_1 <= LCURLY)||(LA113_1 >= LONGINT && LA113_1 <= MINUS)||LA113_1==NAME||LA113_1==NOT||LA113_1==PLUS||LA113_1==PRINT||(LA113_1 >= STRING && LA113_1 <= TILDE)) ) {
								alt113=1;
							}

						}

						switch (alt113) {
						case 1 :
							// Python.g:1827:35: COMMA t+= test[$expr::ctype]
							{
							COMMA237=(Token)match(input,COMMA,FOLLOW_COMMA_in_listmaker6486); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA237_tree = (PythonTree)adaptor.create(COMMA237);
							adaptor.addChild(root_0, COMMA237_tree);
							}

							pushFollow(FOLLOW_test_in_listmaker6490);
							t=test(expr_stack.peek().ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

							if (list_t==null) list_t=new ArrayList<Object>();
							list_t.add(t.getTree());
							}
							break;

						default :
							break loop113;
						}
					}

					if ( state.backtracking==0 ) {
					               etype = new org.python.antlr.ast.List(lbrack, actions.castExprs(list_t), expr_stack.peek().ctype);
					           }
					}
					break;

			}

			// Python.g:1831:11: ( COMMA )?
			int alt115=2;
			int LA115_0 = input.LA(1);
			if ( (LA115_0==COMMA) ) {
				alt115=1;
			}
			switch (alt115) {
				case 1 :
					// Python.g:1831:12: COMMA
					{
					COMMA238=(Token)match(input,COMMA,FOLLOW_COMMA_in_listmaker6519); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA238_tree = (PythonTree)adaptor.create(COMMA238);
					adaptor.addChild(root_0, COMMA238_tree);
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "listmaker"


	public static class testlist_gexp_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "testlist_gexp"
	// Python.g:1835:1: testlist_gexp :t+= test[$expr::ctype] ( ( options {k=2; } :c1= COMMA t+= test[$expr::ctype] )* (c2= COMMA )? {...}?| -> test | ( comp_for[gens] ) ) ;
	public final PythonParser.testlist_gexp_return testlist_gexp() throws RecognitionException {
		PythonParser.testlist_gexp_return retval = new PythonParser.testlist_gexp_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token c1=null;
		Token c2=null;
		List<Object> list_t=null;
		ParserRuleReturnScope comp_for239 =null;
		RuleReturnScope t = null;
		PythonTree c1_tree=null;
		PythonTree c2_tree=null;
		RewriteRuleTokenStream stream_COMMA=new RewriteRuleTokenStream(adaptor,"token COMMA");
		RewriteRuleSubtreeStream stream_test=new RewriteRuleSubtreeStream(adaptor,"rule test");
		RewriteRuleSubtreeStream stream_comp_for=new RewriteRuleSubtreeStream(adaptor,"rule comp_for");


		    expr etype = null;
		    List gens = new ArrayList();

		try {
			// Python.g:1845:5: (t+= test[$expr::ctype] ( ( options {k=2; } :c1= COMMA t+= test[$expr::ctype] )* (c2= COMMA )? {...}?| -> test | ( comp_for[gens] ) ) )
			// Python.g:1845:7: t+= test[$expr::ctype] ( ( options {k=2; } :c1= COMMA t+= test[$expr::ctype] )* (c2= COMMA )? {...}?| -> test | ( comp_for[gens] ) )
			{
			pushFollow(FOLLOW_test_in_testlist_gexp6551);
			t=test(expr_stack.peek().ctype);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) stream_test.add(t.getTree());
			if (list_t==null) list_t=new ArrayList<Object>();
			list_t.add(t.getTree());
			// Python.g:1846:9: ( ( options {k=2; } :c1= COMMA t+= test[$expr::ctype] )* (c2= COMMA )? {...}?| -> test | ( comp_for[gens] ) )
			int alt118=3;
			switch ( input.LA(1) ) {
			case COMMA:
				{
				alt118=1;
				}
				break;
			case RPAREN:
				{
				int LA118_2 = input.LA(2);
				if ( (( c1 != null || c2 != null )) ) {
					alt118=1;
				}
				else if ( (true) ) {
					alt118=2;
				}

				}
				break;
			case FOR:
				{
				alt118=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 118, 0, input);
				throw nvae;
			}
			switch (alt118) {
				case 1 :
					// Python.g:1846:11: ( options {k=2; } :c1= COMMA t+= test[$expr::ctype] )* (c2= COMMA )? {...}?
					{
					// Python.g:1846:11: ( options {k=2; } :c1= COMMA t+= test[$expr::ctype] )*
					loop116:
					while (true) {
						int alt116=2;
						int LA116_0 = input.LA(1);
						if ( (LA116_0==COMMA) ) {
							int LA116_1 = input.LA(2);
							if ( (LA116_1==BACKQUOTE||LA116_1==COMPLEX||LA116_1==FLOAT||LA116_1==INT||(LA116_1 >= LAMBDA && LA116_1 <= LCURLY)||(LA116_1 >= LONGINT && LA116_1 <= MINUS)||LA116_1==NAME||LA116_1==NOT||LA116_1==PLUS||LA116_1==PRINT||(LA116_1 >= STRING && LA116_1 <= TILDE)) ) {
								alt116=1;
							}

						}

						switch (alt116) {
						case 1 :
							// Python.g:1846:28: c1= COMMA t+= test[$expr::ctype]
							{
							c1=(Token)match(input,COMMA,FOLLOW_COMMA_in_testlist_gexp6575); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_COMMA.add(c1);

							pushFollow(FOLLOW_test_in_testlist_gexp6579);
							t=test(expr_stack.peek().ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) stream_test.add(t.getTree());
							if (list_t==null) list_t=new ArrayList<Object>();
							list_t.add(t.getTree());
							}
							break;

						default :
							break loop116;
						}
					}

					// Python.g:1846:61: (c2= COMMA )?
					int alt117=2;
					int LA117_0 = input.LA(1);
					if ( (LA117_0==COMMA) ) {
						alt117=1;
					}
					switch (alt117) {
						case 1 :
							// Python.g:1846:62: c2= COMMA
							{
							c2=(Token)match(input,COMMA,FOLLOW_COMMA_in_testlist_gexp6587); if (state.failed) return retval; 
							if ( state.backtracking==0 ) stream_COMMA.add(c2);

							}
							break;

					}

					if ( !(( c1 != null || c2 != null )) ) {
						if (state.backtracking>0) {state.failed=true; return retval;}
						throw new FailedPredicateException(input, "testlist_gexp", " $c1 != null || $c2 != null ");
					}
					if ( state.backtracking==0 ) {
					               etype = new Tuple((retval.start), actions.castExprs(list_t), expr_stack.peek().ctype);
					           }
					}
					break;
				case 2 :
					// Python.g:1851:11: 
					{

					// AST REWRITE
					// elements: test
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1851:11: -> test
					{
						adaptor.addChild(root_0, stream_test.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;
				case 3 :
					// Python.g:1852:11: ( comp_for[gens] )
					{
					// Python.g:1852:11: ( comp_for[gens] )
					// Python.g:1852:12: comp_for[gens]
					{
					pushFollow(FOLLOW_comp_for_in_testlist_gexp6641);
					comp_for239=comp_for(gens);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_comp_for.add(comp_for239.getTree());
					if ( state.backtracking==0 ) {
					               Collections.reverse(gens);
					               List<comprehension> c = gens;
					               expr e = actions.castExpr(list_t.get(0));
					               if (e instanceof Context) {
					                   ((Context)e).setContext(expr_contextType.Load);
					               }
					               etype = new GeneratorExp((retval.start), actions.castExpr(list_t.get(0)), c);
					           }
					}

					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "testlist_gexp"


	public static class lambdef_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "lambdef"
	// Python.g:1867:1: lambdef : LAMBDA ( varargslist )? COLON test[expr_contextType.Load] ;
	public final PythonParser.lambdef_return lambdef() throws RecognitionException {
		PythonParser.lambdef_return retval = new PythonParser.lambdef_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token LAMBDA240=null;
		Token COLON242=null;
		ParserRuleReturnScope varargslist241 =null;
		ParserRuleReturnScope test243 =null;

		PythonTree LAMBDA240_tree=null;
		PythonTree COLON242_tree=null;


		    expr etype = null;

		try {
			// Python.g:1874:5: ( LAMBDA ( varargslist )? COLON test[expr_contextType.Load] )
			// Python.g:1874:7: LAMBDA ( varargslist )? COLON test[expr_contextType.Load]
			{
			root_0 = (PythonTree)adaptor.nil();


			LAMBDA240=(Token)match(input,LAMBDA,FOLLOW_LAMBDA_in_lambdef6705); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			LAMBDA240_tree = (PythonTree)adaptor.create(LAMBDA240);
			adaptor.addChild(root_0, LAMBDA240_tree);
			}

			// Python.g:1874:14: ( varargslist )?
			int alt119=2;
			int LA119_0 = input.LA(1);
			if ( (LA119_0==DOUBLESTAR||LA119_0==LPAREN||LA119_0==NAME||LA119_0==STAR) ) {
				alt119=1;
			}
			switch (alt119) {
				case 1 :
					// Python.g:1874:15: varargslist
					{
					pushFollow(FOLLOW_varargslist_in_lambdef6708);
					varargslist241=varargslist();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, varargslist241.getTree());

					}
					break;

			}

			COLON242=(Token)match(input,COLON,FOLLOW_COLON_in_lambdef6712); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON242_tree = (PythonTree)adaptor.create(COLON242);
			adaptor.addChild(root_0, COLON242_tree);
			}

			pushFollow(FOLLOW_test_in_lambdef6714);
			test243=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, test243.getTree());

			if ( state.backtracking==0 ) {
			          arguments a = (varargslist241!=null?((PythonParser.varargslist_return)varargslist241).args:null);
			          if (a == null) {
			              a = new arguments(LAMBDA240, new ArrayList<expr>(), (Name)null, null, new ArrayList<expr>());
			          }
			          etype = new Lambda(LAMBDA240, a, actions.castExpr((test243!=null?((PythonTree)test243.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "lambdef"


	public static class trailer_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "trailer"
	// Python.g:1885:1: trailer[Token begin, PythonTree ptree] : ( LPAREN ( arglist |) RPAREN | LBRACK subscriptlist[$begin] RBRACK | DOT attr );
	public final PythonParser.trailer_return trailer(Token begin, PythonTree ptree) throws RecognitionException {
		PythonParser.trailer_return retval = new PythonParser.trailer_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token LPAREN244=null;
		Token RPAREN246=null;
		Token LBRACK247=null;
		Token RBRACK249=null;
		Token DOT250=null;
		ParserRuleReturnScope arglist245 =null;
		ParserRuleReturnScope subscriptlist248 =null;
		ParserRuleReturnScope attr251 =null;

		PythonTree LPAREN244_tree=null;
		PythonTree RPAREN246_tree=null;
		PythonTree LBRACK247_tree=null;
		PythonTree RBRACK249_tree=null;
		PythonTree DOT250_tree=null;


		    expr etype = null;

		try {
			// Python.g:1894:5: ( LPAREN ( arglist |) RPAREN | LBRACK subscriptlist[$begin] RBRACK | DOT attr )
			int alt121=3;
			switch ( input.LA(1) ) {
			case LPAREN:
				{
				alt121=1;
				}
				break;
			case LBRACK:
				{
				alt121=2;
				}
				break;
			case DOT:
				{
				alt121=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 121, 0, input);
				throw nvae;
			}
			switch (alt121) {
				case 1 :
					// Python.g:1894:7: LPAREN ( arglist |) RPAREN
					{
					root_0 = (PythonTree)adaptor.nil();


					LPAREN244=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_trailer6753); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LPAREN244_tree = (PythonTree)adaptor.create(LPAREN244);
					adaptor.addChild(root_0, LPAREN244_tree);
					}

					// Python.g:1895:7: ( arglist |)
					int alt120=2;
					int LA120_0 = input.LA(1);
					if ( (LA120_0==BACKQUOTE||(LA120_0 >= LBRACK && LA120_0 <= LCURLY)||(LA120_0 >= LPAREN && LA120_0 <= MINUS)||LA120_0==NAME||LA120_0==NOT||LA120_0==PLUS||LA120_0==TILDE) ) {
						alt120=1;
					}
					else if ( (LA120_0==PRINT) && ((printFunction))) {
						alt120=1;
					}
					else if ( (LA120_0==COMPLEX||LA120_0==DOUBLESTAR||LA120_0==FLOAT||LA120_0==INT||LA120_0==LAMBDA||LA120_0==LONGINT||LA120_0==STAR||LA120_0==STRING) ) {
						alt120=1;
					}
					else if ( (LA120_0==RPAREN) ) {
						alt120=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 120, 0, input);
						throw nvae;
					}

					switch (alt120) {
						case 1 :
							// Python.g:1895:8: arglist
							{
							pushFollow(FOLLOW_arglist_in_trailer6762);
							arglist245=arglist();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, arglist245.getTree());

							if ( state.backtracking==0 ) {
							           etype = new Call(begin, actions.castExpr(ptree), actions.castExprs((arglist245!=null?((PythonParser.arglist_return)arglist245).args:null)),
							             actions.makeKeywords((arglist245!=null?((PythonParser.arglist_return)arglist245).keywords:null)), (arglist245!=null?((PythonParser.arglist_return)arglist245).starargs:null), (arglist245!=null?((PythonParser.arglist_return)arglist245).kwargs:null));
							       }
							}
							break;
						case 2 :
							// Python.g:1901:8: 
							{
							if ( state.backtracking==0 ) {
							           etype = new Call(begin, actions.castExpr(ptree), new ArrayList<expr>(), new ArrayList<keyword>(), null, null);
							       }
							}
							break;

					}

					RPAREN246=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_trailer6804); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RPAREN246_tree = (PythonTree)adaptor.create(RPAREN246);
					adaptor.addChild(root_0, RPAREN246_tree);
					}

					}
					break;
				case 2 :
					// Python.g:1906:7: LBRACK subscriptlist[$begin] RBRACK
					{
					root_0 = (PythonTree)adaptor.nil();


					LBRACK247=(Token)match(input,LBRACK,FOLLOW_LBRACK_in_trailer6812); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LBRACK247_tree = (PythonTree)adaptor.create(LBRACK247);
					adaptor.addChild(root_0, LBRACK247_tree);
					}

					pushFollow(FOLLOW_subscriptlist_in_trailer6814);
					subscriptlist248=subscriptlist(begin);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, subscriptlist248.getTree());

					RBRACK249=(Token)match(input,RBRACK,FOLLOW_RBRACK_in_trailer6817); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RBRACK249_tree = (PythonTree)adaptor.create(RBRACK249);
					adaptor.addChild(root_0, RBRACK249_tree);
					}

					if ( state.backtracking==0 ) {
					          etype = new Subscript(begin, actions.castExpr(ptree), actions.castSlice((subscriptlist248!=null?((PythonTree)subscriptlist248.getTree()):null)), expr_stack.peek().ctype);
					      }
					}
					break;
				case 3 :
					// Python.g:1910:7: DOT attr
					{
					root_0 = (PythonTree)adaptor.nil();


					DOT250=(Token)match(input,DOT,FOLLOW_DOT_in_trailer6833); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOT250_tree = (PythonTree)adaptor.create(DOT250);
					adaptor.addChild(root_0, DOT250_tree);
					}

					pushFollow(FOLLOW_attr_in_trailer6835);
					attr251=attr();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, attr251.getTree());

					if ( state.backtracking==0 ) {
					          etype = new Attribute(begin, actions.castExpr(ptree), new Name((attr251!=null?((PythonTree)attr251.getTree()):null), (attr251!=null?input.toString(attr251.start,attr251.stop):null), expr_contextType.Load), expr_stack.peek().ctype);
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "trailer"


	public static class subscriptlist_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "subscriptlist"
	// Python.g:1917:1: subscriptlist[Token begin] :sub+= subscript ( options {greedy=true; } :c1= COMMA sub+= subscript )* (c2= COMMA )? ;
	public final PythonParser.subscriptlist_return subscriptlist(Token begin) throws RecognitionException {
		PythonParser.subscriptlist_return retval = new PythonParser.subscriptlist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token c1=null;
		Token c2=null;
		List<Object> list_sub=null;
		RuleReturnScope sub = null;
		PythonTree c1_tree=null;
		PythonTree c2_tree=null;


		    slice sltype = null;

		try {
			// Python.g:1924:5: (sub+= subscript ( options {greedy=true; } :c1= COMMA sub+= subscript )* (c2= COMMA )? )
			// Python.g:1924:7: sub+= subscript ( options {greedy=true; } :c1= COMMA sub+= subscript )* (c2= COMMA )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_subscript_in_subscriptlist6874);
			sub=subscript();
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, sub.getTree());

			if (list_sub==null) list_sub=new ArrayList<Object>();
			list_sub.add(sub.getTree());
			// Python.g:1924:22: ( options {greedy=true; } :c1= COMMA sub+= subscript )*
			loop122:
			while (true) {
				int alt122=2;
				int LA122_0 = input.LA(1);
				if ( (LA122_0==COMMA) ) {
					int LA122_1 = input.LA(2);
					if ( (LA122_1==BACKQUOTE||LA122_1==COLON||LA122_1==COMPLEX||LA122_1==DOT||LA122_1==FLOAT||LA122_1==INT||(LA122_1 >= LAMBDA && LA122_1 <= LCURLY)||(LA122_1 >= LONGINT && LA122_1 <= MINUS)||LA122_1==NAME||LA122_1==NOT||LA122_1==PLUS||LA122_1==PRINT||(LA122_1 >= STRING && LA122_1 <= TILDE)) ) {
						alt122=1;
					}

				}

				switch (alt122) {
				case 1 :
					// Python.g:1924:46: c1= COMMA sub+= subscript
					{
					c1=(Token)match(input,COMMA,FOLLOW_COMMA_in_subscriptlist6886); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					c1_tree = (PythonTree)adaptor.create(c1);
					adaptor.addChild(root_0, c1_tree);
					}

					pushFollow(FOLLOW_subscript_in_subscriptlist6890);
					sub=subscript();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, sub.getTree());

					if (list_sub==null) list_sub=new ArrayList<Object>();
					list_sub.add(sub.getTree());
					}
					break;

				default :
					break loop122;
				}
			}

			// Python.g:1924:72: (c2= COMMA )?
			int alt123=2;
			int LA123_0 = input.LA(1);
			if ( (LA123_0==COMMA) ) {
				alt123=1;
			}
			switch (alt123) {
				case 1 :
					// Python.g:1924:73: c2= COMMA
					{
					c2=(Token)match(input,COMMA,FOLLOW_COMMA_in_subscriptlist6897); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					c2_tree = (PythonTree)adaptor.create(c2);
					adaptor.addChild(root_0, c2_tree);
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          sltype = actions.makeSliceType(begin, c1, c2, list_sub);
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = sltype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subscriptlist"


	public static class subscript_return extends ParserRuleReturnScope {
		public slice sltype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "subscript"
	// Python.g:1931:1: subscript returns [slice sltype] : (d1= DOT DOT DOT | ( test[null] COLON )=>lower= test[expr_contextType.Load] (c1= COLON (upper1= test[expr_contextType.Load] )? ( sliceop )? )? | ( COLON )=>c2= COLON (upper2= test[expr_contextType.Load] )? ( sliceop )? | test[expr_contextType.Load] );
	public final PythonParser.subscript_return subscript() throws RecognitionException {
		PythonParser.subscript_return retval = new PythonParser.subscript_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token d1=null;
		Token c1=null;
		Token c2=null;
		Token DOT252=null;
		Token DOT253=null;
		ParserRuleReturnScope lower =null;
		ParserRuleReturnScope upper1 =null;
		ParserRuleReturnScope upper2 =null;
		ParserRuleReturnScope sliceop254 =null;
		ParserRuleReturnScope sliceop255 =null;
		ParserRuleReturnScope test256 =null;

		PythonTree d1_tree=null;
		PythonTree c1_tree=null;
		PythonTree c2_tree=null;
		PythonTree DOT252_tree=null;
		PythonTree DOT253_tree=null;

		try {
			// Python.g:1936:5: (d1= DOT DOT DOT | ( test[null] COLON )=>lower= test[expr_contextType.Load] (c1= COLON (upper1= test[expr_contextType.Load] )? ( sliceop )? )? | ( COLON )=>c2= COLON (upper2= test[expr_contextType.Load] )? ( sliceop )? | test[expr_contextType.Load] )
			int alt129=4;
			int LA129_0 = input.LA(1);
			if ( (LA129_0==DOT) ) {
				alt129=1;
			}
			else if ( (LA129_0==NOT) ) {
				int LA129_2 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==PLUS) ) {
				int LA129_3 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==MINUS) ) {
				int LA129_4 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==TILDE) ) {
				int LA129_5 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==LPAREN) ) {
				int LA129_6 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==LBRACK) ) {
				int LA129_7 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==LCURLY) ) {
				int LA129_8 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==BACKQUOTE) ) {
				int LA129_9 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==NAME) ) {
				int LA129_10 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==PRINT) && ((printFunction))) {
				int LA129_11 = input.LA(2);
				if ( (((printFunction)&&synpred8_Python())) ) {
					alt129=2;
				}
				else if ( ((printFunction)) ) {
					alt129=4;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 129, 11, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA129_0==INT) ) {
				int LA129_12 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==LONGINT) ) {
				int LA129_13 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==FLOAT) ) {
				int LA129_14 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==COMPLEX) ) {
				int LA129_15 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==STRING) ) {
				int LA129_16 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==LAMBDA) ) {
				int LA129_17 = input.LA(2);
				if ( (synpred8_Python()) ) {
					alt129=2;
				}
				else if ( (true) ) {
					alt129=4;
				}

			}
			else if ( (LA129_0==COLON) && (synpred9_Python())) {
				alt129=3;
			}

			switch (alt129) {
				case 1 :
					// Python.g:1936:7: d1= DOT DOT DOT
					{
					root_0 = (PythonTree)adaptor.nil();


					d1=(Token)match(input,DOT,FOLLOW_DOT_in_subscript6940); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					d1_tree = (PythonTree)adaptor.create(d1);
					adaptor.addChild(root_0, d1_tree);
					}

					DOT252=(Token)match(input,DOT,FOLLOW_DOT_in_subscript6942); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOT252_tree = (PythonTree)adaptor.create(DOT252);
					adaptor.addChild(root_0, DOT252_tree);
					}

					DOT253=(Token)match(input,DOT,FOLLOW_DOT_in_subscript6944); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOT253_tree = (PythonTree)adaptor.create(DOT253);
					adaptor.addChild(root_0, DOT253_tree);
					}

					if ( state.backtracking==0 ) {
					          retval.sltype = new Ellipsis(d1);
					      }
					}
					break;
				case 2 :
					// Python.g:1940:7: ( test[null] COLON )=>lower= test[expr_contextType.Load] (c1= COLON (upper1= test[expr_contextType.Load] )? ( sliceop )? )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_subscript6974);
					lower=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, lower.getTree());

					// Python.g:1941:41: (c1= COLON (upper1= test[expr_contextType.Load] )? ( sliceop )? )?
					int alt126=2;
					int LA126_0 = input.LA(1);
					if ( (LA126_0==COLON) ) {
						alt126=1;
					}
					switch (alt126) {
						case 1 :
							// Python.g:1941:42: c1= COLON (upper1= test[expr_contextType.Load] )? ( sliceop )?
							{
							c1=(Token)match(input,COLON,FOLLOW_COLON_in_subscript6980); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							c1_tree = (PythonTree)adaptor.create(c1);
							adaptor.addChild(root_0, c1_tree);
							}

							// Python.g:1941:51: (upper1= test[expr_contextType.Load] )?
							int alt124=2;
							int LA124_0 = input.LA(1);
							if ( (LA124_0==BACKQUOTE||(LA124_0 >= LBRACK && LA124_0 <= LCURLY)||(LA124_0 >= LPAREN && LA124_0 <= MINUS)||LA124_0==NAME||LA124_0==NOT||LA124_0==PLUS||LA124_0==TILDE) ) {
								alt124=1;
							}
							else if ( (LA124_0==PRINT) && ((printFunction))) {
								alt124=1;
							}
							else if ( (LA124_0==COMPLEX||LA124_0==FLOAT||LA124_0==INT||LA124_0==LAMBDA||LA124_0==LONGINT||LA124_0==STRING) ) {
								alt124=1;
							}
							switch (alt124) {
								case 1 :
									// Python.g:1941:52: upper1= test[expr_contextType.Load]
									{
									pushFollow(FOLLOW_test_in_subscript6985);
									upper1=test(expr_contextType.Load);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, upper1.getTree());

									}
									break;

							}

							// Python.g:1941:89: ( sliceop )?
							int alt125=2;
							int LA125_0 = input.LA(1);
							if ( (LA125_0==COLON) ) {
								alt125=1;
							}
							switch (alt125) {
								case 1 :
									// Python.g:1941:90: sliceop
									{
									pushFollow(FOLLOW_sliceop_in_subscript6991);
									sliceop254=sliceop();
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, sliceop254.getTree());

									}
									break;

							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          retval.sltype = actions.makeSubscript((lower!=null?((PythonTree)lower.getTree()):null), c1, (upper1!=null?((PythonTree)upper1.getTree()):null), (sliceop254!=null?((PythonTree)sliceop254.getTree()):null));
					      }
					}
					break;
				case 3 :
					// Python.g:1945:7: ( COLON )=>c2= COLON (upper2= test[expr_contextType.Load] )? ( sliceop )?
					{
					root_0 = (PythonTree)adaptor.nil();


					c2=(Token)match(input,COLON,FOLLOW_COLON_in_subscript7022); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					c2_tree = (PythonTree)adaptor.create(c2);
					adaptor.addChild(root_0, c2_tree);
					}

					// Python.g:1946:16: (upper2= test[expr_contextType.Load] )?
					int alt127=2;
					int LA127_0 = input.LA(1);
					if ( (LA127_0==BACKQUOTE||(LA127_0 >= LBRACK && LA127_0 <= LCURLY)||(LA127_0 >= LPAREN && LA127_0 <= MINUS)||LA127_0==NAME||LA127_0==NOT||LA127_0==PLUS||LA127_0==TILDE) ) {
						alt127=1;
					}
					else if ( (LA127_0==PRINT) && ((printFunction))) {
						alt127=1;
					}
					else if ( (LA127_0==COMPLEX||LA127_0==FLOAT||LA127_0==INT||LA127_0==LAMBDA||LA127_0==LONGINT||LA127_0==STRING) ) {
						alt127=1;
					}
					switch (alt127) {
						case 1 :
							// Python.g:1946:17: upper2= test[expr_contextType.Load]
							{
							pushFollow(FOLLOW_test_in_subscript7027);
							upper2=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, upper2.getTree());

							}
							break;

					}

					// Python.g:1946:54: ( sliceop )?
					int alt128=2;
					int LA128_0 = input.LA(1);
					if ( (LA128_0==COLON) ) {
						alt128=1;
					}
					switch (alt128) {
						case 1 :
							// Python.g:1946:55: sliceop
							{
							pushFollow(FOLLOW_sliceop_in_subscript7033);
							sliceop255=sliceop();
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, sliceop255.getTree());

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          retval.sltype = actions.makeSubscript(null, c2, (upper2!=null?((PythonTree)upper2.getTree()):null), (sliceop255!=null?((PythonTree)sliceop255.getTree()):null));
					      }
					}
					break;
				case 4 :
					// Python.g:1950:7: test[expr_contextType.Load]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_subscript7051);
					test256=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, test256.getTree());

					if ( state.backtracking==0 ) {
					          retval.sltype = new Index((test256!=null?(test256.start):null), actions.castExpr((test256!=null?((PythonTree)test256.getTree()):null)));
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    retval.tree = retval.sltype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "subscript"


	public static class sliceop_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "sliceop"
	// Python.g:1957:1: sliceop : COLON ( test[expr_contextType.Load] -> test |) ;
	public final PythonParser.sliceop_return sliceop() throws RecognitionException {
		PythonParser.sliceop_return retval = new PythonParser.sliceop_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COLON257=null;
		ParserRuleReturnScope test258 =null;

		PythonTree COLON257_tree=null;
		RewriteRuleTokenStream stream_COLON=new RewriteRuleTokenStream(adaptor,"token COLON");
		RewriteRuleSubtreeStream stream_test=new RewriteRuleSubtreeStream(adaptor,"rule test");


		    expr etype = null;

		try {
			// Python.g:1966:5: ( COLON ( test[expr_contextType.Load] -> test |) )
			// Python.g:1966:7: COLON ( test[expr_contextType.Load] -> test |)
			{
			COLON257=(Token)match(input,COLON,FOLLOW_COLON_in_sliceop7088); if (state.failed) return retval; 
			if ( state.backtracking==0 ) stream_COLON.add(COLON257);

			// Python.g:1967:6: ( test[expr_contextType.Load] -> test |)
			int alt130=2;
			int LA130_0 = input.LA(1);
			if ( (LA130_0==BACKQUOTE||(LA130_0 >= LBRACK && LA130_0 <= LCURLY)||(LA130_0 >= LPAREN && LA130_0 <= MINUS)||LA130_0==NAME||LA130_0==NOT||LA130_0==PLUS||LA130_0==TILDE) ) {
				alt130=1;
			}
			else if ( (LA130_0==PRINT) && ((printFunction))) {
				alt130=1;
			}
			else if ( (LA130_0==COMPLEX||LA130_0==FLOAT||LA130_0==INT||LA130_0==LAMBDA||LA130_0==LONGINT||LA130_0==STRING) ) {
				alt130=1;
			}
			else if ( (LA130_0==COMMA||LA130_0==RBRACK) ) {
				alt130=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 130, 0, input);
				throw nvae;
			}

			switch (alt130) {
				case 1 :
					// Python.g:1967:7: test[expr_contextType.Load]
					{
					pushFollow(FOLLOW_test_in_sliceop7096);
					test258=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) stream_test.add(test258.getTree());

					// AST REWRITE
					// elements: test
					// token labels: 
					// rule labels: retval
					// token list labels: 
					// rule list labels: 
					// wildcard labels: 
					if ( state.backtracking==0 ) {
					retval.tree = root_0;
					RewriteRuleSubtreeStream stream_retval=new RewriteRuleSubtreeStream(adaptor,"rule retval",retval!=null?retval.getTree():null);

					root_0 = (PythonTree)adaptor.nil();
					// 1968:5: -> test
					{
						adaptor.addChild(root_0, stream_test.nextTree());
					}


					retval.tree = root_0;
					}

					}
					break;
				case 2 :
					// Python.g:1970:8: 
					{
					if ( state.backtracking==0 ) {
					           etype = new Name(COLON257, "None", expr_contextType.Load);
					       }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "sliceop"


	public static class exprlist_return extends ParserRuleReturnScope {
		public expr etype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "exprlist"
	// Python.g:1977:1: exprlist[expr_contextType ctype] returns [expr etype] : ( ( expr[null] COMMA )=>e+= expr[ctype] ( options {k=2; } : COMMA e+= expr[ctype] )* ( COMMA )? | expr[ctype] );
	public final PythonParser.exprlist_return exprlist(expr_contextType ctype) throws RecognitionException {
		PythonParser.exprlist_return retval = new PythonParser.exprlist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA259=null;
		Token COMMA260=null;
		List<Object> list_e=null;
		ParserRuleReturnScope expr261 =null;
		RuleReturnScope e = null;
		PythonTree COMMA259_tree=null;
		PythonTree COMMA260_tree=null;

		try {
			// Python.g:1979:5: ( ( expr[null] COMMA )=>e+= expr[ctype] ( options {k=2; } : COMMA e+= expr[ctype] )* ( COMMA )? | expr[ctype] )
			int alt133=2;
			int LA133_0 = input.LA(1);
			if ( (LA133_0==PLUS) ) {
				int LA133_1 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==MINUS) ) {
				int LA133_2 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==TILDE) ) {
				int LA133_3 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==LPAREN) ) {
				int LA133_4 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==LBRACK) ) {
				int LA133_5 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==LCURLY) ) {
				int LA133_6 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==BACKQUOTE) ) {
				int LA133_7 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==NAME) ) {
				int LA133_8 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==PRINT) && ((printFunction))) {
				int LA133_9 = input.LA(2);
				if ( (((printFunction)&&synpred10_Python())) ) {
					alt133=1;
				}
				else if ( ((printFunction)) ) {
					alt133=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 133, 9, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA133_0==INT) ) {
				int LA133_10 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==LONGINT) ) {
				int LA133_11 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==FLOAT) ) {
				int LA133_12 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==COMPLEX) ) {
				int LA133_13 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}
			else if ( (LA133_0==STRING) ) {
				int LA133_14 = input.LA(2);
				if ( (synpred10_Python()) ) {
					alt133=1;
				}
				else if ( (true) ) {
					alt133=2;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 133, 0, input);
				throw nvae;
			}

			switch (alt133) {
				case 1 :
					// Python.g:1979:7: ( expr[null] COMMA )=>e+= expr[ctype] ( options {k=2; } : COMMA e+= expr[ctype] )* ( COMMA )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_expr_in_exprlist7167);
					e=expr(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, e.getTree());

					if (list_e==null) list_e=new ArrayList<Object>();
					list_e.add(e.getTree());
					// Python.g:1979:44: ( options {k=2; } : COMMA e+= expr[ctype] )*
					loop131:
					while (true) {
						int alt131=2;
						int LA131_0 = input.LA(1);
						if ( (LA131_0==COMMA) ) {
							int LA131_1 = input.LA(2);
							if ( (LA131_1==BACKQUOTE||LA131_1==COMPLEX||LA131_1==FLOAT||LA131_1==INT||(LA131_1 >= LBRACK && LA131_1 <= LCURLY)||(LA131_1 >= LONGINT && LA131_1 <= MINUS)||LA131_1==NAME||LA131_1==PLUS||LA131_1==PRINT||(LA131_1 >= STRING && LA131_1 <= TILDE)) ) {
								alt131=1;
							}

						}

						switch (alt131) {
						case 1 :
							// Python.g:1979:61: COMMA e+= expr[ctype]
							{
							COMMA259=(Token)match(input,COMMA,FOLLOW_COMMA_in_exprlist7179); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA259_tree = (PythonTree)adaptor.create(COMMA259);
							adaptor.addChild(root_0, COMMA259_tree);
							}

							pushFollow(FOLLOW_expr_in_exprlist7183);
							e=expr(ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, e.getTree());

							if (list_e==null) list_e=new ArrayList<Object>();
							list_e.add(e.getTree());
							}
							break;

						default :
							break loop131;
						}
					}

					// Python.g:1979:84: ( COMMA )?
					int alt132=2;
					int LA132_0 = input.LA(1);
					if ( (LA132_0==COMMA) ) {
						alt132=1;
					}
					switch (alt132) {
						case 1 :
							// Python.g:1979:85: COMMA
							{
							COMMA260=(Token)match(input,COMMA,FOLLOW_COMMA_in_exprlist7189); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA260_tree = (PythonTree)adaptor.create(COMMA260);
							adaptor.addChild(root_0, COMMA260_tree);
							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					           retval.etype = new Tuple((retval.start), actions.castExprs(list_e), ctype);
					       }
					}
					break;
				case 2 :
					// Python.g:1983:7: expr[ctype]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_expr_in_exprlist7208);
					expr261=expr(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, expr261.getTree());

					if ( state.backtracking==0 ) {
					        retval.etype = actions.castExpr((expr261!=null?((PythonTree)expr261.getTree()):null));
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "exprlist"


	public static class del_list_return extends ParserRuleReturnScope {
		public List<expr> etypes;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "del_list"
	// Python.g:1991:1: del_list returns [List<expr> etypes] : e= expr[expr_contextType.Del] ( options {k=2; } : COMMA e= expr[expr_contextType.Del] )* ( COMMA )? ;
	public final PythonParser.del_list_return del_list() throws RecognitionException {
		PythonParser.del_list_return retval = new PythonParser.del_list_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA262=null;
		Token COMMA263=null;
		ParserRuleReturnScope e =null;

		PythonTree COMMA262_tree=null;
		PythonTree COMMA263_tree=null;

		List<PythonTree> exprList = new ArrayList<>();
		try {
			// Python.g:1994:5: (e= expr[expr_contextType.Del] ( options {k=2; } : COMMA e= expr[expr_contextType.Del] )* ( COMMA )? )
			// Python.g:1994:7: e= expr[expr_contextType.Del] ( options {k=2; } : COMMA e= expr[expr_contextType.Del] )* ( COMMA )?
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_expr_in_del_list7254);
			e=expr(expr_contextType.Del);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, e.getTree());

			if ( state.backtracking==0 ) {exprList.add((e!=null?((PythonTree)e.getTree()):null));}
			// Python.g:1995:9: ( options {k=2; } : COMMA e= expr[expr_contextType.Del] )*
			loop134:
			while (true) {
				int alt134=2;
				int LA134_0 = input.LA(1);
				if ( (LA134_0==COMMA) ) {
					int LA134_1 = input.LA(2);
					if ( (LA134_1==BACKQUOTE||LA134_1==COMPLEX||LA134_1==FLOAT||LA134_1==INT||(LA134_1 >= LBRACK && LA134_1 <= LCURLY)||(LA134_1 >= LONGINT && LA134_1 <= MINUS)||LA134_1==NAME||LA134_1==PLUS||LA134_1==PRINT||(LA134_1 >= STRING && LA134_1 <= TILDE)) ) {
						alt134=1;
					}

				}

				switch (alt134) {
				case 1 :
					// Python.g:1995:26: COMMA e= expr[expr_contextType.Del]
					{
					COMMA262=(Token)match(input,COMMA,FOLLOW_COMMA_in_del_list7276); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA262_tree = (PythonTree)adaptor.create(COMMA262);
					adaptor.addChild(root_0, COMMA262_tree);
					}

					pushFollow(FOLLOW_expr_in_del_list7280);
					e=expr(expr_contextType.Del);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, e.getTree());

					if ( state.backtracking==0 ) {exprList.add((e!=null?((PythonTree)e.getTree()):null));}
					}
					break;

				default :
					break loop134;
				}
			}

			// Python.g:1996:40: ( COMMA )?
			int alt135=2;
			int LA135_0 = input.LA(1);
			if ( (LA135_0==COMMA) ) {
				alt135=1;
			}
			switch (alt135) {
				case 1 :
					// Python.g:1996:41: COMMA
					{
					COMMA263=(Token)match(input,COMMA,FOLLOW_COMMA_in_del_list7300); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA263_tree = (PythonTree)adaptor.create(COMMA263);
					adaptor.addChild(root_0, COMMA263_tree);
					}

					}
					break;

			}

			if ( state.backtracking==0 ) {retval.etypes = actions.makeDeleteList(exprList);}
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "del_list"


	public static class testlist_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "testlist"
	// Python.g:2001:1: testlist[expr_contextType ctype] : ( ( test[null] COMMA )=>t+= test[ctype] ( options {k=2; } : COMMA t+= test[ctype] )* ( COMMA )? | test[ctype] );
	public final PythonParser.testlist_return testlist(expr_contextType ctype) throws RecognitionException {
		PythonParser.testlist_return retval = new PythonParser.testlist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA264=null;
		Token COMMA265=null;
		List<Object> list_t=null;
		ParserRuleReturnScope test266 =null;
		RuleReturnScope t = null;
		PythonTree COMMA264_tree=null;
		PythonTree COMMA265_tree=null;


		    expr etype = null;

		try {
			// Python.g:2010:5: ( ( test[null] COMMA )=>t+= test[ctype] ( options {k=2; } : COMMA t+= test[ctype] )* ( COMMA )? | test[ctype] )
			int alt138=2;
			int LA138_0 = input.LA(1);
			if ( (LA138_0==NOT) ) {
				int LA138_1 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==PLUS) ) {
				int LA138_2 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==MINUS) ) {
				int LA138_3 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==TILDE) ) {
				int LA138_4 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==LPAREN) ) {
				int LA138_5 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==LBRACK) ) {
				int LA138_6 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==LCURLY) ) {
				int LA138_7 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==BACKQUOTE) ) {
				int LA138_8 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==NAME) ) {
				int LA138_9 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==PRINT) && ((printFunction))) {
				int LA138_10 = input.LA(2);
				if ( (((printFunction)&&synpred11_Python())) ) {
					alt138=1;
				}
				else if ( ((printFunction)) ) {
					alt138=2;
				}

				else {
					if (state.backtracking>0) {state.failed=true; return retval;}
					int nvaeMark = input.mark();
					try {
						input.consume();
						NoViableAltException nvae =
							new NoViableAltException("", 138, 10, input);
						throw nvae;
					} finally {
						input.rewind(nvaeMark);
					}
				}

			}
			else if ( (LA138_0==INT) ) {
				int LA138_11 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==LONGINT) ) {
				int LA138_12 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==FLOAT) ) {
				int LA138_13 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==COMPLEX) ) {
				int LA138_14 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==STRING) ) {
				int LA138_15 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}
			else if ( (LA138_0==LAMBDA) ) {
				int LA138_16 = input.LA(2);
				if ( (synpred11_Python()) ) {
					alt138=1;
				}
				else if ( (true) ) {
					alt138=2;
				}

			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 138, 0, input);
				throw nvae;
			}

			switch (alt138) {
				case 1 :
					// Python.g:2010:7: ( test[null] COMMA )=>t+= test[ctype] ( options {k=2; } : COMMA t+= test[ctype] )* ( COMMA )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_testlist7355);
					t=test(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					// Python.g:2011:22: ( options {k=2; } : COMMA t+= test[ctype] )*
					loop136:
					while (true) {
						int alt136=2;
						alt136 = dfa136.predict(input);
						switch (alt136) {
						case 1 :
							// Python.g:2011:39: COMMA t+= test[ctype]
							{
							COMMA264=(Token)match(input,COMMA,FOLLOW_COMMA_in_testlist7367); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA264_tree = (PythonTree)adaptor.create(COMMA264);
							adaptor.addChild(root_0, COMMA264_tree);
							}

							pushFollow(FOLLOW_test_in_testlist7371);
							t=test(ctype);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

							if (list_t==null) list_t=new ArrayList<Object>();
							list_t.add(t.getTree());
							}
							break;

						default :
							break loop136;
						}
					}

					// Python.g:2011:62: ( COMMA )?
					int alt137=2;
					int LA137_0 = input.LA(1);
					if ( (LA137_0==COMMA) ) {
						alt137=1;
					}
					switch (alt137) {
						case 1 :
							// Python.g:2011:63: COMMA
							{
							COMMA265=(Token)match(input,COMMA,FOLLOW_COMMA_in_testlist7377); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA265_tree = (PythonTree)adaptor.create(COMMA265);
							adaptor.addChild(root_0, COMMA265_tree);
							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          etype = new Tuple((retval.start), actions.castExprs(list_t), ctype);
					      }
					}
					break;
				case 2 :
					// Python.g:2015:7: test[ctype]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_test_in_testlist7395);
					test266=test(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, test266.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "testlist"


	public static class dictorsetmaker_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "dictorsetmaker"
	// Python.g:2020:1: dictorsetmaker[Token lcurly] :k+= test[expr_contextType.Load] ( ( COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* ) | ( COMMA k+= test[expr_contextType.Load] )* ) ( COMMA )? | comp_for[gens] ) ;
	public final PythonParser.dictorsetmaker_return dictorsetmaker(Token lcurly) throws RecognitionException {
		PythonParser.dictorsetmaker_return retval = new PythonParser.dictorsetmaker_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COLON267=null;
		Token COMMA269=null;
		Token COLON270=null;
		Token COMMA271=null;
		Token COMMA272=null;
		List<Object> list_k=null;
		List<Object> list_v=null;
		ParserRuleReturnScope comp_for268 =null;
		ParserRuleReturnScope comp_for273 =null;
		RuleReturnScope k = null;
		RuleReturnScope v = null;
		PythonTree COLON267_tree=null;
		PythonTree COMMA269_tree=null;
		PythonTree COLON270_tree=null;
		PythonTree COMMA271_tree=null;
		PythonTree COMMA272_tree=null;


		    List gens = new ArrayList();
		    expr etype = null;

		try {
			// Python.g:2030:5: (k+= test[expr_contextType.Load] ( ( COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* ) | ( COMMA k+= test[expr_contextType.Load] )* ) ( COMMA )? | comp_for[gens] ) )
			// Python.g:2030:7: k+= test[expr_contextType.Load] ( ( COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* ) | ( COMMA k+= test[expr_contextType.Load] )* ) ( COMMA )? | comp_for[gens] )
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_test_in_dictorsetmaker7428);
			k=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

			if (list_k==null) list_k=new ArrayList<Object>();
			list_k.add(k.getTree());
			// Python.g:2031:10: ( ( COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* ) | ( COMMA k+= test[expr_contextType.Load] )* ) ( COMMA )? | comp_for[gens] )
			int alt144=2;
			int LA144_0 = input.LA(1);
			if ( ((LA144_0 >= COLON && LA144_0 <= COMMA)||LA144_0==RCURLY) ) {
				alt144=1;
			}
			else if ( (LA144_0==FOR) ) {
				alt144=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 144, 0, input);
				throw nvae;
			}

			switch (alt144) {
				case 1 :
					// Python.g:2032:14: ( COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* ) | ( COMMA k+= test[expr_contextType.Load] )* ) ( COMMA )?
					{
					// Python.g:2032:14: ( COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* ) | ( COMMA k+= test[expr_contextType.Load] )* )
					int alt142=2;
					int LA142_0 = input.LA(1);
					if ( (LA142_0==COLON) ) {
						alt142=1;
					}
					else if ( (LA142_0==COMMA||LA142_0==RCURLY) ) {
						alt142=2;
					}

					else {
						if (state.backtracking>0) {state.failed=true; return retval;}
						NoViableAltException nvae =
							new NoViableAltException("", 142, 0, input);
						throw nvae;
					}

					switch (alt142) {
						case 1 :
							// Python.g:2032:15: COLON v+= test[expr_contextType.Load] ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* )
							{
							COLON267=(Token)match(input,COLON,FOLLOW_COLON_in_dictorsetmaker7456); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COLON267_tree = (PythonTree)adaptor.create(COLON267);
							adaptor.addChild(root_0, COLON267_tree);
							}

							pushFollow(FOLLOW_test_in_dictorsetmaker7460);
							v=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, v.getTree());

							if (list_v==null) list_v=new ArrayList<Object>();
							list_v.add(v.getTree());
							// Python.g:2033:16: ( comp_for[gens] | ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )* )
							int alt140=2;
							int LA140_0 = input.LA(1);
							if ( (LA140_0==FOR) ) {
								alt140=1;
							}
							else if ( (LA140_0==COMMA||LA140_0==RCURLY) ) {
								alt140=2;
							}

							else {
								if (state.backtracking>0) {state.failed=true; return retval;}
								NoViableAltException nvae =
									new NoViableAltException("", 140, 0, input);
								throw nvae;
							}

							switch (alt140) {
								case 1 :
									// Python.g:2033:18: comp_for[gens]
									{
									pushFollow(FOLLOW_comp_for_in_dictorsetmaker7480);
									comp_for268=comp_for(gens);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_for268.getTree());

									if ( state.backtracking==0 ) {
									                     Collections.reverse(gens);
									                     List<comprehension> c = gens;
									                     etype = new DictComp((retval.start), actions.castExpr(list_k.get(0)), actions.castExpr(list_v.get(0)), c);
									                 }
									}
									break;
								case 2 :
									// Python.g:2039:18: ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )*
									{
									// Python.g:2039:18: ( options {k=2; } : COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load] )*
									loop139:
									while (true) {
										int alt139=2;
										int LA139_0 = input.LA(1);
										if ( (LA139_0==COMMA) ) {
											int LA139_1 = input.LA(2);
											if ( (LA139_1==BACKQUOTE||LA139_1==COMPLEX||LA139_1==FLOAT||LA139_1==INT||(LA139_1 >= LAMBDA && LA139_1 <= LCURLY)||(LA139_1 >= LONGINT && LA139_1 <= MINUS)||LA139_1==NAME||LA139_1==NOT||LA139_1==PLUS||LA139_1==PRINT||(LA139_1 >= STRING && LA139_1 <= TILDE)) ) {
												alt139=1;
											}

										}

										switch (alt139) {
										case 1 :
											// Python.g:2039:34: COMMA k+= test[expr_contextType.Load] COLON v+= test[expr_contextType.Load]
											{
											COMMA269=(Token)match(input,COMMA,FOLLOW_COMMA_in_dictorsetmaker7527); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											COMMA269_tree = (PythonTree)adaptor.create(COMMA269);
											adaptor.addChild(root_0, COMMA269_tree);
											}

											pushFollow(FOLLOW_test_in_dictorsetmaker7531);
											k=test(expr_contextType.Load);
											state._fsp--;
											if (state.failed) return retval;
											if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

											if (list_k==null) list_k=new ArrayList<Object>();
											list_k.add(k.getTree());
											COLON270=(Token)match(input,COLON,FOLLOW_COLON_in_dictorsetmaker7534); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											COLON270_tree = (PythonTree)adaptor.create(COLON270);
											adaptor.addChild(root_0, COLON270_tree);
											}

											pushFollow(FOLLOW_test_in_dictorsetmaker7538);
											v=test(expr_contextType.Load);
											state._fsp--;
											if (state.failed) return retval;
											if ( state.backtracking==0 ) adaptor.addChild(root_0, v.getTree());

											if (list_v==null) list_v=new ArrayList<Object>();
											list_v.add(v.getTree());
											}
											break;

										default :
											break loop139;
										}
									}

									if ( state.backtracking==0 ) {
									                     etype = new Dict(lcurly, actions.castExprs(list_k), actions.castExprs(list_v));
									                 }
									}
									break;

							}

							}
							break;
						case 2 :
							// Python.g:2044:15: ( COMMA k+= test[expr_contextType.Load] )*
							{
							// Python.g:2044:15: ( COMMA k+= test[expr_contextType.Load] )*
							loop141:
							while (true) {
								int alt141=2;
								int LA141_0 = input.LA(1);
								if ( (LA141_0==COMMA) ) {
									int LA141_1 = input.LA(2);
									if ( (LA141_1==BACKQUOTE||LA141_1==COMPLEX||LA141_1==FLOAT||LA141_1==INT||(LA141_1 >= LAMBDA && LA141_1 <= LCURLY)||(LA141_1 >= LONGINT && LA141_1 <= MINUS)||LA141_1==NAME||LA141_1==NOT||LA141_1==PLUS||LA141_1==PRINT||(LA141_1 >= STRING && LA141_1 <= TILDE)) ) {
										alt141=1;
									}

								}

								switch (alt141) {
								case 1 :
									// Python.g:2044:16: COMMA k+= test[expr_contextType.Load]
									{
									COMMA271=(Token)match(input,COMMA,FOLLOW_COMMA_in_dictorsetmaker7594); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									COMMA271_tree = (PythonTree)adaptor.create(COMMA271);
									adaptor.addChild(root_0, COMMA271_tree);
									}

									pushFollow(FOLLOW_test_in_dictorsetmaker7598);
									k=test(expr_contextType.Load);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

									if (list_k==null) list_k=new ArrayList<Object>();
									list_k.add(k.getTree());
									}
									break;

								default :
									break loop141;
								}
							}

							if ( state.backtracking==0 ) {
							                  etype = new Set(lcurly, actions.castExprs(list_k));
							              }
							}
							break;

					}

					// Python.g:2049:14: ( COMMA )?
					int alt143=2;
					int LA143_0 = input.LA(1);
					if ( (LA143_0==COMMA) ) {
						alt143=1;
					}
					switch (alt143) {
						case 1 :
							// Python.g:2049:15: COMMA
							{
							COMMA272=(Token)match(input,COMMA,FOLLOW_COMMA_in_dictorsetmaker7648); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA272_tree = (PythonTree)adaptor.create(COMMA272);
							adaptor.addChild(root_0, COMMA272_tree);
							}

							}
							break;

					}

					}
					break;
				case 2 :
					// Python.g:2050:12: comp_for[gens]
					{
					pushFollow(FOLLOW_comp_for_in_dictorsetmaker7663);
					comp_for273=comp_for(gens);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_for273.getTree());

					if ( state.backtracking==0 ) {
					               Collections.reverse(gens);
					               List<comprehension> c = gens;
					               expr e = actions.castExpr(list_k.get(0));
					               if (e instanceof Context) {
					                   ((Context)e).setContext(expr_contextType.Load);
					               }
					               etype = new SetComp(lcurly, actions.castExpr(list_k.get(0)), c);
					           }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "dictorsetmaker"


	public static class classdef_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "classdef"
	// Python.g:2064:1: classdef : ( decorators )? CLASS NAME ( LPAREN ( testlist[expr_contextType.Load] )? RPAREN )? COLON suite[false] ;
	public final PythonParser.classdef_return classdef() throws RecognitionException {
		PythonParser.classdef_return retval = new PythonParser.classdef_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token CLASS275=null;
		Token NAME276=null;
		Token LPAREN277=null;
		Token RPAREN279=null;
		Token COLON280=null;
		ParserRuleReturnScope decorators274 =null;
		ParserRuleReturnScope testlist278 =null;
		ParserRuleReturnScope suite281 =null;

		PythonTree CLASS275_tree=null;
		PythonTree NAME276_tree=null;
		PythonTree LPAREN277_tree=null;
		PythonTree RPAREN279_tree=null;
		PythonTree COLON280_tree=null;


		    stmt stype = null;

		try {
			// Python.g:2071:5: ( ( decorators )? CLASS NAME ( LPAREN ( testlist[expr_contextType.Load] )? RPAREN )? COLON suite[false] )
			// Python.g:2071:7: ( decorators )? CLASS NAME ( LPAREN ( testlist[expr_contextType.Load] )? RPAREN )? COLON suite[false]
			{
			root_0 = (PythonTree)adaptor.nil();


			// Python.g:2071:7: ( decorators )?
			int alt145=2;
			int LA145_0 = input.LA(1);
			if ( (LA145_0==AT) ) {
				alt145=1;
			}
			switch (alt145) {
				case 1 :
					// Python.g:2071:7: decorators
					{
					pushFollow(FOLLOW_decorators_in_classdef7716);
					decorators274=decorators();
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, decorators274.getTree());

					}
					break;

			}

			CLASS275=(Token)match(input,CLASS,FOLLOW_CLASS_in_classdef7719); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			CLASS275_tree = (PythonTree)adaptor.create(CLASS275);
			adaptor.addChild(root_0, CLASS275_tree);
			}

			NAME276=(Token)match(input,NAME,FOLLOW_NAME_in_classdef7721); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			NAME276_tree = (PythonTree)adaptor.create(NAME276);
			adaptor.addChild(root_0, NAME276_tree);
			}

			// Python.g:2071:30: ( LPAREN ( testlist[expr_contextType.Load] )? RPAREN )?
			int alt147=2;
			int LA147_0 = input.LA(1);
			if ( (LA147_0==LPAREN) ) {
				alt147=1;
			}
			switch (alt147) {
				case 1 :
					// Python.g:2071:31: LPAREN ( testlist[expr_contextType.Load] )? RPAREN
					{
					LPAREN277=(Token)match(input,LPAREN,FOLLOW_LPAREN_in_classdef7724); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					LPAREN277_tree = (PythonTree)adaptor.create(LPAREN277);
					adaptor.addChild(root_0, LPAREN277_tree);
					}

					// Python.g:2071:38: ( testlist[expr_contextType.Load] )?
					int alt146=2;
					int LA146_0 = input.LA(1);
					if ( (LA146_0==BACKQUOTE||(LA146_0 >= LBRACK && LA146_0 <= LCURLY)||(LA146_0 >= LPAREN && LA146_0 <= MINUS)||LA146_0==NAME||LA146_0==NOT||LA146_0==PLUS||LA146_0==TILDE) ) {
						alt146=1;
					}
					else if ( (LA146_0==PRINT) && ((printFunction))) {
						alt146=1;
					}
					else if ( (LA146_0==COMPLEX||LA146_0==FLOAT||LA146_0==INT||LA146_0==LAMBDA||LA146_0==LONGINT||LA146_0==STRING) ) {
						alt146=1;
					}
					switch (alt146) {
						case 1 :
							// Python.g:2071:38: testlist[expr_contextType.Load]
							{
							pushFollow(FOLLOW_testlist_in_classdef7726);
							testlist278=testlist(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist278.getTree());

							}
							break;

					}

					RPAREN279=(Token)match(input,RPAREN,FOLLOW_RPAREN_in_classdef7730); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					RPAREN279_tree = (PythonTree)adaptor.create(RPAREN279);
					adaptor.addChild(root_0, RPAREN279_tree);
					}

					}
					break;

			}

			COLON280=(Token)match(input,COLON,FOLLOW_COLON_in_classdef7734); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			COLON280_tree = (PythonTree)adaptor.create(COLON280);
			adaptor.addChild(root_0, COLON280_tree);
			}

			pushFollow(FOLLOW_suite_in_classdef7736);
			suite281=suite(false);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, suite281.getTree());

			if ( state.backtracking==0 ) {
			          Token t = CLASS275;
			          if ((decorators274!=null?(decorators274.start):null) != null) {
			              t = (decorators274!=null?(decorators274.start):null);
			          }
			          stype = new ClassDef(t, actions.cantBeNoneName(NAME276),
			              actions.makeBases(actions.castExpr((testlist278!=null?((PythonTree)testlist278.getTree()):null))),
			              actions.castStmts((suite281!=null?((PythonParser.suite_return)suite281).stypes:null)),
			              actions.castExprs((decorators274!=null?((PythonParser.decorators_return)decorators274).etypes:null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			   retval.tree = stype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "classdef"


	public static class arglist_return extends ParserRuleReturnScope {
		public List args;
		public List keywords;
		public expr starargs;
		public expr kwargs;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "arglist"
	// Python.g:2087:1: arglist returns [List args, List keywords, expr starargs, expr kwargs] : ( argument[arguments, kws, gens, true, false] ( COMMA argument[arguments, kws, gens, false, false] )* ( COMMA ( STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )? )? | STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] );
	public final PythonParser.arglist_return arglist() throws RecognitionException {
		PythonParser.arglist_return retval = new PythonParser.arglist_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA283=null;
		Token COMMA285=null;
		Token STAR286=null;
		Token COMMA287=null;
		Token COMMA289=null;
		Token DOUBLESTAR290=null;
		Token DOUBLESTAR291=null;
		Token STAR292=null;
		Token COMMA293=null;
		Token COMMA295=null;
		Token DOUBLESTAR296=null;
		Token DOUBLESTAR297=null;
		ParserRuleReturnScope s =null;
		ParserRuleReturnScope k =null;
		ParserRuleReturnScope argument282 =null;
		ParserRuleReturnScope argument284 =null;
		ParserRuleReturnScope argument288 =null;
		ParserRuleReturnScope argument294 =null;

		PythonTree COMMA283_tree=null;
		PythonTree COMMA285_tree=null;
		PythonTree STAR286_tree=null;
		PythonTree COMMA287_tree=null;
		PythonTree COMMA289_tree=null;
		PythonTree DOUBLESTAR290_tree=null;
		PythonTree DOUBLESTAR291_tree=null;
		PythonTree STAR292_tree=null;
		PythonTree COMMA293_tree=null;
		PythonTree COMMA295_tree=null;
		PythonTree DOUBLESTAR296_tree=null;
		PythonTree DOUBLESTAR297_tree=null;


		    List arguments = new ArrayList();
		    List kws = new ArrayList();
		    List gens = new ArrayList();

		try {
			// Python.g:2094:5: ( argument[arguments, kws, gens, true, false] ( COMMA argument[arguments, kws, gens, false, false] )* ( COMMA ( STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )? )? | STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )
			int alt155=3;
			int LA155_0 = input.LA(1);
			if ( (LA155_0==BACKQUOTE||(LA155_0 >= LBRACK && LA155_0 <= LCURLY)||(LA155_0 >= LPAREN && LA155_0 <= MINUS)||LA155_0==NAME||LA155_0==NOT||LA155_0==PLUS||LA155_0==TILDE) ) {
				alt155=1;
			}
			else if ( (LA155_0==PRINT) && ((printFunction))) {
				alt155=1;
			}
			else if ( (LA155_0==COMPLEX||LA155_0==FLOAT||LA155_0==INT||LA155_0==LAMBDA||LA155_0==LONGINT||LA155_0==STRING) ) {
				alt155=1;
			}
			else if ( (LA155_0==STAR) ) {
				alt155=2;
			}
			else if ( (LA155_0==DOUBLESTAR) ) {
				alt155=3;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 155, 0, input);
				throw nvae;
			}

			switch (alt155) {
				case 1 :
					// Python.g:2094:7: argument[arguments, kws, gens, true, false] ( COMMA argument[arguments, kws, gens, false, false] )* ( COMMA ( STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )? )?
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_argument_in_arglist7778);
					argument282=argument(arguments, kws, gens, true, false);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, argument282.getTree());

					// Python.g:2094:51: ( COMMA argument[arguments, kws, gens, false, false] )*
					loop148:
					while (true) {
						int alt148=2;
						int LA148_0 = input.LA(1);
						if ( (LA148_0==COMMA) ) {
							int LA148_1 = input.LA(2);
							if ( (LA148_1==BACKQUOTE||LA148_1==COMPLEX||LA148_1==FLOAT||LA148_1==INT||(LA148_1 >= LAMBDA && LA148_1 <= LCURLY)||(LA148_1 >= LONGINT && LA148_1 <= MINUS)||LA148_1==NAME||LA148_1==NOT||LA148_1==PLUS||LA148_1==PRINT||(LA148_1 >= STRING && LA148_1 <= TILDE)) ) {
								alt148=1;
							}

						}

						switch (alt148) {
						case 1 :
							// Python.g:2094:52: COMMA argument[arguments, kws, gens, false, false]
							{
							COMMA283=(Token)match(input,COMMA,FOLLOW_COMMA_in_arglist7782); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA283_tree = (PythonTree)adaptor.create(COMMA283);
							adaptor.addChild(root_0, COMMA283_tree);
							}

							pushFollow(FOLLOW_argument_in_arglist7784);
							argument284=argument(arguments, kws, gens, false, false);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, argument284.getTree());

							}
							break;

						default :
							break loop148;
						}
					}

					// Python.g:2095:11: ( COMMA ( STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )? )?
					int alt152=2;
					int LA152_0 = input.LA(1);
					if ( (LA152_0==COMMA) ) {
						alt152=1;
					}
					switch (alt152) {
						case 1 :
							// Python.g:2095:12: COMMA ( STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )?
							{
							COMMA285=(Token)match(input,COMMA,FOLLOW_COMMA_in_arglist7800); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA285_tree = (PythonTree)adaptor.create(COMMA285);
							adaptor.addChild(root_0, COMMA285_tree);
							}

							// Python.g:2096:15: ( STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )? | DOUBLESTAR k= test[expr_contextType.Load] )?
							int alt151=3;
							int LA151_0 = input.LA(1);
							if ( (LA151_0==STAR) ) {
								alt151=1;
							}
							else if ( (LA151_0==DOUBLESTAR) ) {
								alt151=2;
							}
							switch (alt151) {
								case 1 :
									// Python.g:2096:17: STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )?
									{
									STAR286=(Token)match(input,STAR,FOLLOW_STAR_in_arglist7818); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									STAR286_tree = (PythonTree)adaptor.create(STAR286);
									adaptor.addChild(root_0, STAR286_tree);
									}

									pushFollow(FOLLOW_test_in_arglist7822);
									s=test(expr_contextType.Load);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, s.getTree());

									// Python.g:2096:52: ( COMMA argument[arguments, kws, gens, false, true] )*
									loop149:
									while (true) {
										int alt149=2;
										int LA149_0 = input.LA(1);
										if ( (LA149_0==COMMA) ) {
											int LA149_1 = input.LA(2);
											if ( (LA149_1==BACKQUOTE||LA149_1==COMPLEX||LA149_1==FLOAT||LA149_1==INT||(LA149_1 >= LAMBDA && LA149_1 <= LCURLY)||(LA149_1 >= LONGINT && LA149_1 <= MINUS)||LA149_1==NAME||LA149_1==NOT||LA149_1==PLUS||LA149_1==PRINT||(LA149_1 >= STRING && LA149_1 <= TILDE)) ) {
												alt149=1;
											}

										}

										switch (alt149) {
										case 1 :
											// Python.g:2096:53: COMMA argument[arguments, kws, gens, false, true]
											{
											COMMA287=(Token)match(input,COMMA,FOLLOW_COMMA_in_arglist7826); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											COMMA287_tree = (PythonTree)adaptor.create(COMMA287);
											adaptor.addChild(root_0, COMMA287_tree);
											}

											pushFollow(FOLLOW_argument_in_arglist7828);
											argument288=argument(arguments, kws, gens, false, true);
											state._fsp--;
											if (state.failed) return retval;
											if ( state.backtracking==0 ) adaptor.addChild(root_0, argument288.getTree());

											}
											break;

										default :
											break loop149;
										}
									}

									// Python.g:2096:105: ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )?
									int alt150=2;
									int LA150_0 = input.LA(1);
									if ( (LA150_0==COMMA) ) {
										alt150=1;
									}
									switch (alt150) {
										case 1 :
											// Python.g:2096:106: COMMA DOUBLESTAR k= test[expr_contextType.Load]
											{
											COMMA289=(Token)match(input,COMMA,FOLLOW_COMMA_in_arglist7834); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											COMMA289_tree = (PythonTree)adaptor.create(COMMA289);
											adaptor.addChild(root_0, COMMA289_tree);
											}

											DOUBLESTAR290=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist7836); if (state.failed) return retval;
											if ( state.backtracking==0 ) {
											DOUBLESTAR290_tree = (PythonTree)adaptor.create(DOUBLESTAR290);
											adaptor.addChild(root_0, DOUBLESTAR290_tree);
											}

											pushFollow(FOLLOW_test_in_arglist7840);
											k=test(expr_contextType.Load);
											state._fsp--;
											if (state.failed) return retval;
											if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

											}
											break;

									}

									}
									break;
								case 2 :
									// Python.g:2097:17: DOUBLESTAR k= test[expr_contextType.Load]
									{
									DOUBLESTAR291=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist7861); if (state.failed) return retval;
									if ( state.backtracking==0 ) {
									DOUBLESTAR291_tree = (PythonTree)adaptor.create(DOUBLESTAR291);
									adaptor.addChild(root_0, DOUBLESTAR291_tree);
									}

									pushFollow(FOLLOW_test_in_arglist7865);
									k=test(expr_contextType.Load);
									state._fsp--;
									if (state.failed) return retval;
									if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

									}
									break;

							}

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          if (arguments.size() > 1 && gens.size() > 0) {
					              actions.errorGenExpNotSoleArg(new PythonTree((retval.start)));
					          }
					          retval.args =arguments;
					          retval.keywords =kws;
					          retval.starargs =actions.castExpr((s!=null?((PythonTree)s.getTree()):null));
					          retval.kwargs =actions.castExpr((k!=null?((PythonTree)k.getTree()):null));
					      }
					}
					break;
				case 2 :
					// Python.g:2109:7: STAR s= test[expr_contextType.Load] ( COMMA argument[arguments, kws, gens, false, true] )* ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )?
					{
					root_0 = (PythonTree)adaptor.nil();


					STAR292=(Token)match(input,STAR,FOLLOW_STAR_in_arglist7912); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					STAR292_tree = (PythonTree)adaptor.create(STAR292);
					adaptor.addChild(root_0, STAR292_tree);
					}

					pushFollow(FOLLOW_test_in_arglist7916);
					s=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, s.getTree());

					// Python.g:2109:42: ( COMMA argument[arguments, kws, gens, false, true] )*
					loop153:
					while (true) {
						int alt153=2;
						int LA153_0 = input.LA(1);
						if ( (LA153_0==COMMA) ) {
							int LA153_1 = input.LA(2);
							if ( (LA153_1==BACKQUOTE||LA153_1==COMPLEX||LA153_1==FLOAT||LA153_1==INT||(LA153_1 >= LAMBDA && LA153_1 <= LCURLY)||(LA153_1 >= LONGINT && LA153_1 <= MINUS)||LA153_1==NAME||LA153_1==NOT||LA153_1==PLUS||LA153_1==PRINT||(LA153_1 >= STRING && LA153_1 <= TILDE)) ) {
								alt153=1;
							}

						}

						switch (alt153) {
						case 1 :
							// Python.g:2109:43: COMMA argument[arguments, kws, gens, false, true]
							{
							COMMA293=(Token)match(input,COMMA,FOLLOW_COMMA_in_arglist7920); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA293_tree = (PythonTree)adaptor.create(COMMA293);
							adaptor.addChild(root_0, COMMA293_tree);
							}

							pushFollow(FOLLOW_argument_in_arglist7922);
							argument294=argument(arguments, kws, gens, false, true);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, argument294.getTree());

							}
							break;

						default :
							break loop153;
						}
					}

					// Python.g:2109:95: ( COMMA DOUBLESTAR k= test[expr_contextType.Load] )?
					int alt154=2;
					int LA154_0 = input.LA(1);
					if ( (LA154_0==COMMA) ) {
						alt154=1;
					}
					switch (alt154) {
						case 1 :
							// Python.g:2109:96: COMMA DOUBLESTAR k= test[expr_contextType.Load]
							{
							COMMA295=(Token)match(input,COMMA,FOLLOW_COMMA_in_arglist7928); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							COMMA295_tree = (PythonTree)adaptor.create(COMMA295);
							adaptor.addChild(root_0, COMMA295_tree);
							}

							DOUBLESTAR296=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist7930); if (state.failed) return retval;
							if ( state.backtracking==0 ) {
							DOUBLESTAR296_tree = (PythonTree)adaptor.create(DOUBLESTAR296);
							adaptor.addChild(root_0, DOUBLESTAR296_tree);
							}

							pushFollow(FOLLOW_test_in_arglist7934);
							k=test(expr_contextType.Load);
							state._fsp--;
							if (state.failed) return retval;
							if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

							}
							break;

					}

					if ( state.backtracking==0 ) {
					          retval.starargs =actions.castExpr((s!=null?((PythonTree)s.getTree()):null));
					          retval.keywords =kws;
					          retval.kwargs =actions.castExpr((k!=null?((PythonTree)k.getTree()):null));
					      }
					}
					break;
				case 3 :
					// Python.g:2115:7: DOUBLESTAR k= test[expr_contextType.Load]
					{
					root_0 = (PythonTree)adaptor.nil();


					DOUBLESTAR297=(Token)match(input,DOUBLESTAR,FOLLOW_DOUBLESTAR_in_arglist7953); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					DOUBLESTAR297_tree = (PythonTree)adaptor.create(DOUBLESTAR297);
					adaptor.addChild(root_0, DOUBLESTAR297_tree);
					}

					pushFollow(FOLLOW_test_in_arglist7957);
					k=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, k.getTree());

					if ( state.backtracking==0 ) {
					          retval.kwargs =actions.castExpr((k!=null?((PythonTree)k.getTree()):null));
					      }
					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "arglist"


	public static class argument_return extends ParserRuleReturnScope {
		public boolean genarg;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "argument"
	// Python.g:2122:1: argument[List arguments, List kws, List gens, boolean first, boolean afterStar] returns [boolean genarg] : t1= test[expr_contextType.Load] ( ( ASSIGN t2= test[expr_contextType.Load] ) | comp_for[$gens] |) ;
	public final PythonParser.argument_return argument(List arguments, List kws, List gens, boolean first, boolean afterStar) throws RecognitionException {
		PythonParser.argument_return retval = new PythonParser.argument_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token ASSIGN298=null;
		ParserRuleReturnScope t1 =null;
		ParserRuleReturnScope t2 =null;
		ParserRuleReturnScope comp_for299 =null;

		PythonTree ASSIGN298_tree=null;

		try {
			// Python.g:2124:5: (t1= test[expr_contextType.Load] ( ( ASSIGN t2= test[expr_contextType.Load] ) | comp_for[$gens] |) )
			// Python.g:2124:7: t1= test[expr_contextType.Load] ( ( ASSIGN t2= test[expr_contextType.Load] ) | comp_for[$gens] |)
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_test_in_argument7996);
			t1=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, t1.getTree());

			// Python.g:2125:9: ( ( ASSIGN t2= test[expr_contextType.Load] ) | comp_for[$gens] |)
			int alt156=3;
			switch ( input.LA(1) ) {
			case ASSIGN:
				{
				alt156=1;
				}
				break;
			case FOR:
				{
				alt156=2;
				}
				break;
			case COMMA:
			case RPAREN:
				{
				alt156=3;
				}
				break;
			default:
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 156, 0, input);
				throw nvae;
			}
			switch (alt156) {
				case 1 :
					// Python.g:2125:10: ( ASSIGN t2= test[expr_contextType.Load] )
					{
					// Python.g:2125:10: ( ASSIGN t2= test[expr_contextType.Load] )
					// Python.g:2125:11: ASSIGN t2= test[expr_contextType.Load]
					{
					ASSIGN298=(Token)match(input,ASSIGN,FOLLOW_ASSIGN_in_argument8009); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					ASSIGN298_tree = (PythonTree)adaptor.create(ASSIGN298);
					adaptor.addChild(root_0, ASSIGN298_tree);
					}

					pushFollow(FOLLOW_test_in_argument8013);
					t2=test(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t2.getTree());

					}

					if ( state.backtracking==0 ) {
					              expr newkey = actions.castExpr((t1!=null?((PythonTree)t1.getTree()):null));
					              //Loop through all current keys and fail on duplicate.
					              for(Object o: kws) {
					                  List list = (List)o;
					                  Object oldkey = list.get(0);
					                  if (oldkey instanceof Name && newkey instanceof Name) {
					                      if (((Name)oldkey).getId().equals(((Name)newkey).getId())) {
					                          errorHandler.error("keyword arguments repeated", (t1!=null?((PythonTree)t1.getTree()):null), true);
					                      }
					                  }
					              }
					              List<expr> exprs = new ArrayList<expr>();
					              exprs.add(newkey);
					              exprs.add(actions.castExpr((t2!=null?((PythonTree)t2.getTree()):null)));
					              kws.add(exprs);
					          }
					}
					break;
				case 2 :
					// Python.g:2143:11: comp_for[$gens]
					{
					pushFollow(FOLLOW_comp_for_in_argument8039);
					comp_for299=comp_for(gens);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_for299.getTree());

					if ( state.backtracking==0 ) {
					              if (!first) {
					                  actions.errorGenExpNotSoleArg((comp_for299!=null?((PythonTree)comp_for299.getTree()):null));
					              }
					              retval.genarg = true;
					              Collections.reverse(gens);
					              List<comprehension> c = gens;
					              arguments.add(new GeneratorExp((t1!=null?(t1.start):null), actions.castExpr((t1!=null?((PythonTree)t1.getTree()):null)), c));
					          }
					}
					break;
				case 3 :
					// Python.g:2154:11: 
					{
					if ( state.backtracking==0 ) {
					              if (kws.size() > 0) {
					                  errorHandler.error("non-keyword arg after keyword arg", (t1!=null?((PythonTree)t1.getTree()):null), true);
					              } else if (afterStar) {
					                  errorHandler.error("only named arguments may follow *expression", (t1!=null?((PythonTree)t1.getTree()):null), true);
					              }
					              arguments.add((t1!=null?((PythonTree)t1.getTree()):null));
					          }
					}
					break;

			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "argument"


	public static class list_iter_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "list_iter"
	// Python.g:2166:1: list_iter[List gens, List ifs] : ( list_for[gens] | list_if[gens, ifs] );
	public final PythonParser.list_iter_return list_iter(List gens, List ifs) throws RecognitionException {
		PythonParser.list_iter_return retval = new PythonParser.list_iter_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope list_for300 =null;
		ParserRuleReturnScope list_if301 =null;


		try {
			// Python.g:2167:5: ( list_for[gens] | list_if[gens, ifs] )
			int alt157=2;
			int LA157_0 = input.LA(1);
			if ( (LA157_0==FOR) ) {
				alt157=1;
			}
			else if ( (LA157_0==IF) ) {
				alt157=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 157, 0, input);
				throw nvae;
			}

			switch (alt157) {
				case 1 :
					// Python.g:2167:7: list_for[gens]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_list_for_in_list_iter8104);
					list_for300=list_for(gens);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, list_for300.getTree());

					}
					break;
				case 2 :
					// Python.g:2168:7: list_if[gens, ifs]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_list_if_in_list_iter8113);
					list_if301=list_if(gens, ifs);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, list_if301.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "list_iter"


	public static class list_for_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "list_for"
	// Python.g:2172:1: list_for[List gens] : FOR exprlist[expr_contextType.Store] IN testlist[expr_contextType.Load] ( list_iter[gens, ifs] )? ;
	public final PythonParser.list_for_return list_for(List gens) throws RecognitionException {
		PythonParser.list_for_return retval = new PythonParser.list_for_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token FOR302=null;
		Token IN304=null;
		ParserRuleReturnScope exprlist303 =null;
		ParserRuleReturnScope testlist305 =null;
		ParserRuleReturnScope list_iter306 =null;

		PythonTree FOR302_tree=null;
		PythonTree IN304_tree=null;


		    List ifs = new ArrayList();

		try {
			// Python.g:2176:5: ( FOR exprlist[expr_contextType.Store] IN testlist[expr_contextType.Load] ( list_iter[gens, ifs] )? )
			// Python.g:2176:7: FOR exprlist[expr_contextType.Store] IN testlist[expr_contextType.Load] ( list_iter[gens, ifs] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			FOR302=(Token)match(input,FOR,FOLLOW_FOR_in_list_for8139); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			FOR302_tree = (PythonTree)adaptor.create(FOR302);
			adaptor.addChild(root_0, FOR302_tree);
			}

			pushFollow(FOLLOW_exprlist_in_list_for8141);
			exprlist303=exprlist(expr_contextType.Store);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, exprlist303.getTree());

			IN304=(Token)match(input,IN,FOLLOW_IN_in_list_for8144); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IN304_tree = (PythonTree)adaptor.create(IN304);
			adaptor.addChild(root_0, IN304_tree);
			}

			pushFollow(FOLLOW_testlist_in_list_for8146);
			testlist305=testlist(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist305.getTree());

			// Python.g:2176:79: ( list_iter[gens, ifs] )?
			int alt158=2;
			int LA158_0 = input.LA(1);
			if ( (LA158_0==FOR||LA158_0==IF) ) {
				alt158=1;
			}
			switch (alt158) {
				case 1 :
					// Python.g:2176:80: list_iter[gens, ifs]
					{
					pushFollow(FOLLOW_list_iter_in_list_for8150);
					list_iter306=list_iter(gens, ifs);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, list_iter306.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          Collections.reverse(ifs);
			          gens.add(new comprehension(FOR302, (exprlist303!=null?((PythonParser.exprlist_return)exprlist303).etype:null), actions.castExpr((testlist305!=null?((PythonTree)testlist305.getTree()):null)), ifs));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "list_for"


	public static class list_if_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "list_if"
	// Python.g:2184:1: list_if[List gens, List ifs] : IF test[expr_contextType.Load] ( list_iter[gens, ifs] )? ;
	public final PythonParser.list_if_return list_if(List gens, List ifs) throws RecognitionException {
		PythonParser.list_if_return retval = new PythonParser.list_if_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token IF307=null;
		ParserRuleReturnScope test308 =null;
		ParserRuleReturnScope list_iter309 =null;

		PythonTree IF307_tree=null;

		try {
			// Python.g:2185:5: ( IF test[expr_contextType.Load] ( list_iter[gens, ifs] )? )
			// Python.g:2185:7: IF test[expr_contextType.Load] ( list_iter[gens, ifs] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			IF307=(Token)match(input,IF,FOLLOW_IF_in_list_if8180); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IF307_tree = (PythonTree)adaptor.create(IF307);
			adaptor.addChild(root_0, IF307_tree);
			}

			pushFollow(FOLLOW_test_in_list_if8182);
			test308=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, test308.getTree());

			// Python.g:2185:38: ( list_iter[gens, ifs] )?
			int alt159=2;
			int LA159_0 = input.LA(1);
			if ( (LA159_0==FOR||LA159_0==IF) ) {
				alt159=1;
			}
			switch (alt159) {
				case 1 :
					// Python.g:2185:39: list_iter[gens, ifs]
					{
					pushFollow(FOLLOW_list_iter_in_list_if8186);
					list_iter309=list_iter(gens, ifs);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, list_iter309.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			        ifs.add(actions.castExpr((test308!=null?((PythonTree)test308.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "list_if"


	public static class comp_iter_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "comp_iter"
	// Python.g:2192:1: comp_iter[List gens, List ifs] : ( comp_for[gens] | comp_if[gens, ifs] );
	public final PythonParser.comp_iter_return comp_iter(List gens, List ifs) throws RecognitionException {
		PythonParser.comp_iter_return retval = new PythonParser.comp_iter_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		ParserRuleReturnScope comp_for310 =null;
		ParserRuleReturnScope comp_if311 =null;


		try {
			// Python.g:2193:5: ( comp_for[gens] | comp_if[gens, ifs] )
			int alt160=2;
			int LA160_0 = input.LA(1);
			if ( (LA160_0==FOR) ) {
				alt160=1;
			}
			else if ( (LA160_0==IF) ) {
				alt160=2;
			}

			else {
				if (state.backtracking>0) {state.failed=true; return retval;}
				NoViableAltException nvae =
					new NoViableAltException("", 160, 0, input);
				throw nvae;
			}

			switch (alt160) {
				case 1 :
					// Python.g:2193:7: comp_for[gens]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_comp_for_in_comp_iter8217);
					comp_for310=comp_for(gens);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_for310.getTree());

					}
					break;
				case 2 :
					// Python.g:2194:7: comp_if[gens, ifs]
					{
					root_0 = (PythonTree)adaptor.nil();


					pushFollow(FOLLOW_comp_if_in_comp_iter8226);
					comp_if311=comp_if(gens, ifs);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_if311.getTree());

					}
					break;

			}
			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "comp_iter"


	public static class comp_for_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "comp_for"
	// Python.g:2198:1: comp_for[List gens] : FOR exprlist[expr_contextType.Store] IN or_test[expr_contextType.Load] ( comp_iter[gens, ifs] )? ;
	public final PythonParser.comp_for_return comp_for(List gens) throws RecognitionException {
		PythonParser.comp_for_return retval = new PythonParser.comp_for_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token FOR312=null;
		Token IN314=null;
		ParserRuleReturnScope exprlist313 =null;
		ParserRuleReturnScope or_test315 =null;
		ParserRuleReturnScope comp_iter316 =null;

		PythonTree FOR312_tree=null;
		PythonTree IN314_tree=null;


		    List ifs = new ArrayList();

		try {
			// Python.g:2202:5: ( FOR exprlist[expr_contextType.Store] IN or_test[expr_contextType.Load] ( comp_iter[gens, ifs] )? )
			// Python.g:2202:7: FOR exprlist[expr_contextType.Store] IN or_test[expr_contextType.Load] ( comp_iter[gens, ifs] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			FOR312=(Token)match(input,FOR,FOLLOW_FOR_in_comp_for8252); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			FOR312_tree = (PythonTree)adaptor.create(FOR312);
			adaptor.addChild(root_0, FOR312_tree);
			}

			pushFollow(FOLLOW_exprlist_in_comp_for8254);
			exprlist313=exprlist(expr_contextType.Store);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, exprlist313.getTree());

			IN314=(Token)match(input,IN,FOLLOW_IN_in_comp_for8257); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IN314_tree = (PythonTree)adaptor.create(IN314);
			adaptor.addChild(root_0, IN314_tree);
			}

			pushFollow(FOLLOW_or_test_in_comp_for8259);
			or_test315=or_test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, or_test315.getTree());

			// Python.g:2202:78: ( comp_iter[gens, ifs] )?
			int alt161=2;
			int LA161_0 = input.LA(1);
			if ( (LA161_0==FOR||LA161_0==IF) ) {
				alt161=1;
			}
			switch (alt161) {
				case 1 :
					// Python.g:2202:78: comp_iter[gens, ifs]
					{
					pushFollow(FOLLOW_comp_iter_in_comp_for8262);
					comp_iter316=comp_iter(gens, ifs);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_iter316.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          Collections.reverse(ifs);
			          gens.add(new comprehension(FOR312, (exprlist313!=null?((PythonParser.exprlist_return)exprlist313).etype:null), actions.castExpr((or_test315!=null?((PythonTree)or_test315.getTree()):null)), ifs));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "comp_for"


	public static class comp_if_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "comp_if"
	// Python.g:2210:1: comp_if[List gens, List ifs] : IF test[expr_contextType.Load] ( comp_iter[gens, ifs] )? ;
	public final PythonParser.comp_if_return comp_if(List gens, List ifs) throws RecognitionException {
		PythonParser.comp_if_return retval = new PythonParser.comp_if_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token IF317=null;
		ParserRuleReturnScope test318 =null;
		ParserRuleReturnScope comp_iter319 =null;

		PythonTree IF317_tree=null;

		try {
			// Python.g:2211:5: ( IF test[expr_contextType.Load] ( comp_iter[gens, ifs] )? )
			// Python.g:2211:7: IF test[expr_contextType.Load] ( comp_iter[gens, ifs] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			IF317=(Token)match(input,IF,FOLLOW_IF_in_comp_if8291); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			IF317_tree = (PythonTree)adaptor.create(IF317);
			adaptor.addChild(root_0, IF317_tree);
			}

			pushFollow(FOLLOW_test_in_comp_if8293);
			test318=test(expr_contextType.Load);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, test318.getTree());

			// Python.g:2211:38: ( comp_iter[gens, ifs] )?
			int alt162=2;
			int LA162_0 = input.LA(1);
			if ( (LA162_0==FOR||LA162_0==IF) ) {
				alt162=1;
			}
			switch (alt162) {
				case 1 :
					// Python.g:2211:38: comp_iter[gens, ifs]
					{
					pushFollow(FOLLOW_comp_iter_in_comp_if8296);
					comp_iter319=comp_iter(gens, ifs);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, comp_iter319.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			        ifs.add(actions.castExpr((test318!=null?((PythonTree)test318.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "comp_if"


	public static class testlist1_return extends ParserRuleReturnScope {
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "testlist1"
	// Python.g:2219:1: testlist1[expr_contextType ctype] :t+= test[ctype] ( COMMA t+= test[ctype] )* ;
	public final PythonParser.testlist1_return testlist1(expr_contextType ctype) throws RecognitionException {
		PythonParser.testlist1_return retval = new PythonParser.testlist1_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token COMMA320=null;
		List<Object> list_t=null;
		RuleReturnScope t = null;
		PythonTree COMMA320_tree=null;


		    expr etype = null;

		try {
			// Python.g:2228:5: (t+= test[ctype] ( COMMA t+= test[ctype] )* )
			// Python.g:2228:7: t+= test[ctype] ( COMMA t+= test[ctype] )*
			{
			root_0 = (PythonTree)adaptor.nil();


			pushFollow(FOLLOW_test_in_testlist18338);
			t=test(ctype);
			state._fsp--;
			if (state.failed) return retval;
			if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

			if (list_t==null) list_t=new ArrayList<Object>();
			list_t.add(t.getTree());
			// Python.g:2229:7: ( COMMA t+= test[ctype] )*
			loop163:
			while (true) {
				int alt163=2;
				int LA163_0 = input.LA(1);
				if ( (LA163_0==COMMA) ) {
					alt163=1;
				}

				switch (alt163) {
				case 1 :
					// Python.g:2230:9: COMMA t+= test[ctype]
					{
					COMMA320=(Token)match(input,COMMA,FOLLOW_COMMA_in_testlist18357); if (state.failed) return retval;
					if ( state.backtracking==0 ) {
					COMMA320_tree = (PythonTree)adaptor.create(COMMA320);
					adaptor.addChild(root_0, COMMA320_tree);
					}

					pushFollow(FOLLOW_test_in_testlist18361);
					t=test(ctype);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, t.getTree());

					if (list_t==null) list_t=new ArrayList<Object>();
					list_t.add(t.getTree());
					if ( state.backtracking==0 ) {
					            etype = new Tuple((retval.start), actions.castExprs(list_t), ctype);
					        }
					}
					break;

				default :
					break loop163;
				}
			}

			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    if (etype != null) {
			        retval.tree = etype;
			    }
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "testlist1"


	public static class yield_expr_return extends ParserRuleReturnScope {
		public expr etype;
		PythonTree tree;
		@Override
		public PythonTree getTree() { return tree; }
	};


	// $ANTLR start "yield_expr"
	// Python.g:2238:1: yield_expr returns [expr etype] : YIELD ( testlist[expr_contextType.Load] )? ;
	public final PythonParser.yield_expr_return yield_expr() throws RecognitionException {
		PythonParser.yield_expr_return retval = new PythonParser.yield_expr_return();
		retval.start = input.LT(1);

		PythonTree root_0 = null;

		Token YIELD321=null;
		ParserRuleReturnScope testlist322 =null;

		PythonTree YIELD321_tree=null;

		try {
			// Python.g:2244:5: ( YIELD ( testlist[expr_contextType.Load] )? )
			// Python.g:2244:7: YIELD ( testlist[expr_contextType.Load] )?
			{
			root_0 = (PythonTree)adaptor.nil();


			YIELD321=(Token)match(input,YIELD,FOLLOW_YIELD_in_yield_expr8412); if (state.failed) return retval;
			if ( state.backtracking==0 ) {
			YIELD321_tree = (PythonTree)adaptor.create(YIELD321);
			adaptor.addChild(root_0, YIELD321_tree);
			}

			// Python.g:2244:13: ( testlist[expr_contextType.Load] )?
			int alt164=2;
			int LA164_0 = input.LA(1);
			if ( (LA164_0==BACKQUOTE||(LA164_0 >= LBRACK && LA164_0 <= LCURLY)||(LA164_0 >= LPAREN && LA164_0 <= MINUS)||LA164_0==NAME||LA164_0==NOT||LA164_0==PLUS||LA164_0==TILDE) ) {
				alt164=1;
			}
			else if ( (LA164_0==PRINT) && ((printFunction))) {
				alt164=1;
			}
			else if ( (LA164_0==COMPLEX||LA164_0==FLOAT||LA164_0==INT||LA164_0==LAMBDA||LA164_0==LONGINT||LA164_0==STRING) ) {
				alt164=1;
			}
			switch (alt164) {
				case 1 :
					// Python.g:2244:13: testlist[expr_contextType.Load]
					{
					pushFollow(FOLLOW_testlist_in_yield_expr8414);
					testlist322=testlist(expr_contextType.Load);
					state._fsp--;
					if (state.failed) return retval;
					if ( state.backtracking==0 ) adaptor.addChild(root_0, testlist322.getTree());

					}
					break;

			}

			if ( state.backtracking==0 ) {
			          retval.etype = new Yield(YIELD321, actions.castExpr((testlist322!=null?((PythonTree)testlist322.getTree()):null)));
			      }
			}

			retval.stop = input.LT(-1);

			if ( state.backtracking==0 ) {
			retval.tree = (PythonTree)adaptor.rulePostProcessing(root_0);
			adaptor.setTokenBoundaries(retval.tree, retval.start, retval.stop);
			}
			if ( state.backtracking==0 ) {
			    //needed for y2+=yield_expr
			    retval.tree = retval.etype;
			}
		}

		catch (RecognitionException re) {
		    reportError(re);
		    errorHandler.recover(this, input,re);
		    retval.tree = (PythonTree)adaptor.errorNode(input, retval.start, input.LT(-1), re);
		}

		finally {
			// do for sure before leaving
		}
		return retval;
	}
	// $ANTLR end "yield_expr"

	// $ANTLR start synpred1_Python
	public final void synpred1_Python_fragment() throws RecognitionException {
		// Python.g:600:7: ( LPAREN fpdef[null] COMMA )
		// Python.g:600:8: LPAREN fpdef[null] COMMA
		{
		match(input,LPAREN,FOLLOW_LPAREN_in_synpred1_Python1296); if (state.failed) return;

		pushFollow(FOLLOW_fpdef_in_synpred1_Python1298);
		fpdef(null);
		state._fsp--;
		if (state.failed) return;

		match(input,COMMA,FOLLOW_COMMA_in_synpred1_Python1301); if (state.failed) return;

		}

	}
	// $ANTLR end synpred1_Python

	// $ANTLR start synpred2_Python
	public final void synpred2_Python_fragment() throws RecognitionException {
		// Python.g:664:8: ( testlist[null] augassign )
		// Python.g:664:9: testlist[null] augassign
		{
		pushFollow(FOLLOW_testlist_in_synpred2_Python1683);
		testlist(null);
		state._fsp--;
		if (state.failed) return;

		pushFollow(FOLLOW_augassign_in_synpred2_Python1686);
		augassign();
		state._fsp--;
		if (state.failed) return;

		}

	}
	// $ANTLR end synpred2_Python

	// $ANTLR start synpred3_Python
	public final void synpred3_Python_fragment() throws RecognitionException {
		// Python.g:678:7: ( testlist[null] ASSIGN )
		// Python.g:678:8: testlist[null] ASSIGN
		{
		pushFollow(FOLLOW_testlist_in_synpred3_Python1802);
		testlist(null);
		state._fsp--;
		if (state.failed) return;

		match(input,ASSIGN,FOLLOW_ASSIGN_in_synpred3_Python1805); if (state.failed) return;

		}

	}
	// $ANTLR end synpred3_Python

	// $ANTLR start synpred4_Python
	public final void synpred4_Python_fragment() throws RecognitionException {
		// Python.g:783:7: ( test[null] COMMA )
		// Python.g:783:8: test[null] COMMA
		{
		pushFollow(FOLLOW_test_in_synpred4_Python2317);
		test(null);
		state._fsp--;
		if (state.failed) return;

		match(input,COMMA,FOLLOW_COMMA_in_synpred4_Python2320); if (state.failed) return;

		}

	}
	// $ANTLR end synpred4_Python

	// $ANTLR start synpred5_Python
	public final void synpred5_Python_fragment() throws RecognitionException {
		// Python.g:804:7: ( test[null] COMMA test[null] )
		// Python.g:804:8: test[null] COMMA test[null]
		{
		pushFollow(FOLLOW_test_in_synpred5_Python2416);
		test(null);
		state._fsp--;
		if (state.failed) return;

		match(input,COMMA,FOLLOW_COMMA_in_synpred5_Python2419); if (state.failed) return;

		pushFollow(FOLLOW_test_in_synpred5_Python2421);
		test(null);
		state._fsp--;
		if (state.failed) return;

		}

	}
	// $ANTLR end synpred5_Python

	// $ANTLR start synpred6_Python
	public final void synpred6_Python_fragment() throws RecognitionException {
		// Python.g:1116:7: ( ( decorators )? DEF )
		// Python.g:1116:8: ( decorators )? DEF
		{
		// Python.g:1116:8: ( decorators )?
		int alt165=2;
		int LA165_0 = input.LA(1);
		if ( (LA165_0==AT) ) {
			alt165=1;
		}
		switch (alt165) {
			case 1 :
				// Python.g:1116:8: decorators
				{
				pushFollow(FOLLOW_decorators_in_synpred6_Python3556);
				decorators();
				state._fsp--;
				if (state.failed) return;

				}
				break;

		}

		match(input,DEF,FOLLOW_DEF_in_synpred6_Python3559); if (state.failed) return;

		}

	}
	// $ANTLR end synpred6_Python

	// $ANTLR start synpred7_Python
	public final void synpred7_Python_fragment() throws RecognitionException {
		// Python.g:1316:9: ( IF or_test[null] ORELSE )
		// Python.g:1316:10: IF or_test[null] ORELSE
		{
		match(input,IF,FOLLOW_IF_in_synpred7_Python4367); if (state.failed) return;

		pushFollow(FOLLOW_or_test_in_synpred7_Python4369);
		or_test(null);
		state._fsp--;
		if (state.failed) return;

		match(input,ORELSE,FOLLOW_ORELSE_in_synpred7_Python4372); if (state.failed) return;

		}

	}
	// $ANTLR end synpred7_Python

	// $ANTLR start synpred8_Python
	public final void synpred8_Python_fragment() throws RecognitionException {
		// Python.g:1940:7: ( test[null] COLON )
		// Python.g:1940:8: test[null] COLON
		{
		pushFollow(FOLLOW_test_in_synpred8_Python6961);
		test(null);
		state._fsp--;
		if (state.failed) return;

		match(input,COLON,FOLLOW_COLON_in_synpred8_Python6964); if (state.failed) return;

		}

	}
	// $ANTLR end synpred8_Python

	// $ANTLR start synpred9_Python
	public final void synpred9_Python_fragment() throws RecognitionException {
		// Python.g:1945:7: ( COLON )
		// Python.g:1945:8: COLON
		{
		match(input,COLON,FOLLOW_COLON_in_synpred9_Python7012); if (state.failed) return;

		}

	}
	// $ANTLR end synpred9_Python

	// $ANTLR start synpred10_Python
	public final void synpred10_Python_fragment() throws RecognitionException {
		// Python.g:1979:7: ( expr[null] COMMA )
		// Python.g:1979:8: expr[null] COMMA
		{
		pushFollow(FOLLOW_expr_in_synpred10_Python7157);
		expr(null);
		state._fsp--;
		if (state.failed) return;

		match(input,COMMA,FOLLOW_COMMA_in_synpred10_Python7160); if (state.failed) return;

		}

	}
	// $ANTLR end synpred10_Python

	// $ANTLR start synpred11_Python
	public final void synpred11_Python_fragment() throws RecognitionException {
		// Python.g:2010:7: ( test[null] COMMA )
		// Python.g:2010:8: test[null] COMMA
		{
		pushFollow(FOLLOW_test_in_synpred11_Python7342);
		test(null);
		state._fsp--;
		if (state.failed) return;

		match(input,COMMA,FOLLOW_COMMA_in_synpred11_Python7345); if (state.failed) return;

		}

	}
	// $ANTLR end synpred11_Python

	// Delegated rules

	public final boolean synpred1_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred1_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred3_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred3_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred10_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred10_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred11_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred11_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred2_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred2_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred4_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred4_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred5_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred5_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred6_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred6_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred7_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred7_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred8_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred8_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}
	public final boolean synpred9_Python() {
		state.backtracking++;
		int start = input.mark();
		try {
			synpred9_Python_fragment(); // can never throw exception
		} catch (RecognitionException re) {
			System.err.println("impossible: "+re);
		}
		boolean success = !state.failed;
		input.rewind(start);
		state.backtracking--;
		state.failed=false;
		return success;
	}


	protected DFA52 dfa52 = new DFA52(this);
	protected DFA136 dfa136 = new DFA136(this);
	static final String DFA52_eotS =
		"\4\uffff";
	static final String DFA52_eofS =
		"\4\uffff";
	static final String DFA52_minS =
		"\2\33\2\uffff";
	static final String DFA52_maxS =
		"\2\77\2\uffff";
	static final String DFA52_acceptS =
		"\2\uffff\1\1\1\2";
	static final String DFA52_specialS =
		"\4\uffff}>";
	static final String[] DFA52_transitionS = {
			"\1\1\43\uffff\1\2",
			"\1\1\22\uffff\1\3\20\uffff\1\2",
			"",
			""
	};

	static final short[] DFA52_eot = DFA.unpackEncodedString(DFA52_eotS);
	static final short[] DFA52_eof = DFA.unpackEncodedString(DFA52_eofS);
	static final char[] DFA52_min = DFA.unpackEncodedStringToUnsignedChars(DFA52_minS);
	static final char[] DFA52_max = DFA.unpackEncodedStringToUnsignedChars(DFA52_maxS);
	static final short[] DFA52_accept = DFA.unpackEncodedString(DFA52_acceptS);
	static final short[] DFA52_special = DFA.unpackEncodedString(DFA52_specialS);
	static final short[][] DFA52_transition;

	static {
		int numStates = DFA52_transitionS.length;
		DFA52_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA52_transition[i] = DFA.unpackEncodedString(DFA52_transitionS[i]);
		}
	}

	protected class DFA52 extends DFA {

		public DFA52(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 52;
			this.eot = DFA52_eot;
			this.eof = DFA52_eof;
			this.min = DFA52_min;
			this.max = DFA52_max;
			this.accept = DFA52_accept;
			this.special = DFA52_special;
			this.transition = DFA52_transition;
		}
		@Override
		public String getDescription() {
			return "967:12: ( (d+= DOT )* dotted_name | (d+= DOT )+ )";
		}
	}

	static final String DFA136_eotS =
		"\75\uffff";
	static final String DFA136_eofS =
		"\2\2\73\uffff";
	static final String DFA136_minS =
		"\2\6\73\uffff";
	static final String DFA136_maxS =
		"\2\136\73\uffff";
	static final String DFA136_acceptS =
		"\2\uffff\1\2\52\uffff\1\1\17\uffff";
	static final String DFA136_specialS =
		"\75\uffff}>";
	static final String[] DFA136_transitionS = {
			"\1\2\3\uffff\1\2\4\uffff\1\2\1\uffff\1\2\1\1\12\uffff\1\2\1\uffff\1\2"+
			"\10\uffff\1\2\4\uffff\1\2\12\uffff\1\2\5\uffff\1\2\1\uffff\1\2\6\uffff"+
			"\1\2\1\uffff\1\2\2\uffff\1\2\3\uffff\3\2\1\uffff\1\2\1\uffff\1\2\7\uffff"+
			"\1\2",
			"\1\2\3\uffff\1\2\1\uffff\1\55\2\uffff\1\2\1\uffff\2\2\1\uffff\1\55\10"+
			"\uffff\1\2\1\uffff\1\2\7\uffff\1\55\1\2\4\uffff\1\2\3\uffff\1\55\1\uffff"+
			"\3\55\2\uffff\1\2\2\uffff\3\55\1\2\1\55\1\2\1\55\5\uffff\1\2\1\55\1\2"+
			"\1\55\1\uffff\1\2\3\uffff\3\2\1\uffff\1\2\1\uffff\1\2\2\55\5\uffff\1"+
			"\2",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			"",
			""
	};

	static final short[] DFA136_eot = DFA.unpackEncodedString(DFA136_eotS);
	static final short[] DFA136_eof = DFA.unpackEncodedString(DFA136_eofS);
	static final char[] DFA136_min = DFA.unpackEncodedStringToUnsignedChars(DFA136_minS);
	static final char[] DFA136_max = DFA.unpackEncodedStringToUnsignedChars(DFA136_maxS);
	static final short[] DFA136_accept = DFA.unpackEncodedString(DFA136_acceptS);
	static final short[] DFA136_special = DFA.unpackEncodedString(DFA136_specialS);
	static final short[][] DFA136_transition;

	static {
		int numStates = DFA136_transitionS.length;
		DFA136_transition = new short[numStates][];
		for (int i=0; i<numStates; i++) {
			DFA136_transition[i] = DFA.unpackEncodedString(DFA136_transitionS[i]);
		}
	}

	protected class DFA136 extends DFA {

		public DFA136(BaseRecognizer recognizer) {
			this.recognizer = recognizer;
			this.decisionNumber = 136;
			this.eot = DFA136_eot;
			this.eof = DFA136_eof;
			this.min = DFA136_min;
			this.max = DFA136_max;
			this.accept = DFA136_accept;
			this.special = DFA136_special;
			this.transition = DFA136_transition;
		}
		@Override
		public String getDescription() {
			return "()* loopback of 2011:22: ( options {k=2; } : COMMA t+= test[ctype] )*";
		}
	}

	public static final BitSet FOLLOW_NEWLINE_in_single_input118 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EOF_in_single_input121 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simple_stmt_in_single_input137 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_single_input139 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EOF_in_single_input142 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_compound_stmt_in_single_input158 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_single_input160 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EOF_in_single_input163 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEWLINE_in_file_input215 = new BitSet(new long[]{0xB83A679003313A00L,0x0000000591804D23L});
	public static final BitSet FOLLOW_stmt_in_file_input225 = new BitSet(new long[]{0xB83A679003313A00L,0x0000000591804D23L});
	public static final BitSet FOLLOW_EOF_in_file_input244 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEADING_WS_in_eval_input298 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800503L});
	public static final BitSet FOLLOW_NEWLINE_in_eval_input302 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800503L});
	public static final BitSet FOLLOW_testlist_in_eval_input306 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_eval_input310 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_EOF_in_eval_input314 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_dotted_attr366 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_DOT_in_dotted_attr377 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_dotted_attr381 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_NAME_in_name_or_print446 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PRINT_in_name_or_print460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AT_in_decorator762 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_dotted_attr_in_decorator764 = new BitSet(new long[]{0x1000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_LPAREN_in_decorator772 = new BitSet(new long[]{0xB83A008040101000L,0x0000000001A20502L});
	public static final BitSet FOLLOW_arglist_in_decorator782 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_decorator826 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_decorator848 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorator_in_decorators876 = new BitSet(new long[]{0x0000000000000802L});
	public static final BitSet FOLLOW_decorators_in_funcdef914 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_DEF_in_funcdef917 = new BitSet(new long[]{0x8000000000000000L,0x0000000000000400L});
	public static final BitSet FOLLOW_name_or_print_in_funcdef919 = new BitSet(new long[]{0x1000000000000000L});
	public static final BitSet FOLLOW_parameters_in_funcdef921 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_funcdef923 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_funcdef925 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_parameters958 = new BitSet(new long[]{0x9000000040000000L,0x0000000000220000L});
	public static final BitSet FOLLOW_varargslist_in_parameters967 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_parameters1011 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fpdef_in_defparameter1044 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_defparameter1048 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_defparameter1050 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_defparameter_in_varargslist1096 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist1107 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_defparameter_in_varargslist1111 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist1123 = new BitSet(new long[]{0x0000000040000002L,0x0000000000200000L});
	public static final BitSet FOLLOW_STAR_in_varargslist1136 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist1140 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist1143 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist1145 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist1149 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist1165 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist1169 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_varargslist1207 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist1211 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_varargslist1214 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist1216 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist1220 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_varargslist1238 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_varargslist1242 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NAME_in_fpdef1279 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_fpdef1306 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fplist_in_fpdef1308 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_fpdef1310 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_fpdef1326 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fplist_in_fpdef1329 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_fpdef1331 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_fpdef_in_fplist1360 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_fplist1377 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fpdef_in_fplist1381 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_fplist1387 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simple_stmt_in_stmt1423 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_compound_stmt_in_stmt1439 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_small_stmt_in_simple_stmt1475 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040001L});
	public static final BitSet FOLLOW_SEMI_in_simple_stmt1485 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D22L});
	public static final BitSet FOLLOW_small_stmt_in_simple_stmt1489 = new BitSet(new long[]{0x0000000000000000L,0x0000000000040001L});
	public static final BitSet FOLLOW_SEMI_in_simple_stmt1494 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000001L});
	public static final BitSet FOLLOW_NEWLINE_in_simple_stmt1498 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_stmt_in_small_stmt1521 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_del_stmt_in_small_stmt1536 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_pass_stmt_in_small_stmt1551 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_flow_stmt_in_small_stmt1566 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_stmt_in_small_stmt1581 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_global_stmt_in_small_stmt1596 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_exec_stmt_in_small_stmt1611 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_assert_stmt_in_small_stmt1626 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_print_stmt_in_small_stmt1645 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1693 = new BitSet(new long[]{0x41000000A0008040L,0x0000000040510280L});
	public static final BitSet FOLLOW_augassign_in_expr_stmt1709 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_yield_expr_in_expr_stmt1713 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_augassign_in_expr_stmt1753 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1757 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1812 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_expr_stmt1839 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1843 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_expr_stmt1888 = new BitSet(new long[]{0x0000000000000000L,0x0000000400000000L});
	public static final BitSet FOLLOW_yield_expr_in_expr_stmt1892 = new BitSet(new long[]{0x0000000000000402L});
	public static final BitSet FOLLOW_testlist_in_expr_stmt1940 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUSEQUAL_in_augassign1982 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUSEQUAL_in_augassign2000 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAREQUAL_in_augassign2018 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASHEQUAL_in_augassign2036 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENTEQUAL_in_augassign2054 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_AMPEREQUAL_in_augassign2072 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_VBAREQUAL_in_augassign2090 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CIRCUMFLEXEQUAL_in_augassign2108 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LEFTSHIFTEQUAL_in_augassign2126 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHTSHIFTEQUAL_in_augassign2144 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAREQUAL_in_augassign2162 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESLASHEQUAL_in_augassign2180 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PRINT_in_print_stmt2220 = new BitSet(new long[]{0xB83A008000101002L,0x0000000001808502L});
	public static final BitSet FOLLOW_printlist_in_print_stmt2231 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHTSHIFT_in_print_stmt2250 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_printlist2_in_print_stmt2254 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_printlist2334 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_printlist2346 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_printlist2350 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_printlist2358 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_printlist2379 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_printlist22436 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_printlist22448 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_printlist22452 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_printlist22460 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_printlist22481 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DELETE_in_del_stmt2518 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_del_list_in_del_stmt2520 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PASS_in_pass_stmt2556 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_break_stmt_in_flow_stmt2582 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_continue_stmt_in_flow_stmt2590 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_return_stmt_in_flow_stmt2598 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_raise_stmt_in_flow_stmt2606 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_yield_stmt_in_flow_stmt2614 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BREAK_in_break_stmt2642 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_CONTINUE_in_continue_stmt2678 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RETURN_in_return_stmt2714 = new BitSet(new long[]{0xB83A008000101002L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist_in_return_stmt2723 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_yield_expr_in_yield_stmt2788 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RAISE_in_raise_stmt2824 = new BitSet(new long[]{0xB83A008000101002L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_raise_stmt2829 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_raise_stmt2833 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_raise_stmt2837 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_raise_stmt2849 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_raise_stmt2853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_name_in_import_stmt2886 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_from_in_import_stmt2894 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IMPORT_in_import_name2922 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_dotted_as_names_in_import_name2924 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FROM_in_import_from2961 = new BitSet(new long[]{0x8000000008000000L});
	public static final BitSet FOLLOW_DOT_in_import_from2966 = new BitSet(new long[]{0x8000000008000000L});
	public static final BitSet FOLLOW_dotted_name_in_import_from2969 = new BitSet(new long[]{0x0000400000000000L});
	public static final BitSet FOLLOW_DOT_in_import_from2975 = new BitSet(new long[]{0x0000400008000000L});
	public static final BitSet FOLLOW_IMPORT_in_import_from2979 = new BitSet(new long[]{0x9000000000000000L,0x0000000000200000L});
	public static final BitSet FOLLOW_STAR_in_import_from2990 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_as_names_in_import_from3015 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_import_from3038 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_import_as_names_in_import_from3042 = new BitSet(new long[]{0x0000000000040000L,0x0000000000020000L});
	public static final BitSet FOLLOW_COMMA_in_import_from3044 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_import_from3047 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_import_as_name_in_import_as_names3104 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_import_as_names3117 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_import_as_name_in_import_as_names3122 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_NAME_in_import_as_name3159 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AS_in_import_as_name3162 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_import_as_name3166 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dotted_name_in_dotted_as_name3206 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AS_in_dotted_as_name3209 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_dotted_as_name3213 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_dotted_as_name_in_dotted_as_names3257 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dotted_as_names3270 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_dotted_as_name_in_dotted_as_names3275 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_NAME_in_dotted_name3313 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_DOT_in_dotted_name3316 = new BitSet(new long[]{0x800CE75903212380L,0x0000000590004C3AL});
	public static final BitSet FOLLOW_attr_in_dotted_name3320 = new BitSet(new long[]{0x0000000008000002L});
	public static final BitSet FOLLOW_GLOBAL_in_global_stmt3362 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_global_stmt3366 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_global_stmt3371 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_global_stmt3375 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_EXEC_in_exec_stmt3415 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_expr_in_exec_stmt3417 = new BitSet(new long[]{0x0000800000000002L});
	public static final BitSet FOLLOW_IN_in_exec_stmt3421 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_exec_stmt3425 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_exec_stmt3429 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_exec_stmt3433 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ASSERT_in_assert_stmt3474 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_assert_stmt3478 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_assert_stmt3482 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_assert_stmt3486 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_if_stmt_in_compound_stmt3515 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_while_stmt_in_compound_stmt3523 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_for_stmt_in_compound_stmt3531 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_try_stmt_in_compound_stmt3539 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_with_stmt_in_compound_stmt3547 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_funcdef_in_compound_stmt3564 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_classdef_in_compound_stmt3572 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_if_stmt3600 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_if_stmt3602 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_if_stmt3605 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_if_stmt3609 = new BitSet(new long[]{0x0000000100000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_elif_clause_in_if_stmt3612 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_else_clause_in_elif_clause3657 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ELIF_in_elif_clause3673 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_elif_clause3675 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_elif_clause3678 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_elif_clause3680 = new BitSet(new long[]{0x0000000100000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_elif_clause_in_elif_clause3692 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ORELSE_in_else_clause3752 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_else_clause3754 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_else_clause3758 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WHILE_in_while_stmt3795 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_while_stmt3797 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_while_stmt3800 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_while_stmt3804 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_while_stmt3808 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_while_stmt3810 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_while_stmt3814 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FOR_in_for_stmt3853 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_exprlist_in_for_stmt3855 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_for_stmt3858 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist_in_for_stmt3860 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_for_stmt3863 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_for_stmt3867 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_for_stmt3879 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_for_stmt3881 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_for_stmt3885 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TRY_in_try_stmt3928 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt3930 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt3934 = new BitSet(new long[]{0x0000004800000000L});
	public static final BitSet FOLLOW_except_clause_in_try_stmt3948 = new BitSet(new long[]{0x0000004800000002L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_try_stmt3968 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt3970 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt3974 = new BitSet(new long[]{0x0000004000000002L});
	public static final BitSet FOLLOW_FINALLY_in_try_stmt3992 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt3994 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt3998 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FINALLY_in_try_stmt4021 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_try_stmt4023 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_try_stmt4027 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_WITH_in_with_stmt4076 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_with_item_in_with_stmt4080 = new BitSet(new long[]{0x0000000000060000L});
	public static final BitSet FOLLOW_COMMA_in_with_stmt4100 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_with_item_in_with_stmt4104 = new BitSet(new long[]{0x0000000000060000L});
	public static final BitSet FOLLOW_COLON_in_with_stmt4118 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_with_stmt4120 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_with_item4159 = new BitSet(new long[]{0x0000000000000102L});
	public static final BitSet FOLLOW_AS_in_with_item4163 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_expr_in_with_item4165 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EXCEPT_in_except_clause4204 = new BitSet(new long[]{0xB83A008000121000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_except_clause4209 = new BitSet(new long[]{0x0000000000060100L});
	public static final BitSet FOLLOW_set_in_except_clause4213 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_except_clause4223 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_except_clause4230 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_except_clause4232 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_simple_stmt_in_suite4278 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NEWLINE_in_suite4294 = new BitSet(new long[]{0x0001000000000000L});
	public static final BitSet FOLLOW_INDENT_in_suite4296 = new BitSet(new long[]{0xB83A679003313A00L,0x0000000591804D22L});
	public static final BitSet FOLLOW_stmt_in_suite4305 = new BitSet(new long[]{0xB83A679003B13A00L,0x0000000591804D22L});
	public static final BitSet FOLLOW_DEDENT_in_suite4325 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_or_test_in_test4355 = new BitSet(new long[]{0x0000200000000002L});
	public static final BitSet FOLLOW_IF_in_test4377 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_or_test_in_test4381 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_test4384 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_test4388 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_lambdef_in_test4433 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_and_test_in_or_test4468 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000008L});
	public static final BitSet FOLLOW_OR_in_or_test4484 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_and_test_in_or_test4488 = new BitSet(new long[]{0x0000000000000002L,0x0000000000000008L});
	public static final BitSet FOLLOW_not_test_in_and_test4569 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_AND_in_and_test4585 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_not_test_in_and_test4589 = new BitSet(new long[]{0x0000000000000082L});
	public static final BitSet FOLLOW_NOT_in_not_test4673 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_not_test_in_not_test4677 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comparison_in_not_test4694 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_comparison4743 = new BitSet(new long[]{0x0604980200000012L,0x0000000000000006L});
	public static final BitSet FOLLOW_comp_op_in_comparison4757 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_expr_in_comparison4761 = new BitSet(new long[]{0x0604980200000012L,0x0000000000000006L});
	public static final BitSet FOLLOW_LESS_in_comp_op4842 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATER_in_comp_op4858 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_EQUAL_in_comp_op4874 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_GREATEREQUAL_in_comp_op4890 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LESSEQUAL_in_comp_op4906 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_ALT_NOTEQUAL_in_comp_op4922 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOTEQUAL_in_comp_op4938 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IN_in_comp_op4954 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_comp_op4970 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_comp_op4972 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_comp_op4988 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IS_in_comp_op5004 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000002L});
	public static final BitSet FOLLOW_NOT_in_comp_op5006 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_xor_expr_in_expr5058 = new BitSet(new long[]{0x0000000000000002L,0x0000000020000000L});
	public static final BitSet FOLLOW_VBAR_in_expr5073 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_xor_expr_in_expr5077 = new BitSet(new long[]{0x0000000000000002L,0x0000000020000000L});
	public static final BitSet FOLLOW_and_expr_in_xor_expr5156 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_CIRCUMFLEX_in_xor_expr5171 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_and_expr_in_xor_expr5175 = new BitSet(new long[]{0x0000000000004002L});
	public static final BitSet FOLLOW_shift_expr_in_and_expr5253 = new BitSet(new long[]{0x0000000000000022L});
	public static final BitSet FOLLOW_AMPER_in_and_expr5268 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_shift_expr_in_and_expr5272 = new BitSet(new long[]{0x0000000000000022L});
	public static final BitSet FOLLOW_arith_expr_in_shift_expr5355 = new BitSet(new long[]{0x0080000000000002L,0x0000000000008000L});
	public static final BitSet FOLLOW_shift_op_in_shift_expr5369 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_arith_expr_in_shift_expr5373 = new BitSet(new long[]{0x0080000000000002L,0x0000000000008000L});
	public static final BitSet FOLLOW_LEFTSHIFT_in_shift_op5457 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_RIGHTSHIFT_in_shift_op5473 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_term_in_arith_expr5519 = new BitSet(new long[]{0x2000000000000002L,0x0000000000000100L});
	public static final BitSet FOLLOW_arith_op_in_arith_expr5532 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_term_in_arith_expr5536 = new BitSet(new long[]{0x2000000000000002L,0x0000000000000100L});
	public static final BitSet FOLLOW_PLUS_in_arith_op5644 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_arith_op5660 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_factor_in_term5706 = new BitSet(new long[]{0x0000000010000002L,0x0000000000280040L});
	public static final BitSet FOLLOW_term_op_in_term5719 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_factor_in_term5723 = new BitSet(new long[]{0x0000000010000002L,0x0000000000280040L});
	public static final BitSet FOLLOW_STAR_in_term_op5805 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_SLASH_in_term_op5821 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PERCENT_in_term_op5837 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESLASH_in_term_op5853 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_PLUS_in_factor5892 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_factor_in_factor5896 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_MINUS_in_factor5912 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_factor_in_factor5916 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TILDE_in_factor5932 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_factor_in_factor5936 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_power_in_factor5952 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_atom_in_power5991 = new BitSet(new long[]{0x1010000048000002L});
	public static final BitSet FOLLOW_trailer_in_power5996 = new BitSet(new long[]{0x1010000048000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_power6011 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_factor_in_power6013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_atom6063 = new BitSet(new long[]{0xB83A008000101000L,0x0000000401820502L});
	public static final BitSet FOLLOW_yield_expr_in_atom6081 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_testlist_gexp_in_atom6101 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_atom6144 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACK_in_atom6152 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001801502L});
	public static final BitSet FOLLOW_listmaker_in_atom6161 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_atom6204 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LCURLY_in_atom6212 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001802502L});
	public static final BitSet FOLLOW_dictorsetmaker_in_atom6222 = new BitSet(new long[]{0x0000000000000000L,0x0000000000002000L});
	public static final BitSet FOLLOW_RCURLY_in_atom6270 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_BACKQUOTE_in_atom6281 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist1_in_atom6283 = new BitSet(new long[]{0x0000000000001000L});
	public static final BitSet FOLLOW_BACKQUOTE_in_atom6288 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_name_or_print_in_atom6306 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_INT_in_atom6324 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LONGINT_in_atom6342 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FLOAT_in_atom6360 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COMPLEX_in_atom6378 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STRING_in_atom6399 = new BitSet(new long[]{0x0000000000000002L,0x0000000000800000L});
	public static final BitSet FOLLOW_test_in_listmaker6442 = new BitSet(new long[]{0x0000010000040002L});
	public static final BitSet FOLLOW_list_for_in_listmaker6454 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_listmaker6486 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_listmaker6490 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_listmaker6519 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist_gexp6551 = new BitSet(new long[]{0x0000010000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist_gexp6575 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_testlist_gexp6579 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist_gexp6587 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_testlist_gexp6641 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LAMBDA_in_lambdef6705 = new BitSet(new long[]{0x9000000040020000L,0x0000000000200000L});
	public static final BitSet FOLLOW_varargslist_in_lambdef6708 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_lambdef6712 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_lambdef6714 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_trailer6753 = new BitSet(new long[]{0xB83A008040101000L,0x0000000001A20502L});
	public static final BitSet FOLLOW_arglist_in_trailer6762 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_trailer6804 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LBRACK_in_trailer6812 = new BitSet(new long[]{0xB83A008008121000L,0x0000000001800502L});
	public static final BitSet FOLLOW_subscriptlist_in_trailer6814 = new BitSet(new long[]{0x0000000000000000L,0x0000000000001000L});
	public static final BitSet FOLLOW_RBRACK_in_trailer6817 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_trailer6833 = new BitSet(new long[]{0x800CE75903212380L,0x0000000590004C3AL});
	public static final BitSet FOLLOW_attr_in_trailer6835 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_subscript_in_subscriptlist6874 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_subscriptlist6886 = new BitSet(new long[]{0xB83A008008121000L,0x0000000001800502L});
	public static final BitSet FOLLOW_subscript_in_subscriptlist6890 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_subscriptlist6897 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOT_in_subscript6940 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_DOT_in_subscript6942 = new BitSet(new long[]{0x0000000008000000L});
	public static final BitSet FOLLOW_DOT_in_subscript6944 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_subscript6974 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_COLON_in_subscript6980 = new BitSet(new long[]{0xB83A008000121002L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_subscript6985 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_sliceop_in_subscript6991 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_subscript7022 = new BitSet(new long[]{0xB83A008000121002L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_subscript7027 = new BitSet(new long[]{0x0000000000020002L});
	public static final BitSet FOLLOW_sliceop_in_subscript7033 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_subscript7051 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_sliceop7088 = new BitSet(new long[]{0xB83A008000101002L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_sliceop7096 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_exprlist7167 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_exprlist7179 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_expr_in_exprlist7183 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_exprlist7189 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_exprlist7208 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_del_list7254 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_del_list7276 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_expr_in_del_list7280 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_del_list7300 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist7355 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist7367 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_testlist7371 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist7377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist7395 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker7428 = new BitSet(new long[]{0x0000010000060002L});
	public static final BitSet FOLLOW_COLON_in_dictorsetmaker7456 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker7460 = new BitSet(new long[]{0x0000010000040002L});
	public static final BitSet FOLLOW_comp_for_in_dictorsetmaker7480 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dictorsetmaker7527 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker7531 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_dictorsetmaker7534 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker7538 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dictorsetmaker7594 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_dictorsetmaker7598 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_dictorsetmaker7648 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_dictorsetmaker7663 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorators_in_classdef7716 = new BitSet(new long[]{0x0000000000010000L});
	public static final BitSet FOLLOW_CLASS_in_classdef7719 = new BitSet(new long[]{0x8000000000000000L});
	public static final BitSet FOLLOW_NAME_in_classdef7721 = new BitSet(new long[]{0x1000000000020000L});
	public static final BitSet FOLLOW_LPAREN_in_classdef7724 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001820502L});
	public static final BitSet FOLLOW_testlist_in_classdef7726 = new BitSet(new long[]{0x0000000000000000L,0x0000000000020000L});
	public static final BitSet FOLLOW_RPAREN_in_classdef7730 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_classdef7734 = new BitSet(new long[]{0xB83A469002303200L,0x0000000401804D23L});
	public static final BitSet FOLLOW_suite_in_classdef7736 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_argument_in_arglist7778 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist7782 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_argument_in_arglist7784 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist7800 = new BitSet(new long[]{0x0000000040000002L,0x0000000000200000L});
	public static final BitSet FOLLOW_STAR_in_arglist7818 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_arglist7822 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist7826 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_argument_in_arglist7828 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist7834 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist7836 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_arglist7840 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist7861 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_arglist7865 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_STAR_in_arglist7912 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_arglist7916 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist7920 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_argument_in_arglist7922 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_arglist7928 = new BitSet(new long[]{0x0000000040000000L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist7930 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_arglist7934 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DOUBLESTAR_in_arglist7953 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_arglist7957 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_argument7996 = new BitSet(new long[]{0x0000010000000402L});
	public static final BitSet FOLLOW_ASSIGN_in_argument8009 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_argument8013 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_argument8039 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_for_in_list_iter8104 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_list_if_in_list_iter8113 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FOR_in_list_for8139 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_exprlist_in_list_for8141 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_list_for8144 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist_in_list_for8146 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_list_iter_in_list_for8150 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_list_if8180 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_list_if8182 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_list_iter_in_list_if8186 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_for_in_comp_iter8217 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_comp_if_in_comp_iter8226 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_FOR_in_comp_for8252 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800500L});
	public static final BitSet FOLLOW_exprlist_in_comp_for8254 = new BitSet(new long[]{0x0000800000000000L});
	public static final BitSet FOLLOW_IN_in_comp_for8257 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_or_test_in_comp_for8259 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_comp_iter_in_comp_for8262 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_comp_if8291 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_comp_if8293 = new BitSet(new long[]{0x0000210000000002L});
	public static final BitSet FOLLOW_comp_iter_in_comp_if8296 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_testlist18338 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_COMMA_in_testlist18357 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_testlist18361 = new BitSet(new long[]{0x0000000000040002L});
	public static final BitSet FOLLOW_YIELD_in_yield_expr8412 = new BitSet(new long[]{0xB83A008000101002L,0x0000000001800502L});
	public static final BitSet FOLLOW_testlist_in_yield_expr8414 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_LPAREN_in_synpred1_Python1296 = new BitSet(new long[]{0x9000000000000000L});
	public static final BitSet FOLLOW_fpdef_in_synpred1_Python1298 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred1_Python1301 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_synpred2_Python1683 = new BitSet(new long[]{0x41000000A0008040L,0x0000000040510280L});
	public static final BitSet FOLLOW_augassign_in_synpred2_Python1686 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_testlist_in_synpred3_Python1802 = new BitSet(new long[]{0x0000000000000400L});
	public static final BitSet FOLLOW_ASSIGN_in_synpred3_Python1805 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred4_Python2317 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred4_Python2320 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred5_Python2416 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred5_Python2419 = new BitSet(new long[]{0xB83A008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_test_in_synpred5_Python2421 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_decorators_in_synpred6_Python3556 = new BitSet(new long[]{0x0000000001000000L});
	public static final BitSet FOLLOW_DEF_in_synpred6_Python3559 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_IF_in_synpred7_Python4367 = new BitSet(new long[]{0xB832008000101000L,0x0000000001800502L});
	public static final BitSet FOLLOW_or_test_in_synpred7_Python4369 = new BitSet(new long[]{0x0000000000000000L,0x0000000000000010L});
	public static final BitSet FOLLOW_ORELSE_in_synpred7_Python4372 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred8_Python6961 = new BitSet(new long[]{0x0000000000020000L});
	public static final BitSet FOLLOW_COLON_in_synpred8_Python6964 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_COLON_in_synpred9_Python7012 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_expr_in_synpred10_Python7157 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred10_Python7160 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_test_in_synpred11_Python7342 = new BitSet(new long[]{0x0000000000040000L});
	public static final BitSet FOLLOW_COMMA_in_synpred11_Python7345 = new BitSet(new long[]{0x0000000000000002L});
}
