/*
 * Decompiled with CFR 0.152.
 */
package org.pcc.webviewOverlay;

import android.content.Context;
import android.util.Log;
import java.util.HashMap;
import java.util.Map;
import org.pcc.webviewOverlay.WebViewHelper;
import org.pcc.webviewOverlay.WebViewOverlayAPI;
import org.pcc.webviewOverlay.WebViewOverlayException;

public class WebViewOverlay
implements WebViewOverlayAPI {
    public static int LIB_VERSION = 1;
    public static String LIB_VERSION_NAME = "1.0";
    static final String TAG = "WebViewOverlay";
    WebViewHelper mWebViewHelper;

    public WebViewOverlay(Context context) {
        this.mWebViewHelper = new WebViewHelper(context);
    }

    @Override
    public void loadWebViewOverlay(String urlToBeLoaded, HashMap<String, String> params) {
        try {
            String url = this.getUrl(urlToBeLoaded, params);
            this.mWebViewHelper.openWebViewInOverlay(url, null);
        }
        catch (WebViewOverlayException e) {
            Log.e((String)TAG, (String)("Exception occurred while loading WebviewOverlay: " + e.getMessage()));
        }
    }

    @Override
    public void loadWebViewOverlay(String urlToBeLoaded, HashMap<String, String> params, String popupTitle) {
        try {
            String url = this.getUrl(urlToBeLoaded, params);
            this.mWebViewHelper.openWebViewInOverlay(url, popupTitle);
        }
        catch (WebViewOverlayException e) {
            Log.e((String)TAG, (String)("Exception occurred while loading WebviewOverlay: " + e.getMessage()));
        }
    }

    public String getUrl(String baseUrl, HashMap<String, String> params) throws WebViewOverlayException {
        String finalUrl = null;
        if (baseUrl instanceof String) {
            if (params == null || params.isEmpty()) {
                return baseUrl;
            }
            finalUrl = baseUrl + "/?";
            int counter = 0;
            for (Map.Entry<String, String> attrib : params.entrySet()) {
                finalUrl = finalUrl + attrib.getKey() + "=" + attrib.getValue();
                if (++counter >= params.size()) continue;
                finalUrl = finalUrl + "&";
            }
        } else {
            throw new WebViewOverlayException("Invalid URL passed into WebViewOverlay");
        }
        return finalUrl;
    }
}

