/*
 * Decompiled with CFR 0.152.
 */
package org.pcc.webviewOverlay;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.webkit.URLUtil;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import org.pcc.webviewOverlay.R;
import org.pcc.webviewOverlay.WebViewOverlayException;

public class WebViewHelper
implements View.OnClickListener {
    private WebView mWebView;
    private Context mContext;
    private Dialog mWebviewDialog = null;

    public WebViewHelper(Context context) {
        this.mContext = context;
    }

    public void openWebViewInOverlay(String url, String popupTitle) throws WebViewOverlayException {
        if (!URLUtil.isValidUrl((String)url)) {
            throw new WebViewOverlayException("Invalid url passed into WebViewOverlay");
        }
        if (popupTitle instanceof String) {
            this.mWebviewDialog = new Dialog(this.mContext, 16974120);
            this.mWebviewDialog.setTitle((CharSequence)popupTitle);
        } else {
            this.mWebviewDialog = new Dialog(this.mContext, 16974065);
        }
        LayoutInflater inflater = (LayoutInflater)this.mContext.getApplicationContext().getSystemService("layout_inflater");
        View view = View.inflate((Context)this.mContext, (int)R.layout.webview_modal, null);
        Button closeSurvey = (Button)view.findViewById(R.id.closeOverlay);
        closeSurvey.setOnClickListener((View.OnClickListener)this);
        this.mWebView = (WebView)view.findViewById(R.id.webviewoverlay);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.loadUrl(url);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                view.loadUrl(url);
                return true;
            }
        });
        this.mWebviewDialog.setContentView(view);
        this.mWebviewDialog.show();
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.copyFrom(this.mWebviewDialog.getWindow().getAttributes());
        lp.width = -1;
        lp.height = -1;
        this.mWebviewDialog.getWindow().setAttributes(lp);
    }

    public void onClick(View v) {
        if (this.mWebviewDialog != null) {
            this.mWebviewDialog.dismiss();
        }
    }
}

