/*
 * Decompiled with CFR 0.152.
 */
package org.protoojs.droid;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.protoojs.droid.Logger;
import org.protoojs.droid.Message;
import org.protoojs.droid.transports.AbsWebSocketTransport;

public class Peer
implements AbsWebSocketTransport.Listener {
    private static final String TAG = "Peer";
    private boolean mClosed = false;
    @NonNull
    private final AbsWebSocketTransport mTransport;
    @NonNull
    private final Listener mListener;
    @NonNull
    private final Handler mTimerCheckHandler;
    private boolean mConnected;
    private JSONObject mData;
    @SuppressLint(value={"UseSparseArrays"})
    private Map<Long, ClientRequestHandlerProxy> mSends = new HashMap<Long, ClientRequestHandlerProxy>();

    public Peer(@NonNull AbsWebSocketTransport transport, @NonNull Listener listener) {
        this.mTransport = transport;
        this.mListener = listener;
        this.mTimerCheckHandler = new Handler(Looper.getMainLooper());
        this.handleTransport();
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public JSONObject getData() {
        return this.mData;
    }

    public void close() {
        if (this.mClosed) {
            return;
        }
        Logger.d(TAG, "close()");
        this.mClosed = true;
        this.mConnected = false;
        this.mTransport.close();
        for (ClientRequestHandlerProxy proxy : this.mSends.values()) {
            proxy.close();
        }
        this.mSends.clear();
        this.mListener.onClose();
    }

    public void request(String method, String data, ClientRequestHandler clientRequestHandler) {
        try {
            this.request(method, new JSONObject(data), clientRequestHandler);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void request(String method, @NonNull JSONObject data, ClientRequestHandler clientRequestHandler) {
        JSONObject request = Message.createRequest(method, data);
        long requestId = request.optLong("id");
        Logger.d(TAG, String.format("request() [method:%s, data:%s]", method, data.toString()));
        String payload = this.mTransport.sendMessage(request);
        long timeout = (long)(1500.0 * (15.0 + 0.1 * (double)payload.length()));
        this.mSends.put(requestId, new ClientRequestHandlerProxy(requestId, method, timeout, clientRequestHandler));
    }

    public void notify(String method, String data) {
        try {
            this.notify(method, new JSONObject(data));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void notify(String method, JSONObject data) {
        JSONObject notification = Message.createNotification(method, data);
        Logger.d(TAG, String.format("notify() [method:%s]", method));
        this.mTransport.sendMessage(notification);
    }

    private void handleTransport() {
        if (this.mTransport.isClosed()) {
            if (this.mClosed) {
                return;
            }
            this.mConnected = false;
            this.mListener.onClose();
            return;
        }
        this.mTransport.connect(this);
    }

    private void handleRequest(final Message.Request request) {
        this.mListener.onRequest(request, new ServerRequestHandler(){

            @Override
            public void accept(String data) {
                try {
                    JSONObject response = TextUtils.isEmpty((CharSequence)data) ? Message.createSuccessResponse(request, new JSONObject()) : Message.createSuccessResponse(request, new JSONObject(data));
                    Peer.this.mTransport.sendMessage(response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void reject(long code, String errorReason) {
                JSONObject response = Message.createErrorResponse(request, code, errorReason);
                try {
                    Peer.this.mTransport.sendMessage(response);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void handleResponse(Message.Response response) {
        ClientRequestHandlerProxy sent = this.mSends.remove(response.getId());
        if (sent == null) {
            Logger.e(TAG, "received response does not match any sent request [id:" + response.getId() + "]");
            return;
        }
        sent.close();
        if (response.isOK()) {
            sent.resolve(response.getData().toString());
        } else {
            sent.reject(response.getErrorCode(), response.getErrorReason());
        }
    }

    private void handleNotification(Message.Notification notification) {
        this.mListener.onNotification(notification);
    }

    @Override
    public void onOpen() {
        if (this.mClosed) {
            return;
        }
        Logger.d(TAG, "onOpen()");
        this.mConnected = true;
        this.mListener.onOpen();
    }

    @Override
    public void onFail() {
        if (this.mClosed) {
            return;
        }
        Logger.e(TAG, "onFail()");
        this.mConnected = false;
        this.mListener.onFail();
    }

    @Override
    public void onMessage(Message message) {
        if (this.mClosed) {
            return;
        }
        Logger.d(TAG, "onMessage()");
        if (message instanceof Message.Request) {
            this.handleRequest((Message.Request)message);
        } else if (message instanceof Message.Response) {
            this.handleResponse((Message.Response)message);
        } else if (message instanceof Message.Notification) {
            this.handleNotification((Message.Notification)message);
        }
    }

    @Override
    public void onDisconnected() {
        if (this.mClosed) {
            return;
        }
        Logger.w(TAG, "onDisconnected()");
        this.mConnected = false;
        this.mListener.onDisconnected();
    }

    @Override
    public void onClose() {
        if (this.mClosed) {
            return;
        }
        Logger.w(TAG, "onClose()");
        this.mClosed = true;
        this.mConnected = false;
        this.mListener.onClose();
    }

    class ClientRequestHandlerProxy
    implements ClientRequestHandler,
    Runnable {
        long mRequestId;
        String mMethod;
        ClientRequestHandler mClientRequestHandler;

        ClientRequestHandlerProxy(long requestId, String method, long timeoutDelayMillis, ClientRequestHandler clientRequestHandler) {
            this.mRequestId = requestId;
            this.mMethod = method;
            this.mClientRequestHandler = clientRequestHandler;
            Peer.this.mTimerCheckHandler.postDelayed((Runnable)this, timeoutDelayMillis);
        }

        @Override
        public void run() {
            Peer.this.mSends.remove(this.mRequestId);
            if (this.mClientRequestHandler != null) {
                this.mClientRequestHandler.reject(408L, "request timeout");
            }
        }

        @Override
        public void resolve(String data) {
            Logger.d(Peer.TAG, "request() " + this.mMethod + " success, " + data);
            if (this.mClientRequestHandler != null) {
                this.mClientRequestHandler.resolve(data);
            }
        }

        @Override
        public void reject(long error, String errorReason) {
            Logger.w(Peer.TAG, "request() " + this.mMethod + " fail, " + error + ", " + errorReason);
            if (this.mClientRequestHandler != null) {
                this.mClientRequestHandler.reject(error, errorReason);
            }
        }

        void close() {
            Peer.this.mTimerCheckHandler.removeCallbacks((Runnable)this);
        }
    }

    public static interface ClientRequestHandler {
        public void resolve(String var1);

        public void reject(long var1, String var3);
    }

    public static interface ServerRequestHandler {
        default public void accept() {
            this.accept(null);
        }

        public void accept(String var1);

        public void reject(long var1, String var3);
    }

    public static interface Listener {
        public void onOpen();

        public void onFail();

        public void onRequest(@NonNull Message.Request var1, @NonNull ServerRequestHandler var2);

        public void onNotification(@NonNull Message.Notification var1);

        public void onDisconnected();

        public void onClose();
    }
}

