/*
 * Decompiled with CFR 0.152.
 */
package org.protoojs.droid;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import org.json.JSONException;
import org.json.JSONObject;
import org.protoojs.droid.Logger;
import org.protoojs.droid.Utils;

public class Message {
    private static final String TAG = "message";
    private JSONObject mData;

    public Message() {
    }

    public Message(JSONObject data) {
        this.mData = data;
    }

    public JSONObject getData() {
        return this.mData;
    }

    public void setData(JSONObject data) {
        this.mData = data;
    }

    public static Message parse(String raw) {
        JSONObject object;
        Logger.d(TAG, "parse() ");
        try {
            object = new JSONObject(raw);
        }
        catch (JSONException e) {
            Logger.e(TAG, String.format("parse() | invalid JSON: %s", e.getMessage()));
            return null;
        }
        if (object.optBoolean("request")) {
            String method = object.optString("method");
            long id = object.optLong("id");
            if (TextUtils.isEmpty((CharSequence)method)) {
                Logger.e(TAG, "parse() | missing/invalid method field. rawData: " + raw);
                return null;
            }
            if (id == 0L) {
                Logger.e(TAG, "parse() | missing/invalid id field. rawData: " + raw);
                return null;
            }
            return new Request(method, id, object.optJSONObject("data"));
        }
        if (object.optBoolean("response")) {
            long id = object.optLong("id");
            if (id == 0L) {
                Logger.e(TAG, "parse() | missing/invalid id field. rawData: " + raw);
                return null;
            }
            if (object.optBoolean("ok")) {
                return new Response(id, object.optJSONObject("data"));
            }
            return new Response(id, object.optLong("errorCode"), object.optString("errorReason"));
        }
        if (object.optBoolean("notification")) {
            String method = object.optString("method");
            if (TextUtils.isEmpty((CharSequence)method)) {
                Logger.e(TAG, "parse() | missing/invalid method field. rawData: " + raw);
                return null;
            }
            return new Notification(method, object.optJSONObject("data"));
        }
        Logger.e(TAG, "parse() | missing request/response field. rawData: " + raw);
        return null;
    }

    public static JSONObject createRequest(String method, JSONObject data) {
        JSONObject request = new JSONObject();
        try {
            request.put("request", true);
            request.put("method", (Object)method);
            request.put("id", Utils.generateRandomNumber());
            request.put("data", (Object)(data != null ? data : new JSONObject()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return request;
    }

    @NonNull
    public static JSONObject createSuccessResponse(@NonNull Request request, JSONObject data) {
        JSONObject response = new JSONObject();
        try {
            response.put("response", true);
            response.put("id", request.getId());
            response.put("ok", true);
            response.put("data", (Object)(data != null ? data : new JSONObject()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return response;
    }

    @NonNull
    public static JSONObject createErrorResponse(@NonNull Request request, long errorCode, String errorReason) {
        JSONObject response = new JSONObject();
        try {
            response.put("response", true);
            response.put("id", request.getId());
            response.put("ok", false);
            response.put("errorCode", errorCode);
            response.put("errorReason", (Object)errorReason);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return response;
    }

    @NonNull
    public static JSONObject createNotification(String method, JSONObject data) {
        JSONObject notification = new JSONObject();
        try {
            notification.put("notification", true);
            notification.put("method", (Object)method);
            notification.put("data", (Object)(data != null ? data : new JSONObject()));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return notification;
    }

    public static class Notification
    extends Message {
        private boolean mNotification = true;
        private String mMethod;

        public Notification(String method, JSONObject data) {
            super(data);
            this.mMethod = method;
        }

        public boolean isNotification() {
            return this.mNotification;
        }

        public void setNotification(boolean notification) {
            this.mNotification = notification;
        }

        public String getMethod() {
            return this.mMethod;
        }

        public void setMethod(String method) {
            this.mMethod = method;
        }
    }

    public static class Response
    extends Message {
        private boolean mResponse = true;
        private long mId;
        private boolean mOK;
        private long mErrorCode;
        private String mErrorReason;

        public Response(long id, JSONObject data) {
            super(data);
            this.mId = id;
            this.mOK = true;
        }

        public Response(long id, long errorCode, String errorReason) {
            this.mId = id;
            this.mOK = false;
            this.mErrorCode = errorCode;
            this.mErrorReason = errorReason;
        }

        public boolean isResponse() {
            return this.mResponse;
        }

        public void setResponse(boolean response) {
            this.mResponse = response;
        }

        public long getId() {
            return this.mId;
        }

        public void setId(long id) {
            this.mId = id;
        }

        public boolean isOK() {
            return this.mOK;
        }

        public void setOK(boolean OK) {
            this.mOK = OK;
        }

        public long getErrorCode() {
            return this.mErrorCode;
        }

        public void setErrorCode(long errorCode) {
            this.mErrorCode = errorCode;
        }

        public String getErrorReason() {
            return this.mErrorReason;
        }

        public void setErrorReason(String errorReason) {
            this.mErrorReason = errorReason;
        }
    }

    public static class Request
    extends Message {
        private boolean mRequest = true;
        private String mMethod;
        private long mId;

        public Request(String method, long id, JSONObject data) {
            super(data);
            this.mMethod = method;
            this.mId = id;
        }

        public boolean isRequest() {
            return this.mRequest;
        }

        public void setRequest(boolean request) {
            this.mRequest = request;
        }

        public long getId() {
            return this.mId;
        }

        public void setId(long id) {
            this.mId = id;
        }

        public String getMethod() {
            return this.mMethod;
        }

        public void setMethod(String method) {
            this.mMethod = method;
        }
    }
}

