/*
 * Decompiled with CFR 0.152.
 */
package org.protoojs.droid;

import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;

class Logger {
    private static LogLevel loggableLevel = LogLevel.LOG_WARN;

    Logger() {
    }

    public static void setLogLevel(LogLevel level) {
        if (level == null) {
            throw new IllegalArgumentException("Logging level may not be null.");
        }
        loggableLevel = level;
    }

    public static void d(String tag, String message) {
        Logger.log(LogLevel.LOG_DEBUG, tag, message);
    }

    public static void e(String tag, String message) {
        Logger.log(LogLevel.LOG_ERROR, tag, message);
    }

    public static void w(String tag, String message) {
        Logger.log(LogLevel.LOG_WARN, tag, message);
    }

    public static void e(String tag, String message, Throwable e) {
        Logger.log(LogLevel.LOG_ERROR, tag, message);
        Logger.log(LogLevel.LOG_ERROR, tag, e.toString());
        Logger.log(LogLevel.LOG_ERROR, tag, Logger.getStackTraceString(e));
    }

    public static void w(String tag, String message, Throwable e) {
        Logger.log(LogLevel.LOG_WARN, tag, message);
        Logger.log(LogLevel.LOG_WARN, tag, e.toString());
        Logger.log(LogLevel.LOG_WARN, tag, Logger.getStackTraceString(e));
    }

    public static void v(String tag, String message) {
        Logger.log(LogLevel.LOG_TRACE, tag, message);
    }

    private static String getStackTraceString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    public static void log(LogLevel level, String tag, String message) {
        if (tag == null || message == null) {
            throw new IllegalArgumentException("Log tag or message may not be null.");
        }
        if (LogLevel.LOG_NONE.equals((Object)loggableLevel) || level.ordinal() > loggableLevel.ordinal()) {
            return;
        }
        switch (level) {
            case LOG_ERROR: {
                Log.e((String)tag, (String)message);
                break;
            }
            case LOG_WARN: {
                Log.w((String)tag, (String)message);
                break;
            }
            case LOG_DEBUG: {
                Log.d((String)tag, (String)message);
                break;
            }
            case LOG_TRACE: {
                Log.v((String)tag, (String)message);
            }
        }
    }

    public static enum LogLevel {
        LOG_NONE,
        LOG_ERROR,
        LOG_WARN,
        LOG_DEBUG,
        LOG_TRACE;

    }
}

