/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.context;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.SmartLifecycle;
import reactor.support.NamedDaemonThreadFactory;

public class RingBufferApplicationEventPublisher
implements ApplicationEventPublisher,
ApplicationContextAware,
SmartLifecycle {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final boolean autoStartup;
    private final ExecutorService executor;
    private final Disruptor<AppEventSlot> disruptor;
    private final EventTranslator<AppEventSlot> translator;
    private volatile boolean running = false;
    private RingBuffer<AppEventSlot> ringBuffer;
    private ApplicationContext appCtx;

    public RingBufferApplicationEventPublisher(int backlog, boolean autoStartup) {
        this(backlog, autoStartup, ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
    }

    public RingBufferApplicationEventPublisher(int backlog, boolean autoStartup, ProducerType producerType, WaitStrategy waitStrategy) {
        this.autoStartup = autoStartup;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedDaemonThreadFactory("ringBufferAppEventPublisher"));
        this.disruptor = new Disruptor((EventFactory)new EventFactory<AppEventSlot>(){

            public AppEventSlot newInstance() {
                return new AppEventSlot();
            }
        }, backlog, (Executor)this.executor, producerType, waitStrategy);
        this.disruptor.handleExceptionsWith(new ExceptionHandler(){

            public void handleEventException(Throwable ex, long sequence, Object event) {
                RingBufferApplicationEventPublisher.this.log.error(ex.getMessage(), ex);
            }

            public void handleOnStartException(Throwable ex) {
                RingBufferApplicationEventPublisher.this.log.error(ex.getMessage(), ex);
            }

            public void handleOnShutdownException(Throwable ex) {
                RingBufferApplicationEventPublisher.this.log.error(ex.getMessage(), ex);
            }
        });
        this.translator = new EventTranslator<AppEventSlot>(){

            public void translateTo(AppEventSlot event, long sequence) {
                RingBufferApplicationEventPublisher.this.appCtx.publishEvent(event.appEvent);
            }
        };
        if (autoStartup) {
            this.start();
        }
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = appCtx;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) {
        this.executor.shutdown();
        this.disruptor.shutdown();
        if (null != callback) {
            callback.run();
        }
        RingBufferApplicationEventPublisher ringBufferApplicationEventPublisher = this;
        synchronized (ringBufferApplicationEventPublisher) {
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        RingBufferApplicationEventPublisher ringBufferApplicationEventPublisher = this;
        synchronized (ringBufferApplicationEventPublisher) {
            this.ringBuffer = this.disruptor.start();
            this.running = true;
        }
    }

    public void stop() {
        this.stop(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        RingBufferApplicationEventPublisher ringBufferApplicationEventPublisher = this;
        synchronized (ringBufferApplicationEventPublisher) {
            return this.running;
        }
    }

    public int getPhase() {
        return 0;
    }

    public void publishEvent(ApplicationEvent event) {
        this.ringBuffer.publishEvent(this.translator);
    }

    private static class AppEventSlot {
        ApplicationEvent appEvent;

        private AppEventSlot() {
        }
    }
}

