/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.wildfly;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.projectodd.vdx.core.ErrorPrinter;
import org.projectodd.vdx.core.ErrorType;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Printer;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.XMLStreamValidationException;
import org.projectodd.vdx.core.schema.SchemaPathGate;
import org.projectodd.vdx.core.schema.SchemaPathPrefixProvider;
import org.projectodd.vdx.wildfly.SchemaDocRelationships;
import org.projectodd.vdx.wildfly.SchemaProvider;
import org.projectodd.vdx.wildfly.SubsystemStringifier;

public abstract class ErrorReporter {
    private final URL document;

    public ErrorReporter(URL document) {
        this.document = document;
    }

    public boolean report(XMLStreamException exception) {
        boolean printed = false;
        try {
            List<URL> schemas = this.findSchemas();
            if (!schemas.isEmpty()) {
                ValidationError error;
                if (exception instanceof XMLStreamValidationException) {
                    error = ((XMLStreamValidationException)exception).getValidationError();
                } else {
                    String message = exception.getMessage();
                    Matcher dupMatcher = Pattern.compile("^Duplicate attribute '(.+?)'\\.").matcher(message);
                    if (dupMatcher.find()) {
                        error = ValidationError.from((XMLStreamException)exception, (ErrorType)ErrorType.DUPLICATE_ATTRIBUTE).attribute(QName.valueOf(dupMatcher.group(1)));
                    } else {
                        error = ValidationError.from((XMLStreamException)exception, (ErrorType)ErrorType.UNKNOWN_ERROR);
                        Matcher m = Pattern.compile("\"?([A-Z]+\\d+: )?(.*?)\"?$").matcher(message);
                        if (m.find()) {
                            error.fallbackMessage(m.group(2));
                        }
                    }
                }
                ArrayList<SubsystemStringifier> stringifiers = new ArrayList<SubsystemStringifier>();
                stringifiers.add(new SubsystemStringifier());
                SchemaDocRelationships rel = new SchemaDocRelationships();
                new ErrorPrinter(this.document, schemas).printer(this.printer()).stringifiers(stringifiers).pathGate((SchemaPathGate)rel).prefixProvider((SchemaPathPrefixProvider)rel).print(error);
                printed = true;
            }
        }
        catch (Exception ex) {
            this.printer().println(I18N.failedToPrintError((Throwable)ex));
        }
        return printed;
    }

    protected List<URL> findSchemas() {
        SchemaProvider provider = this.schemaProvider();
        List<URL> schemas = provider.schemas();
        if (schemas.isEmpty()) {
            this.printer().println(I18N.noSchemasAvailable((String)provider.schemaResource()));
        }
        return schemas;
    }

    protected abstract SchemaProvider schemaProvider();

    protected abstract Printer printer();
}

