/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal.junit;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.spi.WebDriverProvider;

public class ScreenshotOnFailureExtension
implements TestWatcher {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");

    public void testFailed(ExtensionContext context, Throwable cause) {
        String screenshotDirectory = ConfigProvider.getInstance().getScreenshotDirectory();
        if (StringUtils.isNotBlank((CharSequence)screenshotDirectory)) {
            File scrFile = (File)((TakesScreenshot)WebDriverProvider.get()).getScreenshotAs(OutputType.FILE);
            String filename = screenshotDirectory + LocalDateTime.now().format(DATE_TIME_FORMATTER) + "_" + UUID.randomUUID().toString();
            try {
                FileUtils.moveFile((File)scrFile, (File)new File(filename + ".png"));
                PrintWriter printWriter = new PrintWriter(new FileWriter(filename + ".txt"));
                if (context.getTestMethod().isPresent()) {
                    printWriter.println("Test-method: " + String.valueOf(context.getTestMethod().get()));
                }
                printWriter.println("Test-description: " + context.getDisplayName());
                printWriter.println("");
                printWriter.println("Stacktrace: " + ExceptionUtils.getStackTrace((Throwable)cause));
                printWriter.close();
            }
            catch (IOException ex) {
                System.err.println("Failed to save screenshot auf failed test: " + ex.getMessage());
            }
        }
        super.testFailed(context, cause);
    }
}

