/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.primefaces.selenium.internal.DefaultWebDriverAdapter;
import org.primefaces.selenium.spi.DeploymentAdapter;
import org.primefaces.selenium.spi.OnloadScriptsAdapter;
import org.primefaces.selenium.spi.WebDriverAdapter;

public class ConfigProvider {
    public static final String DEPLOYMENT_ADAPTER = "deployment.adapter";
    public static final String DEPLOYMENT_BASEURL = "deployment.baseUrl";
    private static ConfigProvider configProvider = null;
    private static final Pattern PROPERTY_ENV_PLACEHOLDER = Pattern.compile("\\$\\{(.*?)}");
    private int timeoutGui = 2;
    private int timeoutAjax = 10;
    private int timeoutHttp = 10;
    private int timeoutDocumentLoad = 15;
    private int timeoutFileUpload = 20;
    private String scrollElementIntoView;
    private boolean disableAnimations = true;
    private WebDriverAdapter webdriverAdapter;
    private String webdriverBrowser;
    private boolean webdriverHeadless = false;
    private String webdriverVersion;
    private Level webdriverLogLevel = Level.WARNING;
    private String deploymentBaseUrl;
    private DeploymentAdapter deploymentAdapter;
    private OnloadScriptsAdapter onloadScriptsAdapter;
    private List<String> onloadScripts;
    private String screenshotDirectory;

    public ConfigProvider() {
        try {
            InputStream config = this.getClass().getResourceAsStream("/primefaces-selenium/config.properties");
            if (config != null) {
                String screenshotDirectory;
                String onloadScriptsAdapter;
                String webdriverLogLevel;
                String webdriverVersion;
                String webdriverHeadless;
                String webdriverBrowser;
                String webdriverAdapter;
                String deploymentAdapter;
                String deploymentBaseUrl;
                String scrollElementIntoView;
                String disableAnimations;
                String timeoutFileUpload;
                String timeoutDocumentLoad;
                String timeoutHttp;
                String timeoutAjax;
                Properties properties = new Properties();
                properties.load(config);
                String timeoutGui = this.getAndResolveProperty(properties, "timeout.gui");
                if (timeoutGui != null && !timeoutGui.trim().isEmpty()) {
                    this.timeoutGui = Integer.parseInt(timeoutGui);
                }
                if ((timeoutAjax = this.getAndResolveProperty(properties, "timeout.ajax")) != null && !timeoutAjax.trim().isEmpty()) {
                    this.timeoutAjax = Integer.parseInt(timeoutAjax);
                }
                if ((timeoutHttp = this.getAndResolveProperty(properties, "timeout.http")) != null && !timeoutHttp.trim().isEmpty()) {
                    this.timeoutHttp = Integer.parseInt(timeoutHttp);
                }
                if ((timeoutDocumentLoad = this.getAndResolveProperty(properties, "timeout.documentLoad")) != null && !timeoutDocumentLoad.trim().isEmpty()) {
                    this.timeoutDocumentLoad = Integer.parseInt(timeoutDocumentLoad);
                }
                if ((timeoutFileUpload = this.getAndResolveProperty(properties, "timeout.fileUpload")) != null && !timeoutFileUpload.trim().isEmpty()) {
                    this.timeoutFileUpload = Integer.parseInt(timeoutFileUpload);
                }
                if ((disableAnimations = this.getAndResolveProperty(properties, "disableAnimations")) != null && !disableAnimations.trim().isEmpty()) {
                    this.disableAnimations = Boolean.parseBoolean(disableAnimations);
                }
                if ((scrollElementIntoView = this.getAndResolveProperty(properties, "scrollElementIntoView")) != null && !scrollElementIntoView.trim().isEmpty()) {
                    this.scrollElementIntoView = scrollElementIntoView;
                }
                if ((deploymentBaseUrl = this.getAndResolveProperty(properties, DEPLOYMENT_BASEURL)) != null && !deploymentBaseUrl.trim().isEmpty()) {
                    this.deploymentBaseUrl = deploymentBaseUrl;
                }
                if ((deploymentAdapter = this.getAndResolveProperty(properties, DEPLOYMENT_ADAPTER)) != null && !deploymentAdapter.trim().isEmpty()) {
                    this.deploymentAdapter = (DeploymentAdapter)Class.forName(deploymentAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((webdriverAdapter = this.getAndResolveProperty(properties, "webdriver.adapter")) != null && !webdriverAdapter.trim().isEmpty()) {
                    this.webdriverAdapter = (WebDriverAdapter)Class.forName(webdriverAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((webdriverBrowser = this.getAndResolveProperty(properties, "webdriver.browser")) != null && !webdriverBrowser.trim().isEmpty()) {
                    this.webdriverBrowser = webdriverBrowser;
                }
                if ((webdriverHeadless = this.getAndResolveProperty(properties, "webdriver.headless")) != null && !webdriverHeadless.trim().isEmpty()) {
                    this.webdriverHeadless = Boolean.parseBoolean(webdriverHeadless);
                }
                if ((webdriverVersion = this.getAndResolveProperty(properties, "webdriver.version")) != null && !webdriverVersion.trim().isEmpty()) {
                    this.webdriverVersion = webdriverVersion;
                }
                if ((webdriverLogLevel = this.getAndResolveProperty(properties, "webdriver.logLevel")) != null && !webdriverLogLevel.trim().isEmpty()) {
                    this.webdriverLogLevel = Level.parse(webdriverLogLevel);
                }
                if ((onloadScriptsAdapter = this.getAndResolveProperty(properties, "onloadScripts.adapter")) != null && !onloadScriptsAdapter.trim().isEmpty()) {
                    this.onloadScriptsAdapter = (OnloadScriptsAdapter)Class.forName(onloadScriptsAdapter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if ((screenshotDirectory = this.getAndResolveProperty(properties, "screenshotDirectory")) != null && !screenshotDirectory.trim().isEmpty()) {
                    this.screenshotDirectory = screenshotDirectory;
                }
            }
            if (this.webdriverAdapter == null) {
                this.webdriverAdapter = new DefaultWebDriverAdapter();
            }
            if (this.deploymentBaseUrl == null && this.deploymentAdapter == null) {
                throw new RuntimeException("Please either provide a deployment.baseUrl for remote testing or deployment.adapter via config.properties!");
            }
            this.buildOnloadScripts();
            this.webdriverAdapter.initialize(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getAndResolveProperty(Properties properties, String propertyKey) {
        String env;
        Matcher matcher;
        String val = properties.getProperty(propertyKey);
        if (val != null && (matcher = PROPERTY_ENV_PLACEHOLDER.matcher(val)).matches() && (env = System.getenv(matcher.group(1))) != null && !env.trim().isEmpty()) {
            return env;
        }
        return val;
    }

    protected void buildOnloadScripts() throws Exception {
        this.onloadScripts = new ArrayList<String>();
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/primefaces-selenium/onload.js"), StandardCharsets.UTF_8));){
            this.onloadScripts.add(buffer.lines().collect(Collectors.joining("\n")));
        }
        if (this.disableAnimations) {
            this.onloadScripts.add("if (window.PrimeFaces) { $(function() { PrimeFaces.utils.disableAnimations(); }); }");
            this.onloadScripts.add("document.head.insertAdjacentHTML('beforeend', '<style>*, *:before, *:after { -webkit-transition: none !important; -moz-transition: none !important; -ms-transition: none !important; -o-transition: none !important; transition: none !important; }</style>');");
        }
        if (this.scrollElementIntoView != null) {
            this.onloadScripts.add("if (window.PrimeFaces) { $(function() { PrimeFaces.hideOverlaysOnViewportChange = false; }); }");
        }
        if (this.onloadScriptsAdapter != null) {
            this.onloadScriptsAdapter.registerOnloadScripts(this.onloadScripts);
        }
    }

    public int getTimeoutGui() {
        return this.timeoutGui;
    }

    public int getTimeoutAjax() {
        return this.timeoutAjax;
    }

    public void setTimeoutAjax(int timeoutAjax) {
        this.timeoutAjax = timeoutAjax;
    }

    public int getTimeoutHttp() {
        return this.timeoutHttp;
    }

    public int getTimeoutDocumentLoad() {
        return this.timeoutDocumentLoad;
    }

    public int getTimeoutFileUpload() {
        return this.timeoutFileUpload;
    }

    public String getScrollElementIntoView() {
        return this.scrollElementIntoView;
    }

    public boolean isDisableAnimations() {
        return this.disableAnimations;
    }

    public String getDeploymentBaseUrl() {
        return this.deploymentBaseUrl;
    }

    public DeploymentAdapter getDeploymentAdapter() {
        return this.deploymentAdapter;
    }

    public List<String> getOnloadScripts() {
        return this.onloadScripts;
    }

    public WebDriverAdapter getWebdriverAdapter() {
        return this.webdriverAdapter;
    }

    public OnloadScriptsAdapter getOnloadScriptsAdapter() {
        return this.onloadScriptsAdapter;
    }

    public String getWebdriverBrowser() {
        return this.webdriverBrowser;
    }

    public boolean isWebdriverHeadless() {
        return this.webdriverHeadless;
    }

    public String getWebdriverVersion() {
        return this.webdriverVersion;
    }

    public Level getWebdriverLogLevel() {
        return this.webdriverLogLevel;
    }

    public String getScreenshotDirectory() {
        return this.screenshotDirectory;
    }

    public static synchronized ConfigProvider getInstance() {
        if (configProvider == null) {
            configProvider = new ConfigProvider();
        }
        return configProvider;
    }
}

