/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.selenium.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.primefaces.selenium.PrimeExpectedConditions;
import org.primefaces.selenium.PrimeSelenium;
import org.primefaces.selenium.internal.ConfigProvider;
import org.primefaces.selenium.internal.OnloadScripts;
import org.primefaces.selenium.spi.WebDriverProvider;

public class Guard {
    private Guard() {
    }

    public static <T> T custom(T target, int timeout, ExpectedCondition ... expectedConditions) {
        return Guard.custom(target, 0, timeout, expectedConditions);
    }

    public static <T> T custom(T target, int delay, int timeout, ExpectedCondition ... expectedConditions) {
        OnloadScripts.execute();
        return Guard.proxy(target, (p, method, args) -> {
            try {
                Object result = method.invoke(target, args);
                if (delay > 0) {
                    Thread.sleep(delay);
                }
                WebDriver driver = WebDriverProvider.get();
                WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(timeout), Duration.ofMillis(100L));
                wait.until((Function)ExpectedConditions.and((ExpectedCondition[])expectedConditions));
                return result;
            }
            catch (TimeoutException e) {
                throw new TimeoutException("Timeout while waiting for custom guard!", (Throwable)e);
            }
        });
    }

    public static <T> T http(T target) {
        OnloadScripts.execute();
        return Guard.proxy(target, (p, method, args) -> {
            try {
                PrimeSelenium.executeScript("pfselenium.submitting = true;", new Object[0]);
                Object result = method.invoke(target, args);
                WebDriver driver = WebDriverProvider.get();
                WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(ConfigProvider.getInstance().getTimeoutHttp()), Duration.ofMillis(100L));
                wait.until((Function)((ExpectedCondition)d -> {
                    if (((Boolean)PrimeExpectedConditions.validationFailed().apply((Object)driver)).booleanValue()) {
                        return true;
                    }
                    return (Boolean)ExpectedConditions.and((ExpectedCondition[])new ExpectedCondition[]{PrimeExpectedConditions.documentLoaded(), PrimeExpectedConditions.notNavigating(), PrimeExpectedConditions.notSubmitting()}).apply((Object)driver);
                }));
                return result;
            }
            catch (TimeoutException e) {
                throw new TimeoutException("Timeout while waiting for document ready!", (Throwable)e);
            }
        });
    }

    public static <T> T ajax(String script, Object ... args) {
        OnloadScripts.execute();
        WebDriver driver = WebDriverProvider.get();
        JavascriptExecutor executor = (JavascriptExecutor)driver;
        try {
            executor.executeScript("pfselenium.xhr = 'somethingJustNotNull';", new Object[0]);
            Object result = executor.executeScript(script, args);
            Guard.waitUntilAjaxCompletes(driver);
            return (T)result;
        }
        catch (TimeoutException e) {
            throw new TimeoutException("Timeout while waiting for AJAX complete!", (Throwable)e);
        }
    }

    public static <T> T ajax(T target) {
        return Guard.ajax(target, 0);
    }

    public static <T> T ajax(T target, int delay) {
        OnloadScripts.execute();
        return Guard.proxy(target, (p, method, args) -> {
            WebDriver driver = WebDriverProvider.get();
            JavascriptExecutor executor = (JavascriptExecutor)driver;
            try {
                executor.executeScript("pfselenium.xhr = 'somethingJustNotNull';", new Object[0]);
                Object result = method.invoke(target, args);
                if (delay > 0) {
                    Thread.sleep(delay);
                }
                Guard.waitUntilAjaxCompletes(driver);
                return result;
            }
            catch (TimeoutException e) {
                throw new TimeoutException("Timeout while waiting for AJAX complete!", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new TimeoutException("AJAX Guard delay was interrupted!", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof WebDriverException) {
                    throw e.getCause();
                }
                throw e;
            }
        });
    }

    private static String getAjaxDebugInfo(JavascriptExecutor executor) {
        return "document.readyState=" + executor.executeScript("return document.readyState;", new Object[0]) + ", !window.jQuery=" + executor.executeScript("return !window.jQuery;", new Object[0]) + ", jQuery.active=" + executor.executeScript("return jQuery.active;", new Object[0]) + ", !window.PrimeFaces=" + executor.executeScript("return !window.PrimeFaces;", new Object[0]) + ", PrimeFaces.ajax.Queue.isEmpty()=" + executor.executeScript("return PrimeFaces.ajax.Queue.isEmpty();", new Object[0]) + ", PrimeFaces.animationActive=" + executor.executeScript("return PrimeFaces.animationActive;", new Object[0]) + ", !window.pfselenium=" + executor.executeScript("return !window.pfselenium;", new Object[0]) + ", pfselenium.xhr=" + executor.executeScript("return pfselenium.xhr;", new Object[0]) + ", pfselenium.anyXhrStarted=" + executor.executeScript("return pfselenium.anyXhrStarted;", new Object[0]) + ", pfselenium.navigating=" + executor.executeScript("return pfselenium.navigating;", new Object[0]);
    }

    private static void waitUntilAjaxCompletes(WebDriver driver) {
        WebDriverWait wait = new WebDriverWait(driver, Duration.ofSeconds(ConfigProvider.getInstance().getTimeoutAjax()), Duration.ofMillis(50L));
        wait.until(d -> (Boolean)((JavascriptExecutor)driver).executeScript("return (window.pfselenium && pfselenium.validationFailed === true) || (document.readyState === 'complete' && (!window.jQuery || jQuery.active == 0) && (!window.PrimeFaces || (PrimeFaces.ajax.Queue.isEmpty() && PrimeFaces.animationActive === false)) && (!window.pfselenium || (pfselenium.xhr == null && pfselenium.navigating === false)));", new Object[0]));
    }

    private static <T> T proxy(T target, InvocationHandler handler) {
        Class<Object> classToProxy = target.getClass();
        List<Object> interfacesToImplement = new ArrayList();
        ElementMatcher.Junction methods = ElementMatchers.isPublic();
        if (Modifier.isPrivate(classToProxy.getModifiers()) || Modifier.isFinal(classToProxy.getModifiers())) {
            interfacesToImplement = Arrays.asList(classToProxy.getInterfaces());
            classToProxy = Object.class;
            methods = null;
            for (Class clazz : interfacesToImplement) {
                if (methods == null) {
                    methods = ElementMatchers.isDeclaredBy((Class)clazz);
                    continue;
                }
                methods = methods.or((ElementMatcher)ElementMatchers.isDeclaredBy((Class)clazz));
            }
        }
        Class proxyClass = new ByteBuddy().subclass(classToProxy).implement(interfacesToImplement).method((ElementMatcher)methods).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)handler)).make().load(target.getClass().getClassLoader()).getLoaded();
        try {
            try {
                Constructor constructor = proxyClass.getDeclaredConstructor(new Class[0]);
                return constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    if (target instanceof WrapsElement) {
                        Constructor constructor = proxyClass.getDeclaredConstructor(WebElement.class);
                        return constructor.newInstance(((WrapsElement)target).getWrappedElement());
                    }
                }
                catch (NoSuchMethodException noSuchMethodException2) {}
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
        throw new RuntimeException("Could not proxy class " + classToProxy.getName() + " because of missing constructor (default or WebElement)");
    }
}

